<?php

class md_despacho  extends CI_Model
 {
	function __construct()
	{
		parent::__construct();
	}
	
	public function savedespachomanual($idcliente,$rutcliente,$direcretiro,$descripcion,$direcdespa,$tipodespa,$observacion,$codunico,$tptarifa)
	{ 
		//insert despacho
		$data2 = array(
			'ClienteRut' => $rutcliente,
			'DespachoFch' => date("Y-m-d H:i:s"),
			'DespachoEstado' => 1,
			'DespachoDirIdOri' => $direcretiro,
			'DespachoCreateUsr' => $idcliente,
			'DespachoCreateDate' => date("Y-m-d H:i:s"),
			'DespachoTarifaId' => $tptarifa,
		);
			$this->db->insert('Despacho',$data2);
			$DespachoId=$this->db->insert_id();
			return $DespachoId;

	}


	public function savedepachoitem($depachoitemid,$iddespacho,$idcliente,$rutcliente,$direcretiro,$descripcion,$direcdespa,$tipodespa,$observacion,$codunico,$destinatario,$region,$comuna,$direcdespacho,$origenlatlng_item)
	{ 
		$data3 = array(
			'DespachoId' => $iddespacho,
			'DespachoItemId' =>$depachoitemid,
			'DespachoItemDsc' => $descripcion,
			'DespachoItemRecFch' => date("Y-m-d H:i:s"),
			'DespachoItemEstado' => 1,
			'DespachoItemDirIdDes' => $direcdespa,
			'DespachoItemDirNomDes' => $direcdespacho,
			'DespachoItemCreateUsr' => $idcliente,
			'DespachoItemCreateDate' => date("Y-m-d H:i:s"),
			'DespachoItemPrioridad' => $tipodespa,
			'DespachoItemValorEntrega' => 0,
			'DespachoItemCodUnico' => $codunico,
			'DespachoItemObservaciones' => $observacion,
			'DespachoItemDestinatario' => $destinatario,
			'DespachoItemRegionId' => $region,
			'DespachoItemComunaId' => $comuna,
			'DespachoItemGeoreferencia' => $origenlatlng_item
		);

		//print_r($data3);
		
		$this->db->insert('DespachoItem',$data3);
		
	}


	public function despachotracking($iddespacho,$iddepachoitem,$estado)
	{ 
		
		$data3 = array(
			'DespachoId' => $iddespacho,
			'DespachoItemId' => $iddepachoitem,
			'DespTracking_Estado' => $estado,	
			'DespTracking_FechaEstado' => date("Y-m-d H:i:s"),	

		);
		$this->db->insert('DespTracking',$data3);
	

	}


	

	public function infosolicitud($iddepacho)
	{ 

		$this->db->select('a.*,b.clienteDirNombre,b.clienteDirContacto,b.ClienteDirDepto
		,(select ClienteRazonSocial from Cliente c where c.ClienteRut=a.ClienteRut) as nomcliente
		,(select CONCAT(d.ClienteRut,"-", d.ClienteDv) from Cliente d where d.ClienteRut=a.ClienteRut) as rutcliente
		,(select d.SecUserNombre from SecUser d where a.DespachoUserId=d.SecUserId) as mensajero		
		');
		$this->db->from('Despacho a');
		$this->db->join('ClienteDir b','a.despachodiridori=b.clientedirid and a.ClienteRut=b.ClienteRut ');

		$this->db->where('a.DespachoId',$iddepacho);
    
		$query = $this->db->get();
	  
		if($query -> num_rows() >= 1)
		{
			return $query->result();
			return true;
		}
		else
		{
		   return false;
		}
		
		
	}

	public function listado_despachos($idcliente)
	{ 

		$this->db->select('a.*,b.clienteDirNombre,b.ClienteDirContacto
		');
		$this->db->from('Despacho a');
		$this->db->join('ClienteDir b','a.DespachoDirIdOri=b.ClienteDirId and a.ClienteRut=b.ClienteRut ');

		$this->db->where('a.ClienteRut',$idcliente);
		$this->db->where('b.ClienteRut',$idcliente);
		$this->db->order_by('a.DespachoId','desc');
    
		$query = $this->db->get();
	  
		if($query -> num_rows() >= 1)
		{
			return $query->result();
			return true;
		}
		else
		{
		   return false;
		}
		
		
	}

	


	public function listado_despachos_costo($idcliente)
	{ 

		$this->db->select('a.*,b.clienteDirNombre,b.ClienteDirContacto,b.ClienteDirContacto
		,(select sum(c.DespachoItemValorEntrega) from DespachoItem c where a.DespachoId=c.DespachoId) as totaldesp
		');
		$this->db->from('Despacho a');
		$this->db->join('ClienteDir b','a.DespachoDirIdOri=b.ClienteDirId and a.ClienteRut=b.ClienteRut ');

		$this->db->where('a.ClienteRut',$idcliente);
		$this->db->where('b.ClienteRut',$idcliente);
		$this->db->order_by('a.DespachoId','desc');
    
		$query = $this->db->get();
	  
		if($query -> num_rows() >= 1)
		{
			return $query->result();
			return true;
		}
		else
		{
		   return false;
		}
		
		
	}

	public function infosolicitud_det($iddepacho)
	{ 

		$this->db->select('a.*
		,(select b.RegionNom from Region b where b.RegionId=a.DespachoItemRegionId ) as nomregion
		,(select c.ComunaNom from Comuna c where c.ComunaId=a.DespachoItemComunaId ) as nomcomuna
		,(select d.DespCierreObs from DespCierre d where a.DespachoId=d.DespachoId and a.DespachoItemId=d.DespachoItemId order by d.DespCierreID desc limit 1) as cierreobs
		,(select d.DespCierreFoto from DespCierre d where a.DespachoId=d.DespachoId and a.DespachoItemId=d.DespachoItemId order by d.DespCierreID desc limit 1) as fotocierre
		,(select e.DespCierreId from DespCierre e where a.DespachoId=e.DespachoId and a.DespachoItemId=e.DespachoItemId order by e.DespCierreID desc limit 1) as DespCierreId
		');
		$this->db->from('DespachoItem a');
	
		

		$this->db->where('a.DespachoId',$iddepacho);
    
		$query = $this->db->get();
	  
		if($query -> num_rows() >= 1)
		{
			return $query->result();
			return true;
		}
		else
		{
		   return false;
		}

	}
	
	public function infosolicitud_img($idcierre,$depid)
	{ 

		$this->db->select('DespCierreFoto');
		$this->db->from('DespCierre a');
		$this->db->where('a.DespachoId',$depid);
		$this->db->where('a.DespCierreId',$idcierre);
		
    
		$query = $this->db->get();
	  
		if($query -> num_rows() >= 1)
		{
			return $query->result();
			return true;
		}
		else
		{
		   return false;
		}

	}

	public function listado_tarifas()
	{ 

    	$this->db->select('TarifasId, TarifasNombre, TarifasValor, TarifasEstado');
		$this->db->from('Tarifas');
		$this->db->where('TarifasEstado',0);
		$this->db->order_by('TarifasId','desc');
    
		$query = $this->db->get();
	  
		if($query -> num_rows() >= 1)
		{
			return $query->result();
			return true;
		}
		else
		{
		   return false;
		}
		
		
	}

	public function listado_cobros($fechainicons,$fechafincons,$idcliente)
	{ 

		$this->db->select('a.*,c.ClienteRazonSocial,c.ClienteDv');
		$this->db->from('Cobros a');
		$this->db->join('Cliente c','a.ClienteRut=c.ClienteRut');
		
		if($idcliente!=0){
			$this->db->where('a.ClienteRut',$idcliente);

		}

		$this->db->where('a.FechaCobro >=',$fechainicons);
		$this->db->where('a.FechaCobro <=',$fechafincons);
		
		
		$this->db->order_by('a.CobrosID','desc');

    
		$query = $this->db->get();
	  
		if($query -> num_rows() >= 1)
		{
			return $query->result();
			return true;
		}
		else
		{
		   return false;
		}
		
		
  }


  public function cobros_det($cod)
	{ 

		$this->db->select('a.*,c.ClienteRazonSocial,c.ClienteDv');

		$this->db->from('Cobros a');
		$this->db->join('Cliente c','a.ClienteRut=c.ClienteRut');
		$this->db->where('a.CobrosID',$cod);
		
		$this->db->order_by('a.CobrosID','desc');

    
		$query = $this->db->get();
	  
		if($query -> num_rows() >= 1)
		{
			return $query->result();
			return true;
		}
		else
		{
		   return false;
		}
		
		
  }
  public function listado_item_det($cod)
	{ 


		$this->db->select('c.*,
		(select d.SecUserNombre from SecUser d where d.SecUserId=c.DespachoItemCreateUsr  ) as nomsolici
		,(select f.ClienteDirNombre from ClienteDir f where d.DespachoDirIdOri=f.ClienteDirId and d.ClienteRut=f.ClienteRut) as Direccion
		,(select g.ClienteDirDepto from ClienteDir g where d.DespachoDirIdOri=g.ClienteDirId and d.ClienteRut=g.ClienteRut) as Depto
		');
		$this->db->from('CobrosItem a');
		$this->db->join('DespachoItem c','a.DespachoID=c.DespachoId');
		$this->db->join('Despacho d','a.DespachoID=d.DespachoId');

		$this->db->where('a.CobrosID',$cod);
		
		$query = $this->db->get();
	  
		if($query -> num_rows() >= 1)
		{
			return $query->result();
			return true;
		}
		else
		{
		   return false;
		}
		
		
  }
	
}
