/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2018-11-05 20:53:54 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `tb_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `tb_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `tb_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

CREATE TABLE `tb_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `tb_modula` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `configuration` varchar(5000) NOT NULL,
  UNIQUE KEY `id` (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tb_modula_images` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `gid` int(11) NOT NULL,
  `imageId` int(11) NOT NULL,
  `imagePath` longtext NOT NULL,
  `link` longtext,
  `target` varchar(50) DEFAULT NULL,
  `filters` varchar(1500) DEFAULT NULL,
  `description` longtext NOT NULL,
  `title` longtext NOT NULL,
  `sortOrder` int(11) NOT NULL,
  `valign` varchar(50) NOT NULL DEFAULT 'middle',
  `halign` varchar(50) NOT NULL DEFAULT 'center',
  UNIQUE KEY `id` (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tb_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=280 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `tb_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=71 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `tb_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `tb_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `tb_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `tb_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `tb_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  `term_order` int(4) DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `tb_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `tb_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


/* INSERT TABLE DATA: tb_comments */
INSERT INTO `tb_comments` VALUES("1", "1", "Un Comentarista de WordPress", "wapuu@wordpress.example", "https://wordpress.org/", "", "2018-10-25 01:29:01", "2018-10-25 04:29:01", "Hola, este es un comentario.\nPara empezar con la moderación, edición y eliminación de comentarios, por favor visita la pantalla de comentarios en el panel inicial.\nLos Avatares de los comentaristas provienen de <a href=\"https://gravatar.com\">Gravatar</a>.", "0", "1", "", "", "0", "0");

/* INSERT TABLE DATA: tb_duplicator_packages */
INSERT INTO `tb_duplicator_packages` VALUES("1", "20181105_trustworthy", "324541adb13515a27859_20181105205349", "20", "2018-11-05 20:53:54", "admin", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-11-05 20:53:49\";s:7:\"Version\";s:6:\"1.2.52\";s:9:\"VersionWP\";s:5:\"4.9.8\";s:9:\"VersionDB\";s:6:\"5.6.37\";s:10:\"VersionPHP\";s:6:\"5.6.31\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";i:1;s:4:\"Name\";s:20:\"20181105_trustworthy\";s:4:\"Hash\";s:35:\"324541adb13515a27859_20181105205349\";s:8:\"NameHash\";s:56:\"20181105_trustworthy_324541adb13515a27859_20181105205349\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:65:\"/Applications/AMPPS/www/1mentha/midatech/otd/web/wp-snapshots/tmp\";s:8:\"StoreURL\";s:55:\"http://localhost/1mentha/midatech/otd/web/wp-snapshots/\";s:8:\"ScanFile\";s:66:\"20181105_trustworthy_324541adb13515a27859_20181105205349_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"admin\";s:7:\"Archive\";O:11:\"DUP_Archive\":19:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:68:\"20181105_trustworthy_324541adb13515a27859_20181105205349_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:48:\"/Applications/AMPPS/www/1mentha/midatech/otd/web\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-11-05 20:53:49\";s:7:\"Version\";s:6:\"1.2.52\";s:9:\"VersionWP\";s:5:\"4.9.8\";s:9:\"VersionDB\";s:6:\"5.6.37\";s:10:\"VersionPHP\";s:6:\"5.6.31\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";N;s:4:\"Name\";s:20:\"20181105_trustworthy\";s:4:\"Hash\";s:35:\"324541adb13515a27859_20181105205349\";s:8:\"NameHash\";s:56:\"20181105_trustworthy_324541adb13515a27859_20181105205349\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:65:\"/Applications/AMPPS/www/1mentha/midatech/otd/web/wp-snapshots/tmp\";s:8:\"StoreURL\";s:55:\"http://localhost/1mentha/midatech/otd/web/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";O:13:\"DUP_Installer\":9:{s:4:\"File\";s:70:\"20181105_trustworthy_324541adb13515a27859_20181105205349_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:10:\"\0*\0Package\";r:58;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:69:\"20181105_trustworthy_324541adb13515a27859_20181105205349_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:19:\"Source distribution\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:57:\"/Applications/AMPPS/www/1mentha/midatech/otd/web/wp-admin\";i:1;s:67:\"/Applications/AMPPS/www/1mentha/midatech/otd/web/wp-content/uploads\";i:2;s:69:\"/Applications/AMPPS/www/1mentha/midatech/otd/web/wp-content/languages\";i:3;s:67:\"/Applications/AMPPS/www/1mentha/midatech/otd/web/wp-content/plugins\";i:4;s:66:\"/Applications/AMPPS/www/1mentha/midatech/otd/web/wp-content/themes\";i:5;s:60:\"/Applications/AMPPS/www/1mentha/midatech/otd/web/wp-includes\";}}s:9:\"Installer\";r:80;s:8:\"Database\";r:90;}");

/* INSERT TABLE DATA: tb_options */
INSERT INTO `tb_options` VALUES("1", "siteurl", "http://localhost/1mentha/midatech/otd/web", "yes");
INSERT INTO `tb_options` VALUES("2", "home", "http://localhost/1mentha/midatech/otd/web", "yes");
INSERT INTO `tb_options` VALUES("3", "blogname", "TrustWorthy", "yes");
INSERT INTO `tb_options` VALUES("4", "blogdescription", "TrustWorthy Correo Privado", "yes");
INSERT INTO `tb_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `tb_options` VALUES("6", "admin_email", "agomez@midatech.cl", "yes");
INSERT INTO `tb_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `tb_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `tb_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `tb_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `tb_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `tb_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `tb_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `tb_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `tb_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `tb_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `tb_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `tb_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `tb_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `tb_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `tb_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `tb_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `tb_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `tb_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `tb_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `tb_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `tb_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `tb_options` VALUES("28", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "yes");
INSERT INTO `tb_options` VALUES("29", "rewrite_rules", "a:90:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=9&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "yes");
INSERT INTO `tb_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `tb_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `tb_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `tb_options` VALUES("33", "active_plugins", "a:6:{i:0;s:36:\"contact-form-7/wp-contact-form-7.php\";i:1;s:25:\"duplicator/duplicator.php\";i:2;s:35:\"fancybox-for-wordpress/fancybox.php\";i:3;s:39:\"kiwi-social-share/kiwi-social-share.php\";i:4;s:35:\"modula-best-grid-gallery/Modula.php\";i:5;s:53:\"simple-custom-post-order/simple-custom-post-order.php\";}", "yes");
INSERT INTO `tb_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `tb_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `tb_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `tb_options` VALUES("37", "gmt_offset", "-3", "yes");
INSERT INTO `tb_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `tb_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `tb_options` VALUES("40", "template", "pixova-lite", "yes");
INSERT INTO `tb_options` VALUES("41", "stylesheet", "pixova-lite", "yes");
INSERT INTO `tb_options` VALUES("42", "comment_whitelist", "1", "yes");
INSERT INTO `tb_options` VALUES("43", "blacklist_keys", "", "no");
INSERT INTO `tb_options` VALUES("44", "comment_registration", "0", "yes");
INSERT INTO `tb_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `tb_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `tb_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `tb_options` VALUES("48", "db_version", "38590", "yes");
INSERT INTO `tb_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `tb_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `tb_options` VALUES("51", "blog_public", "1", "yes");
INSERT INTO `tb_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `tb_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `tb_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `tb_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `tb_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `tb_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `tb_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `tb_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `tb_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `tb_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `tb_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `tb_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `tb_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `tb_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `tb_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `tb_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `tb_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `tb_options` VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `tb_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `tb_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `tb_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `tb_options` VALUES("73", "page_comments", "0", "yes");
INSERT INTO `tb_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `tb_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `tb_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `tb_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `tb_options` VALUES("78", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `tb_options` VALUES("79", "widget_text", "a:3:{i:2;a:4:{s:5:\"title\";s:5:\"About\";s:4:\"text\";s:143:\"The many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected true of a humour.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:3;a:4:{s:5:\"title\";s:9:\"Quick nav\";s:4:\"text\";s:982:\"<ul id=\"menu-pixova-footer-menu\" class=\"menu\">\r\n										  <li class=\"menu-item menu-item-type-custom menu-item-object-custom current-menu-item current_page_item\"><a href=\"#about\">About us</a></li>\r\n										  <li class=\"menu-item menu-item-type-custom menu-item-object-custom current-menu-item current_page_item\"><a href=\"#works\">Recent Works</a></li>\r\n										  <li class=\"menu-item menu-item-type-custom menu-item-object-custom current-menu-item current_page_item\"><a href=\"#testimonials\">Testimonials</a></li>\r\n										  <li class=\"menu-item menu-item-type-custom menu-item-object-custom current-menu-item current_page_item\"><a href=\"#news\">News</a></li>\r\n										  <li class=\"menu-item menu-item-type-custom menu-item-object-custom current-menu-item current_page_item\"><a href=\"#team\">Team</a></li>\r\n										  <li class=\"menu-item menu-item-type-custom menu-item-object-custom current-menu-item current_page_item\"><a href=\"#contact\">Contact</a></li>\r\n									  </ul>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `tb_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `tb_options` VALUES("81", "uninstall_plugins", "a:1:{s:53:\"simple-custom-post-order/simple-custom-post-order.php\";s:18:\"scporder_uninstall\";}", "no");
INSERT INTO `tb_options` VALUES("82", "timezone_string", "", "yes");
INSERT INTO `tb_options` VALUES("83", "page_for_posts", "10", "yes");
INSERT INTO `tb_options` VALUES("84", "page_on_front", "9", "yes");
INSERT INTO `tb_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `tb_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `tb_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `tb_options` VALUES("88", "site_icon", "0", "yes");
INSERT INTO `tb_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `tb_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `tb_options` VALUES("91", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `tb_options` VALUES("92", "show_comments_cookies_opt_in", "0", "yes");
INSERT INTO `tb_options` VALUES("93", "initial_db_version", "38590", "yes");
INSERT INTO `tb_options` VALUES("94", "tb_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `tb_options` VALUES("95", "fresh_site", "0", "yes");
INSERT INTO `tb_options` VALUES("96", "WPLANG", "es_CL", "yes");
INSERT INTO `tb_options` VALUES("97", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `tb_options` VALUES("98", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `tb_options` VALUES("99", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `tb_options` VALUES("100", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `tb_options` VALUES("101", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `tb_options` VALUES("102", "sidebars_widgets", "a:7:{s:19:\"wp_inactive_widgets\";a:3:{i:0;s:6:\"text-2\";i:1;s:6:\"text-3\";i:2;s:33:\"pixova_lite_widget_social_media-2\";}s:12:\"blog-sidebar\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:16:\"footer-sidebar-1\";a:0:{}s:16:\"footer-sidebar-2\";a:0:{}s:16:\"footer-sidebar-3\";a:0:{}s:16:\"footer-sidebar-4\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `tb_options` VALUES("103", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `tb_options` VALUES("104", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `tb_options` VALUES("105", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `tb_options` VALUES("106", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `tb_options` VALUES("107", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `tb_options` VALUES("108", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `tb_options` VALUES("109", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `tb_options` VALUES("110", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `tb_options` VALUES("111", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `tb_options` VALUES("112", "cron", "a:5:{i:1541453342;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1541478542;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1541478549;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1541534967;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `tb_options` VALUES("113", "theme_mods_twentyseventeen", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1540442384;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}", "yes");
INSERT INTO `tb_options` VALUES("128", "can_compress_scripts", "1", "no");
INSERT INTO `tb_options` VALUES("141", "current_theme", "Pixova Lite", "yes");
INSERT INTO `tb_options` VALUES("142", "theme_mods_pixova-lite", "a:6:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:21:\"pixova_lite_copyright\";s:31:\"© Copyright 2018. TrustWorthy\";s:11:\"custom_logo\";i:26;s:27:\"pixova_lite_news_visibility\";i:0;}", "yes");
INSERT INTO `tb_options` VALUES("143", "theme_switched", "", "yes");
INSERT INTO `tb_options` VALUES("144", "pixova-lite_backup_settings", "6", "yes");
INSERT INTO `tb_options` VALUES("145", "pixova-settings-id", "7", "yes");
INSERT INTO `tb_options` VALUES("146", "pixova-customizer-v2", "1", "yes");
INSERT INTO `tb_options` VALUES("147", "pixova_show_required_actions", "a:2:{s:40:\"pixova-lite-req-ac-install-contact-forms\";b:1;s:31:\"pixova-lite-import-demo-content\";b:1;}", "yes");
INSERT INTO `tb_options` VALUES("148", "pixova_show_recommended_plugins", "a:4:{s:17:\"kiwi-social-share\";b:1;s:24:\"modula-best-grid-gallery\";b:1;s:22:\"fancybox-for-wordpress\";b:1;s:24:\"simple-custom-post-order\";b:1;}", "yes");
INSERT INTO `tb_options` VALUES("149", "widget_pixova_lite_widget_about", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `tb_options` VALUES("150", "widget_pixova_lite_widget_latest_posts", "a:2:{s:12:\"_multiwidget\";i:1;i:2;a:3:{s:5:\"title\";s:12:\"Latest Posts\";s:10:\"show_title\";s:1:\"1\";s:5:\"items\";s:1:\"1\";}}", "yes");
INSERT INTO `tb_options` VALUES("151", "widget_pixova_lite_widget_social_media", "a:2:{s:12:\"_multiwidget\";i:1;i:2;a:14:{s:5:\"title\";s:0:\"\";s:10:\"show_title\";s:0:\"\";s:16:\"profile_facebook\";s:1:\"#\";s:15:\"profile_twitter\";s:1:\"#\";s:12:\"profile_plus\";s:0:\"\";s:17:\"profile_pinterest\";s:0:\"\";s:16:\"profile_linkedin\";s:0:\"\";s:15:\"profile_youtube\";s:0:\"\";s:16:\"profile_dribbble\";s:0:\"\";s:14:\"profile_tumblr\";s:0:\"\";s:17:\"profile_instagram\";s:1:\"#\";s:14:\"profile_github\";s:0:\"\";s:17:\"profile_bitbucket\";s:0:\"\";s:15:\"profile_codepen\";s:0:\"\";}}", "yes");
INSERT INTO `tb_options` VALUES("156", "wpcf7", "a:2:{s:7:\"version\";s:5:\"5.0.5\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1540431604;s:7:\"version\";s:5:\"5.0.4\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "yes");
INSERT INTO `tb_options` VALUES("157", "recently_activated", "a:0:{}", "yes");
INSERT INTO `tb_options` VALUES("170", "scporder_install", "1", "yes");
INSERT INTO `tb_options` VALUES("173", "kiwi_social_sharing_version", "2.0.9", "yes");
INSERT INTO `tb_options` VALUES("174", "kiwi_general_settings", "a:9:{s:17:\"networks_ordering\";s:0:\"\";s:20:\"networks_article_bar\";a:5:{i:0;s:8:\"facebook\";i:1;s:7:\"twitter\";i:2;s:11:\"google-plus\";i:3;s:9:\"pinterest\";i:4;s:6:\"fintel\";}s:13:\"share_buttons\";s:2:\"on\";s:22:\"share_buttons_location\";s:3:\"top\";s:12:\"button_shape\";s:4:\"rect\";s:23:\"share_buttons_posttypes\";s:0:\"\";s:24:\"floating_panel_posttypes\";s:0:\"\";s:28:\"share_buttons_posttypes_list\";a:0:{}s:29:\"floating_panel_posttypes_list\";a:0:{}}", "yes");
INSERT INTO `tb_options` VALUES("177", "Modula_skip_fix", "1", "yes");
INSERT INTO `tb_options` VALUES("180", "mfbfw", "a:53:{s:6:\"border\";s:0:\"\";s:11:\"borderColor\";s:7:\"#BBBBBB\";s:15:\"showCloseButton\";s:2:\"on\";s:11:\"closeHorPos\";s:5:\"right\";s:11:\"closeVerPos\";s:3:\"top\";s:12:\"paddingColor\";s:7:\"#FFFFFF\";s:7:\"padding\";s:2:\"10\";s:11:\"overlayShow\";s:2:\"on\";s:12:\"overlayColor\";s:7:\"#666666\";s:14:\"overlayOpacity\";s:3:\"0.3\";s:9:\"titleShow\";s:2:\"on\";s:13:\"titlePosition\";s:6:\"inside\";s:10:\"titleColor\";s:7:\"#333333\";s:13:\"showNavArrows\";s:2:\"on\";s:11:\"zoomOpacity\";s:2:\"on\";s:11:\"zoomSpeedIn\";s:3:\"500\";s:12:\"zoomSpeedOut\";s:3:\"500\";s:15:\"zoomSpeedChange\";s:3:\"300\";s:12:\"transitionIn\";s:4:\"fade\";s:13:\"transitionOut\";s:4:\"fade\";s:6:\"easing\";s:0:\"\";s:8:\"easingIn\";s:11:\"easeOutBack\";s:9:\"easingOut\";s:10:\"easeInBack\";s:12:\"easingChange\";s:14:\"easeInOutQuart\";s:10:\"imageScale\";s:2:\"on\";s:14:\"centerOnScroll\";s:2:\"on\";s:18:\"hideOnContentClick\";s:0:\"\";s:18:\"hideOnOverlayClick\";s:2:\"on\";s:18:\"enableEscapeButton\";s:2:\"on\";s:6:\"cyclic\";s:0:\"\";s:10:\"mouseWheel\";s:0:\"\";s:11:\"galleryType\";s:3:\"all\";s:16:\"customExpression\";s:74:\"jQuery(thumbnails).addClass(\"fancybox\").attr(\"rel\",\"fancybox\").getTitle();\";s:14:\"autoDimensions\";s:2:\"on\";s:10:\"frameWidth\";s:3:\"560\";s:11:\"frameHeight\";s:3:\"340\";s:12:\"loadAtFooter\";s:0:\"\";s:14:\"callbackEnable\";s:0:\"\";s:15:\"callbackOnStart\";s:31:\"function() { alert(\"Start!\"); }\";s:16:\"callbackOnCancel\";s:32:\"function() { alert(\"Cancel!\"); }\";s:18:\"callbackOnComplete\";s:34:\"function() { alert(\"Complete!\"); }\";s:17:\"callbackOnCleanup\";s:33:\"function() { alert(\"CleanUp!\"); }\";s:15:\"callbackOnClose\";s:31:\"function() { alert(\"Close!\"); }\";s:8:\"nojQuery\";s:0:\"\";s:16:\"extraCallsEnable\";s:0:\"\";s:14:\"extraCallsData\";s:0:\"\";s:9:\"uninstall\";s:0:\"\";s:9:\"titleSize\";s:2:\"14\";s:11:\"showToolbar\";s:2:\"on\";s:16:\"transitionEffect\";s:4:\"fade\";s:23:\"disableWoocommercePages\";s:0:\"\";s:26:\"disableWoocommerceProducts\";s:0:\"\";s:17:\"copyTitleFunction\";s:467:\"var arr = jQuery(\"a[data-fancybox]\");\r\n                                jQuery.each(arr, function() {\r\n                                    var title = jQuery(this).children(\"img\").attr(\"title\");\r\n                                    var caption = jQuery(this).next(\"figcaption\").html();\r\n                                    if(caption.length){jQuery(this).attr(\"title\",title+\" \" + caption)}else{ jQuery(this).attr(\"title\",title);};\r\n                                });	\";}", "yes");
INSERT INTO `tb_options` VALUES("181", "mfbfw_active_version", "3.1.2", "yes");
INSERT INTO `tb_options` VALUES("185", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/es_CL/wordpress-4.9.8.zip\";s:6:\"locale\";s:5:\"es_CL\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/es_CL/wordpress-4.9.8.zip\";s:10:\"no_content\";b:0;s:11:\"new_bundled\";b:0;s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.9.8\";s:7:\"version\";s:5:\"4.9.8\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1541451182;s:15:\"version_checked\";s:5:\"4.9.8\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `tb_options` VALUES("187", "_site_transient_update_themes", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1541451184;s:7:\"checked\";a:4:{s:11:\"pixova-lite\";s:5:\"2.0.3\";s:13:\"twentyfifteen\";s:3:\"2.0\";s:15:\"twentyseventeen\";s:3:\"1.7\";s:13:\"twentysixteen\";s:3:\"1.5\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `tb_options` VALUES("227", "_site_transient_timeout_browser_543775e88f7c2bdea63ea551d4abe2a0", "1542052674", "no");
INSERT INTO `tb_options` VALUES("228", "_site_transient_browser_543775e88f7c2bdea63ea551d4abe2a0", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"70.0.3538.77\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `tb_options` VALUES("229", "_site_transient_timeout_community-events-d41d8cd98f00b204e9800998ecf8427e", "1541491076", "no");
INSERT INTO `tb_options` VALUES("230", "_site_transient_community-events-d41d8cd98f00b204e9800998ecf8427e", "a:2:{s:8:\"location\";a:1:{s:2:\"ip\";b:0;}s:6:\"events\";a:0:{}}", "no");
INSERT INTO `tb_options` VALUES("231", "_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1541491077", "no");
INSERT INTO `tb_options` VALUES("232", "_transient_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"\n	Mon, 05 Nov 2018 00:20:21 +0000	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=5.1-alpha-43678\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:51:\"\n		\n		\n				\n		\n				\n		\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 5.0 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2018/11/wordpress-5-0-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Nov 2018 00:20:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6236\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:359:\"WordPress 5.0 Beta 3 is now available! This software is still in development,&#160;so we don’t recommend you run it on a production site. Consider setting up a test site to play with the new version. There are two ways to test the WordPress 5.0 Beta: try the&#160;WordPress Beta Tester&#160;plugin (you’ll want “bleeding edge nightlies”), or [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Gary Pendergast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3167:\"<p>WordPress 5.0 Beta 3 is now available!</p>\n\n<p><strong>This software is still in development,</strong>&nbsp;so we don’t recommend you run it on a production site. Consider setting up a test site to play with the new version.</p>\n\n<p>There are two ways to test the WordPress 5.0 Beta: try the&nbsp;<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a>&nbsp;plugin (you’ll want “bleeding edge nightlies”), or you can&nbsp;<a href=\"https://wordpress.org/wordpress-5.0-beta3.zip\">download the beta here</a>&nbsp;(zip).</p>\n\n<p>WordPress 5.0 is slated for release on&nbsp;<a href=\"https://make.wordpress.org/core/5-0/\">November 19</a>, and we need your help to get there. Here are some of the big issues that we&#8217;ve fixed since Beta 2:</p>\n\n<h2>Block Editor</h2>\n\n<p>The block editor has been updated to include all of the features and bug fixes from the upcoming <a href=\"https://make.wordpress.org/core/2018/10/31/whats-new-in-gutenberg-31st-october-2/\">Gutenberg 4.2 release</a>. Additionally, there are some newer bug fixes and features, such as:</p>\n\n<ul><li>Adding support for the &#8220;Custom Fields&#8221; meta box.</li><li>Improving the reliability of REST API requests.</li><li>A myriad of minor tweaks and improvements.</li></ul>\n\n<h2>Twenty Nineteen</h2>\n\n<p>Twenty Nineteen has been updated from its <a href=\"https://github.com/WordPress/twentynineteen\">GitHub repository</a>, this version is full of new goodies to check out:</p>\n\n<ul><li>Adds support for Selective Refresh Widgets in the Customiser.</li><li>Adds support for Responsive Embeds.</li><li>Tweaks to improve readability and functionality on mobile devices.</li><li>Fixes nested blocks appearing wider than they should be.</li><li>Fixes some errors in older PHP versions, and in IE11.</li></ul>\n\n<h2>How to Help</h2>\n\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a> </p>\n\n<p>If you&#8217;re able to contribute with coding or testing changes, we have <a href=\"https://make.wordpress.org/core/2018/11/02/upcoming-5-0-bug-scrubs/\">a multitude of bug scrubs</a> scheduled this week, we&#8217;d love to have as many people as we can ensuring all bugs reported get the attention they deserve.</p>\n\n<p><strong><em>If you think you’ve found a bug</em></strong><em>, you can post to the&nbsp;</em><a href=\"https://wordpress.org/support/forum/alphabeta\"><em>Alpha/Beta area</em></a><em>&nbsp;in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report,&nbsp;</em><a href=\"https://make.wordpress.org/core/reports/\"><em>file one on WordPress Trac</em></a><em>, where you can also find&nbsp;</em><a href=\"https://core.trac.wordpress.org/tickets/major\"><em>a list of known bugs</em></a><em>.</em></p>\n\n<hr class=\"wp-block-separator\" />\n\n<p><em>WordPress Five Point Oh<br>is just two short weeks away.<br>Thank you for helping!</em> <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f496.png\" alt=\"💖\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><em><br></em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6236\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:51:\"\n		\n		\n				\n		\n				\n		\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Quarterly Updates | Q3 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/news/2018/11/quarterly-updates-q3-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Nov 2018 16:46:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Updates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6206\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:347:\"To keep everyone aware of big projects and efforts across WordPress contributor teams, I&#8217;ve reached out to each team&#8217;s listed representatives. I asked each of them to share their Top Priority (and when they hope for it to be completed), as well as their biggest Wins and Worries. Have questions? I&#8217;ve included a link to [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Josepha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:13509:\"<p><em>To keep everyone aware of big projects and efforts across WordPress contributor teams, I&#8217;ve reached out to each team&#8217;s <a href=\"https://make.wordpress.org/updates/team-reps/\">listed representatives</a>. I asked each of them to share their Top Priority (and when they hope for it to be completed), as well as their biggest Wins and Worries. Have questions? I&#8217;ve included a link to each team&#8217;s site in the headings.</em></p>\n\n<h2><a href=\"https://make.wordpress.org/accessibility/\">Accessibility</a></h2>\n<p></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/joedolson/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>joedolson</a>, <a href=\'https://profiles.wordpress.org/audrasjb/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>audrasjb</a>, <a href=\'https://profiles.wordpress.org/arush/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>arush</a></li>\n<li><strong>Priority</strong>: Work on authoring a manual for assistive technology users on Gutenberg, led by Claire Brotherton (<a href=\'https://profiles.wordpress.org/abrightclearweb/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>abrightclearweb</a>). Continue to work on improving the overall user experience in Gutenberg. Update and organize the WP A11y handbook.</li>\n<li><strong>Struggle</strong>: Lack of developers and accessibility experts to help test and code the milestone issues. Still over 100 outstanding issues, and developing the Gutenberg AT manual helps expose additional issues. The announcement of an accessibility focus on 4.9.9 derailed our planning for Gutenberg in September with minimal productivity, as that goal was quickly withdrawn from the schedule.</li>\n<li><strong>Big Win</strong>: Getting focus constraint implemented in popovers and similar components in Gutenberg.</li>\n</ul>\n<p></p>\n<h2><a href=\"https://make.wordpress.org/cli/\">CLI</a></h2>\n<p></p>\n<ul>\n<li><strong>Contacted</strong>: @danielbachhuber, <a href=\'https://profiles.wordpress.org/schlessera/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>schlessera</a></li>\n<li><strong>Priority</strong>: Current priority is v2.1.0 of WP-CLI, to polish the major refactoring v2.0.0 introduced. You can <a href=\"https://make.wordpress.org/cli/good-first-issues/\">join in or follow progress</a> on their site.</li>\n<li><strong>Struggle</strong>: Getting enough contributors to make peer-review possible/manageable.</li>\n<li><strong>Big Win</strong>: The major refactoring of v2 was mostly without any negative impacts on existing installs. It provided substantial improvements to maintainability including: faster and more reliable testing, more straight-forward changes to individual packages, and simpler contributor on-boarding.</li>\n</ul>\n<p></p>\n<h2><a href=\"https://make.wordpress.org/community/\">Community</a></h2>\n<p></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/francina/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>francina</a>, <a href=\'https://profiles.wordpress.org/hlashbrooke/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>hlashbrooke</a></li>\n<li><strong>Priority</strong>: Supporting contributors of all levels via: monthly <a href=\"https://make.wordpress.org/community/2018/10/08/announcement-monthly-chat-for-wordcamp-organisers/\">WordCamp Organizers chat</a>, better onboarding with a translated <a href=\"https://make.wordpress.org/community/2017/08/11/global-community-team-welcome-pack/\">welcome pack</a>, and Contribution Drive documentation.</li>\n<li><strong>Struggle</strong>: Fewer contributors than usual.</li>\n<li><strong>Big Win</strong>: <a href=\"https://make.wordpress.org/community/2018/09/21/meetup-application-vetting-sprint-26-27-september/\">Meetup Vetting Sprint</a>! </li>\n</ul>\n<p></p>\n<h2><a href=\"https://make.wordpress.org/core/\">Core</a></h2>\n<p></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/jeffpaul/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jeffpaul</a></li>\n<li><strong>Priority</strong>: Continued preparation for the 5.0 release cycle and Gutenberg.</li>\n<li><strong>Struggle</strong>: Identifying tasks for first time contributors, as well as for new-to-JS contributors.</li>\n</ul>\n<p></p>\n<h2><a href=\"https://make.wordpress.org/design/\">Design</a></h2>\n<p></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/melchoyce/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>melchoyce</a>, <a href=\'https://profiles.wordpress.org/karmatosed/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>karmatosed</a>, <a href=\'https://profiles.wordpress.org/boemedia/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>boemedia</a>, <a href=\'https://profiles.wordpress.org/joshuawold/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>joshuawold</a>, <a href=\'https://profiles.wordpress.org/mizejewski/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mizejewski</a></li>\n<li><strong>Priority</strong>: Preparing for WordPress 5.0 and continuing to work on better onboarding practices.</li>\n<li><strong>Struggle</strong>: Identifying tasks for contributor days, especially for small- to medium-sized tasks that can be fit into a single day.</li>\n<li><strong>Big Win</strong>: Regular contributions are starting to build up.</li>\n</ul>\n<p></p>\n<h2><a href=\"https://make.wordpress.org/docs/\">Documentation</a></h2>\n<p></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/kenshino/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>kenshino</a></li>\n<li><strong>Priority</strong>: Getting HelpHub out before WordPress 5.0&#8217;s launch to make sure Gutenberg User Docs have a permanent position to reside</li>\n<li><strong>Struggle</strong>: Getting the documentation from HelpHub into WordPress.org/support is more manual than initially anticipated.</li>\n<li><strong>Big Win</strong>: Had a good discussion with the Gutenberg team about their docs and how WordPress.org expects documentation to be distributed (via DevHub, Make and HelpHub). Getting past the code blocks to release HelpHub (soon)</li>\n</ul>\n<p></p>\n<h2><a href=\"https://make.wordpress.org/hosting/\">Hosting</a></h2>\n<p></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/mikeschroder/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mikeschroder</a>, <a href=\'https://profiles.wordpress.org/jadonn/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jadonn</a></li>\n<li><strong>Priority</strong>: Helping Gutenberg land well at hosts for users in 5.0.</li>\n<li><strong>Struggle</strong>: Short time frame with few resources to accomplish priority items.</li>\n<li><strong>Big Win</strong>: Preparing Try Gutenberg support guide for hosts during the rollout and good reception from users following it.</li>\n</ul>\n<p></p>\n<h2><a href=\"https://make.wordpress.org/marketing/\">Marketing</a></h2>\n<p></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/bridgetwillard/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>bridgetwillard</a></li>\n<li><strong>Priority</strong>: Continuing to write and publish case studies from the community.</li>\n<li><strong>Big Win</strong>: Onboarding guide is going well and is currently being <a href=\"https://translate.wordpress.org/projects/meta/get-involved\">translated</a>.</li>\n</ul>\n<p></p>\n<h2><a href=\"https://make.wordpress.org/meta/\">Meta</a> (WordPress.org Site)</h2>\n<p></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/tellyworth/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>tellyworth</a>, <a href=\'https://profiles.wordpress.org/coffee2code/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>coffee2code</a></li>\n<li><strong>Priority</strong>: Support for other teams in the lead up to, and the follow-up of, the release of WP 5.0. ETA is the WP 5.0 release date (Nov 19) and thereafter, unless it gets bumped to next quarter.</li>\n<li><strong>Struggle</strong>: Maintaining momentum on tickets (still).</li>\n<li><strong>Big Win</strong>: Launch of front-end demo of Gutenberg on https://wordpress.org/gutenberg/</li>\n</ul>\n<p></p>\n<h2><a href=\"https://make.wordpress.org/mobile/\">Mobile</a></h2>\n<p></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/elibud/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>elibud</a></li>\n<li><strong>Priority</strong>: Have an alpha version of Gutenberg in the WordPress apps, ETA end of year 2018.</li>\n<li><strong>Struggle</strong>: Unfamiliar tech stack and the goal of reusing as much of Gutenberg-web&#8217;s code as possible.</li>\n<li><strong>Big Win</strong>: Running mobile tests on web&#8217;s PRs.</li>\n</ul>\n<p></p>\n<h2><a href=\"https://make.wordpress.org/plugins/\">Plugins</a></h2>\n<p></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/ipstenu/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ipstenu</a></li>\n<li><strong>Priority</strong>: Cleaning up &#8216;inactive&#8217; users, which was supposed to be complete but some work preparing for 5.0 was necessary.</li>\n<li><strong>Struggles</strong>: Devnotes are lacking for the upcoming release which slows progress.</li>\n<li><strong>Big Win</strong>: No backlog even though a lot were out!</li>\n</ul>\n<p></p>\n<h2><a href=\"https://make.wordpress.org/polyglots/\">Polyglots</a></h2>\n<p></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/petya/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>petya</a>, <a href=\'https://profiles.wordpress.org/ocean90/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ocean90</a>, <a href=\'https://profiles.wordpress.org/nao/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>nao</a>, <a href=\'https://profiles.wordpress.org/chantalc/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chantalc</a>, <a href=\'https://profiles.wordpress.org/deconf/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>deconf</a>, <a href=\'https://profiles.wordpress.org/casiepa/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>casiepa</a></li>\n<li><strong>Priority</strong>: Help re-activating inactive locale teams.</li>\n<li><strong>Struggle</strong>: Many GTEs are having a hard time keeping up with incoming translation <a href=\"https://make.wordpress.org/polyglots/?resolved=unresolved&amp;tags=editor-requests\">validation and PTE requests</a>.</li>\n<li><strong>Big Win</strong>: Made some progress in locale research and reassigning new GTEs.</li>\n</ul>\n<p></p>\n<h2><a href=\"https://make.wordpress.org/support/\">Support</a></h2>\n<p></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/clorith/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>clorith</a></li>\n<li><strong>Priority:</strong> Preparing for the upcoming 5.0 release</li>\n<li><strong>Struggle</strong>: Finding a good balance between how much we want to help people and how much we are able to help people. Also, contributor recruitment (always a crowd favorite!)</li>\n<li><strong>Big Win</strong>: How well the team, on a global level, has managed to maintain a good flow of user engagement through support.</li>\n</ul>\n<p></p>\n<h2><a href=\"https://make.wordpress.org/themes/\">Theme Review</a></h2>\n<p></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/acosmin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>acosmin</a>, <a href=\'https://profiles.wordpress.org/rabmalin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rabmalin</a>, <a href=\'https://profiles.wordpress.org/thinkupthemes/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>thinkupthemes</a>, <a href=\'https://profiles.wordpress.org/williampatton/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>williampatton</a></li>\n<li><strong>Priority</strong>: Implementing the Theme Sniffer plugin on WordPress.org which is one step forward towards automation. ETA early 2019</li>\n<li><strong>Struggle</strong>: Not having so many contributors/reviewers.</li>\n<li><strong>Big Win</strong>: Implementing <a href=\"https://make.wordpress.org/themes/2018/10/25/new-requirements/\">multiple requirements</a> into our review flow, like screenshots and readme.txt requirements.</li>\n</ul>\n<p></p>\n<p></p>\n<h2><a href=\"https://make.wordpress.org/training/\">Training</a></h2>\n<p></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/bethsoderberg/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>bethsoderberg</a>, <a href=\'https://profiles.wordpress.org/juliek/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>juliek</a></li>\n<li><strong>Priority:</strong> Getting the learn.wordpress.org site designed, developed, and being able to publish lesson plans to it.</li>\n<li><strong>Struggle:</strong> Getting contributors onboard and continually contributing. Part of that is related to the learn.wordpress.org site. People like to see their contributions.</li>\n<li><strong>Big Win</strong>: We have our new workflow and tools in place. We are also streamlining that process to help things go from idea to publication more quickly.</li>\n</ul>\n<p></p>\n<p><em>Interested in updates from the last quarter? You can find those here: <a href=\"https://wordpress.org/news/2018/07/quarterly-updates-q2-2018/\">https://wordpress.org/news/2018/07/quarterly-updates-q2-2018/</a></em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6206\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"The Month in WordPress: October 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2018/11/the-month-in-wordpress-october-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Nov 2018 08:40:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6230\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:331:\"Teams across the WordPress project are working hard to make sure everything is ready for the upcoming release of WordPress 5.0. Find out what’s going on and how you can get involved. The Plan for WordPress 5.0 Early this month, the planned release schedule was announced for WordPress 5.0, which was updated a few weeks [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8071:\"<p>Teams across the WordPress project are working hard to make sure everything is ready for the upcoming release of WordPress 5.0. Find out what’s going on and how you can get involved.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>The Plan for WordPress 5.0</h2>\n\n<p>Early this month, <a href=\"https://make.wordpress.org/core/2018/10/03/proposed-wordpress-5-0-scope-and-schedule/\">the planned release schedule was announced</a> for WordPress 5.0, which was <a href=\"https://make.wordpress.org/core/2018/10/31/wordpress-5-0-schedule-updates/\">updated</a> a few weeks later. WordPress 5.0 is a highly anticipated release, as it’s the official &nbsp;launch of Gutenberg &#8212; the new block editor for WordPress Core. For more detail, check out this <a href=\"https://make.wordpress.org/core/2018/10/12/granular-timeline/\">&nbsp;granular timeline</a>.<br></p>\n\n<p>Along with the planned release schedule, <a href=\'https://profiles.wordpress.org/matt/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>matt</a>, who is heading up this release, <a href=\"https://make.wordpress.org/core/2018/10/03/a-plan-for-5-0/\">announced leads for critical focuses on the project</a>, including <a href=\'https://profiles.wordpress.org/matveb/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>matveb</a>, <a href=\'https://profiles.wordpress.org/karmatosed/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>karmatosed</a>, <a href=\'https://profiles.wordpress.org/laurelfulford/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>laurelfulford</a>, <a href=\'https://profiles.wordpress.org/allancole/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>allancole</a>, <a href=\'https://profiles.wordpress.org/lonelyvegan/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>lonelyvegan</a>, <a href=\'https://profiles.wordpress.org/omarreiss/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>omarreiss</a>, <a href=\'https://profiles.wordpress.org/antpb/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>antpb</a>, <a href=\'https://profiles.wordpress.org/pento/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>pento</a>, <a href=\'https://profiles.wordpress.org/chanthaboune/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chanthaboune</a>, <a href=\'https://profiles.wordpress.org/danielbachhuber/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>danielbachhuber</a>, and <a href=\'https://profiles.wordpress.org/mcsf/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mcsf</a>.<br></p>\n\n<p><a href=\"https://wordpress.org/news/2018/10/wordpress-5-0-beta-2/\">WordPress 5.0 is currently in its second beta phase</a> and will soon move to the release candidate status. Help test this release right now by installing the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester plugin</a> on your site.<br></p>\n\n<p>Want to get involved in building WordPress Core? Follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a> and join the #core channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>. You can also help out by <a href=\"https://make.wordpress.org/test/\">testing</a> or <a href=\"https://make.wordpress.org/polyglots/2018/10/24/wordpress-5-0-gutenberg-and-twenty-nineteen/\">translating</a> the release into a local language.</p>\n\n<h2>New Editor for WordPress Core</h2>\n\n<p>Active development continues on <a href=\"https://wordpress.org/gutenberg\">Gutenberg</a>, the new editing experience for WordPress Core. <a href=\"https://make.wordpress.org/core/2018/10/31/whats-new-in-gutenberg-31st-october-2/\">The latest release</a> is feature complete, meaning that all further development on it will be to improve existing features and fix outstanding bugs.<br></p>\n\n<p>Some have raised concerns about Gutenberg’s accessibility, prompting the development team <a href=\"https://make.wordpress.org/core/2018/10/18/regarding-accessibility-in-gutenberg/\">to detail some areas</a> in which the new editor is accessible. To help improve things further, the team has made <a href=\"https://make.wordpress.org/core/2018/10/19/call-for-testers-community-gutenberg-accessibility-tests/\">a public call for accessibility testers</a> to assist.<br></p>\n\n<p>Want to get involved in building Gutenberg? Follow <a href=\"https://make.wordpress.org/core/tag/gutenberg\">the Gutenberg tag</a> on the Core team blog and join the #core-editor channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>. Read <a href=\"https://make.wordpress.org/test/2018/10/19/gutenberg-needs-testing-areas/\">this guide</a> to find areas where you can have the most impact.</p>\n\n<h2>Migrating HelpHub to WordPress.org</h2>\n\n<p>HelpHub is an ongoing project to move all of WordPress’ user documentation from the <a href=\"https://codex.wordpress.org/\">Codex</a> to the <a href=\"https://wordpress.org/support/\">WordPress Support portal</a>.<br></p>\n\n<p>HelpHub has been developed on <a href=\"https://wp-helphub.com/\">a separate staging server</a> and it’s now time to migrate the new documentation to its home on WordPress.org. The plan is to have everything moved over &nbsp;before WordPress 5.0 is released, so that all the new documentation will be available on the new platform from the start.<br></p>\n\n<p>The HelpHub team has published <a href=\"https://make.wordpress.org/docs/2018/11/01/call-for-volunteers-helphub-migration/\">a call for volunteers</a> to help with the migration. If you would like to get involved, join the #docs channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>, and contact <a href=\'https://profiles.wordpress.org/atachibana/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>atachibana</a> to get started.</p>\n\n<h2>A New Default Theme for WordPress</h2>\n\n<p><a href=\"https://make.wordpress.org/core/2018/10/16/introducing-twenty-nineteen/\">A brand new default theme &#8212; Twenty Nineteen &#8212; has been announced</a>&nbsp;with development being led by <a href=\'https://profiles.wordpress.org/allancole/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>allancole</a>. The theme is packaged with WordPress 5.0, so it will be following the same release schedule as Core.<br></p>\n\n<p>The new theme is designed to integrate seamlessly with Gutenberg and showcase how you can build a theme alongside the new block editor and take advantage of the creative freedom that it offers.<br></p>\n\n<p>Want to help build Twenty Nineteen? Join in on <a href=\"https://github.com/WordPress/twentynineteen\">the theme’s GitHub repo</a> and join the #core-themes channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.<br></p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Further Reading:</h2>\n\n<ul><li>The Support team are putting together more formal <a href=\"https://github.com/Clorith/wporg-support-guidelines\">Support Guidelines</a> for the WordPress Support Forums.</li><li>The group focused on privacy tools in Core <a href=\"https://make.wordpress.org/core/2018/10/11/whats-new-in-core-privacy/\">has released some details</a> on the work they have been doing recently, with a roadmap for their plans over the next few months.</li><li>The Core team <a href=\"https://make.wordpress.org/core/2018/10/15/wordpress-and-php-7-3/\">released an update</a> about how WordPress will be compatible with PHP 7.3.</li><li>The Theme Review Team have published <a href=\"https://make.wordpress.org/themes/2018/10/25/new-requirements/\">some new requirements</a> regarding child themes, readme files and trusted authors in the Theme Directory.</li><li>The WordCamp Europe team <a href=\"https://make.wordpress.org/community/2018/10/23/progressive-web-app-for-wordcamps/\">are working on a PWA service</a> for all WordCamp websites.</li></ul>\n\n<p><em>If you have a story we should consider including in the next “Month in WordPress” post, please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it here</em></a><em>.</em><br></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6230\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:54:\"\n		\n		\n				\n		\n				\n		\n		\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 5.0 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2018/10/wordpress-5-0-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Oct 2018 05:04:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"5.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6222\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:359:\"WordPress 5.0 Beta 2 is now available! This software is still in development,&#160;so we don’t recommend you run it on a production site. Consider setting up a test site to play with the new version. There are two ways to test the WordPress 5.0 Beta: try the&#160;WordPress Beta Tester&#160;plugin (you’ll want “bleeding edge nightlies”), or [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Gary Pendergast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2197:\"<p>WordPress 5.0 Beta 2 is now available!</p>\n\n<p><strong>This software is still in development,</strong>&nbsp;so we don’t recommend you run it on a production site. Consider setting up a test site to play with the new version.</p>\n\n<p>There are two ways to test the WordPress 5.0 Beta: try the&nbsp;<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a>&nbsp;plugin (you’ll want “bleeding edge nightlies”), or you can&nbsp;<a href=\"https://wordpress.org/wordpress-5.0-beta2.zip\">download the beta here</a>&nbsp;(zip).</p>\n\n<p>WordPress 5.0 is slated for release on&nbsp;<a href=\"https://make.wordpress.org/core/5-0/\">November 19</a>, and we need your help to get there. Here are some of the big issues that we fixed since Beta 1:</p>\n\n<h2>Block Editor</h2>\n\n<p>We&#8217;ve updated to the latest version of the block editor from the Gutenberg plugin, which includes the new <a href=\"https://github.com/WordPress/gutenberg/pull/10209\">Format API</a>, embedding improvements, and <a href=\"https://github.com/WordPress/gutenberg/milestone/71\">a variety of bug fixes</a>.</p>\n\n<p>Meta boxes had a few bugs, and they weren&#8217;t showing at all in the block editor, so we&#8217;ve fixed and polished there.</p>\n\n<h2>Internationalisation</h2>\n\n<p>We&#8217;ve added support for <a href=\"https://core.trac.wordpress.org/ticket/45103\">registering and loading JavaScript translation files</a>.</p>\n\n<h2>Twenty Nineteen</h2>\n\n<p>The <a href=\"https://github.com/WordPress/twentynineteen\">Twenty Nineteen repository</a> is a hive of activity, there have been a stack of minor bugs clean up, and some notable additions:</p>\n\n<ul><li>There&#8217;s now a widget area in the page footer.</li><li>Navigation submenus have been implemented for mobile devices.</li><li>Customiser options have been added for changing the theme colours and feature image filters.</li></ul>\n\n<h2>Everything Else</h2>\n\n<p>The REST API has a couple of bug fixes and performance improvements. PHP 7.3 compatibility has been improved.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<p><em>We&#8217;re fixing the bugs:<br>All the ones you&#8217;ve reported.<br>Some that we&#8217;ve found, too.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6222\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:54:\"\n		\n		\n				\n		\n				\n		\n		\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 5.0 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2018/10/wordpress-5-0-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 24 Oct 2018 21:59:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"5.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6209\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:312:\"WordPress 5.0 Beta 1 is now available! This software is still in development,&#160;so we don’t recommend you run it on a production site. Consider setting up a test site to play with the new version, and if you are using an existing test site be sure to update the Gutenberg plugin to v4.1. There are [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Gary Pendergast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3697:\"<p>WordPress 5.0 Beta 1 is now available!</p>\n\n<p><strong>This software is still in development,</strong>&nbsp;so we don’t recommend you run it on a production site. Consider setting up a test site to play with the new version, and if you are using an existing test site be sure to update the Gutenberg plugin to v4.1. </p>\n\n<p>There are two ways to test the WordPress 5.0 beta: try the&nbsp;<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a>&nbsp;plugin (you’ll want “bleeding edge nightlies”), or you can&nbsp;<a href=\"https://wordpress.org/wordpress-5.0-beta1.zip\">download the beta here</a>&nbsp;(zip).</p>\n\n<p>WordPress 5.0 is slated for release on&nbsp;<a href=\"https://make.wordpress.org/core/5-0/\">November 19</a>, and we need your help to get there. Here are some of the big items to test so we can find as many bugs as possible in the coming weeks.</p>\n\n<h2>The Block Editor</h2>\n\n<p>The new Gutenberg block editor is now the default post editor!</p>\n\n<p>The block editor provides a modern, media-rich editing experience. You can create flexible, beautiful content without writing a single line of code, or you can dive into the <a href=\"https://wordpress.org/gutenberg/handbook/\">modern programming APIs</a> that the block editor provides.</p>\n\n<p>Even before you install WordPress 5.0, you can <a href=\"https://wordpress.org/gutenberg/\">try the block editor here</a>.</p>\n\n<p>Of course, we recognise you might not be ready for this change quite yet. If that&#8217;s the case, you can install the <a href=\"https://wordpress.org/plugins/classic-editor/\">Classic Editor plugin</a> now, which will keep the editor you&#8217;re familiar with as the default, even after you upgrade to WordPress 5.0.</p>\n\n<h2>Twenty Nineteen</h2>\n\n<p>Along with the new block editor, we have a new default theme, called Twenty Nineteen, which takes advantage of the new features the block editor provides.</p>\n\n<p>You can read more about Twenty Nineteen in its <a href=\"https://make.wordpress.org/core/2018/10/16/introducing-twenty-nineteen/\">introduction post</a>, and follow along with development over on the <a href=\"https://github.com/WordPress/twentynineteen\">GitHub repository</a>.</p>\n\n<h2>Default Themes</h2>\n\n<p>Of course, we couldn&#8217;t release a beautiful new default theme, and leave all of our old ones behind. All the way back to Twenty Ten, we&#8217;ve updated every default them to look good in the new block editor.</p>\n\n<h2>How to Help</h2>\n\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a> <strong>A known issue</strong>: the block autocompleter fails for blocks whose names contain  characters in non-Latin scripts. Adding blocks via the plus sign works, and this bug is fixed in the Gutenberg 4.1 plugin. <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f642.png\" alt=\"🙂\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n<p><strong><em>If you think you’ve found a bug</em></strong><em>, you can post to the&nbsp;</em><a href=\"https://wordpress.org/support/forum/alphabeta\"><em>Alpha/Beta area</em></a><em>&nbsp;in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report,&nbsp;</em><a href=\"https://make.wordpress.org/core/reports/\"><em>file one on WordPress Trac</em></a><em>, where you can also find&nbsp;</em><a href=\"https://core.trac.wordpress.org/tickets/major\"><em>a list of known bugs</em></a><em>.</em></p>\n\n<hr class=\"wp-block-separator\" />\n\n<p><em>Minor bug fixes<br>Add up one by one by one<br>Then you change the world</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6209\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"The Month in WordPress: September 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://wordpress.org/news/2018/10/the-month-in-wordpress-september-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 01 Oct 2018 12:01:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6203\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:347:\"The new WordPress editor continues to be a major focus for all WordPress contribution teams. Read on to find out some more about their work, as well as everything else that has been happening around the community this past month. Further Enhancements to the New WordPress Editor Active development continues on Gutenberg, the new editing [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4605:\"<p>The new WordPress editor continues to be a major focus for all WordPress contribution teams. Read on to find out some more about their work, as well as everything else that has been happening around the community this past month.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Further Enhancements to the New WordPress Editor</h2>\n\n<p>Active development continues on <a href=\"https://wordpress.org/gutenberg/\">Gutenberg</a>, the new editing experience for WordPress Core. <a href=\"https://make.wordpress.org/core/2018/09/21/whats-new-in-gutenberg/\">The latest update for the editor</a> includes great new features, such as reusable content blocks, a dark editor style, export and import of templates, and much more. In addition, the Gutenberg team has published <a href=\"https://make.wordpress.org/core/2018/09/26/an-update-on-gutenberg-tasks/\">a comprehensive guide</a> to the features currently included in the editor.<br /></p>\n\n<p>Users can test Gutenberg right now by installing <a href=\"https://wordpress.org/plugins/gutenberg/\">the plugin</a>, which currently has over 450,000 active installs according to the new <a href=\"https://gutenstats.blog/\">Gutenberg in Numbers</a> site. Along with that, <a href=\"https://wordpress.org/gutenberg/handbook/reference/faq/\">the Gutenberg Handbook</a> has some very useful information about how to use and develop for the new editor.<br /></p>\n\n<p>Want to get involved in building Gutenberg? Follow <a href=\"https://make.wordpress.org/core/tag/gutenberg/\">the #gutenberg tag on the Core team blog</a> and join the #core-editor channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<h2>Work Begins on WordPress 5.0</h2>\n\n<p>After initially announcing a minor v4.9.9 release, <a href=\"https://make.wordpress.org/core/2018/09/28/dev-chat-summary-september-26th-4-9-9-week-7/\">the Core team has shifted their focus to the next major release</a> — v5.0. One of the primary factors for this change is that Gutenberg is nearly ready to be considered for merging into Core, with the goal to complete the merge in v5.0.<br /></p>\n\n<p>To maintain flexibility in the development process the final timelines are not yet determined, allowing work already done for v4.9.9 to be moved to v5.0 if needed. Ensuring that WordPress is compatible with the upcoming PHP 7.3 release is a high priority for the Core team. Once a final decision is made, the details will be announced on <a href=\"https://make.wordpress.org/core/\">the Core team blog</a>.<br /></p>\n\n<p>Want to get involved in building WordPress Core? Follow the Core team blog and join the #core channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.<br /></p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Further Reading:</h2>\n\n<ul><li>The Community Team has some great updates on <a href=\"https://make.wordpress.org/community/2018/09/25/wordcamp-incubator-2018-update-thread-september-edition/\">the progress of the current WordCamp Incubator Program</a>.</li><li>A team inside the Drupal community <a href=\"https://drupalgutenberg.org/\">is working on integrating Gutenberg into their CMS</a>.</li><li>There is a current discussion among community organizers about <a href=\"https://make.wordpress.org/community/2018/09/17/proposal-to-increase-the-maximum-ticket-price-for-wordcamps/\">plans to increase the maximum ticket price for WordCamps</a>.</li><li>The Mobile Team <a href=\"https://make.wordpress.org/updates/2018/09/25/mobile-team-update-september-25th/\">is looking for people</a> to grow the beta program for testing the iOS and Android mobile apps.</li><li>The Diversity Outreach Speaker Training group <a href=\"https://make.wordpress.org/community/2018/09/13/input-requested-building-a-diverse-speaker-roster-document/\">is looking for feedback</a> on their document to assist WordPress Meetups and WordCamps in building diverse speaker rosters.</li><li>The Theme Team <a href=\"https://make.wordpress.org/themes/2018/09/26/new-requirement-regarding-affiliate-links/\">has updated their rules</a> regarding sponsored and affiliate links inside themes added to the Theme Directory.</li><li>Meetup organizers <a href=\"https://make.wordpress.org/community/2018/09/25/meetup-organiser-badge-assignments/\">are now able to receive a WordPress.org profile badge</a> for their community work.</li></ul>\n\n<p><em>If you have a story we should consider including in the next “Month in WordPress” post, please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it here</em></a><em>.</em><br /></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6203\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"The Month in WordPress: August 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://wordpress.org/news/2018/09/the-month-in-wordpress-august-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 03 Sep 2018 11:00:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6191\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:355:\"Many of the WordPress contribution teams have been working hard on the new WordPress editor, and the tools, services, and documentation surrounding it. Read on to find out more about this ongoing project, as well as everything else that has been happening around the WordPress community in August. WordPress 4.9.8 is Released WordPress 4.9.8 was [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5554:\"<p>Many of the WordPress contribution teams have been working hard on the new WordPress editor, and the tools, services, and documentation surrounding it. Read on to find out more about this ongoing project, as well as everything else that has been happening around the WordPress community in August.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>WordPress 4.9.8 is Released</h2>\n\n<p><a href=\"https://wordpress.org/news/2018/08/wordpress-4-9-8-maintenance-release/\">WordPress 4.9.8 was released</a> at the beginning of the month. While this was a maintenance release fixing 46 bugs, it was significant for Core development because it made a point of highlighting Gutenberg — the new WordPress editor that is currently in development (more on that below).<br /></p>\n\n<p>This release also included some important updates to the privacy tools that were added to Core earlier this year.<br /></p>\n\n<p>Want to get involved in building WordPress Core? Follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a> and join the #core channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<h2>New WordPress Editor Development Continues</h2>\n\n<p>Active development continues on <a href=\"https://wordpress.org/gutenberg/\">Gutenberg</a>, the new editing experience for WordPress Core. <a href=\"https://make.wordpress.org/core/2018/08/31/whats-new-in-gutenberg-31st-august/\">The latest version</a> features a number of important user experience improvements, including a new unified toolbar and support for a more focussed writing mode.<br /></p>\n\n<p>Users can test Gutenberg right now by installing <a href=\"https://wordpress.org/plugins/gutenberg/\">the plugin</a>, which currently has nearly 300,000 active installs. Along with that, <a href=\"https://wordpress.org/gutenberg/handbook/reference/faq/\">the Gutenberg Handbook</a> has some very useful information about how to use and develop for the new editor.<br /></p>\n\n<p>Want to get involved in building Gutenberg? Follow <a href=\"https://make.wordpress.org/core/tag/gutenberg/\">the #gutenberg tag on the Core team blog</a> and join the #core-editor channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<h2>Planning Begins for the Next Global WordPress Translation Day</h2>\n\n<p>The Global WordPress Translation Day is a 24-hour event held online and all across the world. It is designed to bring communities together to translate WordPress into their local languages, and to help them connect with other communities doing the same thing.<br /></p>\n\n<p>There have been three Translation Days since April 2016, and <a href=\"https://make.wordpress.org/polyglots/2018/08/29/global-wordpress-translation-day-4-preliminary-planning/\">the fourth edition is in the planning stages now</a>. The Polyglots team, who organizes these events, is currently looking for input on the date, format, and content for the event and would love some feedback from the community.<br /></p>\n\n<p>Want to get involved in translating WordPress into your own language? Follow <a href=\"https://make.wordpress.org/polyglots/\">the Polyglots team blog</a> and join the #polyglots channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.<br /></p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Further Reading:</h2>\n\n<ul><li><a href=\"https://wordpress.org/support/upgrade-php/\">The Update PHP page on WordPress.org</a> has been revised and improved to make the reasons for upgrading more clear.</li><li>The Mobile team is looking for people to help test the latest versions of the <a href=\"https://make.wordpress.org/mobile/2018/08/29/call-for-testing-wordpress-for-android-10-8/\">Android</a> and <a href=\"https://make.wordpress.org/mobile/2018/08/28/call-for-testing-wordpress-for-ios-10-8/\">iOS</a> apps for WordPress.</li><li><a href=\"https://wordbits.io/\">WordBits</a> is a innovative new platform for publishing WordPress-based code snippets with the ability to download each snippet as a working plugin.</li><li>The Community Team <a href=\"https://make.wordpress.org/community/2018/08/27/wordcamp-incubator-2018-update-thread-august-edition/\">has some updates</a> about how things are going with this year’s WordCamp Incubator program.</li><li>The WordPress Support Forums <a href=\"https://make.wordpress.org/support/2018/08/august-16th-support-team-meeting-summary/\">now include a feature</a> allowing forum volunteers to easily report a post to the moderators for a follow-up.</li><li>WordCamp Kochi, India <a href=\"https://2018.kochi.wordcamp.org/wordcamp-kochi-2018-is-postponed-to-november-3rd-2018-saturday/\">has unfortunately had to postpone their event</a> due to floods in the region.</li><li><a href=\"http://www.wpglossary.net/\">WP Glossary</a> is a new site that offers helpful definitions of words that you could encounter when using WordPress.</li><li>A few WordPress community members <a href=\"https://make.wordpress.org/community/2018/08/13/in-the-words-of-the/\">have started a working group</a> to tackle the idea of building diverse WordPress  communities all across the world.</li><li>A new <a href=\"https://editorblockswp.com/library/\">Gutenberg Block Library</a> is available, listing the details of the many blocks available for the new editor.</li></ul>\n\n<p><em>If you have a story we should consider including in the next “Month in WordPress” post, please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it here</em></a><em>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6191\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 4.9.8 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2018/08/wordpress-4-9-8-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Aug 2018 21:25:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6165\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:398:\"We are pleased to announce the immediate availability of WordPress 4.9.8.  This maintenance release fixes 46 bugs, enhancements and blessed tasks, including updating the Twenty Seventeen bundled theme. Following are the highlights of what is now available. “Try Gutenberg” callout Most users will now be presented with a notice in their WordPress dashboard. This “Try Gutenberg” [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Paul Biron\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10398:\"<p>We are pleased to announce the immediate availability of WordPress 4.9.8.  This maintenance release fixes 46 bugs, enhancements and blessed tasks, including updating the Twenty Seventeen bundled theme.</p>\n<p><span style=\"font-weight: 400\">Following are the highlights of what is now available.</span></p>\n<h2>“Try Gutenberg” callout</h2>\n<p><span style=\"font-weight: 400\">Most users will now be presented with a notice in their WordPress dashboard. This </span>“Try Gutenberg” is an opportunity for users to use the Gutenberg block editor before it is released in WordPress 5.0.</p>\n<p><img class=\"alignnone wp-image-6168 size-full\" src=\"https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?resize=632%2C392&#038;ssl=1\" alt=\"\" width=\"632\" height=\"392\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?w=2528&amp;ssl=1 2528w, https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?resize=300%2C186&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?resize=768%2C476&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?resize=1024%2C634&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?w=1264&amp;ssl=1 1264w, https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></p>\n<p>In WordPress 4.9.8, the callout will be shown to the following users:</p>\n<ul>\n<li>If Gutenberg <em>is not</em> installed or activated, the callout will be shown to Admin users on single sites, and Super Admin users on multisites.</li>\n<li>If Gutenberg <em>is</em> installed and activated, the callout will be shown to Contributor users and above.</li>\n<li>If the Classic Editor plugin is installed and activated, the callout will be hidden for all users.</li>\n</ul>\n<p class=\"entry-title\"><span style=\"font-weight: 400\">You can learn more by reading  </span><a href=\"https://make.wordpress.org/core/2018/08/02/try-gutenberg-callout-in-wordpress-4-9-8/\">“Try Gutenberg” Callout in WordPress 4.9.8</a>.</p>\n<h2>Privacy fixes/enhancements</h2>\n<p>This release includes 18 Privacy fixes focused on ensuring consistency and flexibility in the new personal data tools <span style=\"font-weight: 400\">that were </span>added in 4.9.6, including:</p>\n<ul>\n<li>The type of request being confirmed is now included in the subject line for all privacy confirmation emails.</li>\n<li>Improved consistency with site name being used for privacy emails in multisite.</li>\n<li>Pagination for Privacy request admin screens can now be adjusted.</li>\n<li>Increased the test coverage for several core privacy functions.</li>\n</ul>\n<p><a href=\"https://make.wordpress.org/core/2018/08/02/wordpress-4-9-8/\">This post has more information about all of the issues fixed in 4.9.8 if you&#8217;d like to learn more</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.9.8</a> or venture over to Dashboard → Updates and click &#8220;Update Now.&#8221; Sites that support automatic background updates are already beginning to update automatically.</p>\n<p>Thank you to everyone who contributed to WordPress 4.9.8:</p>\n<p><a href=\"https://profiles.wordpress.org/1naveengiri/\">1naveengiri</a>, <a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/abdullahramzan/\">Abdullah Ramzan</a>, <a href=\"https://profiles.wordpress.org/alejandroxlopez/\">alejandroxlopez</a>, <a href=\"https://profiles.wordpress.org/allendav/\">Allen Snook</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/andrewtaylor-1/\">Andrew Taylor</a>, <a href=\"https://profiles.wordpress.org/aryamaaru/\">Arun</a>, <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a>, <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a>, <a href=\"https://profiles.wordpress.org/bjornw/\">BjornW</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/burhandodhy/\">Burhan Nasir</a>, <a href=\"https://profiles.wordpress.org/chetan200891/\">Chetan Prajapati</a>, <a href=\"https://profiles.wordpress.org/chrislema/\">Chris Lema</a>, <a href=\"https://profiles.wordpress.org/coreymckrill/\">Corey McKrill</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a>, <a href=\"https://profiles.wordpress.org/danieltj/\">Daniel James</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling (ocean90)</a>, <a href=\"https://profiles.wordpress.org/dontstealmyfish/\">dontstealmyfish</a>, <a href=\"https://profiles.wordpress.org/dyrer/\">dyrer</a>, <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a>, <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/fclaussen/\">Fernando Claussen</a>, <a href=\"https://profiles.wordpress.org/garetharnold/\">Gareth</a>, <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a>, <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a>, <a href=\"https://profiles.wordpress.org/gm_alex/\">GM_Alex</a>, <a href=\"https://profiles.wordpress.org/idea15/\">Heather Burns</a>, <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/ianbelanger/\">ibelanger</a>, <a href=\"https://profiles.wordpress.org/imath/\">imath</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/jpry/\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">JJJ</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a>, <a href=\"https://profiles.wordpress.org/joshuawold/\">JoshuaWold</a>, <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a>, <a href=\"https://profiles.wordpress.org/jrf/\">jrf</a>, <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a>, <a href=\"https://profiles.wordpress.org/khaihong/\">khaihong</a>, <a href=\"https://profiles.wordpress.org/kjellr/\">kjellr</a>, <a href=\"https://profiles.wordpress.org/xkon/\">Konstantinos Xenos</a>, <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a>, <a href=\"https://profiles.wordpress.org/lbenicio/\">lbenicio</a>, <a href=\"https://profiles.wordpress.org/leanderiversen/\">Leander Iversen</a>, <a href=\"https://profiles.wordpress.org/leemon/\">leemon</a>, <a href=\"https://profiles.wordpress.org/macbookandrew/\">macbookandrew</a>, <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a>, <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a>, <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce</a>, <a href=\"https://profiles.wordpress.org/mensmaximus/\">mensmaximus</a>, <a href=\"https://profiles.wordpress.org/mermel/\">mermel</a>, <a href=\"https://profiles.wordpress.org/metalandcoffee/\">metalandcoffee</a>, <a href=\"https://profiles.wordpress.org/michelleweber/\">michelleweber</a>, <a href=\"https://profiles.wordpress.org/dimadin/\">Milan Dinić</a>, <a href=\"https://profiles.wordpress.org/xpertone/\">Muhammad Kashif</a>, <a href=\"https://profiles.wordpress.org/nao/\">Naoko Takano</a>, <a href=\"https://profiles.wordpress.org/nathanatmoz/\">Nathan Johnson</a>, <a href=\"https://profiles.wordpress.org/ov3rfly/\">Ov3rfly</a>, <a href=\"https://profiles.wordpress.org/palmiak/\">palmiak</a>, <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a>, <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a>, <a href=\"https://profiles.wordpress.org/presstigers/\">PressTigers</a>, <a href=\"https://profiles.wordpress.org/programmin/\">programmin</a>, <a href=\"https://profiles.wordpress.org/rafsuntaskin/\">Rafsun Chowdhury</a>, <a href=\"https://profiles.wordpress.org/redcastor/\">redcastor</a>, <a href=\"https://profiles.wordpress.org/littlerchicken/\">Robin Cornett</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/pross/\">Simon Prosser</a>, <a href=\"https://profiles.wordpress.org/skoldin/\">skoldin</a>, <a href=\"https://profiles.wordpress.org/spyderbytes/\">spyderbytes</a>, <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a>, <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a>, <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/tharsheblows/\">tharsheblows</a>, <a href=\"https://profiles.wordpress.org/thomasplevy/\">Thomas Patrick Levy</a>, <a href=\"https://profiles.wordpress.org/timbowesohft/\">timbowesohft</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/tz-media/\">Tobias Zimpel</a>, <a href=\"https://profiles.wordpress.org/tobifjellner/\">Tor-Bjorn Fjellner</a>, <a href=\"https://profiles.wordpress.org/itowhid06/\">Towhidul Islam</a>, <a href=\"https://profiles.wordpress.org/usmankhalid/\">Usman Khalid</a>, <a href=\"https://profiles.wordpress.org/warmlaundry/\">warmlaundry</a>, <a href=\"https://profiles.wordpress.org/earnjam/\">William Earnhardt</a>, <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a>, and <a href=\"https://profiles.wordpress.org/yuriv/\">YuriV</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6165\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"The Month in WordPress: July 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wordpress.org/news/2018/08/the-month-in-wordpress-july-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 01 Aug 2018 09:11:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6158\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:333:\"With WordPress 5.0 coming closer, there’s lots of work going on all across the project. Read on to learn about how we progressed in July. Release of WordPress 4.9.7 On July 5, WordPress 4.9.7 was released,  fixing one security issue and 17 other bugs across the platform. While this is a minor release, incremental fixes [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6411:\"<p>With WordPress 5.0 coming closer, there’s lots of work going on all across the project. Read on to learn about how we progressed in July.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Release of WordPress 4.9.7</h2>\n\n<p>On July 5, <a href=\"https://wordpress.org/news/2018/07/wordpress-4-9-7-security-and-maintenance-release/\">WordPress 4.9.7 was released</a>,  fixing one security issue and 17 other bugs across the platform.<br /></p>\n\n<p>While this is a minor release, incremental fixes are essential to keep WordPress running smoothly. Everyone is encouraged to update as soon as possible and to make sure that automatic updates are switched on.<br /></p>\n\n<p>Would you like to get involved in building WordPress Core? Follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a> and join the #core channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<h2>The New WordPress Editor</h2>\n\n<p>In the upcoming minor release of WordPress, 4.9.8, a new section in the dashboard will feature Gutenberg, the upcoming content editor for WordPress.<br /></p>\n\n<p>While the official release of Gutenberg <a href=\"https://wordpress.org/news/2018/07/update-on-gutenberg/\">is scheduled</a> for the coming months, you can already install it as <a href=\"https://wordpress.org/plugins/gutenberg/\">a plugin</a> to test it out right now. Additionally, <a href=\"https://wordpress.org/gutenberg/\">a brand new demo page</a> is now available — play around with the many features the editor has to offer, without installing it on your own site.<br /></p>\n\n<p>Would you like to help build or test Gutenberg? Follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a> and join the #core-editor channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<h2>Page Design Updates on WordPress.org</h2>\n\n<p>Bit by bit we’re refreshing the design of WordPress.org. The latest pages to get a new treatment have been <a href=\"https://wordpress.org/download/\">the Download page</a> and <a href=\"https://profiles.wordpress.org/matt/\">user profiles</a>.<br /></p>\n\n<p>The Meta and Design teams worked hard to make these new designs a reality, with notable contributions from <a href=\'https://profiles.wordpress.org/melchoyce/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>melchoyce</a>, <a href=\'https://profiles.wordpress.org/obenland/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>obenland</a>, <a href=\'https://profiles.wordpress.org/mapk/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mapk</a>, and <a href=\'https://profiles.wordpress.org/kjellr/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>kjellr</a>. The new designs enhance the overall look of the site and provide more relevant information to those searching.<br /></p>\n\n<p>Would you like to get involved in the design refresh? Follow the <a href=\"https://make.wordpress.org/meta/\">Meta</a> and <a href=\"https://make.wordpress.org/design/\">Design</a> team blogs and join the #meta and #design channels in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<h2>The First WP-CLI Hack Day</h2>\n\n<p>On Friday July 20, the WP-CLI team <a href=\"https://make.wordpress.org/cli/2018/07/04/wp-cli-hack-day/\">held their first hack day</a> — a global event encouraging people to contribute to the official command line tool for WordPress.<br /></p>\n\n<p>Run by <a href=\'https://profiles.wordpress.org/schlessera/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>schlessera</a>, the event <a href=\"https://make.wordpress.org/cli/2018/07/21/wp-cli-hack-day-results/\"> was a great success</a>. Twelve pull requests were  merged and another 13 submitted. It also included a video chat to give all contributors a space to meet each other and connect directly.<br /></p>\n\n<p>Would  you like to get involved in contributing to WP-CLI? Follow <a href=\"https://make.wordpress.org/cli/\">the team blog</a> and join the #cli channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Further Reading:</h2>\n\n<ul><li>The WordPress Foundation is <a href=\"https://wordpressfoundation.org/2018/call-for-organizers-introduction-to-open-source-workshops-for-2018/\">looking for local community organizers to run introductory open-source workshops</a> in 2018.</li><li><a href=\'https://profiles.wordpress.org/chanthaboune/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chanthaboune</a> compiled <a href=\"https://wordpress.org/news/2018/07/quarterly-updates-q2-2018/\">updates for the last quarter</a> from the contribution teams all across the WordPress project.</li><li>In a great move for internationalization, <a href=\"https://en.blog.wordpress.com/2018/03/29/the-wordpress-mobile-apps-now-support-right-to-left-languages/\">the WordPress Mobile Apps now support right-to-left languages</a>.</li><li><a href=\"https://make.wordpress.org/community/2018/07/10/stripe-is-now-available-to-all-wordcamps/\">WordCamp events can now accept payment via Stripe</a> — PayPal remains an alternative option.</li><li>The WP-CLI team will soon <a href=\"https://make.wordpress.org/cli/2018/07/19/details-on-the-upcoming-major-release/\">release v2.0</a> of the official WordPress command line tool.</li><li>The Fields API project in WordPress Core <a href=\"https://wptavern.com/wordpress-core-fields-api-project-is-seeking-new-leadership\">is looking for a new lead</a> to drive it forward.</li><li>In WordPress 4.9.8, <a href=\"https://make.wordpress.org/core/2018/07/27/registering-metadata-in-4-9-8/\">it will  be possible</a> for developers to fully register the meta fields used by their plugins and themes.</li><li>After many years of hard work, <a href=\"https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards\">v1.0.0 of the WordPress Coding Standards for PHP_CodeSniffer</a> has been released.</li><li>The Mobile team <a href=\"https://make.wordpress.org/mobile/2018/07/31/call-for-testing-wordpress-for-ios-10-6/\">is looking for people to help test</a> v10.6 of WordPress for iOS.</li></ul>\n\n<p><em>If you have a story we should consider including in the next “Month in WordPress” post, please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it here</em></a><em>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6158\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:51:\"\n		\n		\n				\n		\n				\n		\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Quarterly Updates | Q2 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/news/2018/07/quarterly-updates-q2-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 Jul 2018 14:50:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Updates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6140\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:347:\"To keep everyone aware of big projects and efforts across WordPress contributor teams, I&#8217;ve reached out to each team&#8217;s listed representatives. I asked each of them to share their Top Priority (and when they hope for it to be completed), as well as their biggest Wins and Worries. Have questions? I&#8217;ve included a link to [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Josepha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:15622:\"<p><em>To keep everyone aware of big projects and efforts across WordPress contributor teams, I&#8217;ve reached out to each team&#8217;s <a href=\"https://make.wordpress.org/updates/team-reps/\">listed representatives</a>. I asked each of them to share their Top Priority (and when they hope for it to be completed), as well as their biggest Wins and Worries. Have questions? I&#8217;ve included a link to each team&#8217;s site in the headings.﻿</em></p>\n\n<h2><a href=\"https://make.wordpress.org/accessibility/\">Accessibility</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/rianrietveld/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rianrietveld</a>, <a href=\'https://profiles.wordpress.org/joedolson/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>joedolson</a>, <a href=\'https://profiles.wordpress.org/afercia/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>afercia</a></li>\n	<li><strong>Priority</strong>: Working to make sure that Gutenberg is reasonably accessible prior to merge. ETA is before 5.0</li>\n	<li><strong>Struggle</strong>: Lack of developers and accessibility experts to help test and code the milestone issues. <em>The team is doing outreach to help solve this problem.</em></li>\n	<li><strong>Big Win</strong>: Interest from companies like The Paciello Group and Tenon.io to help out with Gutenberg code review and testing tools.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/cli/\">CLI</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: @danielbachhuber, <a href=\'https://profiles.wordpress.org/schlessera/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>schlessera</a></li>\n	<li><strong>Priority</strong>: Very first global <a href=\"https://make.wordpress.org/cli/2018/07/04/wp-cli-hack-day/\">Hack Day</a> is coming up July 20. Version 2.0.0 is still in progress (new <a href=\"https://github.com/wp-cli/wp-cli/issues/4752\">ETA</a> is end of July).</li>\n	<li><strong>Struggle</strong>: The team continues to need new contributors. The current team is tiny but tough.</li>\n	<li><strong>Big Win</strong>: WP-CLI is currently one of the project&#8217;s four main focuses, as mentioned in the Summer Update at WordCamp Europe.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/community/\">Community</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/francina/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>francina</a>, <a href=\'https://profiles.wordpress.org/hlashbrooke/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>hlashbrooke</a></li>\n	<li><strong>Priority</strong>: Focusing on smoothing out the processes in our community management by building up our team of volunteers and establishing what tools we need to keep things running well. ETA is ongoing.</li>\n	<li><strong>Struggle</strong>: Our two biggest struggles at the moment are tracking what we need to get done, and making final decisions on things. <em>There is current work on the tools available to assist with tracking progress.﻿</em></li>\n	<li><strong>Big Win</strong>: After making a concerted effort to get more contributors on the Community Team, we now have a much larger group of volunteers working as deputies and WordCamp mentors</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/core/\">Core</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/jeffpaul/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jeffpaul</a></li>\n	<li><strong>Priority</strong>: Following the <a href=\"https://wordpress.tv/2018/07/04/matt-mullenweg-a-summertime-update-keynote-and-qa/\">WordCamp Europe summer update</a> ﻿(and the companion post <a href=\"https://wordpress.org/news/2018/07/update-on-gutenberg/\">here</a>), the team is getting Gutenberg (the new WordPress editing experience) into a strong state for the 5.0 release. Potential ETA as soon as August.</li>\n	<li><strong>Struggle</strong>: Coordinating momentum and direction as we start seeing more contributors offering their time. Still working our way through open issues. <em>﻿The team is starting multiple bug scrubs each week to work through these more quickly and transparently.</em></li>\n	<li><strong>Big Win</strong>: Had a <a href=\"https://wordpress.org/news/2018/05/wordpress-4-9-6-privacy-and-maintenance-release/\">sizable release in 4.9.6</a> which featured major updates around privacy tools and functionality in Core.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/design/\">Design</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/melchoyce/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>melchoyce</a>, <a href=\'https://profiles.wordpress.org/karmatosed/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>karmatosed</a>, <a href=\'https://profiles.wordpress.org/boemedia/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>boemedia</a>, <a href=\'https://profiles.wordpress.org/joshuawold/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>joshuawold</a>, <a href=\'https://profiles.wordpress.org/mizejewski/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mizejewski</a></li>\n	<li><strong>Priority</strong>: Better on-boarding of new contributors, especially creating better documentation. ETA is end of July.</li>\n	<li><strong>Struggle</strong>: It&#8217;s hard to identify reasonably small tasks for first-time contributors.</li>\n	<li><strong>Big Win</strong>: The team is much more organized now which has helped clear out the design backlog, bring in new contributors, and also keep current contributors coming back. <em>Bonus: Joshua Wold will co-lead the upcoming release.</em></li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/docs/\">Documentation</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/kenshino/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>kenshino</a><br /></li>\n	<li><strong>Priority</strong>: Opening up the work on <a href=\"https://make.wordpress.org/docs/2018/02/26/state-of-helphub-february-2018/\">HelpHub</a> to new contributors and easing the onboarding process. No ETA.<br /></li>\n	<li><strong>Struggle</strong>: Some blockers with making sure the code and database can be ready to launch on https://wordpress.org/support/<br /></li>\n	<li><strong>Big Win</strong>: The <a href=\"https://wp-helphub.com/\">first phase of HelpHub</a> creation is complete, which means content updates (current info, more readable, easier discovery), internal search, design improvements, and REST API endpoints.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/hosting/\">Hosting</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/mikeschroder/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mikeschroder</a>, <a href=\'https://profiles.wordpress.org/jadonn/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jadonn</a></li>\n	<li><strong>Priority</strong>: Preparing hosts for supporting Gutenberg, especially support questions they&#8217;re likely to see when the &#8220;Try Gutenberg&#8221; callout is released. ETA July 31st, then before WordPress 5.0<br /><strong></strong></li>\n	<li><strong>Struggle</strong>: Most contributions are still made a by a small team of volunteers. Seeing a few more people join, but progress is slow.<br /><strong></strong></li>\n	<li><strong>﻿Big Win</strong>: New team members and hosting companies have joined the #hosting-community team and have started contributing.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/marketing/\">Marketing</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/bridgetwillard/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>bridgetwillard</a></li>\n	<li><strong>Priority</strong>: Continuing to write and publish case studies from the community. ETA is ongoing.</li>\n	<li><strong>Struggle</strong>: No current team struggles.</li>\n	<li><strong>Big Win</strong>: Wrote and designed a short <a href=\"https://make.wordpress.org/marketing/2018/04/24/contributor-day-onboarding-pdf/\">Contributor Day onboarding card</a>. It was used at Contributor Day at WCEU and onboarding time went down to 1 hour instead of 3 hours.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/meta/\">Meta</a> (WordPress.org Site)</h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/tellyworth/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>tellyworth</a>, <a href=\'https://profiles.wordpress.org/coffee2code/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>coffee2code</a></li>\n	<li><strong>Priority</strong>: Reducing manual work around the contributor space (theme review, GDPR/privacy, plugin review). ETA for small wins is end of quarter, larger efforts after that.</li>\n	<li><strong>Struggle</strong>: Maintaining momentum on tickets. <em>There are also some discussions about updating the ticket management process across teams that use the Meta trac system.</em></li>\n	<li><strong>Big Win</strong>: The new About page launched and has been translated across most locale sites.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/mobile/\">Mobile</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/elibud/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>elibud</a></li>\n	<li><strong>Priority</strong>: Getting Gutenberg in the mobile applications. ETA is late December.</li>\n	<li><strong>Struggle</strong>: Consuming the Gutenberg source in the ReactNative app directly. <em>More info can be found here: https://make.wordpress.org/mobile/2018/07/09/next-steps-for-gutenberg-mobile/</em></li>\n	<li><strong>Big Win</strong>: The WordPress mobile applications now fully support right-to-left languages and are compliant with the latest standards for accessibility.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/plugins/\">Plugins</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/ipstenu/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ipstenu</a></li>\n	<li><strong>Priority</strong>: Clearing ~8,000 unused plugins from the queues. Likely ETA is September.<br /></li>\n	<li><strong>Struggles</strong>: Had to triage a lot of false claims around plugins offering GDPR compliance.</li>\n	<li><strong>Big Win</strong>: Released 4.9.6 and <a href=\"https://make.wordpress.org/plugins/2018/05/17/wp-4-9-6-privacy-hooks-and-you/\">updated expectations</a> with plugin authors. Huge thanks to the Core Privacy team for their hard work on this.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/polyglots/\">Polyglots</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/petya/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>petya</a>, <a href=\'https://profiles.wordpress.org/ocean90/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ocean90</a>, <a href=\'https://profiles.wordpress.org/nao/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>nao</a>, <a href=\'https://profiles.wordpress.org/chantalc/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chantalc</a>, <a href=\'https://profiles.wordpress.org/deconf/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>deconf</a>, <a href=\'https://profiles.wordpress.org/casiepa/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>casiepa</a></li>\n	<li><strong>Priority</strong>: Keep WordPress releases translated to 100% and then concentrate on the top 100 plugins and themes. ETA is ongoing.<br /><strong></strong></li>\n	<li><strong>﻿Struggle</strong>: Getting new PTEs fast enough, and complex tools/systems. Overall, the volume of strings awaiting approval.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/support/\">Support</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/clorith/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>clorith</a></li>\n	<li><strong>Priority:</strong> Getting ready for the Gutenberg callout (it got pushed last quarter). Needing a better presence on the official support forums, and outreach for that is underway, ETA end of July. <br /></li>\n	<li><strong>Struggle</strong>: Keeping contributors participating post-contributor days/drives. <em>﻿Considering the creation of a dedicated post-contributor day survey to get some insight here.</em></li>\n	<li><strong>Big Win</strong>: The increase in international liaisons joining for weekly meetings, helping bring the wider support community together.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/themes/\">Theme Review</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/acosmin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>acosmin</a>, <a href=\'https://profiles.wordpress.org/rabmalin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rabmalin</a>, <a href=\'https://profiles.wordpress.org/thinkupthemes/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>thinkupthemes</a>, <a href=\'https://profiles.wordpress.org/williampatton/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>williampatton</a></li>\n	<li><strong>Priority</strong>: Building a better Theme Check/Sniffer in order to automate most of the checks done right now by reviewers. ETA late 2018, early 2019.</li>\n	<li><strong>Struggle</strong>: Bringing in new contributors to the team.</li>\n	<li><strong>Big Win</strong>: <a href=\"https://make.wordpress.org/themes/2018/04/30/trusted-authors-program/\">Trusted Authors program﻿</a></li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/tide/\">Tide</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/valendesigns/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>valendesigns</a> (but usually <a href=\'https://profiles.wordpress.org/jeffpaul/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jeffpaul</a>)</li>\n	<li><strong>Priority</strong>: Storing PHPCompatibilty results inside the WordPress.org API and building a UI to display those results, an endpoint to request an audit is required for this work to continue.</li>\n	<li><strong>Struggle</strong>: Development has dramatically slowed down while team members are on leave or pulled into internal client work.</li>\n	<li><strong>Big Win</strong>: Migration to Google Cloud Platform (GCP) from Amazon Web Services (AWS) is complete and the audit servers have all been rewritten in Go. (This allows us to be faster with greater capacity and less cost.)</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/training/\">Training</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/bethsoderberg/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>bethsoderberg</a>, <a href=\'https://profiles.wordpress.org/juliek/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>juliek</a></li>\n	<li><strong>Priority:</strong> Lesson plan production. ETA is ongoing.</li>\n	<li><strong>Struggle:</strong> The workflow is a little complex, so recruiting and training enough contributors to keep the process moving is a struggle.</li>\n	<li><strong>Big Win</strong>: WordCamp Europe&#8217;s Contributor Day was very productive. New tools/workflow are in place and two team representatives were there to lead and help.</li>\n</ul>\n\n<p><em>Interested in updates from the first quarter of this year? You can find those here: <a href=\"https://make.wordpress.org/updates/2018/04/24/quarterly-updates-q1-2018/\"><em>https://make.wordpress.org/updates/2018/04/24/quarterly-updates-q1-2018/</em></a>\n	</em>\n</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6140\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Mon, 05 Nov 2018 19:57:56 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Mon, 05 Nov 2018 00:20:21 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";s:14:\"20130911070210\";}", "no");
INSERT INTO `tb_options` VALUES("233", "_transient_timeout_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1541491077", "no");
INSERT INTO `tb_options` VALUES("234", "_transient_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1541447877", "no");
INSERT INTO `tb_options` VALUES("235", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1541491078", "no");
INSERT INTO `tb_options` VALUES("236", "_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WPTavern: WordPress 5.0 Beta 3 Released, RC 1 Expected November 12\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=85224\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://wptavern.com/wordpress-5-0-beta-3-released-rc-1-expected-november-12\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6909:\"<p><a href=\"https://wordpress.org/news/2018/11/wordpress-5-0-beta-3/\" rel=\"noopener noreferrer\" target=\"_blank\">WordPress 5.0 Beta 3</a> was released this morning. This beta incorporates all the changes from <a href=\"https://make.wordpress.org/core/2018/10/31/whats-new-in-gutenberg-31st-october-2/\" rel=\"noopener noreferrer\" target=\"_blank\">Gutenberg 4.2 RC1</a>, which was released last week. It fixes a bug with the display of the custom fields meta box and also improves REST API requests.</p>\n<p>Gutenberg has undergone a few UI tweaks and introduces a <a href=\"https://github.com/WordPress/gutenberg/pull/10209\" rel=\"noopener noreferrer\" target=\"_blank\">Formatting API</a> for adding new RichText components. The inserter between blocks was updated to provide a more consistent experience that matches the other “add block” buttons. Version 4.2 also adds support for displaying icons in new block categories to better organize groups of blocks. The example pictured in the release post shows the Jetpack icon. The Jetpack team has been <a href=\"https://wptavern.com/jetpack-6-6-improves-site-verification-tools-asset-cdn-module-now-in-beta-gutenberg-blocks-coming-soon\" rel=\"noopener noreferrer\" target=\"_blank\">working on a number of blocks for existing features</a> and is expected to release those soon.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2018/11/block-categories.png?ssl=1\"><img /></a></p>\n<p>WordPress 5.0 Beta 3 brings in updates from Twenty Nineteen&#8217;s GitHub repository, including support for selective refresh widgets in the customizer, support for responsive embeds, and tweaks to improve the experience on mobile devices.</p>\n<h3>Updates to WordPress 5.0 Schedule: More Beta Releases and a Shortened RC Period</h3>\n<p>WordPress 5.0 is now two weeks away from its <a href=\"https://make.wordpress.org/core/5-0/\" rel=\"noopener noreferrer\" target=\"_blank\">projected release date</a> of November 19. Last week Gary Pendergast announced some <a href=\"https://make.wordpress.org/core/2018/10/31/wordpress-5-0-schedule-updates/\" rel=\"noopener noreferrer\" target=\"_blank\">updates to the 5.0 release schedule</a> that build in extra time for betas. After pushing out Beta 3 Pendergast said he expects to release Beta 4 later this week. He also offered an explanation for why RC1 is scheduled for release on November 12, allowing for just one week of last-minute testing following RC.</p>\n<p>&#8220;The block editor has been available for over a year,&#8221; Pendergast said. &#8220;It’s already had a longer testing period, with 30 times the number of sites using it, than any previous WordPress release. The primary purpose of the beta and release candidate periods is to ensure that it’s been correctly merged into Core.&#8221;</p>\n<p>Initial feedback on the schedule changes indicate that some user would appreciate a longer RC period, since the code being tested has changed so often. </p>\n<p>&#8220;The API freeze just happened in version 4.2, so saying the editor has been available for over a year in anywhere near its current state doesn’t make sense for a 7-day RC period on such a major change,&#8221; WordPress trainer and developer Brian Hogg <a href=\"https://make.wordpress.org/core/2018/10/31/wordpress-5-0-schedule-updates/#comment-34292\" rel=\"noopener noreferrer\" target=\"_blank\">said</a>.</p>\n<p>&#8220;As an example, just in the last version or two the hover-over menu to remove a block has been taken out and tucked away at the top menu (which was available as shown in <a href=\"https://youtu.be/yjqW_IS6Q7w?t=80\" rel=\"noopener noreferrer\" target=\"_blank\">https://youtu.be/yjqW_IS6Q7w?t=80</a>), with little time for anyone to provide usability feedback on changes like this.&#8221;</p>\n<p>Those who are creating training materials and videos have been waiting for a bit of a reprieve in Gutenberg development to make sure their materials are accurate and ready for 5.0.</p>\n<p>&#8220;Knowing it’s an RC means we can assume a level of &#8216;this is how it will be&#8217; that just isn’t necessarily with pre-RC versions,&#8221; Modern Tribe developer George Gecewicz <a href=\"https://make.wordpress.org/core/2018/10/31/wordpress-5-0-schedule-updates/#comment-34278\" rel=\"noopener noreferrer\" target=\"_blank\">commented</a> on the post. &#8220;That relative certainty is useful for testing aggressively, finalizing design/UI stuff, and revealing post-merge bugs.&#8221;</p>\n<p>Gutenberg 4.1 was supposed to be the &#8220;<a href=\"https://github.com/WordPress/gutenberg/milestone/66\" rel=\"noopener noreferrer\" target=\"_blank\">UI freeze</a>&#8221; milestone, but that hasn&#8217;t happened yet with several changes introduced in 4.2. </p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">The \"freeze\" in \"UI freeze\" doesn\'t mean you can thaw it and change it willy nilly. Some of us rely on such landmarks to do our work.</p>\n<p>&mdash; Morten Rand-Hendriksen (@mor10) <a href=\"https://twitter.com/mor10/status/1059269623944642560?ref_src=twsrc%5Etfw\">November 5, 2018</a></p></blockquote>\n<p></p>\n<p>There should be short window of time before 5.0 is released where training materials can be finalized. However, the Gutenberg team plans to continue on from there with its same pace of development.</p>\n<p>&#8220;Over the past six months, there has been a release every two weeks,&#8221; Pendergast said. &#8220;We’ll plan to continue that over the first few WordPress 5.0.x releases, to ensure that bug fixes are available as quickly as possible. How soon should we expect WordPress 5.0.1? Approximately two weeks after WordPress 5.0, unless we see bug reports that indicate a need for a faster release.&#8221;</p>\n<p>WordPress 5.0 is on schedule for its original release date, but there is still a possibility for the the release to be delayed. Matt Mullenweg, <a href=\"https://wptavern.com/wordpress-accessibility-team-delivers-sobering-assessment-of-gutenberg-we-have-to-draw-a-line#comment-266997\" rel=\"noopener noreferrer\" target=\"_blank\">commenting</a> on responses to the accessibility team&#8217;s assessment of Gutenberg, said that delaying the release has &#8220;definitely been considered&#8221; and that it may still happen. His response also indicates that WordPress users can expect the pace of core development to continue along the path Gutenberg has carved. </p>\n<p>&#8220;Despite some differences that still need be resolved, there’s general consensus that the long-term way to create the best WP experience for all types of users is not something you can tack on with 5-6 weeks at the end, but will be the result of continuing the continuous iteration we’ve had with the 42 public releases of Gutenberg so far,&#8221; Mullenweg said. &#8220;It means we can get improvements into the hands of users within weeks following a release, not months (or years) as was the old model with WordPress.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Nov 2018 18:39:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Dev Blog: WordPress 5.0 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6236\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2018/11/wordpress-5-0-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3134:\"<p>WordPress 5.0 Beta 3 is now available!</p>\n\n<p><strong>This software is still in development,</strong>&nbsp;so we don’t recommend you run it on a production site. Consider setting up a test site to play with the new version.</p>\n\n<p>There are two ways to test the WordPress 5.0 Beta: try the&nbsp;<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a>&nbsp;plugin (you’ll want “bleeding edge nightlies”), or you can&nbsp;<a href=\"https://wordpress.org/wordpress-5.0-beta3.zip\">download the beta here</a>&nbsp;(zip).</p>\n\n<p>WordPress 5.0 is slated for release on&nbsp;<a href=\"https://make.wordpress.org/core/5-0/\">November 19</a>, and we need your help to get there. Here are some of the big issues that we&#8217;ve fixed since Beta 2:</p>\n\n<h2>Block Editor</h2>\n\n<p>The block editor has been updated to include all of the features and bug fixes from the upcoming <a href=\"https://make.wordpress.org/core/2018/10/31/whats-new-in-gutenberg-31st-october-2/\">Gutenberg 4.2 release</a>. Additionally, there are some newer bug fixes and features, such as:</p>\n\n<ul><li>Adding support for the &#8220;Custom Fields&#8221; meta box.</li><li>Improving the reliability of REST API requests.</li><li>A myriad of minor tweaks and improvements.</li></ul>\n\n<h2>Twenty Nineteen</h2>\n\n<p>Twenty Nineteen has been updated from its <a href=\"https://github.com/WordPress/twentynineteen\">GitHub repository</a>, this version is full of new goodies to check out:</p>\n\n<ul><li>Adds support for Selective Refresh Widgets in the Customiser.</li><li>Adds support for Responsive Embeds.</li><li>Tweaks to improve readability and functionality on mobile devices.</li><li>Fixes nested blocks appearing wider than they should be.</li><li>Fixes some errors in older PHP versions, and in IE11.</li></ul>\n\n<h2>How to Help</h2>\n\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a> </p>\n\n<p>If you&#8217;re able to contribute with coding or testing changes, we have <a href=\"https://make.wordpress.org/core/2018/11/02/upcoming-5-0-bug-scrubs/\">a multitude of bug scrubs</a> scheduled this week, we&#8217;d love to have as many people as we can ensuring all bugs reported get the attention they deserve.</p>\n\n<p><strong><em>If you think you’ve found a bug</em></strong><em>, you can post to the&nbsp;</em><a href=\"https://wordpress.org/support/forum/alphabeta\"><em>Alpha/Beta area</em></a><em>&nbsp;in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report,&nbsp;</em><a href=\"https://make.wordpress.org/core/reports/\"><em>file one on WordPress Trac</em></a><em>, where you can also find&nbsp;</em><a href=\"https://core.trac.wordpress.org/tickets/major\"><em>a list of known bugs</em></a><em>.</em></p>\n\n<hr class=\"wp-block-separator\" />\n\n<p><em>WordPress Five Point Oh<br />is just two short weeks away.<br />Thank you for helping!</em> <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f496.png\" alt=\"💖\" class=\"wp-smiley\" /><em><br /></em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Nov 2018 00:20:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Gary Pendergast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"WPTavern: GitHub Rolls Out More Small Improvements as Part of Project Paper Cuts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=85245\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://wptavern.com/github-rolls-out-more-small-improvements-as-part-of-project-paper-cuts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4625:\"<p>In August, GitHub <a href=\"https://blog.github.com/2018-08-28-announcing-paper-cuts/\" rel=\"noopener noreferrer\" target=\"_blank\">announced</a> Project Paper Cuts, an effort aimed at bringing small improvements to the developer and project maintainer experiences. These are fixes for issues that don&#8217;t generally fall within larger initiatives. Some of the first improvements that have already been implemented include the following:</p>\n<ul>\n<li>Unselect markers when copying and pasting the contents of a diff</li>\n<li>Edit a repository’s README from the repository root</li>\n<li>Access your repositories straight from the profile dropdown</li>\n<li>Highlight permalinked comments</li>\n<li>Remove files from a pull request with a button</li>\n<li>Branch names in merge notification emails</li>\n<li>Create new pull requests from your repository’s Pull Requests Page</li>\n<li>Add a teammate from the team discussions page</li>\n<li>Collapse all diffs in a pull request at once</li>\n<li>Copy the URL of a comment</li>\n</ul>\n<p>One of the latest improvements allows repository admins to transfer an issue that has been misfiled to another repository where it belongs. At the moment it only works within the same GitHub organization account. Initial <a href=\"https://twitter.com/asmeurer/status/1057741387108560897\" rel=\"noopener noreferrer\" target=\"_blank\">feedback</a> from users indicates many would appreciate this feature require push permissions, instead of admin permissions, as there are likely more users who can help in the bug tracker with moving issues, setting labels, and closing bugs.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Issue filed in the wrong repo? </p>\n<p>We know your pain! And now we\'ve got a fix. </p>\n<p>Repo admins can transfer issues to wherever they belong. <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f3d8.png\" alt=\"🏘\" class=\"wp-smiley\" /> <a href=\"https://t.co/rPwNng7ZOl\">pic.twitter.com/rPwNng7ZOl</a></p>\n<p>&mdash; GitHub (@github) <a href=\"https://twitter.com/github/status/1057678791764467712?ref_src=twsrc%5Etfw\">October 31, 2018</a></p></blockquote>\n<p></p>\n<p>The &#8220;<a href=\"https://blog.github.com/2018-11-01-suggested-changes-update/\" rel=\"noopener noreferrer\" target=\"_blank\">suggested changes</a>&#8221; feature GitHub introduced in beta two weeks ago seems to have been adopted fairly quickly by users. Suggested Changes lets users suggest a change to code in a pull request. These changes can be accepted by the author or assignees with one click and then committed.</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2018/11/suggested-changes.png?ssl=1\"><img /></a></p>\n<p>GitHub reports more than 10 percent of all reviewers suggested at least one change. They have received 100,000 suggestions and estimate that 4% of all review commits created have included a suggestion. Based on feedback so far, GitHub put the following improvements on the roadmap for the Suggested Changes feature: </p>\n<ul>\n<li>The ability to suggest changes to multiple lines at once</li>\n<li>The ability to accept multiple changes in a single commit</li>\n</ul>\n<p>Project Paper Cuts is borrowing heavily from <a href=\"https://github.com/sindresorhus/refined-github/\" rel=\"noopener noreferrer\" target=\"_blank\">Refined GitHub</a>, a browser extension that simplifies the GitHub interface and adds useful features. </p>\n<p>&#8220;Full-time open source developer <a href=\"https://github.com/sindresorhus/\" rel=\"noopener noreferrer\" target=\"_blank\">Sindre Sorhus</a> has built a great browser extension that builds on and improves the GitHub experience, along with a fantastic community that has come together to discuss workflows and build their favorite features,&#8221; GitHub product manager Luke Hefson said. &#8220;Project Paper Cuts has taken inspiration from a lot of Refined GitHub’s additions, and we’re building some of the most-loved features right into GitHub itself.&#8221;</p>\n<p>GitHub is aiming to be more open and transparent with user feedback after the <a href=\"https://wptavern.com/open-source-project-maintainers-confront-github-with-open-letter-on-issue-management\" rel=\"noopener noreferrer\" target=\"_blank\">2016 fiasco with disgruntled open source project maintainers</a>. These fixes for small annoyances add up in the grand scheme of things to improve project workflow for millions of developers and project maintainers. The improvements are shipping out regularly and are all outlined in <a href=\"https://blog.github.com/changelog/\" rel=\"noopener noreferrer\" target=\"_blank\">GitHub&#8217;s public changelog</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 02 Nov 2018 18:58:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"WPTavern: WPWeekly Episode 336 – Interview With Andrew Roberts, CEO and Co-founder of Tiny\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=85267&preview=true&preview_id=85267\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"https://wptavern.com/wpweekly-episode-336-interview-with-andrew-roberts-ceo-and-co-founder-of-tiny\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2772:\"<p>In this episode, <a href=\"http://jjj.me\">John James Jacoby</a> and I are joined by <a href=\"https://twitter.com/andrew_roberts?lang=en\">Andrew Roberts</a>, CEO and Co-founder of <a href=\"https://www.tiny.cloud/\">Tiny</a>. Tiny is the company behind the popular open source library <a href=\"https://www.tiny.cloud/features/\">TinyMCE</a>. Roberts shares his entrepreneurial journey, what the company plans on doing with its recent <a href=\"https://wptavern.com/tiny-raises-4m-in-series-a-funding-publishes-gutenberg-faq\">round of funding</a>, and the relationship between TinyMCE and Gutenberg.</p>\n<p>Here is an excerpt from the show on what Roberts thinks about Gutenberg.</p>\n<blockquote><p>I think that ultimately Gutenberg will be more innovative than just incrementally changing from the old editor experience toward block-based editing.</p>\n<p>I think you know Matt&#8217;s probably had a tough year with some of the criticisms around Gutenberg but I admire his courage and leadership because if he hadn&#8217;t put his brand equity on the line, if he hadn&#8217;t invested his goodwill in doing this, this would never be launching in a month from now.</p>\n<p>There may be a painful year or two but in the grand scheme of things this will turn out for the better. It&#8217;s taken a lot of courage and bravery for him to do that. He&#8217;s taken a lot of shots in the back, but you know that&#8217;s why he gets paid the big bucks as they say.</p></blockquote>\n<h2>Stories Discussed:</h2>\n<p><a href=\"https://jjj.blog/2018/10/wordpress-5-0-beta-1/\">WordPress 5.0 Beta 1</a><br />\n<a href=\"https://wptavern.com/wordpress-accessibility-team-delivers-sobering-assessment-of-gutenberg-we-have-to-draw-a-line\">WordPress Accessibility Team Delivers Sobering Assessment of Gutenberg: “We have to draw a line.”</a><br />\n<a href=\"https://wptavern.com/woocommerce-3-5-introduces-rest-api-v3-improves-transactional-emails\">WooCommerce 3.5 Introduces REST API v3, Improves Transactional Emails</a><br />\n<a href=\"https://wptavern.com/wp-engine-acquires-array-themes\">WP Engine Acquires Array Themes</a></p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, November 7th 3:00 P.M. Eastern</p>\n<p>Subscribe to <a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\">WordPress Weekly via Itunes</a></p>\n<p>Subscribe to <a href=\"https://www.wptavern.com/feed/podcast\">WordPress Weekly via RSS</a></p>\n<p>Subscribe to <a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\">WordPress Weekly via Stitcher Radio</a></p>\n<p>Subscribe to <a href=\"https://play.google.com/music/listen?u=0#/ps/Ir3keivkvwwh24xy7qiymurwpbe\">WordPress Weekly via Google Play</a></p>\n<p><strong>Listen To Episode #336:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 02 Nov 2018 13:25:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"WPTavern: How to Add an Image to A Paragraph Block in Gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=85201\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://wptavern.com/how-to-add-an-image-to-a-paragraph-block-in-gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2345:\"<p>WordPress 5.0 is on the horizon and with it comes a number of opportunities to explain how to get things done in the new editor. </p>\n<h2>Testing Scenario<br /></h2>\n<p>A user has written three paragraphs and decides to add an image to the second paragraph. This user wants the image to be aligned to the right. </p>\n<h2>Accomplishing the Task in the Classic Editor</h2>\n<p>The classic editor is essentially one big block. Adding media to a paragraph is as quick as placing the mouse cursor at the beginning of a paragraph, clicking the add new media button, selecting or uploading an image, and choosing its alignment. </p>\n<h2 id=\"mce_6\">Accomplishing the Task in Gutenberg</h2>\n<p>In Gutenberg, each paragraph is a block and each block has its own toolbar. This is important because after writing three paragraphs, you can&#8217;t click on an add media button. Instead, you need to create an image block. </p>\n<p>Once you&#8217;ve selected an image, you need to move the image block above the paragraph block where you want to insert it. At first, you might try to drag and drop the image into the paragraph but that doesn&#8217;t work. You need to use the up and down arrows or drag the block into position. </p>\n<p>Once the image block is in the correct location, click the align right icon. The image will be inserted into the right side of the paragraph block. </p>\n<img />A Right Aligned Image Inside of A Paragraph Block\n<p>If you want to move the image to a different paragraph block, you&#8217;ll need to click the Align center button which turns the image back into its own block and repeat the process described above. </p>\n<h2>Adding Images to Paragraphs in the Classic Editor Is Easier<br /></h2>\n<p>The task I described above is one I think millions of users will have trouble completing when WordPress 5.0 is released. In the Classic editor, the writing flow doesn&#8217;t feel disjointed when you want to add images or embed content into posts. </p>\n<p>In Gutenberg, everything is a block which in many cases, causes the flow to be disrupted as you need to figure out what block you need, how to manipulate it, where to move it, find where the options are, etc. </p>\n<p>The process of adding images to paragraphs will likely improve after WordPress 5.0 is released but until then, the Classic editor wins this use case. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 02 Nov 2018 11:35:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"WPTavern: Google’s reCAPTCHA v3 Promises a “Frictionless User Experience”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=85145\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://wptavern.com/googles-recaptcha-v3-promises-a-frictionless-user-experience\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3218:\"<p>Google <a href=\"https://webmasters.googleblog.com/2018/10/introducing-recaptcha-v3-new-way-to.html\" rel=\"noopener noreferrer\" target=\"_blank\">introduced reCAPTCHA v3</a> this week, which promises a new &#8220;frictionless user experience.&#8221; Earlier versions of the API stopped bots but also drew the ire of internet users across the globe. Users were regularly inconvenienced with distorted text challenges, street sign puzzles, click requirements, and other actions to prove their humanity. </p>\n<p>v3 offers a marked improvement by detecting bots in the background and returning a score that tells the admin if the interaction is suspicious. It scores traffic with its <a href=\"https://patents.google.com/patent/US20110054961A1/en\">Adaptive Risk Analysis Engine</a> instead of forcing human users to perform interactive challenges. The score can be used three different ways:</p>\n<ul>\n<li>Set a threshold that determines when a user is let through or when further verification needs to be done, i.e. two-factor authentication or phone verification.</li>\n<li>Combine the score with your own signals that reCAPTCHA can’t access, such as user profiles or transaction histories.</li>\n<li>Use the reCAPTCHA score as one of the signals to train your machine learning model to fight abuse.</li>\n</ul>\n<p>v3 give site owners more options to customize the thresholds and actions for different types of traffic. The video below explains how it works and the <a href=\"https://developers.google.com/recaptcha/docs/v3\" rel=\"noopener noreferrer\" target=\"_blank\">developer docs</a> have more information on frontend integration and score interpretation.</p>\n<p></p>\n<p>Site owners can view their traffic in the <a href=\"https://www.google.com/recaptcha/admin\" rel=\"noopener noreferrer\" target=\"_blank\">reCAPTCHA admin console</a>. It also displays a list of all of your sites and what version of the API they are using.</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2018/10/Screen-Shot-2018-11-01-at-5.08.11-PM.png?ssl=1\"><img /></a></p>\n<p>The admin console also has a form for registering new sites:</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/10/Screen-Shot-2018-11-01-at-5.09.18-PM.png?ssl=1\"><img /></a></p>\n<p>The WordPress Plugin Directory has <a href=\"https://wordpress.org/plugins/search/reCAPTCHA/\" rel=\"noopener noreferrer\" target=\"_blank\">dozens of standalone plugins and contact forms</a> that make use of reCAPTCHA in some way. Sites that are already set up to use v2 or the Invisible CAPTCHA, will not automatically update to use v3. There&#8217;s a different signup and implementation process that the site owner has to perform before having it integrated on the site.</p>\n<p>WordPress plugin developers who offer reCAPTCHA will have to decide if they want to update existing plugins to use v3 or package a v3 offering in a new plugin. The reCAPTCHA v1 API was shut down earlier this year in March. Google&#8217;s <a href=\"https://github.com/google/recaptcha/\" rel=\"noopener noreferrer\" target=\"_blank\">reCAPTCHA PHP client library on GitHub</a> is still actively encouraging use of both v2 and v3. A date has not been announced for v2 to be deprecated. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 02 Nov 2018 00:09:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"Dev Blog: Quarterly Updates | Q3 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6206\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/news/2018/11/quarterly-updates-q3-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:13505:\"<p><em>To keep everyone aware of big projects and efforts across WordPress contributor teams, I&#8217;ve reached out to each team&#8217;s <a href=\"https://make.wordpress.org/updates/team-reps/\">listed representatives</a>. I asked each of them to share their Top Priority (and when they hope for it to be completed), as well as their biggest Wins and Worries. Have questions? I&#8217;ve included a link to each team&#8217;s site in the headings.</em></p>\n\n<h2><a href=\"https://make.wordpress.org/accessibility/\">Accessibility</a></h2>\n<p></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\"https://profiles.wordpress.org/joedolson/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>joedolson</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>audrasjb</a>, <a href=\"https://profiles.wordpress.org/arush/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>arush</a></li>\n<li><strong>Priority</strong>: Work on authoring a manual for assistive technology users on Gutenberg, led by Claire Brotherton (<a href=\"https://profiles.wordpress.org/abrightclearweb/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>abrightclearweb</a>). Continue to work on improving the overall user experience in Gutenberg. Update and organize the WP A11y handbook.</li>\n<li><strong>Struggle</strong>: Lack of developers and accessibility experts to help test and code the milestone issues. Still over 100 outstanding issues, and developing the Gutenberg AT manual helps expose additional issues. The announcement of an accessibility focus on 4.9.9 derailed our planning for Gutenberg in September with minimal productivity, as that goal was quickly withdrawn from the schedule.</li>\n<li><strong>Big Win</strong>: Getting focus constraint implemented in popovers and similar components in Gutenberg.</li>\n</ul>\n<p></p>\n<h2><a href=\"https://make.wordpress.org/cli/\">CLI</a></h2>\n<p></p>\n<ul>\n<li><strong>Contacted</strong>: @danielbachhuber, <a href=\"https://profiles.wordpress.org/schlessera/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>schlessera</a></li>\n<li><strong>Priority</strong>: Current priority is v2.1.0 of WP-CLI, to polish the major refactoring v2.0.0 introduced. You can <a href=\"https://make.wordpress.org/cli/good-first-issues/\">join in or follow progress</a> on their site.</li>\n<li><strong>Struggle</strong>: Getting enough contributors to make peer-review possible/manageable.</li>\n<li><strong>Big Win</strong>: The major refactoring of v2 was mostly without any negative impacts on existing installs. It provided substantial improvements to maintainability including: faster and more reliable testing, more straight-forward changes to individual packages, and simpler contributor on-boarding.</li>\n</ul>\n<p></p>\n<h2><a href=\"https://make.wordpress.org/community/\">Community</a></h2>\n<p></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\"https://profiles.wordpress.org/francina/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>francina</a>, <a href=\"https://profiles.wordpress.org/hlashbrooke/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>hlashbrooke</a></li>\n<li><strong>Priority</strong>: Supporting contributors of all levels via: monthly <a href=\"https://make.wordpress.org/community/2018/10/08/announcement-monthly-chat-for-wordcamp-organisers/\">WordCamp Organizers chat</a>, better onboarding with a translated <a href=\"https://make.wordpress.org/community/2017/08/11/global-community-team-welcome-pack/\">welcome pack</a>, and Contribution Drive documentation.</li>\n<li><strong>Struggle</strong>: Fewer contributors than usual.</li>\n<li><strong>Big Win</strong>: <a href=\"https://make.wordpress.org/community/2018/09/21/meetup-application-vetting-sprint-26-27-september/\">Meetup Vetting Sprint</a>! </li>\n</ul>\n<p></p>\n<h2><a href=\"https://make.wordpress.org/core/\">Core</a></h2>\n<p></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\"https://profiles.wordpress.org/jeffpaul/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>jeffpaul</a></li>\n<li><strong>Priority</strong>: Continued preparation for the 5.0 release cycle and Gutenberg.</li>\n<li><strong>Struggle</strong>: Identifying tasks for first time contributors, as well as for new-to-JS contributors.</li>\n</ul>\n<p></p>\n<h2><a href=\"https://make.wordpress.org/design/\">Design</a></h2>\n<p></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\"https://profiles.wordpress.org/melchoyce/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>melchoyce</a>, <a href=\"https://profiles.wordpress.org/karmatosed/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>karmatosed</a>, <a href=\"https://profiles.wordpress.org/boemedia/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>boemedia</a>, <a href=\"https://profiles.wordpress.org/joshuawold/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>joshuawold</a>, <a href=\"https://profiles.wordpress.org/mizejewski/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mizejewski</a></li>\n<li><strong>Priority</strong>: Preparing for WordPress 5.0 and continuing to work on better onboarding practices.</li>\n<li><strong>Struggle</strong>: Identifying tasks for contributor days, especially for small- to medium-sized tasks that can be fit into a single day.</li>\n<li><strong>Big Win</strong>: Regular contributions are starting to build up.</li>\n</ul>\n<p></p>\n<h2><a href=\"https://make.wordpress.org/docs/\">Documentation</a></h2>\n<p></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\"https://profiles.wordpress.org/kenshino/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>kenshino</a></li>\n<li><strong>Priority</strong>: Getting HelpHub out before WordPress 5.0&#8217;s launch to make sure Gutenberg User Docs have a permanent position to reside</li>\n<li><strong>Struggle</strong>: Getting the documentation from HelpHub into WordPress.org/support is more manual than initially anticipated.</li>\n<li><strong>Big Win</strong>: Had a good discussion with the Gutenberg team about their docs and how WordPress.org expects documentation to be distributed (via DevHub, Make and HelpHub). Getting past the code blocks to release HelpHub (soon)</li>\n</ul>\n<p></p>\n<h2><a href=\"https://make.wordpress.org/hosting/\">Hosting</a></h2>\n<p></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\"https://profiles.wordpress.org/mikeschroder/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mikeschroder</a>, <a href=\"https://profiles.wordpress.org/jadonn/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>jadonn</a></li>\n<li><strong>Priority</strong>: Helping Gutenberg land well at hosts for users in 5.0.</li>\n<li><strong>Struggle</strong>: Short time frame with few resources to accomplish priority items.</li>\n<li><strong>Big Win</strong>: Preparing Try Gutenberg support guide for hosts during the rollout and good reception from users following it.</li>\n</ul>\n<p></p>\n<h2><a href=\"https://make.wordpress.org/marketing/\">Marketing</a></h2>\n<p></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\"https://profiles.wordpress.org/bridgetwillard/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>bridgetwillard</a></li>\n<li><strong>Priority</strong>: Continuing to write and publish case studies from the community.</li>\n<li><strong>Big Win</strong>: Onboarding guide is going well and is currently being <a href=\"https://translate.wordpress.org/projects/meta/get-involved\">translated</a>.</li>\n</ul>\n<p></p>\n<h2><a href=\"https://make.wordpress.org/meta/\">Meta</a> (WordPress.org Site)</h2>\n<p></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\"https://profiles.wordpress.org/tellyworth/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>tellyworth</a>, <a href=\"https://profiles.wordpress.org/coffee2code/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>coffee2code</a></li>\n<li><strong>Priority</strong>: Support for other teams in the lead up to, and the follow-up of, the release of WP 5.0. ETA is the WP 5.0 release date (Nov 19) and thereafter, unless it gets bumped to next quarter.</li>\n<li><strong>Struggle</strong>: Maintaining momentum on tickets (still).</li>\n<li><strong>Big Win</strong>: Launch of front-end demo of Gutenberg on https://wordpress.org/gutenberg/</li>\n</ul>\n<p></p>\n<h2><a href=\"https://make.wordpress.org/mobile/\">Mobile</a></h2>\n<p></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\"https://profiles.wordpress.org/elibud/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>elibud</a></li>\n<li><strong>Priority</strong>: Have an alpha version of Gutenberg in the WordPress apps, ETA end of year 2018.</li>\n<li><strong>Struggle</strong>: Unfamiliar tech stack and the goal of reusing as much of Gutenberg-web&#8217;s code as possible.</li>\n<li><strong>Big Win</strong>: Running mobile tests on web&#8217;s PRs.</li>\n</ul>\n<p></p>\n<h2><a href=\"https://make.wordpress.org/plugins/\">Plugins</a></h2>\n<p></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\"https://profiles.wordpress.org/ipstenu/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ipstenu</a></li>\n<li><strong>Priority</strong>: Cleaning up &#8216;inactive&#8217; users, which was supposed to be complete but some work preparing for 5.0 was necessary.</li>\n<li><strong>Struggles</strong>: Devnotes are lacking for the upcoming release which slows progress.</li>\n<li><strong>Big Win</strong>: No backlog even though a lot were out!</li>\n</ul>\n<p></p>\n<h2><a href=\"https://make.wordpress.org/polyglots/\">Polyglots</a></h2>\n<p></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\"https://profiles.wordpress.org/petya/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>petya</a>, <a href=\"https://profiles.wordpress.org/ocean90/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ocean90</a>, <a href=\"https://profiles.wordpress.org/nao/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>nao</a>, <a href=\"https://profiles.wordpress.org/chantalc/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>chantalc</a>, <a href=\"https://profiles.wordpress.org/deconf/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>deconf</a>, <a href=\"https://profiles.wordpress.org/casiepa/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>casiepa</a></li>\n<li><strong>Priority</strong>: Help re-activating inactive locale teams.</li>\n<li><strong>Struggle</strong>: Many GTEs are having a hard time keeping up with incoming translation <a href=\"https://make.wordpress.org/polyglots/?resolved=unresolved&tags=editor-requests\">validation and PTE requests</a>.</li>\n<li><strong>Big Win</strong>: Made some progress in locale research and reassigning new GTEs.</li>\n</ul>\n<p></p>\n<h2><a href=\"https://make.wordpress.org/support/\">Support</a></h2>\n<p></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\"https://profiles.wordpress.org/clorith/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>clorith</a></li>\n<li><strong>Priority:</strong> Preparing for the upcoming 5.0 release</li>\n<li><strong>Struggle</strong>: Finding a good balance between how much we want to help people and how much we are able to help people. Also, contributor recruitment (always a crowd favorite!)</li>\n<li><strong>Big Win</strong>: How well the team, on a global level, has managed to maintain a good flow of user engagement through support.</li>\n</ul>\n<p></p>\n<h2><a href=\"https://make.wordpress.org/themes/\">Theme Review</a></h2>\n<p></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\"https://profiles.wordpress.org/acosmin/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>acosmin</a>, <a href=\"https://profiles.wordpress.org/rabmalin/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>rabmalin</a>, <a href=\"https://profiles.wordpress.org/thinkupthemes/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>thinkupthemes</a>, <a href=\"https://profiles.wordpress.org/williampatton/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>williampatton</a></li>\n<li><strong>Priority</strong>: Implementing the Theme Sniffer plugin on WordPress.org which is one step forward towards automation. ETA early 2019</li>\n<li><strong>Struggle</strong>: Not having so many contributors/reviewers.</li>\n<li><strong>Big Win</strong>: Implementing <a href=\"https://make.wordpress.org/themes/2018/10/25/new-requirements/\">multiple requirements</a> into our review flow, like screenshots and readme.txt requirements.</li>\n</ul>\n<p></p>\n<p></p>\n<h2><a href=\"https://make.wordpress.org/training/\">Training</a></h2>\n<p></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\"https://profiles.wordpress.org/bethsoderberg/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>bethsoderberg</a>, <a href=\"https://profiles.wordpress.org/juliek/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>juliek</a></li>\n<li><strong>Priority:</strong> Getting the learn.wordpress.org site designed, developed, and being able to publish lesson plans to it.</li>\n<li><strong>Struggle:</strong> Getting contributors onboard and continually contributing. Part of that is related to the learn.wordpress.org site. People like to see their contributions.</li>\n<li><strong>Big Win</strong>: We have our new workflow and tools in place. We are also streamlining that process to help things go from idea to publication more quickly.</li>\n</ul>\n<p></p>\n<p><em>Interested in updates from the last quarter? You can find those here: <a href=\"https://wordpress.org/news/2018/07/quarterly-updates-q2-2018/\">https://wordpress.org/news/2018/07/quarterly-updates-q2-2018/</a></em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Nov 2018 16:46:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Josepha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"Dev Blog: The Month in WordPress: October 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6230\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2018/11/the-month-in-wordpress-october-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8092:\"<p>Teams across the WordPress project are working hard to make sure everything is ready for the upcoming release of WordPress 5.0. Find out what’s going on and how you can get involved.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>The Plan for WordPress 5.0</h2>\n\n<p>Early this month, <a href=\"https://make.wordpress.org/core/2018/10/03/proposed-wordpress-5-0-scope-and-schedule/\">the planned release schedule was announced</a> for WordPress 5.0, which was <a href=\"https://make.wordpress.org/core/2018/10/31/wordpress-5-0-schedule-updates/\">updated</a> a few weeks later. WordPress 5.0 is a highly anticipated release, as it’s the official &nbsp;launch of Gutenberg &#8212; the new block editor for WordPress Core. For more detail, check out this <a href=\"https://make.wordpress.org/core/2018/10/12/granular-timeline/\">&nbsp;granular timeline</a>.<br /></p>\n\n<p>Along with the planned release schedule, <a href=\"https://profiles.wordpress.org/matt/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>matt</a>, who is heading up this release, <a href=\"https://make.wordpress.org/core/2018/10/03/a-plan-for-5-0/\">announced leads for critical focuses on the project</a>, including <a href=\"https://profiles.wordpress.org/matveb/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>matveb</a>, <a href=\"https://profiles.wordpress.org/karmatosed/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>karmatosed</a>, <a href=\"https://profiles.wordpress.org/laurelfulford/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>laurelfulford</a>, <a href=\"https://profiles.wordpress.org/allancole/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>allancole</a>, <a href=\"https://profiles.wordpress.org/lonelyvegan/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>lonelyvegan</a>, <a href=\"https://profiles.wordpress.org/omarreiss/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>omarreiss</a>, <a href=\"https://profiles.wordpress.org/antpb/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>antpb</a>, <a href=\"https://profiles.wordpress.org/pento/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>pento</a>, <a href=\"https://profiles.wordpress.org/chanthaboune/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>chanthaboune</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>danielbachhuber</a>, and <a href=\"https://profiles.wordpress.org/mcsf/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mcsf</a>.<br /></p>\n\n<p><a href=\"https://wordpress.org/news/2018/10/wordpress-5-0-beta-2/\">WordPress 5.0 is currently in its second beta phase</a> and will soon move to the release candidate status. Help test this release right now by installing the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester plugin</a> on your site.<br /></p>\n\n<p>Want to get involved in building WordPress Core? Follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a> and join the #core channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>. You can also help out by <a href=\"https://make.wordpress.org/test/\">testing</a> or <a href=\"https://make.wordpress.org/polyglots/2018/10/24/wordpress-5-0-gutenberg-and-twenty-nineteen/\">translating</a> the release into a local language.</p>\n\n<h2>New Editor for WordPress Core</h2>\n\n<p>Active development continues on <a href=\"https://wordpress.org/gutenberg\">Gutenberg</a>, the new editing experience for WordPress Core. <a href=\"https://make.wordpress.org/core/2018/10/31/whats-new-in-gutenberg-31st-october-2/\">The latest release</a> is feature complete, meaning that all further development on it will be to improve existing features and fix outstanding bugs.<br /></p>\n\n<p>Some have raised concerns about Gutenberg’s accessibility, prompting the development team <a href=\"https://make.wordpress.org/core/2018/10/18/regarding-accessibility-in-gutenberg/\">to detail some areas</a> in which the new editor is accessible. To help improve things further, the team has made <a href=\"https://make.wordpress.org/core/2018/10/19/call-for-testers-community-gutenberg-accessibility-tests/\">a public call for accessibility testers</a> to assist.<br /></p>\n\n<p>Want to get involved in building Gutenberg? Follow <a href=\"https://make.wordpress.org/core/tag/gutenberg\">the Gutenberg tag</a> on the Core team blog and join the #core-editor channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>. Read <a href=\"https://make.wordpress.org/test/2018/10/19/gutenberg-needs-testing-areas/\">this guide</a> to find areas where you can have the most impact.</p>\n\n<h2>Migrating HelpHub to WordPress.org</h2>\n\n<p>HelpHub is an ongoing project to move all of WordPress’ user documentation from the <a href=\"https://codex.wordpress.org/\">Codex</a> to the <a href=\"https://wordpress.org/support/\">WordPress Support portal</a>.<br /></p>\n\n<p>HelpHub has been developed on <a href=\"https://wp-helphub.com/\">a separate staging server</a> and it’s now time to migrate the new documentation to its home on WordPress.org. The plan is to have everything moved over &nbsp;before WordPress 5.0 is released, so that all the new documentation will be available on the new platform from the start.<br /></p>\n\n<p>The HelpHub team has published <a href=\"https://make.wordpress.org/docs/2018/11/01/call-for-volunteers-helphub-migration/\">a call for volunteers</a> to help with the migration. If you would like to get involved, join the #docs channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>, and contact <a href=\"https://profiles.wordpress.org/atachibana/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>atachibana</a> to get started.</p>\n\n<h2>A New Default Theme for WordPress</h2>\n\n<p><a href=\"https://make.wordpress.org/core/2018/10/16/introducing-twenty-nineteen/\">A brand new default theme &#8212; Twenty Nineteen &#8212; has been announced</a>&nbsp;with development being led by <a href=\"https://profiles.wordpress.org/allancole/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>allancole</a>. The theme is packaged with WordPress 5.0, so it will be following the same release schedule as Core.<br /></p>\n\n<p>The new theme is designed to integrate seamlessly with Gutenberg and showcase how you can build a theme alongside the new block editor and take advantage of the creative freedom that it offers.<br /></p>\n\n<p>Want to help build Twenty Nineteen? Join in on <a href=\"https://github.com/WordPress/twentynineteen\">the theme’s GitHub repo</a> and join the #core-themes channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.<br /></p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Further Reading:</h2>\n\n<ul><li>The Support team are putting together more formal <a href=\"https://github.com/Clorith/wporg-support-guidelines\">Support Guidelines</a> for the WordPress Support Forums.</li><li>The group focused on privacy tools in Core <a href=\"https://make.wordpress.org/core/2018/10/11/whats-new-in-core-privacy/\">has released some details</a> on the work they have been doing recently, with a roadmap for their plans over the next few months.</li><li>The Core team <a href=\"https://make.wordpress.org/core/2018/10/15/wordpress-and-php-7-3/\">released an update</a> about how WordPress will be compatible with PHP 7.3.</li><li>The Theme Review Team have published <a href=\"https://make.wordpress.org/themes/2018/10/25/new-requirements/\">some new requirements</a> regarding child themes, readme files and trusted authors in the Theme Directory.</li><li>The WordCamp Europe team <a href=\"https://make.wordpress.org/community/2018/10/23/progressive-web-app-for-wordcamps/\">are working on a PWA service</a> for all WordCamp websites.</li></ul>\n\n<p><em>If you have a story we should consider including in the next “Month in WordPress” post, please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it here</em></a><em>.</em><br /></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Nov 2018 08:40:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"WPTavern: Gutenberg Cloud Plugin for WordPress is Now in Beta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=85115\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://wptavern.com/gutenberg-cloud-plugin-for-wordpress-is-now-in-beta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5938:\"<p><a href=\"https://www.frontkom.no/\" rel=\"noopener noreferrer\" target=\"_blank\">Frontkom</a>, the team behind the <a href=\"https://gutenbergcloud.org/\" rel=\"noopener noreferrer\" target=\"_blank\">Gutenberg Cloud</a> project, has published the beta version of its WordPress plugin to the official repository. <a href=\"https://wordpress.org/plugins/cloud-blocks/\" rel=\"noopener noreferrer\" target=\"_blank\">Cloud Blocks</a> serves as a connector, allowing WordPress users to browse and install open source blocks from Gutenberg Cloud. The blocks are hosted on NPM and their assets are served from CloudFlare using <a href=\"https://unpkg.com\" rel=\"noopener noreferrer\" target=\"_blank\">unpkg.com</a>.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2018/10/gutenberg-cloud-wp-plugin.gif?ssl=1\"><img /></a></p>\n<p>Gutenberg Cloud&#8217;s online library of blocks is CMS agnostic, offering blocks for both Drupal and WordPress sites, and more CMSs in the future. The service advertises three key benefits for developers who host blocks on Gutenberg Cloud:</p>\n<ul>\n<li>Wider adoption: Your blocks can be used outside of WP</li>\n<li>Discoverability: Your blocks will pop up in the Cloud Blocks UI</li>\n<li>Faster development: No plugin/SVN needed, just publish to NPM</li>\n</ul>\n<p>Frontkom is actively recruiting WordPress developers to add blocks to the cloud to test the process. Documentation for <a href=\"https://github.com/front/cloud-blocks/blob/master/docs/migrate-block.md\" rel=\"noopener noreferrer\" target=\"_blank\">migrating blocks from a plugin</a> is available on GitHub. Frontkom has also produced a new <a href=\"https://github.com/front/create-cloud-block\" rel=\"noopener noreferrer\" target=\"_blank\">boilerplate generator for building Gutenberg Cloud blocks</a>.</p>\n<p>Users should note that the team is still ironing out the experience for developers adding blocks to the cloud, so the plugin isn&#8217;t yet ready for general use. It&#8217;s currently under active development. </p>\n<h3>WordPress Developers Say Gutenberg Cloud May Not be the Best Way to Release Blocks but Platform has Potential</h3>\n<p>I contacted some WordPress developers who have tested sending their blocks to Gutenberg Cloud to get their initial reactions to the platform. </p>\n<p>&#8220;The idea that folks will be able to install blocks a la carte is interesting,&#8221; <a href=\"https://coblocks.com/\" rel=\"noopener noreferrer\" target=\"_blank\">CoBlocks</a> author and ThemeBeans founder Rich Tabor said. &#8220;It’s pretty much as easy as installing plugins.&#8221;</p>\n<p>Tabor experimented with migrating his Block Gallery blocks and said the process was not difficult but he foresees difficulties in maintaining blocks across parent plugins and Gutenberg Cloud.</p>\n<p>&#8220;As a developer, I’m still not entirely convinced Gutenberg Cloud is the best way to release blocks, aside from relatively simple blocks,&#8221; Tabor said. &#8220;I personally lean towards building suites of blocks that share a relative purpose, instead of one plugin (or one Cloud Block instance) per block. For one, it cuts down on maintenance quite a bit, as custom components can be shared between blocks. And there’s much better discoverability on getting relative blocks in the hands of users — if they’re grouped together.&#8221;</p>\n<p>Block collections have been criticized for making it difficult to search for and discover individual blocks, but Tabor makes some good arguments for improving block discoverability by grouping together features users often need. That is the whole point of successful plugins like Jetpack, but this type of packaging also lends itself to criticism about bloat.</p>\n<p>&#8220;It’s a similar conundrum when we look at grouped/not grouped shortcode plugins,&#8221; Tabor said. &#8220;I suppose the main difference is that the nature of blocks is much more complicated than that of shortcodes. History seems to repeat itself.&#8221;</p>\n<p>Tabor said he is considering distributing a few of his free blocks through Gutenberg Cloud but he hasn&#8217;t fully decided yet.</p>\n<p>WordPress core contributor, <a href=\"https://joshpress.net/\" rel=\"noopener noreferrer\" target=\"_blank\">Josh Pollock</a>, who has worked extensively with React and Gutenberg, also tested the Gutenberg Cloud platform. He said he thinks it has a lot of potential for developers who write blocks that are mainly JavaScript already.</p>\n<p>&#8220;I could see how an agency that builds WordPress sites could save a lot of time and hassle building out a block library,&#8221; Pollock said. &#8220;As a plugin developer with a lot of little ideas, the pain and time of setting up a block and block environment, which no one has gotten right yet, makes me very excited about this.&#8221;</p>\n<p>Pollock also reported a positive experience with the <a href=\"https://github.com/front/create-cloud-block\" rel=\"noopener noreferrer\" target=\"_blank\">create-cloud-block</a> generator.</p>\n<p>&#8220;The code that create-cloud-block generates is well-written, but not too opinionated,&#8221; Pollock said. &#8220;The developer experience is both really cool &#8212; you preview your block in a functional Gutenberg-powered editor with no WordPress site attached &#8212; and a little frustrating as there is no live reload yet. I know they are just getting started and the tool doesn&#8217;t lock you into any structure, which is great. I&#8217;ll be keeping my eye on this project.&#8221;</p>\n<p>Frontkom CTO Per André Rønsen said his team will continue testing the cloud internally until they get more developer feedback on the corresponding WordPress plugin. For Drupal users, Gutenberg Cloud will be shipped as a submodule of Gutenberg, which means all sites that install Gutenberg will also get the Cloud module. It can, however, be disabled. Rønsen said his team plans to showcase Gutenberg Cloud for D8 at DrupalCamp Oslo in November.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 31 Oct 2018 23:12:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"Matt: What’s in My Bag, 2018 Edition\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=48557\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://ma.tt/2018/10/whats-in-my-bag-2018-edition/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:12475:\"<a href=\"https://i2.wp.com/ma.tt/files/2018/10/bag-v4.jpg?ssl=1\" target=\"_blank\" rel=\"noreferrer noopener\"><img /></a>\n<ol>\n<li><a href=\"https://sdrtraveller.com/collections/accessories/products/travel-folio\">SDR Kashmir Travel Folio</a>, made with this super-cool material called Dyneema, which is twice as strong as Kevlar and 15 times as strong as steel, but virtually weightless.</li>\n<li><a href=\"https://www.amazon.com/dp/B06XGD6CS4/?tag=photomatt08-20\">Garmin Forerunner 935</a> which is a triathlon watch, so it can tell me how much I don’t run, how much I don’t bike, and how much I don’t swim. Crazy sensors on it, and it’s lighter than an Apple Watch, which I tried again to use this year but wasn’t able to handle another device in my life that I had to charge daily. It has a weird charger, pictured next to it, but only needs charging once every few weeks so I don’t mind at all.</li>\n<li>This is the latest 15” grey touchbar MacBook Pro, customized by <a href=\"https://www.uncovermac.com/\">Uncover</a> to have the <a href=\"https://jetpack.com/\">Jetpack</a> logo on it. I like the keyboard quietness and performance improvements of latest generation.</li>\n<li><a href=\"https://www.aersf.com/fit-pack-2-black\">Fit Pack 2 from Aer</a> is the same I wrote a whole blog post about last year, and I still love and adore it every day. They have a few bigger and smaller packs, but the quality is just fantastic and I love all the pockets. Mine is starting to tear a little bit by one of the shoulder straps, but I do keep ~18lbs in it regularly.</li>\n<li>This is a <a href=\"https://www.amazon.com/dp/B0035N09CS/?tag=photomatt08-20\">grey wool buff</a>, which works as a scarf, a hat, or an eye cover if I’m trying to sleep. I tried this out because of one of <a href=\"http://tynan.com/gear2017\">Tynan’s also-great gear posts</a>.</li>\n<li>Passport, because you never know when you’ll need to leave the country.</li>\n<li><a href=\"https://www.amazon.com/gp/product/B06VTJWRJW/?tag=photomatt08-20\">Kindle Oasis</a> with this <a href=\"https://www.amazon.com/gp/product/B07B7H4L8F/?tag=photomatt08-20\">random case on it</a>. I dig that this one is apparently waterproof — which I’ve never tested — but doesn’t feel like we’ve found the perfect size and weight balance yet. Reading is my favorite activity right now so this is my most-loved item.</li>\n<li><a href=\"https://www.amazon.com/gp/product/B01EN9QK6G/?tag=photomatt08-20\">Imazing 10k charger</a>. Great capacity, charges via USB-C. (2nd year)</li>\n<li>I’ve started carrying around some stationery so I can write notes to people when I’m on the road. Now I just need better handwriting&#8230;</li>\n<li><a href=\"http://www.delfonics.com\">Delfonics</a> is a funky-cool Japanese stationery, and <a href=\"https://www.amazon.com/dp/B003N1XRYY/?tag=photomatt08-20\">this 3”x4” Rollbahn notebook is tops</a>, and actually fits in my pocket. The Amazon one linked might be larger, I found it at <a href=\"http://paper-ya.com/\">Paper-Ya on Granville Island</a>.</li>\n<li>A small leather bracelet I got in Seoul, Korea.</li>\n<li>Two things here: a <a href=\"https://www.amazon.com/gp/product/B00CM589B8/?tag=photomatt08-20\">rolled-up chamois cloth</a> for cleaning glasses, inspired by <a href=\"https://ma.tt/2018/01/r-i-p-dean/\">my late friend Dean</a>, and <a href=\"https://twitter.com/helenhousandi/status/746057671531429889\">a WordPress ring I wear sometimes</a>.</li>\n<li>Three pens here: A <a href=\"https://matt.blog/2018/09/30/new-automattic-pen/\">cool customized one we did for Automatticians</a>; a <a href=\"https://www.amazon.com/dp/B00J2S5JNY/?tag=photomatt08-20\">Lamy Accent 4pen</a> which has red, blue, black, and a mechanical pencil built in; a Sharpie for signing stuff.</li>\n<li>Have gone away from the carbon fiber clip and now using this <a href=\"https://www.paulsmith.com/us/mens/accessories/wallets?style=205\">small Paul Smith card wallet</a>.</li>\n<li><a href=\"https://www.amazon.com/dp/B016QO5YNG/?tag=photomatt08-20\">Apple Magic Mouse 2</a>. When this one breaks I’ll switch it out for a black one.</li>\n<li>Charger for the MacBook Pro.</li>\n<li>A super small international adapter, which is also nice for converting the 3-prong in the next item into a 2-prong. It’s Lenmar but I’m not going to link Amazon because they’re charging too much, just picked up in an airport store.</li>\n<li><strong>Probably my favorite new item of the year:</strong> I have given Native Union a hard time in the past but super love <a href=\"https://www.amazon.com/gp/product/B075LPVWBS/?tag=photomatt08-20\">this combo extension cord and USB charger</a>. It is an 8-foot extension cord, which is remarkably handy, has two AC outlets, 3 USB ports, and one USB-C. Total life-saver.</li>\n<li>A <a href=\"https://sdrtraveller.com/collections/accessories/products/accessory-pouch\">dyneema accessory pouch</a>, <a href=\"https://retaw.tokyo/en/\">retaW aoyama / tokyo fragrance lipcream</a>, <a href=\"https://www.amazon.com/gp/product/B005LVYSKQ/?tag=photomatt08-20\">Aveda Peppymint breath refresher</a>, <a href=\"https://www.amazon.com/dp/B000IB0H8G/?tag=photomatt08-20\">Aesop Ginger Flight Therapy</a> roller, a spray hand cleanser, and <a href=\"https://www.amazon.com/dp/B003J35X9I/?tag=photomatt08-20\">Mintia COLDSMASH</a>.</li>\n<li><a href=\"https://www.districtvision.com/about\">District Vision</a> makes these <a href=\"https://www.sportique.com/products/district-vision-nagata-gray-sunglasses-district-black-rose\">these running sunglasses</a> in Japan, which I found at the <a href=\"https://snowpeak.com/\">Snow Peak</a> store in NYC.</li>\n<li>These sunglasses are a collaboration between <a href=\"https://saltoptics.com/\">Salt</a> and <a href=\"https://www.aetherapparel.com/\">Aether</a>.</li>\n<li>A single-use packet of Sriracha. Hot sauce in your bag? Swag.</li>\n<li>A <a href=\"https://www.amazon.com/dp/B00JDUCSD0/?tag=photomatt08-20\">palo santo smudge stick</a>, smells great when you burn it. I’m turning into a hippie.</li>\n<li>Hermes business card holder.</li>\n<li>iPhone XS with a Jetpack <a href=\"https://www.popsockets.com/\">Popsocket</a>.</li>\n<li>Pixel 2, now replaced by a Pixel 3 XL.</li>\n<li>This is a bag with some small opals I gave as a Burning Man gift.</li>\n<li>iPad Pro 10.5 and <a href=\"https://www.amazon.com/dp/B071WLK8GY/?tag=photomatt08-20\">Apple sleeve with Pencil holder</a>, which is still one of my favorite gadgets of the year. Everything about this device just works and is a pleasure to use, and I&#8217;ve already ordered the new 11&#8243; Pro and related accessories.</li>\n<li><a href=\"https://www.amazon.com/gp/product/B013VL4W58/?tag=photomatt08-20\">Half meter (the perfect size) lightning cable</a>.</li>\n<li>Apple USB-C dongle.</li>\n<li><a href=\"https://www.amazon.com/gp/product/B01M8PYE5X/?tag=photomatt08-20\">Cool multi-function USB cable with lightning, two micro-USBs, and USB-C</a>. I give these away all the time now and it’s nice to pair with the battery in #8 because I know I can charge anybody with this thing.</li>\n<li>Short USB-C.</li>\n<li>Combo micro-USB and Lightning.</li>\n<li>Short lightning cable, just like 29.</li>\n<li><a href=\"https://www.amazon.com/gp/product/B001E1Y5O6/?tag=photomatt08-20\">Velcro cable ties</a>, great for tidying pretty much anything. I just take a few out of the big pack and roll them up to travel with.</li>\n<li><a href=\"https://www.amazon.com/gp/product/B06XTXLNCW/?tag=photomatt08-20\">Retractable USB-C</a>, don’t love these as they break but it’s the best of what’s out there.</li>\n<li>USB-C to Lightning, great for super-fast charging.</li>\n<li>My favorite USB-C hub so far, the <a href=\"https://www.amazon.com/gp/product/B07B87BN1M/?tag=photomatt08-20\">Satechi Aluminum Type-C Multimedia Adapter with 4K HDMI, Mini DP, USB-C PD, Gigabit Ethernet, USB 3.0, Micro/SD Card Slots</a>. Pretty much everything you could possibly need.</li>\n<li>A pretty handy <a href=\"https://www.amazon.com/dp/B00OWBHE9I/?tag=photomatt08-20\">Ventev dashport car port charger that’s small and light</a>. (2nd year)</li>\n<li>A few spare SIM cards, some SD cards, thingy to poke SIM card holder, and <a href=\"https://www.amazon.com/gp/product/B010HWCFDA/?tag=photomatt08-20\">combo USB-C / USB-A 64gb stick</a>.</li>\n<li>Lockpick set. (4th year)</li>\n<li><a href=\"https://www.bragi.com/thedashpro/customize/\">Bragi Pro custom earphones</a>. For many years I had custom in-ear monitors, but the convenience of wireless overcame that, even before they started taking headphone jacks out of phones. Bragi now allows you to send in ear molds from an audiologist and they’ll make these custom true wireless headphones that fit and sound great, but I have trouble recommending because the case is so heavy and once got so jammed I almost thought I’d have to throw the whole thing away, and the app has never been able to “connect” for me because it gets stuck on turning on some fitness sensors. If it could connect I think I could turn off the other feature that is annoying, which is the touch controls that I find get triggered by my hat or when my head is against a chair. So, a qualified “maybe try this.”</li>\n<li><a href=\"http://www.amazon.com/gp/product/B00D4LBOV6/?tag=photomatt08-20\">Sennheiser Culture Series Wideband Headset</a>, which I use for podcasts, Skype, Facetime, Zoom, and Google Hangout calls with external folks and teams inside of Automattic. Light, comfortable, great sound quality, and great at blocking out background noise so you don’t annoy other people on the call. I’d love to replace this with something wireless but haven’t found one with as high fidelity audio.</li>\n<li><a href=\"https://www.amazon.com/gp/product/B07712LKJM/?tag=photomatt08-20\">GL.iNet GL-AR750 Travel AC Router</a> which I use to create wifi networks different places I go, which is often faster than hotel/etc wifi, and I can also VPN encrypt all my traffic through it. Pretty handy! But not user-friendly. Often keep it in my suitcase and not my backpack. I have a retractable Ethernet and micro-USB attached to it.</li>\n<li>Matte black Airpods. I love Airpods and these look super cool, I think these were from BlackPods which looks shut down now but <a href=\"https://www.colorware.com/p-743-apple-airpods.aspx\">Colorware has some alternatives</a>. (2nd year)</li>\n<li><a href=\"http://www.westoneaudio.com/index.php/products/hearing-protection/es49-custom-hearing-protection.html\">Westone ES49 custom earplugs</a>, for if I go to concerts or anyplace overly loud. (4th year)</li>\n<li>An ultralight running jacket I think I got at Lululemon Lab in Vancouver. They don’t have anything like it available online right now but it folds up ultra-tiny, weighs nothing, and is a nice layer for on an airplane. My only complaint (as with all Lululemon products) is the low quality of the zipper. (2nd year)</li>\n</ol>\n<p>That’s it for this year. As a bonus I’ll link some of my favorite other-bag items including toiletries: <a href=\"http://www.muji.us/store/4549738743743.html\">Muji dopp kit bag</a>, <a href=\"https://www.amazon.com/gp/product/B00JRK8VAU/?tag=photomatt08-20\">these amazing travel bottles for creams</a>, <a href=\"https://www.amazon.com/gp/product/B0091JL3IO/?tag=photomatt08-20\">travel atomizer</a>, <a href=\"http://www.elysiumhealth.com/\">Elysium Basis</a>, <a href=\"http://www.amazon.com/dp/B00GHDK32Y/?tag=photomatt08-20\">Muji q-tips</a>, <a href=\"https://www.aesop.com/us/p/skin/hydrate/in-two-minds-facial-hydrator/\">Aesop Two Minds Facial Hydrator</a>, <a href=\"https://www.amazon.com/gp/product/B00375P3IE/?tag=photomatt08-20\">Sunleya Sun Care SPF 15</a>, <a href=\"https://www.amazon.com/dp/B00G63D2XC/?tag=photomatt08-20\">folding brush / comb</a>, <a href=\"http://www.amazon.com/gp/product/B00CUG273A/?tag=photomatt08-20\">Philips Sonicare Brush</a>, <a href=\"https://www.aesop.com/us/p/body/personal-care/toothpaste/\">Aesop toothpaste</a>, <a href=\"https://www.amazon.com/dp/B008QMWKES/?tag=photomatt08-20\">Tom&#8217;s SLS-free toothpaste</a>, <a href=\"https://www.amazon.com/dp/B019J13OCQ/?tag=photomatt08-20\">Orabrush cleaner</a>.</p>\n<p>If you&#8217;re curious, here are the previous years: <a href=\"https://ma.tt/2015/01/whats-in-my-bag-2014/\">2014</a>, <a href=\"https://ma.tt/2016/03/whats-in-my-bag-2016-edition/\">2016</a>, <a href=\"https://ma.tt/2017/05/whats-in-my-bag-2017/\">2017</a>.</p>\n<p>If you have any questions please leave them in the comments!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 31 Oct 2018 03:44:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"WPTavern: WordPress.com and Jetpack Launch New Activity Feature for Monitoring Website Changes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=85171\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"https://wptavern.com/wordpress-com-and-jetpack-launch-new-activity-feature-for-monitoring-website-changes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3652:\"<p><a href=\"https://en.blog.wordpress.com/2018/10/30/introducing-activity/\" rel=\"noopener noreferrer\" target=\"_blank\">WordPress.com launched a new Activity feature</a> today, a tool for monitoring changes that occur on the site and actions initiated through the admin. It&#8217;s also available for Jetpack-enabled sites and the activity log can be viewed on WordPress.com or on the WordPress mobile apps. </p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2018/10/activity-feature.png?ssl=1\"><img /></a></p>\n<p>Activity logs the following actions and presents them in an easy-to-read timeline on WordPress.com:</p>\n<ul>\n<li>Published or updated posts and pages</li>\n<li>Comment submission and management activity</li>\n<li>Settings and options modifications</li>\n<li>Login attempts by registered site users</li>\n<li>Plugin installations, updates, and removals</li>\n<li>Theme switches, installations, updates, and deletions</li>\n</ul>\n<p>The Activity log can be useful for debugging client sites where the client cannot remember the actions they performed that changed their website. Users can also update plugins and themes directly from the activity log. </p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2018/10/Screen-Shot-2018-10-30-at-8.02.41-PM.png?ssl=1\"><img /></a></p>\n<p>WordPress.com&#8217;s new Activity feature is reminiscent of XWP&#8217;s <a href=\"https://wordpress.org/plugins/stream/\" rel=\"noopener noreferrer\" target=\"_blank\">Stream</a> plugin, which launched in 2013 with similar admin logging features stored locally. It offers support for multisite as well as several popular plugins, such as ACF, bbPress, BuddyPress, EDD, Gravity Forms, WooCommerce, Yoast SEO, and Jetpack. Stream hasn&#8217;t gained much traction in recent years with just 30,000 active installations. </p>\n<p>In 2014, Stream&#8217;s creators explored offering <a href=\"https://wptavern.com/stream-morphs-from-a-plugin-into-a-service\" rel=\"noopener noreferrer\" target=\"_blank\">Stream as a service</a> where the logs were stored in AWS and included configurable SMS notifications. The service was <a href=\"https://wptavern.com/stream-is-shutting-down-its-cloud-data-storage-october-1st\" rel=\"noopener noreferrer\" target=\"_blank\">shut down in 2015</a> in favor of storing the activity logs locally due to the expense of cloud storage. Shortly after that it was acquired by XWP.</p>\n<p>Automattic is also exploring offering its new Activity feature as a paid service. Currently sites on the Free plan only have access to the last 20 most recent events. Access is tiered based on the plan. Personal and Premium users have access to activities from the last 30 days and Professional users can see all activities for the past year. The ability to filter activities by type is also restricted to paid users only.</p>\n<p>Jetpack site owners should note that Activity is activated by default &#8211; it&#8217;s not a module that can be turned on or off. The feature doesn&#8217;t send any new data to WordPress.com but rather offers a new interface for data that is already synced.</p>\n<p>The full list of activities the feature collects, as well as privacy information related to data retention, is available for <a href=\"https://en.support.wordpress.com/activity/\" rel=\"noopener noreferrer\" target=\"_blank\">WordPress.com</a> and <a href=\"https://jetpack.com/support/activity-log/\" rel=\"noopener noreferrer\" target=\"_blank\">Jetpack sites</a> in the documentation for the feature. Users can report bugs to the <a href=\"https://github.com/Automattic/wp-calypso\" rel=\"noopener noreferrer\" target=\"_blank\">Calypso GitHub repository</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 31 Oct 2018 03:04:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"WPTavern: WordPress Accessibility Team Delivers Sobering Assessment of Gutenberg: “We have to draw a line.”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=85082\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"https://wptavern.com/wordpress-accessibility-team-delivers-sobering-assessment-of-gutenberg-we-have-to-draw-a-line\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9807:\"<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/10/accessibility-team-assessment-gutenberg.jpg?ssl=1\"><img /></a>photo credit: classroomcamera <a href=\"http://www.flickr.com/photos/155535822@N07/27792517478\">DSC03657</a> &#8211; <a href=\"https://creativecommons.org/licenses/by/2.0/\">(license)</a>\n<p>WordPress&#8217; accessibility team has published a <a href=\"https://make.wordpress.org/accessibility/2018/10/29/report-on-the-accessibility-status-of-gutenberg/\" rel=\"noopener noreferrer\" target=\"_blank\">statement on the level of overall accessibility of Gutenberg</a>. The team, largely a group of unpaid volunteers, collaborated on a detailed assessment that publicly challenges Gutenberg&#8217;s readiness for core in a way that no other WordPress team has done through official channels to date. After a week of testing the most recent version of the plugin, the team concluded that they cannot recommend Gutenberg to be used by anyone who relies on assistive technology.</p>\n<blockquote><p>The Accessibility team – like any team in WordPress – has no specific authority over the project. Because we’re a small team of volunteers, we’ve been pragmatic in how we apply the guidelines. We have made tradeoffs in prioritization. Gutenberg is a place where we feel it is necessary to draw a line. The ability to author, edit, and publish posts is the primary purpose of WordPress.</p></blockquote>\n<p>Accessibility team rep Joe Dolson, speaking on behalf of the team, cited cognitive load and complexity, inconsistent user interface behavior, heavy reliance on keyboard shortcuts, and difficulties with keyboard navigation through blocks, among other concerns about Gutenberg. He outlined an example of the keyboard sequence required to do something as simple as change the font size in a paragraph block. It currently requires 34 separate keyboard stops, and even more if the tester doesn&#8217;t have prior knowledge of how to navigate Gutenberg.</p>\n<p>&#8220;Because the complexity of interaction with Gutenberg is an order of magnitude greater than in the classic editor, we believe that Gutenberg is less accessible than the existing classic editor, though it offers many great features that are not available in the current editor,&#8221; Dolson said. </p>\n<p>This assessment echoes many of the common themes found in <a href=\"https://wordpress.org/support/plugin/gutenberg/reviews/\" rel=\"noopener noreferrer\" target=\"_blank\">Gutenberg&#8217;s reviews on WordPress.org</a>, even among the most recent reviews of the latest version. Ratings are currently hovering at 2.3 out of 5 stars. Users have repeatedly said the interface is &#8220;<a href=\"https://wordpress.org/support/topic/gutenberg-is-a-clear-winner/\" rel=\"noopener noreferrer\" target=\"_blank\">far too heavily reliant on hover based functionality</a>.&#8221; Even those without accessibility needs find it <a href=\"https://wordpress.org/support/topic/blocks-concept-seems-great-but-still-so-confusing/\" rel=\"noopener noreferrer\" target=\"_blank\">confusing</a>, <a href=\"https://wordpress.org/support/topic/rage-inducing/\" rel=\"noopener noreferrer\" target=\"_blank\">unintuitive</a>, and <a href=\"https://wordpress.org/support/topic/an-unusable-codewreck/\" rel=\"noopener noreferrer\" target=\"_blank\">difficult to navigate content</a>. Some testers find it <a href=\"https://wordpress.org/support/topic/fixing-what-isnt-broken-w-broken-tools/\" rel=\"noopener noreferrer\" target=\"_blank\">nearly impossible to do what they want to do with it</a>.</p>\n<p>The positive reviews recognize the software as <a href=\"https://wordpress.org/support/topic/much-needed-update-2/\" rel=\"noopener noreferrer\" target=\"_blank\">a work in progress</a> and testers seem more aware of the overall vision for the plugin. They are excited about some of the <a href=\"https://wordpress.org/support/topic/my-experience-with-gutenberg-the-good-and-not-so-good/\" rel=\"noopener noreferrer\" target=\"_blank\">more advanced features that blocks offer</a>, but many positive reviewers urge WordPress to give it more time before making it the default editor.</p>\n<p>The accessibility team is convinced that the main accessibility issues in Gutenberg stem from design issues. </p>\n<p>&#8220;Gutenberg is the way of the future in WordPress, but the direction it has taken so far has been worrying,&#8221; Dolson said. &#8220;We do not want to miss the opportunity to build a modern and inclusive application for WordPress, but in order to achieve that goal, accessibility needs to incorporated in all design processes in the project.</p>\n<p>&#8220;These problems are solvable. Retrofitting accessibility is not an effective process. It is costly in terms of time and resources.&#8221;</p>\n<p>In a recent post titled <a href=\"https://pento.net/2018/10/26/iterating-on-merge-proposals/\" rel=\"noopener noreferrer\" target=\"_blank\">Iterating on Merge Proposals</a>, Gary Pendergast, who is leading the merge of Gutenberg into core, acknowledged that they could have asked for the accessibility team&#8217;s help much earlier in the process. </p>\n<p>&#8220;The Accessibility team should’ve been consulted more closely, much earlier in the process, and that’s a mistake I expect to see rectified as the Gutenberg project moves into its next phase after WordPress 5.0,&#8221; Pendergast said. &#8220;While Gutenberg has always aimed to prioritize accessibility, both providing tools to make the block editor more accessible, as well as encouraging authors to publish accessible content, there are still areas where we can improve.&#8221;</p>\n<p>At this time there has been no official response to the accessibility team&#8217;s assessment. It does not look like it will meaningfully impact the release date, as <a href=\"https://wordpress.org/news/2018/10/wordpress-5-0-beta-2/\" rel=\"noopener noreferrer\" target=\"_blank\">Beta 2</a> went out last night and RC 1 is planned for release today. If the core dev chats are any indication, contributors involved in 5.0 seem to be on board with the ambitious timeline for its release. </p>\n<p>In a post titled &#8220;<a href=\"https://werdswords.com/accessibility-in-gutenberg-is-not-a-one-more-feature/\" rel=\"noopener noreferrer\" target=\"_blank\">Accessibility in Gutenberg is not a one-more feature</a>,&#8221; core developer Drew Jaynes urges the project&#8217;s leadership and contributors not to compromise core accessibility standards for the sake of an expedited timeline.</p>\n<p>&#8220;Please let&#8217;s not make the &#8216;new standard&#8217; be that we&#8217;re willing to ship technically accessible but perhaps not entirely usable-for-all features; let&#8217;s not define it as one that sacrifices standards core to the WordPress experience in the name of perceived expediency; let&#8217;s not define it as the new default authoring experience for all users when not all users can use it well,&#8221; Jaynes said.</p>\n<p>WordPress 5.0 release lead Matt Mullenweg has frequently said the release will ship when it&#8217;s ready. He contends that the interface has been continually modified for accessibility needs throughout the process of developing Gutenberg. </p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Modifying the interface to accomodate a11y is the compromise, it has been continuous throughout the process. I don\'t know how to achieve the imaginary bar you\'re setting up.</p>\n<p>&mdash; Matt Mullenweg (@photomatt) <a href=\"https://twitter.com/photomatt/status/1055889800119508992?ref_src=twsrc%5Etfw\">October 26, 2018</a></p></blockquote>\n<p></p>\n<p>Matthew MacPherson, Gutenberg&#8217;s accessibility lead, was not immediately available for comment on the team&#8217;s assessment. Ultimately, the decision to delay the release will fall to Mullenweg and his leadership team. The accessibility team, however, will not lend its endorsement of Gutenberg at this time:</p>\n<blockquote><p>The accessibility team will continue to work to support Gutenberg to the best of our ability. However, based on its current status, we cannot recommend that anybody who has a need for assistive technology allow it to be in use on any sites they need to use at this time.</p></blockquote>\n<p>Gutenberg is now 20 days away from landing in WordPress 5.0, but this does not leave enough time to solve the design and architectural issues the accessibility team has identified. They have <a href=\"https://core.trac.wordpress.org/ticket/44671\" rel=\"noopener noreferrer\" target=\"_blank\">proposed a notice</a> on the 5.0 release to inform administrators of Gutenberg&#8217;s inadequacy for users of assistive technology, with a prompt to install the Classic Editor plugin. Many people with accessibility needs depend on the WordPress editor in order to do their work and will need to stick with the old interface. The proposal has been closed with a note indicating that 5.0 will point users to the Classic Editor plugin if they need it.</p>\n<p>The mistake of not having consulted accessibility experts in the design phase cannot be easily rectified at this point, but the Classic Editor is still available for those who need to preserve their same workflow. The conflict lies in whether WordPress should ship a new editor that those with accessibility needs cannot immediately use. It is a somewhat painful and frustrating outcome for those users when the entire ecosystem is rapidly moving towards Gutenberg as the standard. </p>\n<p>Either the accessibility and usability issues the team identified are not as bad as they purport or this document is a last-minute clarion call that could prevent WordPress from shipping an editor that excludes users who rely on assistive technology. Due to the gravity of their claims, the accessibility team&#8217;s statement on Gutenberg demands an official response.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Oct 2018 19:16:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Dev Blog: WordPress 5.0 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6222\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2018/10/wordpress-5-0-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2200:\"<p>WordPress 5.0 Beta 2 is now available!</p>\n\n<p><strong>This software is still in development,</strong>&nbsp;so we don’t recommend you run it on a production site. Consider setting up a test site to play with the new version.</p>\n\n<p>There are two ways to test the WordPress 5.0 Beta: try the&nbsp;<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a>&nbsp;plugin (you’ll want “bleeding edge nightlies”), or you can&nbsp;<a href=\"https://wordpress.org/wordpress-5.0-beta2.zip\">download the beta here</a>&nbsp;(zip).</p>\n\n<p>WordPress 5.0 is slated for release on&nbsp;<a href=\"https://make.wordpress.org/core/5-0/\">November 19</a>, and we need your help to get there. Here are some of the big issues that we fixed since Beta 1:</p>\n\n<h2>Block Editor</h2>\n\n<p>We&#8217;ve updated to the latest version of the block editor from the Gutenberg plugin, which includes the new <a href=\"https://github.com/WordPress/gutenberg/pull/10209\">Format API</a>, embedding improvements, and <a href=\"https://github.com/WordPress/gutenberg/milestone/71\">a variety of bug fixes</a>.</p>\n\n<p>Meta boxes had a few bugs, and they weren&#8217;t showing at all in the block editor, so we&#8217;ve fixed and polished there.</p>\n\n<h2>Internationalisation</h2>\n\n<p>We&#8217;ve added support for <a href=\"https://core.trac.wordpress.org/ticket/45103\">registering and loading JavaScript translation files</a>.</p>\n\n<h2>Twenty Nineteen</h2>\n\n<p>The <a href=\"https://github.com/WordPress/twentynineteen\">Twenty Nineteen repository</a> is a hive of activity, there have been a stack of minor bugs clean up, and some notable additions:</p>\n\n<ul><li>There&#8217;s now a widget area in the page footer.</li><li>Navigation submenus have been implemented for mobile devices.</li><li>Customiser options have been added for changing the theme colours and feature image filters.</li></ul>\n\n<h2>Everything Else</h2>\n\n<p>The REST API has a couple of bug fixes and performance improvements. PHP 7.3 compatibility has been improved.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<p><em>We&#8217;re fixing the bugs:<br />All the ones you&#8217;ve reported.<br />Some that we&#8217;ve found, too.</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Oct 2018 05:04:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Gary Pendergast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: php[world] 2018 to Feature Full-Day Gutenberg Development Workshop\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=85120\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://wptavern.com/phpworld-2018-to-feature-full-day-gutenberg-development-workshop\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4715:\"<p>The fourth annual <a href=\"https://world.phparch.com/\" rel=\"noopener noreferrer\" target=\"_blank\">php[world]</a> conference is just two weeks away. The event is dedicated to uniting the PHP community and will be held November 14-15, 2018, in Washington, D.C. </p>\n<p>This year the organizing team created a &#8220;Content Advisory Board&#8221; to ensure the event included sessions that will appeal to everyone. The board includes two WordPress Developers, two Drupal developers, and two more more general PHP developers. They reviewed all incoming talk submissions and gave organizers ideas on what they thought would be of greatest interest to each community.</p>\n<p>php[world] has traditionally included several topics and speakers from the WordPress world. This year the program features a full-day training workshop on Gutenberg development led by Josh Pollock and Zac Gordon. The workshop is called <a href=\"https://world.phparch.com/sessions/modern-wordpress/\" rel=\"noopener noreferrer\" target=\"_blank\">The Future of WordPress Development</a> and is available through a <a href=\"https://world.phparch.com/register/\" rel=\"noopener noreferrer\" target=\"_blank\">separate day ticket</a>. </p>\n<p>&#8220;We&#8217;ve always tried to focus php[world] on being the PHP conference that appeals to WordPress and Drupal developers as well,&#8221; conference co-chair Eli White said.  &#8220;We all write PHP (and JavaScript) code, and the DC area is full of WordPress and Drupal development shops. In fact, the majority of people in the local PHP user groups are doing WordPress development anyway. So we should all just be learning from each other. </p>\n<p>&#8220;For WordPress, that was obviously Gutenberg. Currently the release date for WordPress 5.0 and Gutenberg is November 19th, just a few days after php[world], and so it&#8217;s a really important topic for any developer who works with WordPress to be familiar with.&#8221;</p>\n<p>Workshop attendees can expect to become better acquainted with extending Gutenberg. The instructors plan to cover the basics of block creation as well as more advanced topics like making blocks dynamic and creating advanced blocks with the WordPress REST API and Redux.</p>\n<p>&#8220;For the workshop, our goal is to get folks comfortable with what they could do with Gutenberg,&#8221; Josh Pollock said. &#8220;We&#8217;ll cover the anatomy of a block, and different patterns for creating simple and complex blocks. We&#8217;ll go over each of the types of block types you can create and have hands-on time to play with these new skills and ask real time questions.</p>\n<p>&#8220;Developers should leave with an understanding of the different types of blocks they can build and why. They&#8217;ll also get plenty of example code, links, and advice they can use when it&#8217;s time to build blocks for their own WordPress projects.&#8221;</p>\n<p>The event includes a few other sessions geared towards WordPress developers: David Wolfpaw is giving a workshop called &#8220;<a href=\"https://world.phparch.com/sessions/building-wordpress-themes-a-primer/\" rel=\"noopener noreferrer\" target=\"_blank\">Building WordPress Themes: A Primer</a>&#8221; and Mo Jangda from Automattic is giving a talk on &#8220;<a href=\"https://world.phparch.com/sessions/handle-an-outage/\" rel=\"noopener noreferrer\" target=\"_blank\">How to Handle a Site Outage</a>.&#8221; There is another full-day training on modern PHP security that happens the day before the Gutenberg workshop that White said the WordPress Developers on the content board urged them to include.</p>\n<p>The main conference is also hosting many sessions that would benefit WordPress developers who want to sharpen their PHP skills. A few highlights include:</p>\n<ul>\n<li>Steve Grunwell is giving a &#8220;<a href=\"https://world.phparch.com/sessions/a-crash-course-in-php-namespaces-for-wordpress-developers/\" rel=\"noopener noreferrer\" target=\"_blank\">Crash-Course in PHP Namespaces</a>.&#8221;</li>\n<li>Sara Goleman, a core PHP contributor, will be talking about &#8220;<a href=\"https://world.phparch.com/sessions/php-now-and-tomorrow/\" rel=\"noopener noreferrer\" target=\"_blank\">PHP: Now and Tomorrow</a>,&#8221; discussing the PHP roadmap for 7.4 and 8.0.</li>\n<li>Brandon Savage is giving a two-hour workshop on &#8220;<a href=\"https://world.phparch.com/sessions/practical-object-oriented-design-principles/\" rel=\"noopener noreferrer\" target=\"_blank\">Object-Oriented Design Principles</a>,&#8221; designed to be a an introduction or refresher on OOP best practices.</li>\n</ul>\n<p>Check out the <a href=\"https://world.phparch.com/schedule/\" rel=\"noopener noreferrer\" target=\"_blank\">full schedule</a> on the php[world] website.  </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 29 Oct 2018 22:36:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"WPTavern: WooCommerce 3.5 Introduces REST API v3, Improves Transactional Emails\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84995\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://wptavern.com/woocommerce-3-5-introduces-rest-api-v3-improves-transactional-emails\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3596:\"<p><a href=\"https://woocommerce.wordpress.com/2018/10/23/woocommerce-3-5-is-here/\" rel=\"noopener noreferrer\" target=\"_blank\">WooCommerce 3.5</a> was released this week. It&#8217;s a minor update that has been in development since May and began testing in September. The release should be backwards compatible to version 3.0 of the plugin but users are always advised to test all of their themes and extensions before updating.</p>\n<p>Store owners can expect to see a change in the copy of the default transactional emails. They have been <a href=\"https://github.com/woocommerce/woocommerce/pull/21288\" rel=\"noopener noreferrer\" target=\"_blank\">updated to be friendlier and more human</a>. This is particularly important for the customer-facing emails. All of the following have been updated: on-hold, processing, completed, refunded both full and partially, invoice both with a pending and non-pending status, customer notes, password reset, new account. The default content in the store admin emails has also been improved.</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2018/10/payment-received.png?ssl=1\"><img /></a></p>\n<p>The WooCommerce team anticipates that the updates to the transactional emails will reduce the need for store owners to customize their email templates. It also gives customers a better, friendlier connection to the store. More updates to the email content editing experience are planned for 2019. </p>\n<p>Store owners may also benefit from the new option to set a low stock threshold in the inventory tab for individual products, export products by category to the CSV exporter, and define custom product placeholder images that will resize to correct store aspect ratio. </p>\n<p>The WooCommerce REST API continues to evolve with v3 introduced in this release. It adds new endpoints required for the <a href=\"https://github.com/woocommerce/wc-admin\" rel=\"noopener noreferrer\" target=\"_blank\">wc-admin feature plugin</a>, the React-powered WooCommerce admin interface that was <a href=\"https://wptavern.com/the-new-woo-adopts-gutenberg-components-user-interface-driven-by-react\" rel=\"noopener noreferrer\" target=\"_blank\">featured at last week&#8217;s WooSesh</a>. REST API v3 also adds new features to existing endpoints while maintaining backwards compatibility with legacy API versions.</p>\n<p>WooCommerce 3.5 introduces support for the <a href=\"https://wptavern.com/woocommerce-custom-product-tables-plugin-now-in-beta-boasts-30-faster-page-loads\" rel=\"noopener noreferrer\" target=\"_blank\">Custom Product Tables feature plugin</a>, which is being developed to improve store performance and scalability. In some cases storing product data in custom tables has brought <a href=\"https://woocommerce.wordpress.com/2018/07/17/woocommerce-custom-product-tables-beta/\" rel=\"noopener noreferrer\" target=\"_blank\">30% faster page loads</a>. </p>\n<p>In version 3.5 the &#8220;Preview Changes&#8221; button was <a href=\"https://github.com/woocommerce/woocommerce/pull/20650\" rel=\"noopener noreferrer\" target=\"_blank\">removed from the publish meta box when editing products</a>. If you&#8217;re missing it, <a href=\"https://www.remicorson.com/woocommerce-3-5-bring-me-that-preview-button-back/\" rel=\"noopener noreferrer\" target=\"_blank\">Rémi Corson published a quick CSS snippet</a> to bring it back.</p>\n<p>Check out the <a href=\"https://woocommerce.wordpress.com/2018/10/23/woocommerce-3-5-is-here/\" rel=\"noopener noreferrer\" target=\"_blank\">release post</a> for a full rundown of all the updates, deprecations, and template file changes in version 3.5. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 27 Oct 2018 02:15:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"WPTavern: WP Engine Acquires Array Themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=85078\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wptavern.com/wp-engine-acquires-array-themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5848:\"<p>WP Engine <a href=\"https://wpengine.com/blog/bringing-array-themes-into-the-wp-engine-family/\">has acquired</a> <a href=\"https://arraythemes.com/\">Array Themes</a> and <a href=\"https://atomicblocks.com/\">Atomic Blocks</a> from Mike McAlister for an undisclosed amount. McAlister has been developing WordPress themes since 2009. He initially sold his themes on ThemeForest. In 2011, he founded Array Themes.</p>\n<p>I reached out to McAlister to learn why he chose to be acquired, what excites him most about Gutenberg, and what the plans are going forward.</p>\n<h2>Interview with Mike McAlister</h2>\n<h4><strong>What ultimately made you decide to move on from managing your own theme and products company to a larger, more established company?</strong></h4>\n<p>The catalyst was when Brian Gardner reached out this summer and started a conversation about joining his team at <a href=\"https://wpengine.com\">WP Engine</a>. As I told him at the time, he certainly wasn&#8217;t the first to make that offer, but he was definitely the most interesting. I had always respected Brian&#8217;s ethos on quality and design and really enjoyed our chats over the years.</p>\n<p>Once I started meeting folks at WP Engine like Jason Cohen and David Vogelpohl, it became obvious that we were all striving for the same future and outcome for customers. It just made sense to join forces to make it happen together.</p>\n<p>This was also a unique opportunity for me to start fresh and focus on crafting products with a stellar team. Although I was able to create an industry-respected theme collection and recently the <a href=\"https://wordpress.org/plugins/atomic-blocks/\">Atomic Blocks</a> plugin for Gutenberg, I wanted a new challenge. </p>\n<h4><strong>Couldn&#8217;t Array Themes have been built to directly support the Genesis framework without being acquired by WP Engine?</strong></h4>\n<p>It would be a lot of work to infuse the Array Themes collection and Genesis. The idea wasn&#8217;t exactly to bring Genesis to Array, rather to bring the expertise and craft of Array and Atomic Blocks to WP Engine, StudioPress and Gutenberg. </p>\n<p>StudioPress already has one of the biggest and best theme collections out there and is doubling down on Gutenberg support. I&#8217;m going to contribute what I&#8217;ve learned building Array Themes and Atomic Blocks to make the StudioPress offering even better.</p>\n<h4><strong>Will future themes require the Genesis framework?</strong></h4>\n<p>Although there will not be any new themes released under the Array Themes brand, some of the designs will live on as <a href=\"https://my.studiopress.com/themes/\">StudioPress themes</a> in the future and those will be powered by the Genesis framework. </p>\n<p>We&#8217;re working on some really exciting new themes and features for Genesis that are going to continue making it the go-to solution for creating beautiful websites on WordPress, especially in the Gutenberg era.</p>\n<h4><strong>What do you think of the consolidation of brands in the WordPress space?</strong></h4>\n<p>We&#8217;re seeing a very unique and transitional time in the WordPress industry. The old way of doing things is going out the window as WordPress and its community changes before our eyes. </p>\n<p>Now, more than ever, WordPress needs companies with stellar talent to help usher it through to the next era and contribute to its long term success. I&#8217;m excited to be part of a team that is willing to take on that challenge!</p>\n<p>I can&#8217;t speak to the motivations of other businesses in the WordPress space, but the WP Engine acquisition of the Array product suite makes a lot of sense. </p>\n<p>With their recent acquisition of StudioPress, Array Themes, and Atomic Blocks, WP Engine is showing its customers and the WordPress community that they are doubling down on quality, design, Gutenberg, and an unmatched customer experience. These are all shared qualities between these individual entities and part of the long term strategy at WP Engine.</p>\n<h4><strong>What excites you most about Gutenberg?</strong></h4>\n<p>I&#8217;ve been excited about Gutenberg for over a year now. I was one of the first WordPress product developers to release a <a href=\"https://wordpress.org/plugins/atomic-blocks/\">blocks plugin</a>, a <a href=\"https://wordpress.org/themes/atomic-blocks/\">Gutenberg-friendly theme</a>, <a href=\"https://atomicblocks.com/blog/\">a blog with tutorials</a>, and the <a href=\"http://gutenberg.news/\">Gutenberg News</a> site. </p>\n<p>I created all of these resources as a way of learning Gutenberg as well as contributing back to the community, and I will continue to do that with WP Engine and StudioPress!</p>\n<p>Gutenberg unlocks the WordPress editor and the endless opportunities that follow for content creators, developers, and everyone in between. Gutenberg is already responsible for a flood of new products and new solutions to problems the classic editor couldn&#8217;t solve and it hasn&#8217;t even been merged into core yet! </p>\n<p>The reality here is that Gutenberg isn&#8217;t just the future of WordPress, it&#8217;s the future of the Internet.</p>\n<h2>Discounts Available for Array Themes Customers<br /></h2>\n<p>McAlister is joining WP Engine as a full-time employee. In addition, <a href=\"https://arraythemes.com/about/\">John Parris</a>, a code wrangler for Array Themes has also joined WP Engine. </p>\n<p>StudioPress and WP Engine are offering discounts to single theme and theme club members. Those who purchased a lifetime membership will receive free access to the StudioPress Pro Plus All-Theme package with support and updates.</p>\n<p>To learn more about these discounts and how the acquisition came about, check out <a href=\"https://arraythemes.com/onward/\">McAlister&#8217;s post</a> where he says thanks and farewell to his customers. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 26 Oct 2018 23:08:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"Gary: Iterating on Merge Proposals\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"https://pento.net/?p=2535\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://pento.net/2018/10/26/iterating-on-merge-proposals/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5731:\"<p>Developing new WordPress features as plugins has been a wonderfully valuable process for all sorts of features to come into being, from the MP6 Dashboard Redesign, to oEmbed endpoints, and including multiple Customiser enhancements over the years. Thanks to the flexibility that this model offers, folks have been able to iterate rapidly on a wide range of features, touching just about every part of WordPress.</p>\n\n<p>The &#8220;Features as Plugins&#8221; idea was first introduced during the WordPress 3.7 development cycle, during which the features were merged after a short discussion during a core chat: it was only in the WordPress 3.8 cycle that the idea of a merge proposal post (called &#8220;Present Your Feature&#8221; back then) came into being. It was envisioned as a way to consult with WordPress leaders, key contributors, and the wider WordPress community on the readiness of this feature to be released. Ultimately, WordPress leaders would make a decision on whether the feature was right for WordPress, and the release lead would decide if it was ready for that release.</p>\n\n<p>Since then, most feature plugins have published some form of merge proposal post before they were ultimately merged into WordPress, and they&#8217;ve nearly all benefited to some degree from this process.</p>\n\n<p class=\"has-large-font-size\">The merge proposal process has worked well for smaller features, but it struggled with larger changes.</p>\n\n<p>The REST API is a great example of where the merge proposal process didn&#8217;t work. The REST API was a significant change, and trying to communicate the scope of that change within the bounds of a single merge proposal post didn&#8217;t really do it justice. It was impossible to convey everything that was changing, how it all worked together, and what it meant for WordPress.</p>\n\n<p>I&#8217;d go so far as to say that the shortcomings of the merge proposal process are at least partially responsible for why the REST API hasn&#8217;t seen the level of adoption we&#8217;d hoped for. It&#8217;s managed to gain a moderate amount of popularity with WordPress development agencies, and a handful of plugins use it in some ways, but it never really entered into mainstream usage in the ways it could&#8217;ve.</p>\n\n<p class=\"has-large-font-size\">In a project that prides itself on being willing to try new ideas, the merge proposal process has remained largely static for many years.</p>\n\n<p>Gutenberg is the first opportunity since the REST API was merged where we can examine the shortcomings of the merge proposal process, and see how we can apply the original intent of it to the Gutenberg project&#8217;s scope and long term vision.</p>\n\n<h2>Merge Consultation</h2>\n\n<p>Over the last six months, Gutenberg project leads have been consulting with teams across the WordPress project. Helping them get involved when they didn&#8217;t have any Gutenberg experience, explaining how their focus fit into the vision for Gutenberg, and listening to feedback on where things needed to be improved. In many circumstances, this consultation process has been quite successful: the WordPress Media and REST API teams are great examples of that. Both teams have got up to speed on the Gutenberg project, and have provided their valuable experience to make it even better.</p>\n\n<p>That&#8217;s not to say it&#8217;s been entirely successful. There&#8217;s been a lot of discussion about Gutenberg and Accessibility recently, much of it boils down to what <a href=\"https://www.joedolson.com/2018/10/some-gutenberg-accessibility-clarifications/\">Joe Dolson summarised</a> as being &#8220;too little, too late&#8221;. He&#8217;s correct, the Accessibility team should&#8217;ve been consulted more closely, much earlier in the process, and that&#8217;s a mistake I expect to see rectified as the Gutenberg project moves into its next phase after WordPress 5.0. While Gutenberg has always aimed to prioritise accessibility, both <a href=\"https://make.wordpress.org/core/2018/10/18/regarding-accessibility-in-gutenberg/\">providing tools to make the block editor more accessible, as well as encouraging authors to publish accessible content</a>, there are still areas where we can improve.</p>\n\n<p>While there&#8217;s much to be discussed following WordPress 5.0, we can already see now that different teams needed to be consulted at different points during the project. Where Gutenberg has aimed to consult with teams earlier than a previous feature plugin would&#8217;ve, we need to push that further, ensuring that teams are empowered to get involved earlier still in the process.</p>\n\n<p class=\"has-large-font-size\">All feature plugins in the future, great and small, will benefit from this iteration.</p>\n\n<p>Creating a framework for more fluid feedback over the entire lifecycle of a feature project is beneficial for everyone. WordPress teams can ensure that their feedback is taken on board at the right time, project leads gain experience across the broad range of teams that work on WordPress, and projects themselves are able to produce a better resulting feature.</p>\n\n<p>They important thing to remember throughout all of this is that everything is an experiment. We can try an approach, discover the weaknesses, and iterate. We&#8217;re all only human, we all make mistakes, but every mistake is an opportunity to ensure the same mistake can&#8217;t happen again. Sometimes that means changing the software, and sometimes that means changing the processes that help build the software. Either way, we&#8217;re always able to iterate further, and make WordPress fun for everyone. <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f642.png\" alt=\"🙂\" class=\"wp-smiley\" /></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 26 Oct 2018 03:30:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Gary\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"WPTavern: WPWeekly Episode 335 – Introduction to BigCommerce with Topher DeRosia\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=85070&preview=true&preview_id=85070\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://wptavern.com/wpweekly-episode-335-introduction-to-bigcommerce-with-topher-derosia\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1798:\"<p>In this episode, <a href=\"http://jjj.me\">John James Jacoby</a> and I are joined by <a href=\"https://topher1kenobe.com/\">Topher DeRosia</a>, a developer evangelist for <a href=\"https://www.bigcommerce.com/\">BigCommerce</a>. DeRosia introduces what BigCommerce is, why users and developers should take a look at it, and why they&#8217;re making a big push into the WordPress space. He also provides an update on HeroPress and why next year, you&#8217;ll be seeing him at a lot more WordPress events.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"https://wptavern.com/polldaddy-rebrands-to-crowdsignal\" rel=\"bookmark\">Polldaddy Rebrands to Crowdsignal</a><br />\n<a href=\"https://wptavern.com/the-new-woo-adopts-gutenberg-components-user-interface-driven-by-react\" rel=\"bookmark\">The New Woo Adopts Gutenberg Components, User Interface Driven by React</a><br />\n<a href=\"https://wptavern.com/gutenberg-team-addresses-accessibility-concerns-highlights-tools-and-features-that-surpass-the-classic-editor\" rel=\"bookmark\">Gutenberg Team Addresses Accessibility Concerns, Highlights Tools and Features that Surpass the Classic Editor</a></p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, October 31st 3:00 P.M. Eastern</p>\n<p>Subscribe to <a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\">WordPress Weekly via Itunes</a></p>\n<p>Subscribe to <a href=\"https://www.wptavern.com/feed/podcast\">WordPress Weekly via RSS</a></p>\n<p>Subscribe to <a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\">WordPress Weekly via Stitcher Radio</a></p>\n<p>Subscribe to <a href=\"https://play.google.com/music/listen?u=0#/ps/Ir3keivkvwwh24xy7qiymurwpbe\">WordPress Weekly via Google Play</a></p>\n<p><strong>Listen To Episode #335:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 25 Oct 2018 20:06:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"WPTavern: WPCampus is Pursuing an Independent Accessibility Audit of Gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=85035\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://wptavern.com/wpcampus-is-pursuing-an-independent-accessibility-audit-of-gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:11736:\"<p>WPCampus is looking to hire a company to perform an accessibility audit of the Gutenberg editor. The organization is a community of more than 800 web professionals, educators, and others who work with WordPress in higher education. WPCampus director Rachel Cherry <a href=\"https://wpcampus.org/2018/10/gutenberg-a11y-audit-rfp/\" rel=\"noopener noreferrer\" target=\"_blank\">published a request for proposals</a> detailing the organization&#8217;s specific concerns:</p>\n<blockquote><p>Our organization is sensitive to the legal requirements set by <a href=\"https://section508.gov/\" rel=\"noopener noreferrer\" target=\"_blank\">Section 508 of the Rehabilitation Act</a>. The recent 508 refresh brought these requirements in line with <a href=\"https://www.w3.org/WAI/standards-guidelines/wcag/\" rel=\"noopener noreferrer\" target=\"_blank\">WCAG 2.0 level AA</a>, an industry standard that helps ensure accessibility. WCAG 2.0 is also <a href=\"https://www.w3.org/WAI/policies/\" rel=\"noopener noreferrer\" target=\"_blank\">commonly used as a baseline for policies</a> governing many WPCampus participants outside the United States, with the <a href=\"https://www.w3.org/blog/2018/09/wcag-2-1-adoption-in-europe/\" rel=\"noopener noreferrer\" target=\"_blank\">European Union already moving to WCAG 2.1</a>.</p></blockquote>\n<p>The audit is aimed at determining potential legal risk for institutions upgrading to WordPress 5.0 and will also identify specific challenges that Gutenberg introduces for assistive technology users and others with accessibility needs.</p>\n<p>WPCampus is funding the audit and is not soliciting contributions from the community at this time. However, Pagely has <a href=\"https://twitter.com/Pagely/status/1055289065883365377\" rel=\"noopener noreferrer\" target=\"_blank\">offered to donate $1,000 to the organization</a> in order to offset the costs of the audit.</p>\n<p>&#8220;Contributions wise, at this point, we’d love for folks to share to help ensure we receive a wide variety of proposals,&#8221; Cherry said. WPCampus will publish the results of the audit to share with the greater WordPress community. </p>\n<p>&#8220;Beyond our institutions’ legal obligations, colleges and universities worldwide have committed to providing an accessible digital experience to their diverse communities,&#8221; Cherry said. &#8220;This is consistent with the broader culture of higher education, which values inclusivity and an exchange of ideas free from artificial barriers.</p>\n<p>&#8220;While the WordPress accessibility coding standards require new code to meet WCAG 2.0 AA, the new editor has not received a full accessibility audit. Lacking such an audit, the overall accessibility of Gutenberg is unclear. This makes it difficult for colleges and universities to determine the best course of action once WordPress 5.0 is released with Gutenberg as the default editor.&#8221;</p>\n<h3>The Accessibility Team is Preparing a Statement on Gutenberg&#8217;s Current Level of Accessibility</h3>\n<p>Accessibility has been one of the most pressing concerns regarding Gutenberg&#8217;s readiness for the world. The accessibility team met Monday and established a new weekly meeting time:&nbsp;15:00 UTC on Fridays. They discussed a communication plan for&nbsp;Gutenberg accessibility feedback, particularly in regards to&nbsp;Matthew<a href=\"https://make.wordpress.org/core/2018/10/19/call-for-testers-community-gutenberg-accessibility-tests/\"> MacPherson&#8217;s call for accessibility testing</a> on the plugin. User testing was conducted in March but a lot has changed since then. MacPherson has called for another round of tests from the community after <a href=\"https://wptavern.com/gutenberg-accessibility-audit-postponed-indefinitely\" rel=\"noopener noreferrer\" target=\"_blank\">Automattic decided to forego his proposed independent audit</a> on Gutenberg.</p>\n<p>The discussion became somewhat contentious after Gutenberg phase 2 lead Riad Benguella urged the accessibility team not to make its assessment in comparison to the classic editor but instead look at the larger picture.</p>\n<p>&#8220;Gutenberg is meant for the whole site editing (even if it’s not at the moment) which means it’s the customizer + editor + menus + widgets at the same time,&#8221; Benguella said. &#8220;Just compare apples to apples, please, and if you see Gutenberg as an editor, you missed it. For the sake of iteration, it’s being shipped as an editor for now.&#8221;</p>\n<p>Several members of the accessibility team took issue with statement because Gutenberg will replace the classic editor in WordPress 5.0 (even if users can bring it back with a plugin).</p>\n<p>&#8220;It is <em>crucial</em> we compare these two experiences, because the one completely replaces the other,&#8221; Joe Dolson said. &#8220;It doesn’t matter that the new editor aims to do a lot more, it still must accomplish the same tasks effectively.&#8221;</p>\n<p>Amanda Rush, a blind WordPress user and accessibility specialist, concurred with Dolson&#8217;s assessment.</p>\n<p>&#8220;As someone trying to use Gutenberg as it currently stands with a screen reader, I promise you that future goals for the project are the absolute furthest thing away from my brain at the time,&#8221; Rush said.</p>\n<p>&#8220;Let’s put it this way. Imagine that you are someone who must use assistive technology, or is otherwise reliant on something to do with Accessibility, and you have Gutenberg in front of you and you are trying to accomplish a task. Right now, the only task you can accomplish is writing or editing a post. So, as you are becoming more and more frustrated with the state of things, and trying to get your work done at the same time, imagine what it would be like if someone walked up to you in the middle of this frustrating experience and said well, if you’re calling as an editor you’ve missed it. Because this is going to be so much more than that. That is completely useless, doesn’t have any bearing on what you were trying to accomplish at the time, and promises, whether fairly or not, just more frustration down the road.&#8221;</p>\n<p><a href=\"https://wptavern.com/wordpress-5-0-beta-1-now-available-for-testing\" rel=\"noopener noreferrer\" target=\"_blank\">Beta 1</a> has arrived before the next round of accessibility testing has been completed, and Gutenberg has only recently arrived at UI freeze within the last week. The accessibility team is collaborating on a detailed article with a general and professional statement on the level of overall accessibility in Gutenberg. They plan to publish the statement on Friday.</p>\n<p>In the meantime, WPCampus has taken it upon themselves to spearhead an independent audit to determine if Gutenberg is in compliance with the industry standard WCAG 2.0 level AA, a standard which the accessibility team <a href=\"https://wptavern.com/wordpress-adopts-accessibility-coding-standards-for-all-new-and-updated-code\" rel=\"noopener noreferrer\" target=\"_blank\">adopted as a requirement for all new or updated code released in WordPress</a>. WPCampus&#8217; submission deadline for proposals is November 7, and the organization will select a vendor by November 30. The goal is to release the audit no later than January 17, 2019. </p>\n<p>The timeline WPCampus has identified would not deliver results in time to meaningfully impact WordPress 5.0&#8217;s release date. As Gutenberg has already been merged into core, it seems neither the accessibility team&#8217;s assessment nor an independent third-party audit would be considered a factor in delaying the release. </p>\n<p>&#8220;The goal with the timeline is to allow adequate time to do it right,&#8221; Cherry said. </p>\n<p>The WordPress community has responded positively to this independent effort to get more information on Gutenberg&#8217;s accessibility issues. </p>\n<p>&#8220;I&#8217;m excited for this process as an example of how the community can tackle large tasks like this in creative ways,&#8221; Jeremy Felt <a href=\"https://twitter.com/jeremyfelt/status/1055176432861634560\" rel=\"noopener noreferrer\" target=\"_blank\">said</a> in response to WPCampus&#8217; taking the initiative to get an audit. &#8220;It also has an opportunity to provide great insight and instruction on the accessibility of a complex React application with many interacting pieces.&#8221;</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">This <a href=\"https://twitter.com/hashtag/Gutenberg?src=hash&ref_src=twsrc%5Etfw\">#Gutenberg</a> / <a href=\"https://twitter.com/hashtag/WordPress?src=hash&ref_src=twsrc%5Etfw\">#WordPress</a> <a href=\"https://twitter.com/hashtag/accessibility?src=hash&ref_src=twsrc%5Etfw\">#accessibility</a> audit, spearheaded by <a href=\"https://twitter.com/wpcampusorg?ref_src=twsrc%5Etfw\">@wpcampusorg</a>, is exciting. Now that we power 32% of the web, we need independent verification that we\'re doing it right, building a better web. <a href=\"https://t.co/cXRwcXWQlN\">https://t.co/cXRwcXWQlN</a></p>\n<p>&mdash; Morten Rand-Hendriksen (@mor10) <a href=\"https://twitter.com/mor10/status/1055506088567627776?ref_src=twsrc%5Etfw\">October 25, 2018</a></p></blockquote>\n<p></p>\n<p>Accessibility is part of <a href=\"https://wordpress.org/about/\" rel=\"noopener noreferrer\" target=\"_blank\">WordPress&#8217; stated mission</a>: &#8220;WordPress is software designed for everyone, emphasizing accessibility, performance, security, and ease of use.&#8221; The <a href=\"https://wordpress.org/about/accessibility/\" rel=\"noopener noreferrer\" target=\"_blank\">accessibility pages</a> on the project&#8217;s website advertise WordPress as committed to ensuring all new and updated code conforms with WordPress Accessibility Coding Standards. Many in the community have expressed concern that if WordPress 5.0 ships a critically inaccessible new editor, it will be violating both its stated mission and its standards.</p>\n<p>A great deal of friction has surrounded Gutenberg&#8217;s journey towards becoming an accessible tool for millions of users. The struggle has highlighted areas where the WordPress project can improve its collaboration across teams. It has inspired many to <a href=\"https://twitter.com/mor10/status/1054962217022640128\" rel=\"noopener noreferrer\" target=\"_blank\">share</a> their personal stories and some have even <a href=\"https://twitter.com/ryanwelcher/status/1055158337057239040\" rel=\"noopener noreferrer\" target=\"_blank\">pledged</a> to <a href=\"https://jonathandesrosiers.com/2018/10/accessibility-a-developers-pledge/\" rel=\"noopener noreferrer\" target=\"_blank\">ramp up their accessibility contributions</a>.</p>\n<p>Many contributors were disappointed after Automattic decided to forego the independent accessibility audit on Gutenberg, given the company&#8217;s strong messaging about their passion for inclusive design. However, one positive outcome is that the company is now looking to <a href=\"https://automattic.com/work-with-us/product-designer-accessibility/\" rel=\"noopener noreferrer\" target=\"_blank\">hire a product designer who specializes in accessibility</a>. </p>\n<p>Rian Rietveld&#8217;s <a href=\"https://wptavern.com/wordpress-accessibility-team-lead-resigns-cites-political-complications-related-to-gutenberg\" rel=\"noopener noreferrer\" target=\"_blank\">resignation from the accessibility team</a> was a great loss for the project but it served as a catalyst to bring more visibility to the efforts of WordPress&#8217; accessibility contributors. WPCampus&#8217; initiative to get an accessibility audit for Gutenberg is one example of how the community is rallying around the accessibility team and working to help make the new editor a success for all users, including those with accessibility needs.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 25 Oct 2018 19:53:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"WPTavern: WordPress 5.0 Beta 1 Now Available for Testing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84914\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wptavern.com/wordpress-5-0-beta-1-now-available-for-testing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2404:\"<p>WordPress 5.0 is marching forward with <a href=\"https://wordpress.org/news/2018/10/wordpress-5-0-beta-1/\">beta 1 released</a> this evening. Major items that need testing include the Gutenberg editor, the new Twenty Nineteen default theme, and all previous default themes, which have been updated to be compatible with the new editor.</p>\n<p>You&#8217;ll want to make sure you are using Gutenberg version 4.1 before updating your site to WordPress 5.0 beta 1. Gutenberg is now considered feature complete as of the <a href=\"https://make.wordpress.org/core/2018/10/19/whats-new-in-gutenberg-19th-october/\">4.1 release</a>. It is active on more than 580,000 installations.</p>\n<p>WordPress 5.0 beta 1 has arrived five days after its expected release on October 19. Contributors expressed concern in today&#8217;s dev chat over the large number of issues on GitHub in milestones related to 5.0.</p>\n<p>Gary Pendergast, who is responsible for leading the merge, said the dates for RC can be changed if necessary.</p>\n<p>&#8220;We can shift RC if we need to, which won’t necessarily affect the final release date,&#8221; Pendergast said. &#8220;If we have to shift RC a long way, that would be a good time to have another look at the release date.&#8221;</p>\n<p>The Gutenberg team has not published a merge proposal to date. In September, Pendergast <a href=\"https://wordpress.slack.com/archives/C02RQBWTW/p1537994851000100\">said</a> &#8220;the Gutenberg leads are ultimately responsible for the merge proposal&#8221; but the timeline was still to be determined. Unless a proposal is forthcoming, the project seems to have bypassed this stage, which has frequently been a requirement for new themes, APIs, and feature plugins in the past.</p>\n<p>Volunteers contributing to the Gutenberg handbook met for the first time today in the #core-docs channel. Chris Van Patten is coordinating the documentation effort to clean up and prepare Gutenberg-related docs for 5.0 over the next  five weeks.</p>\n<p>Testers are advised to <a href=\"https://core.trac.wordpress.org/tickets/major\">consult the list of known bugs</a> before reporting to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta forum</a> or <a href=\"https://make.wordpress.org/core/reports/\">filing a bug on trac</a>.</p>\n<p>If this release stays on schedule, Gutenberg is now 26 days away from shipping in WordPress 5.0.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 25 Oct 2018 00:35:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Dev Blog: WordPress 5.0 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6209\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2018/10/wordpress-5-0-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3662:\"<p>WordPress 5.0 Beta 1 is now available!</p>\n\n<p><strong>This software is still in development,</strong>&nbsp;so we don’t recommend you run it on a production site. Consider setting up a test site to play with the new version, and if you are using an existing test site be sure to update the Gutenberg plugin to v4.1. </p>\n\n<p>There are two ways to test the WordPress 5.0 beta: try the&nbsp;<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a>&nbsp;plugin (you’ll want “bleeding edge nightlies”), or you can&nbsp;<a href=\"https://wordpress.org/wordpress-5.0-beta1.zip\">download the beta here</a>&nbsp;(zip).</p>\n\n<p>WordPress 5.0 is slated for release on&nbsp;<a href=\"https://make.wordpress.org/core/5-0/\">November 19</a>, and we need your help to get there. Here are some of the big items to test so we can find as many bugs as possible in the coming weeks.</p>\n\n<h2>The Block Editor</h2>\n\n<p>The new Gutenberg block editor is now the default post editor!</p>\n\n<p>The block editor provides a modern, media-rich editing experience. You can create flexible, beautiful content without writing a single line of code, or you can dive into the <a href=\"https://wordpress.org/gutenberg/handbook/\">modern programming APIs</a> that the block editor provides.</p>\n\n<p>Even before you install WordPress 5.0, you can <a href=\"https://wordpress.org/gutenberg/\">try the block editor here</a>.</p>\n\n<p>Of course, we recognise you might not be ready for this change quite yet. If that&#8217;s the case, you can install the <a href=\"https://wordpress.org/plugins/classic-editor/\">Classic Editor plugin</a> now, which will keep the editor you&#8217;re familiar with as the default, even after you upgrade to WordPress 5.0.</p>\n\n<h2>Twenty Nineteen</h2>\n\n<p>Along with the new block editor, we have a new default theme, called Twenty Nineteen, which takes advantage of the new features the block editor provides.</p>\n\n<p>You can read more about Twenty Nineteen in its <a href=\"https://make.wordpress.org/core/2018/10/16/introducing-twenty-nineteen/\">introduction post</a>, and follow along with development over on the <a href=\"https://github.com/WordPress/twentynineteen\">GitHub repository</a>.</p>\n\n<h2>Default Themes</h2>\n\n<p>Of course, we couldn&#8217;t release a beautiful new default theme, and leave all of our old ones behind. All the way back to Twenty Ten, we&#8217;ve updated every default them to look good in the new block editor.</p>\n\n<h2>How to Help</h2>\n\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a> <strong>A known issue</strong>: the block autocompleter fails for blocks whose names contain  characters in non-Latin scripts. Adding blocks via the plus sign works, and this bug is fixed in the Gutenberg 4.1 plugin. <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f642.png\" alt=\"🙂\" class=\"wp-smiley\" /></p>\n\n<p><strong><em>If you think you’ve found a bug</em></strong><em>, you can post to the&nbsp;</em><a href=\"https://wordpress.org/support/forum/alphabeta\"><em>Alpha/Beta area</em></a><em>&nbsp;in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report,&nbsp;</em><a href=\"https://make.wordpress.org/core/reports/\"><em>file one on WordPress Trac</em></a><em>, where you can also find&nbsp;</em><a href=\"https://core.trac.wordpress.org/tickets/major\"><em>a list of known bugs</em></a><em>.</em></p>\n\n<hr class=\"wp-block-separator\" />\n\n<p><em>Minor bug fixes<br />Add up one by one by one<br />Then you change the world</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 24 Oct 2018 21:59:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Gary Pendergast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"WPTavern: WCEU Team is Working on PWA Support for All WordCamp Websites\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84992\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://wptavern.com/wceu-team-is-working-on-pwa-support-for-all-wordcamp-websites\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3605:\"<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/06/venue-map.png?ssl=1\"><img /></a>WordCamp Europe&#8217;s new PWA (Progressive Web App) was one of the highlights of the 2018 event in Belgrade. It allowed attendees to view the schedule, venue map, create bookmarks for sessions, and provided offline access in case of network failure. Attendees could add the app to their home screens and opt to receive push notifications for important updates about the event.</p>\n<p>The first iteration of the PWA was not ready to be scaled for use at other WordCamps across the community, but <a href=\"https://make.wordpress.org/community/2018/10/23/progressive-web-app-for-wordcamps/\">volunteers from the WCEU organizing team are working towards that goal</a>.&nbsp; The app was originally built using React on the frontend and was hosted on a node server. It used WordPress for content management on the backend, along with the&nbsp;<a href=\"https://wordpress.org/plugins/wp-pwa/\">WordPress PWA</a>&nbsp;plugin and&nbsp;<a href=\"https://wordpress.org/plugins/onesignal-free-web-push-notifications/\">OneSignal Push Notifications</a>. The team working on scaling the app for use at other WordCamps is still debating the technologies they will use moving forward.</p>\n<p>Hugh Lashbrooke <a href=\"https://make.wordpress.org/community/2018/10/23/progressive-web-app-for-wordcamps/\">posted</a> about the app&#8217;s progress and invited the community to contribute to <a href=\"https://github.com/wceu/pwa\">WCEU&#8217;s PWA repository</a> on GitHub.&nbsp;</p>\n<p>&#8220;The next stage in the process is for the WCEU Design team to create some designs and wireframes for what the app could look like, posting them for feedback,&#8221; Lashbrooke said. &#8220;We will keep posting updates here as things progress; for now it would be helpful to gather some input from other WordCamp organizers.&#8221;</p>\n<p>Lashbrooke said the goal is that each WordCamp site will have its own PWA so the app is unique for each camp. Since it loads in a mobile browser, it doesn&#8217;t require additional app installations.</p>\n<p>Weston Ruter, one of the collaborators on the <a href=\"https://github.com/xwp/pwa-wp/\">PWA for WordPress</a> feature plugin, emphasized in the comments that the PWA should not be separate from the main site and that users need not even know about the app.</p>\n<p>&#8220;After all, a PWA is just a website,&#8221; Ruter said.&nbsp;&nbsp;&#8220;A PWA does not have to be installed to their homescreen to take advantage of PWA capabilities. They just continue go to their WordCamp website as they do normally, except that it also works when they are offline. The interactive schedule is important, but it’s not really PWA territory: rather it’s just a JavaScript component used on a page.&#8221;</p>\n<p>Ruter encouraged those working on the app to view it as a progressive enhancement on top of the existing WordCamp sites, not an entirely separate application. Ideally it will use the same style and theme used on the main website.</p>\n<p>Lashbrooke asked for developers and WordCamp organizers to leave feedback and feature requests in the comments of his <a href=\"https://make.wordpress.org/community/2018/10/23/progressive-web-app-for-wordcamps/\">post</a>. Requests submitted so far include a &#8220;you are here&#8221; feature and the capability for users to log in with their WordPress.org account to sync schedule favorites across devices. Not every feature request will make it into the first version, but the team will consult the list for future versions of the project.</p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 24 Oct 2018 15:08:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"WPTavern: New Plugin Adds Elementor Templates as Gutenberg Blocks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84998\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://wptavern.com/new-plugin-adds-elementor-templates-as-gutenberg-blocks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5217:\"<p>One of the most pressing concerns for users in the Gutenberg era is how page builder plugins will respond. Speculation about the new editor &#8220;killing off page builders&#8221; has run rampant, but these plugins are slowly evolving ahead of Gutenberg&#8217;s imminent inclusion in WordPress 5.0.</p>\n<p>In February, <a href=\"https://wordpress.org/plugins/elementor/\" rel=\"noopener noreferrer\" target=\"_blank\">Elementor</a>, one of WordPress&#8217; most popular page builders, <a href=\"https://elementor.com/blog/upcoming-elementor-v2/\" rel=\"noopener noreferrer\" target=\"_blank\">announced</a> the plugin would be completely compatible with Gutenberg beginning with its 2.0 version that was released a few months later. Like many other plugins, that meant a nominal compatibility without any custom blocks built specifically for the new editor.</p>\n<p>This week marks a major milestone for the page builder, as Elementor <a href=\"https://elementor.com/blog/blocks-for-gutenberg/\" rel=\"noopener noreferrer\" target=\"_blank\">introduced</a> its new <a href=\"https://wordpress.org/plugins/block-builder/\" rel=\"noopener noreferrer\" target=\"_blank\">Elementor Blocks for Gutenberg</a> plugin. The plugin goes beyond basic compatibility, allowing users to insert any Elementor template into Gutenberg with one click. Its custom block functions as a pipeline to the Elementor library, pulling in content and designs the user has already created in the Elementor interface.</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2018/10/Screen-Shot-2018-10-23-at-9.29.14-PM.png?ssl=1\"><img /></a></p>\n<p>Elementor Blocks for Gutenberg lets users compose with the new editor while maintaining convenient access to items designed in the page builder. It makes it possible to bring more advanced layouts into Gutenberg and preview them inside the editor. Users can select from more than 300+ pre-designed blocks and 100+ pre-designed pages. The plugin will eventually be incorporated into Elementor&#8217;s core plugin.</p>\n<p>The availability of this new plugin demonstrates Elementor&#8217;s commitment to evolving with WordPress as it adopts the editor and tackles customization in Phase 2. The page builder has more than a million active installations and a 4.8-star average on WordPress.org. Achieving this level of success in the page builder market has required a certain level of tenacity and perseverance. Elementor CMO Ben Pines made it clear their product is not going to be sidelined by Gutenberg.</p>\n<p>&#8220;Elementor was launched in a saturated market, with many page builder and website builder alternatives,&#8221; Pines said. &#8220;We managed to become the leaders of our market by offering the best solution, and we plan to continue to lead the way. We will continue in our mission in full collaboration with WordPress.&#8221;</p>\n<p>Elementor and Gutenberg share similar goals in helping WordPress users design their websites without having to touch the code. Pines also emphasized the benefits for developers.</p>\n<p>&#8220;Elementor, Gutenberg, and the veer towards code-free website customization, presents a huge improvement for developers,&#8221; he said.</p>\n<p>&#8220;Instead of being tied up in endless menial tasks like button or headline customization, and having to hand-hold the designer every step of the process – developers can now focus on greater challenges.</p>\n<p>&#8220;This improvement creates a positive loop. Developers have time to build more tools, which in turn help the designers workflow.&#8221;</p>\n<p>Other popular page builder plugins, like <a href=\"https://www.elegantthemes.com/blog/theme-releases/divi-feature-update-introducing-initial-gutenberg-support\" rel=\"noopener noreferrer\" target=\"_blank\">Divi Builder</a> (500k+ installs) and <a href=\"https://kb.wpbeaverbuilder.com/article/588-how-beaver-builder-works-with-gutenberg\" rel=\"noopener noreferrer\" target=\"_blank\">Beaver Builder</a> (500k+ installs), have announced initial support for Gutenberg but in both instances this constitutes a button that lets users toggle between the builder and the new editor.</p>\n<p>Elementor is leading the way among page builders by making its content available inside Gutenberg. It essentially builds in an extra step so users can continue with their existing workflow in the page builder and insert those designs into the new editor.</p>\n<p>Gutenberg&#8217;s current customization capabilities pale in comparison to what popular page builders offer, but phase 2 of the project may precipitate another avalanche of blocks pouring into the WordPress ecosystem &#8211; the same way it did after Gutenberg&#8217;s roadmap was unveiled in June at WordCamp Europe.</p>\n<p>Page builders may not reproduce all of their exiting features in custom blocks until WordPress core is more advanced on its road to Gutenberg-powered customization. This would split the creation interface across two admin screens. At some point users may want to see a deeper integration between the editor and page building capabilities. The exciting thing about Elementor&#8217;s new blocks plugin is that its users don&#8217;t have to choose between Gutenberg and their favorite page builder.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 24 Oct 2018 03:58:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"WPTavern: Upcase Developer Learning Platform is Now Free\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84859\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wptavern.com/upcase-developer-learning-platform-is-now-free\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1943:\"<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2018/10/upcase-thoughtbot.png?ssl=1\"><img /></a></p>\n<p><a href=\"https://thoughtbot.com/upcase\" rel=\"noopener noreferrer\" target=\"_blank\">Upcase</a>, a subscription learning platform for developers, is now free and open to the public. The content, which includes workshops, videos, flash cards, and coding exercises, was built by <a href=\"https://thoughtbot.com/\" rel=\"noopener noreferrer\" target=\"_blank\">thoughtbot</a>, a design and development consultancy.</p>\n<p>&#8220;We’ve loved building Upcase, both as a business and as a way to share what we’ve learned with the community,&#8221; thoughtbot development director Chris Toomey said. &#8220;But while we’d love to keep investing in Upcase and producing tons of new content, we’ve been moving in a different direction—back to our roots, in fact, as we focus on our core consulting business.&#8221;</p>\n<p>Thoughtbot employees work four days a week and Friday is devoted to learning new skills, working on open source, blogging, and other projects. The company found there was a lack of quality learning resources for intermediate and advanced topics, so they built Upcase with the content they wished had existed. Topics and courses include Git, intro to React, React Native, Unit Testing JavaScript, Ruby on Rails, Haskell, workflow and developer tooling, and techniques and patterns for building maintainable large scale applications.</p>\n<p>Upcase creators said they have seen thousands of customers improve their skills and gain new levels in their careers since launching the site in 2012. The consultancy has created hundreds of hours of videos and screencasts based on their collective expertise. To start on any of the <a href=\"https://thoughtbot.com/upcase\" rel=\"noopener noreferrer\" target=\"_blank\">Upcase</a> learning &#8220;trails&#8221; you can sign in with your GitHub credentials for free access.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 23 Oct 2018 15:10:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"WPTavern: Polldaddy Rebrands to Crowdsignal\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84964\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://wptavern.com/polldaddy-rebrands-to-crowdsignal\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2040:\"<p>Polldaddy&nbsp;was founded in 2006 by David Lenehan in Sligo, Ireland and was <a href=\"http://blog.polldaddy.com/2008/10/15/automattic-acquires-polldaddy/\">acquired by Automattic</a> in 2008. Polldaddy is a platform agnostic service providing users with the ability to create polls and surveys.</p>\n<div class=\"wp-block-image\">\n<img />Crowdsignal Logo\n</div>\n<p>Today, 12 years later, Automattic is <a href=\"https://blog.polldaddy.com/2018/10/18/introducing-crowdsignal/\">retiring the Polldaddy</a> name and replacing it with Crowdsignal. Outside of some minor color changes, and updated graphics, the service will largely remain the same. </p>\n<p>Redirects are in place so that bookmarked links to edit surveys, polls, and quizzes will continue to work. Beginning October 24th, visitors to Polldaddy.com will be redirected to Crowdsignal.com.</p>\n<p>There are a few notable changes to keep in mind regarding the transition. The Polldaddy dashboard will automatically redirect to the Crowdsignal version. Polldaddy&#8217;s API will live on <a href=\"https://api.crowdsignal.com/v1/\">https://api.crowdsignal.com/v1/</a> instead of <a href=\"https://api.polldaddy.com/\">https://api.polldaddy.com/</a>. Surveys and quizzes will be served from survey.fm and polls will be served from poll.fm.&nbsp; </p>\n<p>According to Donncha Ó Caoimh, some networks and hosts may need to whitelist the following domains to prevent interruptions in service. The domains are:</p>\n<ul>\n<li>api.crowdsignal.com</li>\n<li>app.crowdsignal.com</li>\n<li>crowdsignal.com</li>\n<li>survey.fm</li>\n<li>poll.fm</li>\n</ul>\n<p>Surveys, quizzes, and polls that are embedded will continue to function normally. </p>\n<p>It&#8217;s the end of an era for the Polldaddy name but what the announcement doesn&#8217;t include is <a href=\"https://twitter.com/jeffr0/status/1053013327834681344\">why the rebranding was necessary</a>. Whatever the reasons are for rebranding, Crowdsignal is a more accurate way to describe what the service provides without being tied to a gender. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 23 Oct 2018 02:48:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:115:\"WPTavern: Genesis Framework and StudioPress Themes Add Gutenberg Compatibility, More Gutenberg Features Coming Soon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84464\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:125:\"https://wptavern.com/genesis-framework-and-studiopress-themes-add-gutenberg-compatibility-more-gutenberg-features-coming-soon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2380:\"<p>After <a href=\"https://wptavern.com/wp-engine-acquires-studiopress\" rel=\"noopener noreferrer\" target=\"_blank\">WP Engine acquired StudioPress</a> in June, the company began investing in expanding the Genesis team. WP Engine is hiring new people to work on the <a href=\"https://wpengine.com/themes/genesis-framework/\" rel=\"noopener noreferrer\" target=\"_blank\">framework</a> and expand support and community activities.</p>\n<p>On the latest episode of the newly revived <a href=\"https://studiopress.blog/studiopressfm-season2/\" rel=\"noopener noreferrer\" target=\"_blank\">StudioPress.fm</a> podcast, StudioPress founder Brian Gardner said one of the reasons he sold the company was because he needed outside help to take it where it needed to go in the Gutenberg era. The Genesis community has nothing to worry about when the new editor launches in WordPress 5.0, because <a href=\"https://wpengine.com/blog/gutenberg-believe-in-beauty-of-dreams/\" rel=\"noopener noreferrer\" target=\"_blank\">StudioPress has already made its framework and themes Gutenberg-ready</a>.</p>\n<p>&#8220;With regards to Genesis, the good news is that it has no substantial backwards-compatibility issues with Gutenberg,&#8221; WP Engine CTO Jason Cohen said. &#8220;The main focus of updates to the StudioPress themes are focused on adding styles for the new Gutenberg blocks. However, what we’re most excited about are the brand new features we will be adding to Genesis and the StudioPress themes, that Gutenberg helps enable.&#8221;</p>\n<p>Cohen said the Genesis community can expect their entire product line to become Gutenberg-first themes that add new features to enhance users&#8217; experience in the editor.</p>\n<p>&#8220;Beyond just being &#8216;compatible,&#8217; Genesis will play a big role in being Gutenberg-First,&#8221; Cohen said. &#8220;That means not only supporting the software and ideals of Gutenberg, but using them for new features. In doing so, it’s our intention to light the way for the countless agencies and developers who use WordPress to fuel incredible digital experiences that are made even easier with Gutenberg.&#8221;</p>\n<p>Cohen said WP Engine will update all StudioPress themes to include additional features for Gutenberg once the new editor launches in WordPress 5.0. If the release stays on its current schedule, users can expect to see 5.0 on November 19.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 19 Oct 2018 22:41:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:120:\"WPTavern: Gutenberg Team Addresses Accessibility Concerns, Highlights Tools and Features that Surpass the Classic Editor\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84857\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:130:\"https://wptavern.com/gutenberg-team-addresses-accessibility-concerns-highlights-tools-and-features-that-surpass-the-classic-editor\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8021:\"<p>The Gutenberg team has officially <a href=\"https://make.wordpress.org/core/2018/10/18/regarding-accessibility-in-gutenberg/\" rel=\"noopener noreferrer\" target=\"_blank\">responded to recent concerns about the new editor&#8217;s accessibility</a>. Matias Ventura, the project&#8217;s technical lead, published a post with examples of the accessibility efforts the team has made, many which may not be easy to discover. These include features such as keyboard shortcuts, slash command and insertion, high-contrast mode, and mechanisms for navigating regions and blocks with the keyboard.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/10/keyboard-shortcuts.png?ssl=1\"><img /></a></p>\n<p>Ventura highlighted the audible messages feature that works with screen readers and posted a demo of the fully automated end-to-end testing. It allows contributors to test a sequence of operations with the keyboard (without mouse controls). He also identified several fixes landing in the next releases, including accessibility improvements to the date and color picker features, block navigation, and better focus management.</p>\n<p>&#8220;A large amount of work and effort has gone in building mechanisms necessary to make the editor accessible for a wide user base,&#8221; Ventura said. &#8220;For example, it is entirely possible right now to recreate the &#8216;demo post&#8217; that comes with the Gutenberg plugin using the keyboard. In many ways, these tools are better and more sophisticated than what we offer in the current editor.&#8221;</p>\n<p>Although 270 accessibility-specific tickets have been closed to date, Ventura acknowledged there are still more than 90 remaining. &#8220;The goal is to make this experience as seamless as possible for all users,&#8221; he said.</p>\n<p>Early reactions to the post do not dispute that accessibility work has been done but concerns about Gutenberg&#8217;s overall complexity remain. Fixing this may not be as simple as targeting isolated interactions in the editor.</p>\n<p>&#8220;We need to continue to develop close feedback loops with different users interacting through their preferred tools to make sure what we build is relevant to their experiences,&#8221; Ventura said. Throughout the process of building and testing Gutenberg, contributors have referenced &#8220;short feedback loops,&#8221; an agile process term that seems to make its way into these conversations.</p>\n<p>However, the frequent built-in checkpoints don&#8217;t seem to have served accessibility needs well, as the accessibility team in convinced that having their input much earlier in the design process would have made a bigger difference further downstream.</p>\n<p>&#8220;We’ve been begging for React development assistance focused on accessibility since the beginning,&#8221; Accessibility specialist Joe Dolson said in a post addressing what he perceives to be <a href=\"https://www.joedolson.com/2018/10/some-gutenberg-accessibility-clarifications/\" rel=\"noopener noreferrer\" target=\"_blank\">common myths about Gutenberg&#8217;s accessibility</a>. &#8220;None of us were already primarily JavaScript-focused, let alone React-focused, and with limited time (spread across Gutenberg, the rest of WordPress, all of the WordPress sites themselves, and theme concerns), managing to keep up with the breakneck pace of development was never feasible.&#8221;</p>\n<p>WordPress core contributor John James Jacoby commented on Ventura&#8217;s post, calling attention to the complexity of the interface for all users, including those with and without accessibility needs.</p>\n<p>&#8220;My concern is that many of the above things do not really improve accessibility in the broader sense,&#8221; Jacoby said. &#8220;Instead, they make a complex user interface more complicated by littering the landscape with hidden keyboard shortcuts that are likely to be undiscoverable by regular-bodied folks, let alone folks who lack dexterity in their hands or fingers or eyes to find/understand/navigate/enjoy them.</p>\n<p>&#8220;These are users who demand a semantically simpler application to get their jobs done. Though they’re used to quickly navigating the useless mixed-up garbage-markup soup that comes from web development as a whole, it doesn’t help to add extra &#8216;accessibility-centric&#8217; approaches – we should be making the existing approaches accessible first, and adding new approaches after.&#8221;</p>\n<p>Dolson echoes that sentiment in his recent post. &#8220;Where Gutenberg falls down is on the overall use of the system,&#8221; he said. &#8220;Even though most individual interactions are handled effectively, the overall complexity of the system creates an enormous barrier to users if they are keyboard dependent or using a screen reader.&#8221;</p>\n<p>The community has advocated for a myriad of different needs and wishes during the course of Gutenberg&#8217;s development, but any interface created for the millions of people that WordPress aims to serve will inevitably have to deliver some compromises. Matt Mullenweg answered the feedback regarding complexity from his perspective as the project lead:</p>\n<p>&#8220;We think that the current interface could be a ton more streamlined, but we’ve compromised a lot of the alternative approaches we’ve wanted to take based on accessibility feedback and trying to have a single interface that serves all types of users,&#8221; Mullenweg said. &#8220;If we branched, it would be a different discussion and possibly serve multiple audiences better. There’s a lot of FUD though, ie, that’s going to be illegal in EU.&#8221;</p>\n<p>Ventura&#8217;s post is tightly focused on Gutenberg&#8217;s existing accessibility features and makes no mention of the audit that would have measured if it meets <a href=\"https://wptavern.com/wordpress-adopts-accessibility-coding-standards-for-all-new-and-updated-code\" rel=\"noopener noreferrer\" target=\"_blank\">WordPress&#8217; own stated accessibility standards</a>. These standards require that all new or updated code released in WordPress must conform with the WCAG 2.0 guidelines at level AA. Without an examination of how the product meets these standards, much of the the discussion revolves around subjective opinions about complexity. It&#8217;s difficult to quantify issues like cognitive overload.</p>\n<p>&#8220;It is entirely possible that Gutenberg will come within a hair of passing WCAG (Web Content Accessibility Guidelines) 2.0 at level AA at release, but still be inaccessible,&#8221; Dolson said. &#8220;This is because the micro-interactions are being managed well but the macro-interactions are not. This is a flaw with using WCAG 2.0 as a standard; it does not handle address large scale issues effectively. The cognitive load inherent in the current navigation requirements for assistive technology is overwhelming, and that is an accessibility issue – just not one effectively reflected in our current standards requirements.&#8221;</p>\n<p>One of the myths Dolson&#8217;s post dispelled is that the Gutenberg team doesn’t care about accessibility. Ventura&#8217;s post calls attention what he believes to be &#8220;a significant volume of accessibility-specific tools and functionalities&#8221; in Gutenberg that surpass those of the Classic Editor. The team has worked hard to address accessibility concerns but needs better communication across teams in order to continue serving the wider community of WordPress users with accessibility needs.</p>\n<p>&#8220;There have been a lot of issues on the way that could have been avoided if a React developer had been available to assist with significant dedicated time earlier than 6 weeks before the proposed release; but those were issues coming from ignorance, not a lack of compassion,&#8221; Dolson said.</p>\n<p>&#8220;I don’t know what Gutenberg will be at release. But the accessibility team and the Gutenberg team are working hard to try and reach the best solutions we can.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 19 Oct 2018 18:00:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"WPTavern: The New Woo Adopts Gutenberg Components, User Interface Driven by React\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84854\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://wptavern.com/the-new-woo-adopts-gutenberg-components-user-interface-driven-by-react\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2865:\"<p><a href=\"https://woosesh.com/\">WooSesh</a>, the free virtual conference devoted to WooCommerce kicked off earlier today. Todd Wilkins, Head of eCommerce at Automattic, Kelly Hoffman, Head of Design for eCommerce at Automattic, and Aviva Pinchas, Product Lead of the WooCommerce Marketplace at Automattic got things started with the keynote presentation.</p>\n<p>Wilkins highlighted what the team has accomplished since last year and outlined what users can expect in 2019. Pinchas shared a wealth of data from a survey that was sent to WooCommerce users and to end the presentation, Hoffman described how the team designed the new interfaces.</p>\n<p>One of the major changes <a href=\"https://woocommerce.wordpress.com/2018/10/18/wc-admin/\">coming to WooCommerce</a> is a redesigned backend. The project is being developed on GitHub as a feature plugin called <a href=\"https://github.com/woocommerce/wc-admin\">WC-Admin</a>.</p>\n<img />New WooCommerce Dashboard\n<p>The dashboard is a landing page where store owners will be able to see at a glance how their store is doing. The new interface is powered by the React JavaScript framework, specifically the React components that are part of the Gutenberg project. It&#8217;s modular, allowing users to add, move, and remove blocks. Developers will be able to extend the dashboard and provide custom blocks.</p>\n<p>In addition to the new interface, reports are being overhauled. Store owners will be able to filter data, compare date records, have easy access to important data points, and download reports in CSV format. The Activity Panel has been completely redesigned and will be accessible from any page in the WooCommerce backend.</p>\n<img />WooCommerce Activity Panel\n<p>The activity panel will also house a Notifications area that acts as an email Inbox. Developers will be able to add notifications from their extensions using the WooCommerce REST API endpoints.</p>\n<img />WooCommerce Notifications Panel\n<p>To see WC-Admin in action, you&#8217;ll need to download the <a href=\"https://github.com/woocommerce/wc-admin\">feature plugin</a> and run it in a test environment. The WooCommerce team does not recommend using it in a production environment.</p>\n<p>Once it reaches beta, the plugin will be made available on WordPress.org to allow a larger audience to test it before being merged into WooCommerce core. The plugin is scheduled to hit beta in early 2019 with new features being merged in the first quarter of 2019.</p>\n<p>Similar to Gutenberg development where progress updates were published to the Make Core Developer blog every week or every other week, the WooCommerce team plans to publish progress updates every two weeks on its <a href=\"https://woocommerce.wordpress.com/\">developer blog</a>. With these improvements, WooCommerce is another reason for developers to learn JavaScript deeply.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 19 Oct 2018 02:49:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"WPTavern: Learn How to Build an Interactive Prototype with Dave Martin’s Free JavaScript for Designers Course\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84685\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:119:\"https://wptavern.com/learn-how-to-build-an-interactive-prototype-with-dave-martins-free-javascript-for-designers-course\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2439:\"<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2018/10/Screen-Shot-2018-10-18-at-1.23.18-PM.png?ssl=1\"><img /></a></p>\n<p>Product designer <a href=\"http://davemart.in/\" rel=\"noopener noreferrer\" target=\"_blank\">Dave Martin</a> has published a free video course called <a href=\"http://jsfordesigners.davemart.in/\" rel=\"noopener noreferrer\" target=\"_blank\">JavaScript for Designers</a>. The course is made up of 46 bite-sized videos that walk students through the basics via a hands-on tutorial for building an interactive HTML prototype.</p>\n<p>Martin said he created the course specifically for designers who have been putting off learning how to code with JavaScript. He focused on concepts that are applicable to designers in their jobs, teaching skills that help them communicate to developers exactly how they want an app to behave.</p>\n<p>Coming from a designer&#8217;s perspective, Martin said most JavaScript tutorials are &#8220;dry and boring,&#8221; because they are written by developers. Ordinarily, these types of courses begin with JavaScript&#8217;s historical roots and progress from variables to arrays to objects, losing many learners along the way. Martin&#8217;s course is built more like a tutorial. Students will replicate some of the functionality found in a site like Dribbble. At the end, students should have a sufficient foundation of JavaScript that enables them to build an interactive HTML prototype.</p>\n<p>One of the other important ways this course is different is that the giant &#8220;Get Started&#8221; button on the page doesn&#8217;t take you to a registration form or make you sign up for dripped emails. It simply scrolls down the page so you can dive into the videos. Participants can download the code and follow along with the tutorial.</p>\n<p>Today&#8217;s announcement from WooSesh that WooCommerce is testing its new Javascript-driven interface is just another reminder that JavaScript is overtaking modern UI design and architecture. JavaScript knowledge is going to become increasingly in demand, and designers who have a decent grasp of it will land themselves higher paying positions. Even if you&#8217;re not a designer, Martin&#8217;s course may hold your interest better than traditional JavaScript beginners&#8217; courses. Check out the videos at <a href=\"http://jsfordesigners.davemart.in/\" rel=\"noopener noreferrer\" target=\"_blank\">jsfordesigners.davemart.in</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 18 Oct 2018 19:13:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"WPTavern: WPWeekly Episode 334 – Accessibility, Gutenberg, and Twenty Nineteen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=84845&preview=true&preview_id=84845\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://wptavern.com/wpweekly-episode-334-accessibility-gutenberg-and-twenty-nineteen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1849:\"<p>In this episode, <a href=\"http://jjj.me\">John James Jacoby</a> and I have a lengthy discussion about the numerous Accessibility concerns being raised by members of the community. We also talk about the WordPress 5.0 release date, tempers flaring in the WordPress core Slack channel, dealing with political situations within the WordPress project, and more. We share our thoughts on the Twenty Nineteen default theme and provide a quick update on the status of WooCommerce 3.5.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"https://wptavern.com/wordpress-accessibility-team-lead-resigns-cites-political-complications-related-to-gutenberg\">WordPress Accessibility Team Lead Resigns, Cites Political Complications Related to Gutenberg</a><br />\n<a href=\"https://wptavern.com/first-look-at-the-twenty-nineteen-default-theme\">First Look at The Twenty Nineteen Default Theme</a><br />\n<a href=\"https://woocommerce.wordpress.com/2018/10/16/important-update-woocommerce-3-5-will-now-be-released-october-23rd/\">Important update: WooCommerce 3.5 will now be released October 23rd.</a><br />\n<a href=\"https://w3techs.com/technologies/overview/content_management/all\">WordPress Now at 32%</a></p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, October 24th 3:00 P.M. Eastern</p>\n<p>Subscribe to <a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\">WordPress Weekly via Itunes</a></p>\n<p>Subscribe to <a href=\"https://www.wptavern.com/feed/podcast\">WordPress Weekly via RSS</a></p>\n<p>Subscribe to <a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\">WordPress Weekly via Stitcher Radio</a></p>\n<p>Subscribe to <a href=\"https://play.google.com/music/listen?u=0#/ps/Ir3keivkvwwh24xy7qiymurwpbe\">WordPress Weekly via Google Play</a></p>\n<p><strong>Listen To Episode #334:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 18 Oct 2018 14:40:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"WPTavern: Gutenberg Accessibility Audit Postponed Indefinitely\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84781\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://wptavern.com/gutenberg-accessibility-audit-postponed-indefinitely\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:10590:\"<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/red-pen.jpg?ssl=1\"><img /></a>photo credit: <a href=\"https://www.flickr.com/photos/pollas/526544001/\">pollas</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc-sa/2.0/\">cc</a>\n<p>Discussion surrounding Gutenberg&#8217;s independent accessibility audit is heating up. Two weeks ago, Matthew MacPherson, who was named WordPress 5.0&#8217;s new accessibility lead, <a href=\"https://github.com/WordPress/gutenberg/issues/10318\" rel=\"noopener noreferrer\" target=\"_blank\">proposed the audit</a> and agreed to it being performed by an independent third party. The audit had gained strong support among accessibility contributors and others following the ticket.</p>\n<p>After soliciting detailed proposals from four companies, MacPherson has since rescinded the offer to coordinate the audit at this time and it seems he was unaware that he didn&#8217;t have the authority to authorize it in the first place.</p>\n<p>&#8220;For at least the time being, Automattic has decided to forgo conducting an Accessibility audit on Gutenberg,&#8221; MacPherson said. He cited the following reasons:</p>\n<ol>\n<li>&#8220;an audit will not be actionable given our release timeline, because…</li>\n<li>the audit will not affect release timing, so&#8230;</li>\n<li>it would be more prudent to explore an audit on a less rushed timeline in the future&#8221;</li>\n</ol>\n<p>MacPherson apologized for &#8220;getting hopes up and then failing the community&#8221; on this particular issue. He is supportive of getting an audit but it is not a priority to complete before Gutenberg&#8217;s merge proposal.</p>\n<p>&#8220;I&#8217;m hopeful we&#8217;ll explore an audit going forward, but unfortunately it will not happen before the merge proposal and thus I&#8217;m closing this issue as a won&#8217;t fix,&#8221; MacPherson said. &#8220;I would still like to blog about the state of Gutenberg accessibility, both the good and the bad. We&#8217;re making some improvements to keyboard navigation, color contrast, focus behavior, and date/color-pickers just this week.&#8221;</p>\n<p>Those following the ticket were disappointed in the decision and several heated replies have been hidden and/or moderated. The issue has since been locked and unlocked several times since the announcement that Automattic has decided to forgo the audit.</p>\n<p>&#8220;Literally every person with disabilities who has tested Gutenberg, both recently and at the outset, has flagged blocking issues as to why it&#8217;s not accessible,&#8221; Accessibility team member Amanda Rush said. &#8220;And user testing is just as important to accessibility as is WCAG 2.0 level AA compliance.&#8221;</p>\n<p>Because MacPherson said the decision came from Automattic, dissidents on the other side of the issue are saying that the company is acting in its own interests, as the decision was delivered without much explanation beyond an audit not fitting into Gutenberg&#8217;s timeline.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Gutenberg appears to be a commercially-driven add-on primarily intended for a8c’s benefit and should probably be treated as such by the community wherever that isn’t already true. <a href=\"https://t.co/c3yFImB5XL\">pic.twitter.com/c3yFImB5XL</a></p>\n<p>&mdash; Another Day, Another Doug (@zamoose) <a href=\"https://twitter.com/zamoose/status/1052033672952598528?ref_src=twsrc%5Etfw\">October 16, 2018</a></p></blockquote>\n<p></p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">So disappointed in <a href=\"https://twitter.com/automattic?ref_src=twsrc%5Etfw\">@automattic</a>’s decision to forego an independent accessibility audit for Gutenberg. Shipping with known issues is the wrong way to go. Users with disabilities are more important than that! <a href=\"https://t.co/Z4diHmv4GX\">https://t.co/Z4diHmv4GX</a></p>\n<p>&mdash; Marcy Sutton (@marcysutton) <a href=\"https://twitter.com/marcysutton/status/1052307597192126464?ref_src=twsrc%5Etfw\">October 16, 2018</a></p></blockquote>\n<p></p>\n<p>&#8220;The idea of accessibility being punted to meet a release deadline is what people have been worried about for over a year, and those concerns have not been alleviated,&#8221; Morten Rand-Hendriksen said during a recent Accessibility team meeting on Slack before the audit was post-poned. &#8220;A clear message about what would happen should the audit come back with substantial issues and recommendations would greatly improve communication and take some of the tension out of the conversation in my opinion.&#8221;</p>\n<p>In response to one contributor asking how the audit might affect Gutenberg&#8217;s timeline, MacPherson <a href=\"https://github.com/WordPress/gutenberg/issues/10318#issuecomment-429154806\" rel=\"noopener noreferrer\" target=\"_blank\">said</a> he doesn&#8217;t have veto power over the release, nor does he have the data to make that assessment.</p>\n<p>&#8220;I&#8217;m still not convinced there are sufficient Accessibility issues that prevent a release,&#8221; MacPherson said. &#8220;If the second point changes, I&#8217;ll relay that info. I plan to be an advocate, but I don&#8217;t set the timelines and I also don&#8217;t have solid data around accessibility. That&#8217;s the point of the audit: so we can speak from a place of hard data.&#8221;</p>\n<p>An independent accessibility audit would have revealed whether the team&#8217;s current perceptions of Gutenberg&#8217;s lack of accessibility are accurate or inflated. It would also give the team&#8217;s new leadership the data he needs in order to make the most accurate recommendations regarding its readiness for the world. Kevin Hoffman advocated for pushing on with the audit regardless, in case WordPress 5.0 comes on a later timeline.</p>\n<p>&#8220;The January 22, 2019 date would allow more than three months between today and the release of 5.0 to complete an audit and take action,&#8221; Hoffman said. &#8220;The reasons above suggest that we cannot get an audit completed and significantly improve accessibility in three months time. If true, that is all the more reason to start the process now and respond to the audit by fixing as many issues as we can before 5.0 releases.</p>\n<p>&#8220;The idea that the timeline will become less rushed after 5.0 (when it&#8217;s in the hands of real-world users who need it most) makes no sense at all.&#8221;</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">As a blind <a href=\"https://twitter.com/hashtag/WordPress?src=hash&ref_src=twsrc%5Etfw\">#WordPress</a> user &amp; sometime dev I really appreciate your work &amp; it is a real tragedy that the leaders of WordPress &amp; this project didn\'t build in <a href=\"https://twitter.com/hashtag/a11y?src=hash&ref_src=twsrc%5Etfw\">#a11y</a> from the very beginning &#8211; Any good team knows it is much harder to fix in hindsight</p>\n<p>&mdash; Dale Reardon (@DaleReardon) <a href=\"https://twitter.com/DaleReardon/status/1049640723887185925?ref_src=twsrc%5Etfw\">October 9, 2018</a></p></blockquote>\n<p></p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Absolutely this. Like most prior <a href=\"https://twitter.com/hashtag/WordPress?src=hash&ref_src=twsrc%5Etfw\">#WordPress</a> admin functionality, <a href=\"https://twitter.com/hashtag/Gutenberg?src=hash&ref_src=twsrc%5Etfw\">#Gutenberg</a> has been designed and built with hardly any thought for <a href=\"https://twitter.com/hashtag/a11y?src=hash&ref_src=twsrc%5Etfw\">#a11y</a>. And the WP A11y Team have been left the job of trying to help retrofit it. This always ends badly &#8211; in burn out, and half-baked solutions. <a href=\"https://t.co/UKMR442gM5\">https://t.co/UKMR442gM5</a></p>\n<p>&mdash; CoolfieldsConsulting (@coolfields) <a href=\"https://twitter.com/coolfields/status/1049912989112000512?ref_src=twsrc%5Etfw\">October 10, 2018</a></p></blockquote>\n<p></p>\n<p>While Twitter&#8217;s court of public opinion cannot answer the question of whether or not Gutenberg is accessible, an independent audit would give contributors a good shot at resolving the most critical issues.</p>\n<p>&#8220;I really like the idea of a professional audit, though I don&#8217;t recall us ever doing one of these in WordPress, certainly not a condition for a release,&#8221; Gutenberg merge lead Gary Pendergast said. &#8220;I&#8217;d love to see something like it happen at some point. WordPress has always tried to get most of the way there on accessibility by sticking to common patterns and semantics, with the difference covered by key efforts of volunteers everyone on the Accessibility team doing testing and filing actionable bug reports. Gutenberg&#8217;s move to being an entirely JavaScript-based application has made it harder to apply those patterns, but we can work together to establish new patterns, a new baseline.&#8221;</p>\n<p>Although there is no precedent for it, in this instance where Automattic&#8217;s perception of the editor&#8217;s accessibility differs wildly from that of the community, an outside audit might mitigate some of the conflict surrounding the issue.</p>\n<p>Pendergast said that despite best intentions and prioritizing accessibility, there is a possibility the Gutenberg team may not be able to deliver an &#8220;acceptable UX for assistive technology users by the time 5.0 is released.&#8221;</p>\n<p>&#8220;I&#8217;m sorry,&#8221; Pendergast said. &#8220;Despite the best intentions of everyone on the Gutenberg team, we haven&#8217;t done enough. I can honestly say that accessibility has always been a priority, but it hasn&#8217;t been a high enough priority, and we&#8217;ve done a poor job of communicating where accessibility has been improved. I mentioned some of those improvements in my earlier comment, but those improvements are of no benefit if we haven&#8217;t hit the baseline accessible experience.&#8221;</p>\n<p>The challenge of building in accessibility at the design stage, instead of retrofitting it after the fact, is one that WordPress is still struggling to get right in the Gutenberg era. Accessibility experts with React skills are few and far between, so it&#8217;s not easy to get fixes for all the issues testers are finding.</p>\n<p>&#8220;In some meetings we’ve discussed how to make accessibility integrated in the design process (design in its broader sense) since the beginning,&#8221; Accessibility specialist Andrea Fercia said during the team&#8217;s most recent meeting on Slack. &#8220;This is certainly an area were our communication and knowledge sharing should improve.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 17 Oct 2018 22:16:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"WPTavern: First Look at The Twenty Nineteen Default Theme\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84808\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wptavern.com/first-look-at-the-twenty-nineteen-default-theme\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2272:\"<p><a href=\"https://www.allancole.com/\">Allan Cole</a>, a WordPress Theme Imagineer at Automattic has published the <a href=\"https://make.wordpress.org/core/2018/10/16/introducing-twenty-nineteen/\">first glimpses</a> of the Twenty Nineteen default theme slated to ship with WordPress 5.0. Cole is leading the theme while <a href=\"https://kjellr.com/\">Kjell Regstad</a> who does Product and Editorial Design at Automattic will be a design coach.</p>\n<div class=\"wp-block-image\">\n<img />Twenty Nineteen Blog Post Layout\n</div>\n<p>The theme takes a minimalist approach that&#8217;s a good fit for writers and can be adapted for simple business sites as well. Twenty Nineteen doesn&#8217;t have a sidebar but will have an area in the footer to display widgets.</p>\n<p>The theme will have full compatibility with Gutenberg when it&#8217;s released. It will also contain Front-end and Back-end editor styles. This will allow the presentation of content in the back-end to closely resemble how the finished product will look like. </p>\n<p>Twenty Nineteen is based on the <a href=\"https://github.com/Automattic/_s/\">Underscores</a> and <a href=\"https://github.com/WordPress/gutenberg-starter-theme\">Gutenberg starter themes</a>. SASS is used to keep styles in-sync between Gutenberg and the front-end experience which Cole notes is, &#8220;not usual for a default theme and open to debate.&#8221; </p>\n<p>With WordPress 5.0 scheduled for a November release, Twenty Nineteen is on a fast track development cycle. A release candidate is expected to be available at the end of this month. </p>\n<p>To keep tabs on development, you can monitor the <a href=\"https://github.com/WordPress/twentynineteen\">project&#8217;s GitHub page</a>. GitHub will be used to develop Twenty Nineteen until it&#8217;s ready to be merged into core. At that time, the GitHub page will be deprecated as development moves to WordPress Core Trac. </p>\n<p>Dev meetings that last a half-hour will take place every Tuesday at 12PM EDT in the <a href=\"https://make.wordpress.org/core/tag/core-themes/\">#core-themes</a> Slack channel. It&#8217;s worth noting that if Twenty Nineteen is not ready in time for the planned November 19th, release of WordPress 5.0, it will be removed and released at a later date.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 17 Oct 2018 02:45:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"WPTavern: ACF 5.8 Beta 1 Introduces Blocks Feature, Release Slated for November\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84754\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://wptavern.com/acf-5-8-beta-1-introduces-blocks-feature-release-slated-for-november\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2092:\"<a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2018/10/blocks.jpg?ssl=1\"><img /></a>photo credit: Adabo! <a href=\"http://www.flickr.com/photos/34731278@N05/36299849102\">3d printed tetris blocks</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-nc-sa/2.0/\">(license)</a>\n<p>Advanced Custom Fields is now actively testing its new block creation feature in <a href=\"https://www.advancedcustomfields.com/blog/acf-5-8-introducing-acf-blocks-for-gutenberg/\" rel=\"noopener noreferrer\" target=\"_blank\">ACF 5.8 beta 1</a>, released this week. ACF Blocks is a feature aimed at PHP developers who have not taken the deep dive into JavaScript yet. It essentially offers a shortcut to creating custom blocks using PHP and HTML instead of JavaScript.</p>\n<p>&#8220;We believe that ACF Blocks is one of the more important features ever added to our plugin,&#8221; ACF representative Eric Karkovack said. &#8220;It levels the playing field and allows more developers to take advantage of Gutenberg’s key feature.&#8221; The feature was designed to allow WordPress developers who use ACF to maintain their current workflow for extending the editor.</p>\n<p>ACF Blocks allows developers to register a custom block type from a functions.php file. From there they can create a field group and use any ACF fields in the block. Rendering the block is the same process that&#8217;s used for displaying custom fields, with the notable addition of wrapping the HTML + PHP in a function.</p>\n<p>The ACF team plans to include the new blocks feature in version 5.8, which is anticipated to arrive in November.</p>\n<p>Creating custom blocks in this way seems like a stopgap measure for developers who haven&#8217;t had the time to learn how to extend Gutenberg before WordPress 5.0 arrives. This feature may be a useful abstraction for those who need to maintain their current workflow with ACF but it postpones the inevitable for developers who want to be truly proficient at extending the new editor. JavaScript skills will be required to properly understand what is going on under the hood.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 16 Oct 2018 18:05:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"Matt: The Importance of Meeting In-Person\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=48528\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://ma.tt/2018/10/the-importance-of-meeting-in-person/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4207:\"<p>I recently returned from Orlando where Automattic hosted its annual Grand Meetup where nearly all of our 800 employees from around the world, spend a week together in the same place. (And yes, <a href=\"https://automattic.com/work-with-us/\">we&#8217;re hiring</a>.)</p>\n<p>Despite being a fully distributed company, I believe it&#8217;s still important to meet face-to-face — just not every day, in the same office. The Grand Meetup is our chance to get to know the people behind the Slack avatars and <a href=\"https://intenseminimalism.com/2015/distributed-companies-the-importance-of-meeting-face-to-face/\">build relationships</a> that can carry us through other 51 weeks of the year, when we’re working from more than 65 countries. It&#8217;s so much easier to hear the nuance in someone&#8217;s chat messages or <a href=\"https://p2theme.com/\">p2 posts</a> if you&#8217;ve <a href=\"https://www.instagram.com/p/BojFXGelvzn/\">hung out with them at Harry Potter World</a>, or learned about their family, pets, and hobbies during a flash talk. </p>\n<img src=\"https://lh4.googleusercontent.com/KjkOXxAo8T4JitC7jv38GmvxSEAIx4KSQRLty5yfgDmvBVEU-cVLBNxAeStjDjFjIZM6wn0kEYmtUkKheddr3BggN2WAQ9b4IJTb2Kyu6J80zFbpW1oOpDrG8j-JCsshDPHch8VV\" alt=\"\" />Photo by&nbsp;<a href=\"https://pauljacobson.me/\">Paul Jacobson</a>\n<p>The week can be mentally exhausting, given that you&#8217;re often meeting many people for the first time. But we urge people to take it at their own pace, and the results are well worth the effort. Our <a href=\"https://data.blog/2017/04/12/welcoming-new-colleagues-a-data-based-story/\">data team actually studied the impact of the Grand Meetup</a> on our work relationships &#8212; the connections established between coworkers using our “Meetamattician” tool <a href=\"https://qz.com/work/1289444/automattics-secret-to-successful-remote-work-is-having-everyone-meet-in-person/\">were demonstrably closer</a> after the meetup: </p>\n<img src=\"https://lh6.googleusercontent.com/x2WKDviUT-kk-M2WzbvBEmbJvSFs5oVQXcK2tze3t3ABJd291cUDxcBX31RlahdCYd4982ZUBQoEhUr5hrcxfpyBB-lbmBk2Vk7M_3eTh5vLbeo_kLD7ayLY0e1WJdgQXHucP2MF\" alt=\"\" />Before the Grand Meetup.\n<img src=\"https://lh6.googleusercontent.com/t7crZ1H36rX0wveq29-q6ue7zVDDcAcV76UZPXQCNJygxix45Lc3GoPyJrGKatP8Zd_J_En3NfIEC8fWnEKLM-QF8CzT-KCBE_vK_ta4Q1omQ-4ClI8xI5LjEMLVKBvS0H0dRfeM\" alt=\"\" />After the Grand Meetup.\n<p>This year we were proud to welcome some incredible keynote speakers: <em><a href=\"https://www.indiebound.org/book/9780307476074\">Wild</a></em> author <a href=\"http://www.cherylstrayed.com/\">Cheryl Strayed</a> talking about creativity and writing; <a href=\"https://ma.tt/2018/06/automattics-first-new-board-member-general-ann-dunwoody/\">Automattic board member Gen. Ann Dunwoody</a>, the first woman in U.S. Army history to achieve the four-star officer rank; <a href=\"https://lessdoing.com/\">Ari Meisel</a> on delegating and automating your life; and Dan Harris, author of <a href=\"https://www.10percenthappier.com/\"><em>10% Happier</em></a>, on the panic attack that led him to embrace meditation and mindfulness.</p>\n\n<div class=\"wp-block-embed__wrapper\">\n<a href=\"https://www.instagram.com/p/BoZatKgFmW7/\" title=\"View on Instagram\" target=\"_blank\"><img src=\"http://instagr.am/p/BoZatKgFmW7/media/?size=l\" alt=\"Instagram Photo\" /></a>\n</div>Photo by&nbsp;<a href=\"https://leif.me/\">Leif Singer</a>\n<img src=\"https://lh5.googleusercontent.com/mazbsxl25hryG27trCrw-zpjBTcfHfI2tOsZYMxOzEynrNuDlJTQosWqw24dTTCDEHDXoFoh2yDWt-vc77RlTZxF3rB_dCNec1nWs2b49oAehR4hPPwIagU4Cj8Wli9nOu-zE3R_\" alt=\"\" />Ann Dunwoody. Photo by&nbsp;<a href=\"https://luca.blog/\">Luca Sartoni</a>\n<img src=\"https://lh3.googleusercontent.com/zq0pB7AUQDxdfSt_HWwz1aJfeFCF4sf2gB9Dwq_KMocsKThcedHSujsFv-P69VdnJAP-_XjyrarzLhT-AYzUryJkrE7t2jFiACT5mEmizslJ8I29laplSzIKqB4jUefXxqdAHyRv\" alt=\"\" />Ari Meisel. Photo by&nbsp;<a href=\"https://luca.blog/\">Luca Sartoni</a>\n\n<div class=\"wp-block-embed__wrapper\">\n<a href=\"https://www.instagram.com/p/BojgfYzA7px/\" title=\"View on Instagram\" target=\"_blank\"><img src=\"http://instagr.am/p/BojgfYzA7px/media/?size=l\" alt=\"Instagram Photo\" /></a>\n</div>Photo by&nbsp;<a href=\"https://www.instagram.com/jsscga/\">jessicacg</a>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 16 Oct 2018 16:40:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"WPTavern: WordPress Privacy Contributors Begin Work on V2 Roadmap, Form Cross-Platform Working Group\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84759\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"https://wptavern.com/wordpress-privacy-contributors-begin-work-on-v2-roadmap-form-cross-platform-working-group\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6584:\"<a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2018/10/privacy.jpg?ssl=1\"><img /></a>photo credit: Infosec Images <a href=\"http://www.flickr.com/photos/136770128@N07/41737510115\">Privacy blue</a> &#8211; <a href=\"https://creativecommons.org/licenses/by/2.0/\">(license)</a>\n<p>Contributors to WordPress&#8217; core <a href=\"https://make.wordpress.org/core/components/privacy/\" rel=\"noopener noreferrer\" target=\"_blank\">Privacy component</a> are <a href=\"https://make.wordpress.org/core/2018/10/11/whats-new-in-core-privacy/\" rel=\"noopener noreferrer\" target=\"_blank\">collaborating on a V2 roadmap</a> to address broader privacy and data protection issues that fall outside of legal requirements. The group organized at the beginning of the year to work on GDPR-specific objectives but has since expanded its scope to tackle concerns that are not attached to any specific piece of legislation.</p>\n<p>The Privacy team meets weekly and has approximately a dozen contributors who show up regularly to work on tickets and issues. The working <a href=\"https://docs.google.com/document/d/1EaEHY7dDovDZDdp05VZKH-obGZdH6bdUxGZsQ03OMRc/edit\" rel=\"noopener noreferrer\" target=\"_blank\">V2 roadmap</a> identifies a list of common international privacy concerns, such as data minimization, data integrity, transparency and notice, and contributors will explore their impact on a few core focus areas:</p>\n<ul>\n<li>Core privacy features\n<ul>\n<li>Gravatar privacy controls</li>\n<li>Embed privacy controls</li>\n</ul>\n</li>\n<li>Plugin privacy\n<ul>\n<li>For administrators</li>\n<li>For developers</li>\n</ul>\n</li>\n<li>Consent and logging</li>\n<li>WP-CLI support</li>\n<li>Multisite support</li>\n</ul>\n<p>The team has agreed to use a <a href=\"https://github.com/webdevlaw/open-source-privacy-standards/blob/master/privacy-by-design.md\" rel=\"noopener noreferrer\" target=\"_blank\">Privacy by Design (PbD)</a> approach, which uses a proactive framework to anticipate privacy issues before they are a problem for the user.</p>\n<p>Privacy team contributors are also monitoring two specific pieces of legislation that may impact WordPress site owners in 2019 &#8211; the <a href=\"https://iapp.org/resources/topics/california-consumer-privacy-act/\" rel=\"noopener noreferrer\" target=\"_blank\">US California Consumer Privacy Act</a> (CCPA), and the <a href=\"https://ec.europa.eu/digital-single-market/en/proposal-eprivacy-regulation\" rel=\"noopener noreferrer\" target=\"_blank\">EU ePrivacy Directive overhaul</a>. They plan to examine specific requirements once that information is available and will assist site owners in reaching compliance.</p>\n<h3>New Privacy Working Group to Facilitate Collaboration across Open Source Communities</h3>\n<p>At Drupal Europe 2018 a group of WordPress and Drupal contributors met to discuss the possibility of welcoming teams from major open source projects to work together on shared concerns. WordPress Privacy team contributor Heather Burns attended the first test run of the working group in the Open Source Lounge at the conference.</p>\n<p>&#8220;For the working group we have the big three &#8211; Drupal, WordPress, and Joomla &#8211; and we also spoke with representatives from the smaller projects like Neos and Typo3,&#8221; Burns said. &#8220;We&#8217;re all dealing with similar issues but from different approaches.&#8221;</p>\n<p>Burns said one of the goals of the working group is to push the idea forward that privacy is a common, positive, proactive value which can be taught and shared across projects. Members will discussion questions like whether privacy fixes belong in core or modules, how privacy notices pull information from different plugins and modules, and what laws are coming up that would require open source CMSs to build in some functionality in advance.</p>\n<p>&#8220;It&#8217;s a way of pooling resources, code libraries, and briefings, as well as giving us a forum to share experiences,&#8221; Burns said. &#8220;For example, we&#8217;re going to arrange for Drupal&#8217;s privacy lead to give a live video demo of their GDPR tools to our core group, and we&#8217;re going to do the same for them.&#8221;</p>\n<p>The privacy working group is being set up through the Drupal community structure and members are in the process of coordinating some funding. More information on funding will be available in the next few weeks.</p>\n<h3>Privacy Contributors Seek to Change the Perception of Privacy to a Positive, Proactive Value</h3>\n<p>In addition to collaborating across the broader open source community, the privacy working group endeavors to educate their communities on the inherent value of privacy instead of simply focusing on the consequences of companies being forced to pay a fee if they don&#8217;t meet legal obligations.</p>\n<p>&#8220;We&#8217;re very keen to also shift the perception of what privacy is, and that it&#8217;s not just seen as being about negative legal obligations for GDPR, CCPA, etc.,&#8221; Burns said. &#8220;We want people to think of privacy like accessibility: just the right thing to do for user protection.&#8221;</p>\n<p>Burns speaks about privacy at WordPress and Drupal conferences and how projects can have differing cultural, historical, and legal approaches to privacy. Cultural barriers to the recognition of privacy as a core value is one of the privacy team&#8217;s biggest challenges in advocating contributions that respect and protect users&#8217; rights.</p>\n<p>&#8220;What I&#8217;m proudest of this year is helping people to understand each other better,&#8221; Burns said. &#8220;We all come to the table assuming we share the same cultural, historical, and legal views of what privacy means and what role it should play, when the truth is there are wildly different views held even within project teams.</p>\n<p>&#8220;To paraphrase that awful quote, we don&#8217;t know what we don&#8217;t know. What I do is help people to understand where we&#8217;re all coming from and what we don&#8217;t actually know. From there, I define what a healthy approach to privacy should involve outside reactive legal obligations, using a methodology derived from a number of international frameworks and treaties on privacy. It&#8217;s a matter of inspiring people to realize that as open source project contributors, we are people of enormous power and influence over privacy on the web. The actions we take within our projects, however small, can help to protect people from those who would use their data to hurt them. That&#8217;s the most important thing any developer can ever do.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 16 Oct 2018 00:30:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"WPTavern: Contributing to Gutenberg: A New Contributor’s Experience\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84718\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://wptavern.com/contributing-to-gutenberg-a-new-contributors-experience\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7967:\"<div class=\"wp-block-image\">\n<img />\n</div>\n<p>The following is a guest post by <a href=\"https://twitter.com/ChrisVanPatten\">Chris Van Patten</a> who shares his experience learning and contributing to Gutenberg. There&#8217;s been a lot of talk of Gutenberg&#8217;s higher barrier to entry for new contributors.  Van Patten is the founder of <a href=\"https://tomodomo.co\">Tomodomo</a>, a digital agency for magazine publishers. </p>\n<hr class=\"wp-block-separator\" />\n<p>Over the past few months, but especially over the last few weeks, there has been extensive conversation about the barriers to entry present in contributing to the upcoming Gutenberg editor for WordPress.</p>\n<p>Of course, everyone&#8217;s experiences are subjective and unique. I can&#8217;t pretend to understand what everyone has felt. But my experience has been different than what some folks have been articulating, and I wanted to share my own take.</p>\n<h1>The Early Days</h1>\n<p>I&#8217;ve used WordPress for close to half my life; almost 15 years now. I remember some of the earliest versions of WordPress: the classic theme, the advent of Kubrick, MP6, up through today.</p>\n<div class=\"wp-block-image\">\n<img />Early Days of the WordPress Backend\n</div>\n<p>Like many in the community, I&#8217;m entirely self-taught. I have no background in computer science, and have no formal instruction under my belt. I picked up code through trial-and-error, tweaking files and breaking my site as I wanted to make changes.</p>\n<p>Since those early days, WordPress was always my CMS of choice both for personal projects and for clients with my agency Tomodomo. But even though I had committed to the WordPress platform, my contributions back were limited.</p>\n<p>The rules, rituals, and etiquette around posting on Trac seemed arcane and illegible. To this day, I could not make an SVN patch if my life depended on it. And much of the core code, imbued with years of history and backwards compatibility, was hard for me to pick apart.</p>\n<p>So instead, I contributed in other ways: open sourcing simple custom plugins I was building, organizing WordCamps and meetups, and speaking at WordCamps around the globe. But it always bothered me that I couldn&#8217;t find a way to get those elusive &#8216;props&#8217;.</p>\n<p>(Okay, so I did actually get props on one release, but I am convinced it was a mistake; I had neither opened the ticket or provided a patch.)</p>\n<h1>Going… Going… Gutenberg</h1>\n<p>When I first learned about Gutenberg and started exploring, I was apprehensive. At first it seemed scary. My JavaScript abilities didn&#8217;t extend beyond jQuery. React was inscrutable and it seemed like I&#8217;d need a doctorate to understand some of the ideas behind it. I still don&#8217;t understand how Webpack works its magic. Does anyone, really?</p>\n<p>But the possibilities of the new block interface were too enticing to ignore, so I started diving in and figuring out how it worked. In those halcyon days (aka earlier this year), Gutenberg was still pretty rough around the edges, and there were a lot of opportunities for improvement. I started lurking on the GitHub repo, reading issues, examining the code, and generally trying to wrap my head around what the heck was going on.</p>\n<p>As I was playing around with Gutenberg for a client project, I started reporting issues: simple things, like user interface bugs. I started commenting on tickets, usually offering suggestions for a particular feature, trying to advocate from the perspective of independent developers.</p>\n<p>I even <a href=\"https://github.com/WordPress/gutenberg/pull/6855\">filed my first pull request</a>! It was simple. I updated the README to include the day and time of the weekly #core-editor meeting (Wednesdays at 1pm UTC, if you&#8217;re wondering). It was an inauspicious beginning, but I was excited to get it merged.</p>\n<p>Over time, my knowledge grew. It was like my early days in web development, learning a CSS property here, and an HTML element there. I learned what a component was and how you could reuse them in different situations. I learned about JSX, and ES6, and some of the other crazy acronyms you encounter in Gutenland.</p>\n<p>As I was building more with Gutenberg, I was also finding new ways to <em>build Gutenberg itself</em>. I was able to understand more of the discussions, and offer my thoughts and suggestions. I started opening pull requests, largely dealing with design issues but also solving small bugs and quirks. I made a point of attending the weekly meeting I had previously added to the README, chiming in when I felt I had more perspective to share.</p>\n<p>Today I have 25 new issues and 27 pull requests under my belt, in addition to dozens of comments on existing tickets. I&#8217;m a &#8216;member&#8217; of the Gutenberg team on GitHub, and try to find time every day to triage new bugs or review pull requests. It took me most of the year to get to that point and it certainly wasn&#8217;t always easy. I still have so much to learn.</p>\n<p>When I hear about how difficult it is to contribute to Gutenberg, I can&#8217;t reconcile that with my own experience. That&#8217;s not to say it&#8217;s a breeze: Gutenberg does things very differently than WordPress core, and there is undoubtedly a learning curve.</p>\n<h1>Advice for Contributing to Gutenberg</h1>\n<p>If you aren&#8217;t comfortable coding from day one, there are so many other ways to contribute. Read through issues and add your own ideas and suggestions. Try testing and replicating bug reports. Hunt through inline documentation for typos and grammar corrections. All of these are valuable, and always appreciated.</p>\n<p>As you absorb the Guten-way through osmosis, you&#8217;ll find that the code isn&#8217;t as hard as you think — it&#8217;s just different. The intelligent people who build Gutenberg have done a great job at hiding away the &#8216;computer-science&#8217; bits so the rest of us don&#8217;t have to worry about data binding and other complex ideas. I still cannot explain state management, data stores, or context APIs but I have managed to find small areas of the code to improve.</p>\n<p>This isn&#8217;t to deny anyone&#8217;s frustration or confusion with Gutenberg and its development. Documentation is still lacking in many places. Some of the APIs are unintuitive. The tooling isn&#8217;t the simplest to set up. These are real problems, and I don&#8217;t want to pretend they don&#8217;t exist; we can undoubtedly do more to make Gutenberg development easier.</p>\n<p>And of course I have privilege to check: I&#8217;m lucky to have the time to spend in the GitHub repo, experimenting with code, and participating in weekly meetings. I recognize that&#8217;s not a reality for many people.</p>\n<p>If you can&#8217;t find the time, the Classic Editor will continue to be an option, and there&#8217;s no shame in prolonging the upgrade. It may take time for the Gutenberg experience to be as intuitive as we would all like it to be, and waiting for that is totally reasonable.</p>\n<p>But if you open yourself to some new ideas about what WordPress can be, and can make the time, you may end up surprised at how easy it is to contribute. If you get stumped, pop into <a href=\"https://wordpress.slack.com/messages/core-editor/\">#core-editor</a> or the <a href=\"https://wordpress.org/support/\">forums</a>. Don&#8217;t be afraid to post a bug report or suggestion; we might consolidate it with another issue if it was previously reported, but the additional information is still valuable. Every experience matters.</p>\n<p>I&#8217;m incredibly excited about the future of WordPress with Gutenberg and to finally be a real WordPress contributor. We have a long way to go, but that means there are still many exciting ways to make a difference. The project will only get stronger with more independent community voices chiming in.</p>\n<p>I hope you&#8217;ll join us!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 13 Oct 2018 02:32:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"WPTavern: WordCamp for Publishers Seeks Host City for 2019\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84683\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wptavern.com/wordcamp-for-publishers-seeks-host-city-for-2019\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1634:\"<p>WordCamp For Publishers&#8217; distributed organizing team is looking for a new host city in 2019. The industry-focused camp gathers together professionals who use WordPress to manage publications. This year&#8217;s successful event hosted speakers who highlighted important topics, such as ethics in journalism, the open web, AMP, Gutenberg, and communication between tech and editorial teams.</p>\n<p>The inaugural edition of this camp was held in Denver (2017), followed by Chicago this year. A few people on social media have lobbied for cities like Los Angeles and Detroit, but the decision rests on the availability of local organizers to handle the logistics of the event. These duties include facilitating venue coordination, swag delivery, and other things that need to happen on the ground.</p>\n<p>Based on the <a href=\"https://2018-chicago.publishers.wordcamp.org/2018/09/26/help-us-host-wordcamp-for-publishers-2019/\" rel=\"noopener noreferrer\" target=\"_blank\">call for host city applications</a>, it seems that applicants do not need a large team behind them, since there&#8217;s already an existing organizing team. Applicants need only the availability to coordinate local preparations.</p>\n<p>Individuals or teams who are interested to host the event in 2019 can <a href=\"https://docs.google.com/forms/d/15HseaVsp1Dn_bZ48Y6mVN8qPcw2Kf_IigunOl6QZSPU/viewform?edit_requested=true\" rel=\"noopener noreferrer\" target=\"_blank\">submit an application</a>. Organizers said they have a preference for cities that are &#8220;underrepresented media markets&#8221; where attendees may not see as many of these types of events.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 12 Oct 2018 23:32:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"WPTavern: Learn How to Build JavaScript Plugins for WordPress with Riad Benguella’s Starter Kit/Tutorial\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84528\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"https://wptavern.com/learn-how-to-build-javascript-plugins-for-wordpress-with-riad-benguellas-starter-kit-tutorial\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2542:\"<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/10/tools.jpg?ssl=1\"><img /></a>photo credit: <a href=\"https://stocksnap.io/photo/F91K0WLE2D\">Krzysztof Puszczyński</a>\n<p>Riad Benguella, the technical lead for phase 2 of the Gutenberg project, has <a href=\"https://riad.blog/2018/10/07/lets-start-building-javascript-plugins-for-wordpress/\" rel=\"noopener noreferrer\" target=\"_blank\">published</a> an educational resource to help WordPress developers get started building JavaScript plugins. The <a href=\"https://github.com/youknowriad/wp-js-plugin-starter\" rel=\"noopener noreferrer\" target=\"_blank\">WordPress JavaScript Plugin Starter</a> is unique in that it is built as a tutorial, not just a boilerplate. The GitHub repo contains eight commits that have been structured to explain each step along the way. Benguella designed the repository to answer the following questions:</p>\n<ul>\n<li>How do I quickly setup a WordPress environment and how do I bake it into my plugin?</li>\n<li>How do I define a WordPress Plugin?</li>\n<li>How do I load a simple JavaScript script in WordPress?</li>\n<li>How do I bundle my JavaScript files?</li>\n<li>How do I use advanced JavaScript features like JSX?</li>\n<li>How do I build a production-ready version of my plugin?</li>\n<li>How does all this fit together?</li>\n</ul>\n<p>Benguella predicts a shift in the WordPress development community, as JavaScript skills become essential for extending core&#8217;s rapidly evolving JS-based UI. Plugin architecture is changing to accommodate that.</p>\n<p>&#8220;Plugin developers are required to use JavaScript more in order to extend the editor,&#8221; Benguella said. &#8220;Most blocks need to be developed using this technology. The modules Gutenberg provides (Components, data module, i18n, apiFetch…) will also encourage developers to extend other parts of WP-Admin in JavaScript. Instead of writing HTML/CSS screens from scratch and rendering them from the server, developers are able to bootstrap and prototype fully accessible new screens in WP-Admin by composing these components in a small number lines of code.&#8221;</p>\n<p>Benguella&#8217;s <a href=\"https://github.com/youknowriad/wp-js-plugin-starter\" rel=\"noopener noreferrer\" target=\"_blank\">WordPress JavaScript Plugin Starter</a> resource demystifies the plugin creation process with detailed explanations of each step throughout the readme file. It&#8217;s a valuable resource for PHP developers who are just getting started transitioning into building JavaScript plugins.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 12 Oct 2018 20:21:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"WPTavern: WordCamp Nordic 2019 to be Held in Helsinki, March 7-8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84526\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://wptavern.com/wordcamp-nordic-2019-to-be-held-in-helsinki-march-7-8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6872:\"<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2018/10/wordcamp-nordic.png?ssl=1\"><img /></a></p>\n<p>After many years of planning, WordPress&#8217; Nordic communities are finally getting a regional WordCamp. The first <a href=\"https://2019.nordic.wordcamp.org/\" rel=\"noopener noreferrer\" target=\"_blank\">WordCamp Nordic 2019</a> is set to be held in Helsinki, Finland the weekend of March 7-8 at the <a href=\"https://www.paasitorni.fi/en/\" rel=\"noopener noreferrer\" target=\"_blank\">Paasitorni Congress Center</a>.</p>\n<p>&#8220;Some folks from the Norwegian community came up with idea in 2016,&#8221; lead organizer Marco Martins said. &#8220;Then in a WordCamp Stockholm we got people together and we discussed the idea. But it was earlier this year in WordCamp Jyväskylä (Finland) that we decided to commit to it and organize it. After that I went to Oslo to discuss personally with people from the Nordic countries and we came to an agreement. We gathered a team from the different countries and here we are.&#8221;</p>\n<p>The international organizing team is planning for approximately 600 attendees but the venue has the capacity for 800 people, if ticket demand is higher than expected. Paasitorni is an 111-year old complex brimming with historic significance. The Art Nouveau style building is also known as the Helsinki Workers&#8217; House, previously serving as leisure premises for the working class. It also provided the headquarters for the Red army during the 1918 Finnish Civil War. In the 1990&#8217;s it was remodeled to be a conference center and now includes a hotel and restaurants on premises.</p>\n<p>Finland has a stable and active WordPress community, which Martins said was one of the factors in the decision to host the first WordCamp Nordic in Helsinki. Regular meetups are held across the country in Turku, Tampere, Jyväskylä, Oulu, and Seinäjoki. The local <a href=\"https://www.meetup.com/WPHelsinki/\" rel=\"noopener noreferrer\" target=\"_blank\">WordPress Helsinki Meetup</a> group has more than 900 members with average attendance of 20-60 attendees each month.</p>\n<p>Helsinki has hosted two previous WordCamps, both averaging more than 220 attendees. Three other WordCamps were held in Turku, Tampere, and Jyväskylä, along with an unofficial <a href=\"https://wp-metsa.fi/\" rel=\"noopener noreferrer\" target=\"_blank\">WP Metsä</a> (&#8220;WP Forest&#8221;) in 2017, featuring cabins, lakes, outdoor tubs, sauna, and lightning talks by the fire. According to local organizers, Finnish camps have always sold out sponsor packages and tickets relatively fast.</p>\n<p>WordCamp Nordic will host a Contributor Day on March 7, followed by the main event on March 8. Organizers expect attendees from Sweden, Norway, Iceland, Denmark, and other countries, with likely the most attendees from Finland. All the sessions will be conducted in English.</p>\n<p>&#8220;While Nordic countries have very close ties both culturally and historically, one of the challenges we often face when thinking of attending a local WordCamp in the region is language,&#8221; co-organizer Niko Pettersen said. &#8220;Even though most Finns learn Swedish in school, the language often stays at a basic level and doesn’t extend to technical things such as WordPress. By having all of our talks in English, we’re hoping to level the playing field and hopefully attract more people from all around the world to come and listen to what these communities have to share.&#8221;</p>\n<p>Organizers are still in the process of discussing what topics they would like to see, but Pettersen said many Nordic countries tend to focus heavily on education, the environment, and healthcare. &#8220;Also with the EU Accessibility Directive coming to full effect in the coming years, I have a feeling a11y will be one of the major topics we will want to cover,&#8221; Pettersen said.</p>\n<p>WordCamp Nordic will also be hosting an informal Activity Day on March 9th where attendees will be welcome to join various activities, such as karaoke, cycling tours, trips to islands, and other other events coordinated by the community and sponsors.</p>\n<p>&#8220;It is something that Oslo has been doing informally the day after the camp and the feedback has been great so we thought it would be a good idea to have the activity day for people to do something together and experience something Finnish in more informal way,&#8221; Martins said. &#8220;We are planning the activities, but sauna for sure, because Finland.&#8221;</p>\n<p>One unique aspect of Finnish culture is the national obsession with saunas, and WordCamp Nordic organizers are ready to introduce attendees to Finland&#8217;s favorite pastime.</p>\n<p>&#8220;Traditionally saunas have been a place to cleanse the body and mind, but more recently travelers have discovered it is also a great place to meet locals, share experiences and get tips on where to go next,&#8221; Pettersen said. &#8220;If you’ve never been to one, I warmly suggest you extend your stay over the weekend as we’re planning on taking groups to some of the new public saunas in Helsinki during the Activity Day the day after the event.&#8221;</p>\n<h3>WordCamp Nordic Organizers Aim to Revitalize Local Communities by Fostering New Meetup Groups</h3>\n<p>Finland is the birth place of many open source projects, including SSH, MySQL, Linux, and IRC. WordCamp Nordic organizers hope to inspire that same spirit of collaboration among neighboring WordPress communities by hosting the regional camp.</p>\n<p>&#8220;One of the goals we listed in our initial proposal was to focus on revitalizing the local communities in the region and help to form new meetup groups by getting the organizers and interested parties together during Contributor Day,&#8221; Pettersen said. &#8220;We saw our meetup scene grow in Finland from one to six in the space of a few years largely thanks events like these and good mentoring from the community at large.&#8221;</p>\n<p>Organizers plan to keep the camp running in future years but have not yet settled on the selection process for future host cities.</p>\n<p>&#8220;As long as WordCamp Europe is organized during the summer, I have a feeling future events will be leaning towards spring/autumn or winter,&#8221; Pettersen said. &#8220;The selection process is still up for debate, but I imagine whoever feels like this is their calling will have the full support of the Nordic community to carry on where we left off.&#8221;</p>\n<p>WordCamp Nordic joins a small list of regional WordCamps that have become can&#8217;t-miss, enriching events for many in the WordPress community. Tickets will go on sale at the end of October. Follow <a href=\"https://twitter.com/WordCampNordic\" rel=\"noopener noreferrer\" target=\"_blank\">@WordCampNordic</a> on Twitter or subscribe to the newsletter to get notified.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 12 Oct 2018 04:43:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"WPTavern: Tiny Raises $4M in Series A Funding, Publishes Gutenberg FAQ\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84692\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://wptavern.com/tiny-raises-4m-in-series-a-funding-publishes-gutenberg-faq\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4061:\"<p><!-- wp:paragraph --></p>\n<p>Tiny, the company <a href=\"https://wptavern.com/ephox-creators-of-tinymce-rebrand-to-tiny-technologies-inc\">formerly known</a> as Ephox <a href=\"https://go.tiny.cloud/blog/big-milestones-for-tiny-today/\">has raised</a> $4M in Series A funding from <a href=\"https://www.brv.com/\">BlueRun Ventures</a>. Tiny is the company behind TinyMCE, a popular text editor used in many opensource projects, including WordPress. </p>\n<p><!-- /wp:paragraph --></p>\n<p><!-- wp:paragraph --></p>\n<p>In addition to the funding, Jeff Tannenbaum, partner at BlueRun Ventures <a href=\"https://medium.com/brv-signals/how-to-find-and-invest-in-sleeping-giants-a2a3f2e7b3d3\">is joining</a> Tiny&#8217;s board of directors. The company has also launched <a href=\"https://www.tiny.cloud/developer-preview/\">Tiny Drive</a>, a preview of <a href=\"https://www.tiny.cloud/developer-preview/\">TinyMCE 5</a>, and the <a href=\"https://go.tiny.cloud/partners/\">Tiny App Directory</a>. </p>\n<p><!-- /wp:paragraph --></p>\n<p><!-- wp:heading --></p>\n<h2>TinyMCE&#8217;s Relationship With Gutenberg</h2>\n<p><!-- /wp:heading --></p>\n<p><!-- wp:paragraph --></p>\n<p>Gutenberg is built on top of TinyMCE and this has led to few misconceptions about the project. To alleviate these misconceptions, Tiny published a <a href=\"https://go.tiny.cloud/blog/gutenberg-tinymce-faq/\">Gutenberg and TinyMCE FAQ</a> earlier this year.</p>\n<p><!-- /wp:paragraph --></p>\n<p><!-- wp:paragraph --></p>\n<p>TinyMCE is used by the Classic Editor but as the FAQ explains, they are not one in the same and never have been. </p>\n<p><!-- /wp:paragraph --></p>\n<p><!-- wp:quote --></p>\n<blockquote class=\"wp-block-quote\">\n<p>The Classic Editor is <em>less</em> than TinyMCE in that it exposes just 6 of the 54 of the <a href=\"https://www.tiny.cloud/docs/plugins/\">official plugins</a> and a fraction of the UI. A popular WordPress plugin called <a href=\"https://wordpress.org/plugins/tinymce-advanced/\">TinyMCE Advanced</a> created by Andrew Ozz exposes more of TinyMCE’s UI, core features, and plugins.</p>\n<p>The Classic Editor is also <em>more</em> than TinyMCE in that there is significant custom code in WordPress. This includes WordPress-specific UI components and backend code for embedding, links, media, and more. Some of the filtering code is specific to WordPress.</p>\n<p><cite>Andrew Roberts</cite></p></blockquote>\n<p><!-- /wp:quote --></p>\n<p><!-- wp:paragraph --></p>\n<p>Gutenberg uses TinyMCE to provide rich text editing and provides a Classic editor block that contains some UI elements from TinyMCE, but that&#8217;s about it. </p>\n<p><!-- /wp:paragraph --></p>\n<p><!-- wp:paragraph --></p>\n<p>Both projects have a close relationship but as Roberts <a href=\"https://techcrunch.com/2018/10/02/rich-text-editing-platform-tiny-raises-4m-launches-file-management-service/\">noted on TechCrunch</a>, the two are not mutually dependent on each other.</p>\n<p><!-- /wp:paragraph --></p>\n<p><!-- wp:paragraph --></p>\n<p>&#8220;Tiny’s core business comes from a mix of software vendors, large enterprises, and agencies building custom solutions for clients that has little to do with the WordPress ecosystem,” Roberts told TechCrunch. “It is a popular and commercially viable project in its own right.</p>\n<p><!-- /wp:paragraph --></p>\n<p><!-- wp:paragraph --></p>\n<p>While TinyMCE 5 features a brand new UI, earlier versions such as 4.7 were inspired by beta versions of Gutenberg. Tiny is not yet committed to making block based editing the default but is keeping a close eye on how Gutenberg rolls out. </p>\n<p><!-- /wp:paragraph --></p>\n<p><!-- wp:paragraph --></p>\n<p>TinyMCE and WordPress are open source projects that will continue to benefit each other as it makes sense. </p>\n<p><!-- /wp:paragraph --></p>\n<p><!-- wp:paragraph --></p>\n<p>&#8220;The TinyMCE and WordPress projects have had a symbiotic relationship over the years. We hope that this goodwill and sense of community continues for many years to come,&#8221; Roberts said.</p>\n<p><!-- /wp:paragraph --></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 12 Oct 2018 03:57:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"WPTavern: WPWeekly Episode 333 – Interview With Mike ‘Shredder’ Schroder\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=84675&preview=true&preview_id=84675\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://wptavern.com/wpweekly-episode-333-interview-with-mike-shredder-schroder\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1895:\"<p>In this episode, <a href=\"http://jjj.me\">John James Jacoby</a> and I are joined by <a href=\"https://twitter.com/GetSource\">Mike Schroder</a>. Schroder co-led the release of WordPress 3.9 and in 2016, he led the release of WordPress 4.5.</p>\n<p>In the interview, we learn his WordPress origin story, his thoughts on Gutenberg and whether or not he sees it as the future of WordPress, the WordPress media component, and near the end of the show, he explains how he received the nickname Shredder.</p>\n<h2>Useful Links Mentioned:</h2>\n<p><a href=\"https://make.wordpress.org/meetings/\">A Detailed List of Meetings of the Various WordPress Core Teams</a><br />\n<a href=\"https://make.wordpress.org/core/tag/new-contributors/\">New Contributors Bi-Monthly Meeting</a><br />\n<a href=\"https://make.wordpress.org/core/handbook/\">WordPress Core Contributor Handbook</a><br />\n<a href=\"https://wordpress.tv/2017/12/12/mike-schroder-tammie-lister-media-matters/\">Mike Schroder and Tammie Lister&#8217;s Presentation from WCUS 2017 &#8211; Media Matters</a><br />\n<a href=\"https://wptavern.com/godaddy-hires-mike-schroder-to-contribute-to-wordpress-core-full-time\">GoDaddy Hires Mike Schroder to Contribute to WordPress Core Full-Time</a></p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, October 17th 3:00 P.M. Eastern</p>\n<p>Subscribe to <a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\">WordPress Weekly via Itunes</a></p>\n<p>Subscribe to <a href=\"https://www.wptavern.com/feed/podcast\">WordPress Weekly via RSS</a></p>\n<p>Subscribe to <a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\">WordPress Weekly via Stitcher Radio</a></p>\n<p>Subscribe to <a href=\"https://play.google.com/music/listen?u=0#/ps/Ir3keivkvwwh24xy7qiymurwpbe\">WordPress Weekly via Google Play</a></p>\n<p><strong>Listen To Episode #333:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 11 Oct 2018 09:07:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"WPTavern: Gutenberg 4.0 RC 1 Released, Testing Ramps Up Amid Critical Accessibility Concerns\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84635\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"https://wptavern.com/gutenberg-4-0-rc-1-released-testing-ramps-up-amid-critical-accessibility-concerns\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6432:\"<p>A <a href=\"https://make.wordpress.org/test/2018/10/10/call-for-testing-gutenberg-4-0-pre-release/\" rel=\"noopener noreferrer\" target=\"_blank\">pre-release of Gutenberg 4.0 RC 1</a> is now available for testing. During today&#8217;s core developer chat, Matias Ventura, the project&#8217;s technical lead, said he plans to post a full changelog and a video tomorrow. In the meantime, a call for testing 4.0 RC 1 has been posted to the make.wordpress.org/test blog with a list of 15 specific testing items highlighted for attention.</p>\n<p>Gutenberg 4.0 introduces several new features, (including but not limited to) the following:</p>\n<ul>\n<li>Add ability to change overlay color in Cover Image</li>\n<li>New Font Size Picker with clear labels and size comparison</li>\n<li>New RichText data structure to allow better manipulation of inline content</li>\n<li>Add Pullquote style variation and color palette support</li>\n<li>Add support for post locking when multiple authors interact with the editor</li>\n<li>Add support for shortcode embeds that enqueue scripts.</li>\n</ul>\n<p>A running list of the enhancements, bug fixes, and other changes is available on GitHub in the <a href=\"https://github.com/WordPress/gutenberg/pull/10472\" rel=\"noopener noreferrer\" target=\"_blank\">changelog</a>. <a href=\"https://wordpress.org/gutenberg/handbook/reference/deprecated/#4-0-0\" rel=\"noopener noreferrer\" target=\"_blank\">Deprecations for 4.0.0</a> are outlined in the Gutenberg handbook.</p>\n<p>Grzegorz Ziółkowski has published Gutenberg&#8217;s npm packages this evening, so the team can move forward on core integration with Gutenberg.</p>\n<p>Accessibility has been one of the recent concerns with the project, as there are many outstanding <a href=\"https://github.com/WordPress/gutenberg/issues?q=is%3Aopen+is%3Aissue+label%3AAccessibility\" rel=\"noopener noreferrer\" target=\"_blank\">tickets</a> with this tag. One of the most prolific contributors to testing, Andrea Fercia, has stated that the editor in its current state is &#8220;barely usable&#8221; for those with accessibility needs. Joe Dolson, another WordPress accessibility contributor, wrote a <a href=\"https://www.joedolson.com/2018/10/wordpress-accessibility-and-gutenberg/\" rel=\"noopener noreferrer\" target=\"_blank\">reaction post</a> that concurs with Fercia&#8217;s assessment.</p>\n<p>&#8220;The leadership within the Gutenberg project has not taken seriously the scope of accessibility problems in Gutenberg,&#8221; Dolson said. &#8220;I do not want to diminish the dedication to accessibility issues at some levels. The dedication to producing accessible content is still very high. But I’m not seeing dedication to developing an accessible authoring tool. It’s as if there’s no awareness of the needs of authors with disabilities; only consumers.&#8221;</p>\n<p>If WordPress 5.0 is released on schedule, Dolson said he believes it is &#8220;almost a guarantee that the first release of Gutenberg in WordPress will not be accessible,&#8221; as there are too many major accessibility issues left to resolve.</p>\n<p>Matthew MacPherson, the new accessibility lead for WordPress 5.0, <a href=\"https://github.com/WordPress/gutenberg/issues/10318#issue-366539284\" rel=\"noopener noreferrer\" target=\"_blank\">said</a> he is willing to bet that Gutenberg is more accessible than the Classic Editor and that the perception of its inaccessibility is based on older evaluations of earlier releases:</p>\n<blockquote><p>I think there&#8217;s a notion of Gutenberg being inaccessible because of older accessibility audits that identified a lot of issues in the very early versions. Things have changed a lot since the early days, and when the plugin was labeled &#8220;1.0&#8221; it was hardly a ready-to-ship product. I worry that many of those sentiments haven&#8217;t been re-examined and updated, so there is a prevailing idea that Gutenberg is not accessible or is entirely less accessible than the Classic Editor.</p>\n<p>What I&#8217;d venture is that Gutenberg is selectively less accessible, but overall more accessible feature-for-feature. Something like a date picker or a certain interaction being inaccessible does not make the entire editor inaccessible. Feature-for-feature, compared to a classic editor with similar capabilities (eg a bunch of plugins installed), I&#8217;d bet* Gutenberg is more accessible.</p></blockquote>\n<p>Despite his suggestion that Gutenberg&#8217;s current accessibility issues are likely not as critical as contributors have claimed, MacPherson is willing to coordinate an <a href=\"https://github.com/WordPress/gutenberg/issues/10318\" rel=\"noopener noreferrer\" target=\"_blank\">independent accessibility audit</a> to get an outside opinion. Selection of the company to perform the audit is currently in process.</p>\n<p>After the recent <a href=\"https://wptavern.com/wordpress-accessibility-team-lead-resigns-cites-political-complications-related-to-gutenberg\" rel=\"noopener noreferrer\" target=\"_blank\">resignation of team rep Rian Rietveld</a>, accessibility contributors are <a href=\"https://make.wordpress.org/accessibility/2018/10/09/suggested-agenda-for-meeting-on-october-15th/#comment-72719\" rel=\"noopener noreferrer\" target=\"_blank\">meeting next Monday</a> to get reorganized and discuss the leadership and decision processes of the team.</p>\n<p>Many have speculated outside of official channels on whether the recent shakeup in the leadership of the accessibility team is a referendum on the aggressive timeline for Gutenberg&#8217;s inclusion in core or simply the natural turnover in open source projects when friction cannot be resolved. A truly independent accessibility audit, with results that are shared transparently to the WordPress community, will reveal whether current perceptions of Gutenberg&#8217;s lack of accessibility are accurate.</p>\n<p>In the meantime, a new &#8220;<a href=\"https://github.com/WordPress/gutenberg/labels/Needs%20Accessibility%20Feedback\" rel=\"noopener noreferrer\" target=\"_blank\">Needs Accessibility Feedback</a>&#8221; label is available for use on the Gutenberg GitHub repository to facilitate communication between developers and accessibility contributors. There is also a label for <a href=\"https://github.com/WordPress/gutenberg/issues?q=is%3Aopen+is%3Aissue+label%3ARegression\" rel=\"noopener noreferrer\" target=\"_blank\">regressions</a> where changes broke accessibility along the way.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 11 Oct 2018 04:31:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"WPTavern: Jetpack 6.6 Improves Site Verification Tools, Asset CDN Module Now in Beta, Gutenberg Blocks Coming Soon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84562\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:123:\"https://wptavern.com/jetpack-6-6-improves-site-verification-tools-asset-cdn-module-now-in-beta-gutenberg-blocks-coming-soon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2105:\"<p><a href=\"https://jetpack.com/2018/10/09/jetpack-6-6-better-site-verification-tools/\" rel=\"noopener noreferrer\" target=\"_blank\">Jetpack 6.6</a> was released today with an update to the Site Verification tools that enables one-click verification and sitemap.xml registration with Google.</p>\n<p>This release also introduces the beta of Jetpack&#8217;s <a href=\"https://jetpack.com/support/asset-cdn/\" rel=\"noopener noreferrer\" target=\"_blank\">Asset CDN</a>. The new module, built on the same infrastructure as the Photon CDN, speeds up sites by cloud-hosting widely-used Jetpack and core WordPress scripts, styles, and assets. It takes a load off of users&#8217; servers and increases the allowed maximum concurrent connections through Photon. Once it is ready for use in production, the Asset CDN will be a new opt-in feature that can help speed up Jetpack&#8217;s 5+ million active installations.</p>\n<p>Version 6.6 also adds the necessary infrastructure for new Gutenberg blocks. The activity on the plugin&#8217;s GitHub repository indicates the team is <a href=\"https://github.com/Automattic/jetpack/projects/14\" rel=\"noopener noreferrer\" target=\"_blank\">working on a number of blocks for existing features</a>, including things like recipes, shortcodes, Jetpack subscription form, Simple Payments, Publicize, the contact form, tweet shortcode, VR shortcode, Giphy, and more. Everything touching the editor is in the process of being ported to blocks. Many of the blocks are already complete and some are still in progress. Some features, such as support for tiled gallery layouts, have bugs that need to be sorted before Jetpack will be ready for WordPress 5.0.</p>\n<p>Jetpack 6.6.1 will be going out soon to address a bug with social icons that this release introduced. In the meantime, users can paste the CSS in this <a href=\"https://raw.githubusercontent.com/Automattic/jetpack/3bf312d33b2aa4e1e693642e296fc3995ee74e95/modules/widgets/social-icons/social-icons.css\" rel=\"noopener noreferrer\" target=\"_blank\">gist</a> into  Appearance > Customize > Additional CSS to provide a temporary fix.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 09 Oct 2018 22:19:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"WPTavern: WordPress Accessibility Team Lead Resigns, Cites Political Complications Related to Gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84564\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"https://wptavern.com/wordpress-accessibility-team-lead-resigns-cites-political-complications-related-to-gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4543:\"<p>WordPress Accessibility Team lead <a href=\"https://rianrietveld.com/2018/10/09/i-have-resigned-the-wordpress-accessibility-team/\" rel=\"noopener noreferrer\" target=\"_blank\">Rian Rietveld has resigned</a> due to what she describes as political complications and problems with working on Gutenberg accessibility.</p>\n<p>&#8220;The last year, especially the last few weeks have been too politically complicated for me,&#8221; Rietveld said. &#8220;It’s better that someone else takes the lead now.&#8221;</p>\n<p>Her post outlines challenges the accessibility team has encountered in working with Gutenberg without having a skilled React developer on their team. Their contributions have primarily been limited to testing and reporting issues. Rietveld said team members experienced frustration when they tested and improved functionality but saw it changed at a later stage, breaking accessibility requirements again. She also cites a lack of commitment to keyboard testing new features before implementation.</p>\n<p>Rietveld said she used her network to try to get more companies and developers with React skills involved in Gutenberg accessibility contribution. In March, tests they ran on the plugin revealed a staggering number of <a href=\"https://github.com/WordPress/gutenberg/issues?q=is%3Aopen+is%3Aissue+label%3AAccessibility\" rel=\"noopener noreferrer\" target=\"_blank\">Gutenberg accessibility issues</a> that remain unresolved.</p>\n<p>&#8220;The results indicated so many accessibility issues that most testers refused to look at Gutenberg again,&#8221; Rietveld said. She included a statement from fellow contributor <a href=\"https://twitter.com/afercia\" rel=\"noopener noreferrer\" target=\"_blank\">Andrea Fercia</a>, who has been highly active in testing Gutenberg functionality and reporting issues:</p>\n<blockquote><p>While the Gutenberg team has worked hard to implement some fundamental accessibility features (e.g. focus management, navigate landmark regions), the overall user experience is terribly complicated for users with accessibility needs at the point the new editor is barely usable for them. </p>\n<p>The main reason for this lack of overall accessibility is in the overall Gutenberg design, where accessibility hasn’t been incorporated in the design process. </p>\n<p>Feedback from accessibility users has been constantly evaluated and Gutenberg is actually a regression in terms of accessibility level, compared to the previous editor.</p></blockquote>\n<p>The Gutenberg project now has a dedicated developer from Automattic, <a href=\"http://codinginairports.com\" rel=\"noopener noreferrer\" target=\"_blank\">Matthew MacPherson</a>, who is working on accessibility issues and Rietveld said she hopes the core accessibility team will continue to offer him all the support he needs.</p>\n<p>Rietveld&#8217;s resignation is a major loss to the WordPress project. For years her leadership and contributions have demonstrated the project&#8217;s commitment to serving those with a disability.</p>\n<p>In 2016, she was instrumental in <a href=\"https://wptavern.com/wordpress-adopts-accessibility-coding-standards-for-all-new-and-updated-code\" rel=\"noopener noreferrer\" target=\"_blank\">WordPress adopting accessibility coding standards for all new and updated code</a>. Rietveld was <a href=\"https://wptavern.com/wordpress-contributor-rian-rietveld-wins-heroes-of-accessibility-award\" rel=\"noopener noreferrer\" target=\"_blank\">recognized by Knowbility.org</a> as &#8220;a knowledgeable, dedicated, and effective advocate for accessibility in the global WordPress community,&#8221; whose achievements had a major impact on the application used by more than 25% of the world at that time. She took first place in the Individual Achievement category of the Heroes of Accessibility Awards.</p>\n<p>News of Rietveld&#8217;s resignation <a href=\"https://twitter.com/RianRietveld/status/1049615192626253825\" rel=\"noopener noreferrer\" target=\"_blank\">roused an outpouring of sadness and gratitude on Twitter</a>. The WordPress community thanked her for her work and that of other accessibility contributors, whose efforts often go unappreciated.</p>\n<p>&#8220;I’m not leaving WordPress nor accessibility, and in fact maybe now I can actually work on accessibility again,&#8221; Rietveld said. &#8220;I will keep giving talks and workshops. I also want to do research and work on tickets. But in my own pace.</p>\n<p>&#8220;I will join the a11y table if asked on contributor days, but maybe I’ll just go to a museum instead.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 09 Oct 2018 16:27:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"WPTavern: Alexis Lloyd and Riad Benguella Will Lead Phase Two of Gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84550\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://wptavern.com/alexis-lloyd-and-riad-benguella-will-lead-phase-two-of-gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3856:\"<p>As activity ramps up to try to get WordPress 5.0 released in November, Matt Mullenweg <a href=\"https://make.wordpress.org/core/2018/10/05/gutenberg-phase-2-leads/\">has announced</a> who will lead phase two of the Gutenberg project. Phase two focuses on Customization and entire site layouts. </p>\n\n<p>Alexis Lloyd, Head of Design Innovation at Automattic, will handle the design and product side. Riad Benguella, a JavaScript Engineer at Automattic, will handle the technical side of the project. </p>\n\n<p>One of the goals of phase two is to replace widgets with blocks and menus with a navigation block. <a href=\"https://make.wordpress.org/core/2018/10/05/gutenberg-phase-2-leads/#comment-34057\">Lloyd</a> and <a href=\"https://make.wordpress.org/core/2018/10/05/gutenberg-phase-2-leads/#comment-34063\">Benguella</a> commented on the post, introducing themselves to the community. <br /></p>\n\n<p>&#8220;Hi all! I’m thrilled to be working on phase 2 of Gutenberg,&#8221; Lloyd said. &#8220;I think there’s a huge opportunity to take the ease of use that has been brought to page/post editing in phase 1 and extend that to the full site experience. </p>\n\n<p>&#8220;I’m coming from many years leading design and product teams in news organizations (including designing and building custom CMSes), and am looking forward to bringing my experience to WordPress, as well as learning from the deep expertise in the community!&#8221;</p>\n\n<p>&#8220;Hi all! I’m so excited to be working with you all alongside <a href=\"https://profiles.wordpress.org/alexislloyd/\">@alexislloyd</a> to build upon the amazing technology that is Gutenberg in order to bring the content creation experience in WordPress to a whole new level,&#8221; Benguella said.<br /></p>\n\n<p>&#8220;For those who don’t know me yet, I’m a JavaScript engineer at Automattic. I’ve been fortunate to have contributed to the Gutenberg project since its beginning, including a lot of work on Gutenberg APIs, JavaScript in Core, and Accessibility.</p>\n\n<p>&#8220;I look forward to bringing my humble expertise to achieve the second phase of this project, as we look into things like widgets, menus, templates, and site-building in general.&#8221;</p>\n\n<h2>Theseus&#8217;s Paradox  Makes More Sense Now</h2>\n\n<p>In <a href=\"https://wptavern.com/wpweekly-episode-331-status-update-on-gutenberg-with-gary-pendergast\">episode 331 of WordPress Weekly</a>, one of the items we discussed with Gary Pendergast is the future of Gutenberg beyond the editor. At its core, Gutenberg is supposed to unify a number of areas of WordPress. </p>\n\n<blockquote class=\"wp-block-quote\"><p>Blocks are the unifying evolution of what is now covered, in different ways, by shortcodes, embeds, widgets, post formats, custom post types, theme options, meta-boxes, and other formatting elements. They embrace the breadth of functionality WordPress is capable of, with the clarity of a consistent user experience.</p><cite>From the <a href=\"https://wordpress.org/plugins/gutenberg/\">Gutenberg Plugin Page</a></cite></blockquote>\n\n<p>I hypothesized that since Gutenberg is an interface to manage blocks and that menus as well as widgets will become blocks, the menus and widget management pages in the WordPress backend can be replaced or removed in favor of Gutenberg. </p>\n\n<p>In this way, the Menu and Widget management boards on <a href=\"https://matiasventura.com/post/gutenberg-or-the-ship-of-theseus/\">the Ship of Theseus </a>would be replaced without sinking or disrupting the entire boat. </p>\n\n<p>With Mullenweg&#8217;s announcement regarding phase two, the <a href=\"http://en.wikipedia.org/wiki/Ship_of_Theseus\">Ship Of Theseus or Theseus’s paradox</a> begins to make more sense. Gutenberg becomes the foundation for bringing many areas of the WordPress project up to par without starting from scratch.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 09 Oct 2018 01:52:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"WPTavern: Miami WordPresser Todrick Moore Passes Away\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84545\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wptavern.com/miami-wordpresser-todrick-moore-passes-away\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:928:\"<div class=\"wp-block-image\"><img />Todrick Moore Courtesy of <a href=\"http://davidbisset.com/todrick-moore/\">David Bisset</a></div>\n\n<p>Fellow WordPresser Todrick Moore, a member of the Miami WordPress community and volunteer organizer of WordCamp Miami 2015 and 2016  passed away last week of Leukemia.</p>\n\n<p>&#8220;Todrick Moore was one of the kindest and strongest members of the South Florida WordPress community, and I still to this day remember meeting him first at his local meetup,&#8221; David Bisset said. </p>\n\n<p>&#8220;Like many people who come to meetups he was eager to learn, but also as I would quickly come to realize, he would be eager to help others as well.&#8221;</p>\n\n<p>To learn more about Todrick and how to help out his wife with their <a href=\"https://www.madeinthemia.com/\">WordPress business site</a>, please <a href=\"http://davidbisset.com/todrick-moore/\">read this post</a> by David Bisset.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 09 Oct 2018 00:24:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"WPTavern: How the Student-Owned Pelham Examiner Uses WordPress to Empower Young Journalists\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84349\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"https://wptavern.com/how-the-student-owned-pelham-examiner-uses-wordpress-to-empower-young-journalists\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4229:\"<p>When the <a href=\"https://newsofpelham.com/\" rel=\"noopener noreferrer\" target=\"_blank\">News of Pelham</a> became another casualty of the blighted newspaper industry, student journalist contributors lost a platform for their voices to be heard. Their advisor, Rich Zahradnik, called a meeting to address the paper&#8217;s closure. More than a dozen middle and high school kids showed up and decided to start their own paper: <a href=\"https://www.pelhamexaminer.com/\" rel=\"noopener noreferrer\" target=\"_blank\">The Pelham Examiner</a>.</p>\n<p><a href=\"https://www.richzahradnik.com\" rel=\"noopener noreferrer\" target=\"_blank\">Zahradnik</a> is a former journalist who has been volunteering for years in the local elementary schools, teaching kids how to write news stories. Before the News of Pelham shut down he was acting as a liaison to recruit student contributors. He registered the Examiner as a corporation and the paper is also part of the New York Press Association.</p>\n<p>The Pelham Examiner is an online-only publication that covers everything from local politics and crime to sports and entertainment. It is running on WordPress, using plugins like All-in-One Event Calendar and WP Polls to enhance students&#8217; stories. The site uses the FLEX WordPress Theme by <a href=\"https://snosites.com/\" rel=\"noopener noreferrer\" target=\"_blank\">SNO</a>, an organization that sells publishing solutions for scholastic news programs.</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2018/10/screely-1539030523820.png?ssl=1\"><img /></a></p>\n<p>WordPress provided a cost-effective way to launch a student-run newspaper and students also found it to be intuitive for publishing.</p>\n<p>&#8220;We chose to use WordPress mainly because of the ease with which we could use it and create a website look that worked for our goal,&#8221; Executive Editor Ben Glickman said. Zahradnik had used the platform with prior publications he had worked on with students at Colonial Elementary School.</p>\n<p>&#8220;Several of the students who had worked on The Colonial Times loosely remembered some aspects of WordPress, but most of us had to learn from the beginning,&#8221; Glickman said. &#8220;I started with the basics (creating new articles, saving drafts, etc.) and worked my way up to the more complex stuff.&#8221; Most students contributing to the Pelham Examiner didn&#8217;t require much training to get up to speed with publishing articles.</p>\n<p>&#8220;Personally, I thought that much of WordPress was rather intuitive, so learning was not too hard,&#8221; Glickman said. &#8220;I haven&#8217;t had any problems with WordPress so far. I&#8217;ve been especially impressed with how easy it is to integrate all kinds of story elements into a given story.&#8221;</p>\n<p>Poynter published a <a href=\"https://www.poynter.org/news/when-paper-they-were-writing-folded-kids-started-their-own\" rel=\"noopener noreferrer\" target=\"_blank\">story</a> last week about the enthusiastic and highly motivated group of young journalists behind the <a href=\"https://www.pelhamexaminer.com/\" rel=\"noopener noreferrer\" target=\"_blank\">Pelham Examiner</a>. For now the publication is self-sustaining with volunteer contributions, but Zahradnik told Poynter that he is open to ads or investors in the future.</p>\n<p>Sustaining the news as a business is another skill the students will need to learn as the publishing industry is increasingly demanding more creative revenue models from journalists who want to work independently. Zahradnik told Poynter that the Pelham Examiner&#8217;s student-owned online paper could be a model for other places that are no longer able to support traditional local newspapers.</p>\n<p>The News of Pelham was a bi-weekly, print-only publication before it closed its doors. With a WordPress-powered website, students can get the news out faster, publishing every day with virtually no overhead costs.</p>\n<p>&#8220;I think the model for the Examiner is absolutely reproducible,&#8221; Glickman said. &#8220;For the relatively small price of a startup fee and annual hosting and support fees, you can essentially have the same type of town or city coverage with a conventional town newspaper.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 08 Oct 2018 20:52:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WPTavern: WooSesh Schedule Published, WooCommerce Team to Deliver Keynote\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84428\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://wptavern.com/woosesh-schedule-published-woocommerce-team-to-deliver-keynote\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1835:\"<p><a href=\"https://woosesh.com/\" rel=\"noopener noreferrer\" target=\"_blank\">WooSesh</a>, the virtual WooCommerce conference, is now less than two weeks away. The two-day event will be held October 18-19 and is free for all attendees who join the livestream. Organizers Patrick Rauland and Brian Richards published the schedule this week with <a href=\"https://woosesh.com/#day1\" rel=\"noopener noreferrer\" target=\"_blank\">descriptions for each session</a>.</p>\n<p>Day 1 will feature speakers on a variety of topics suited for all attendees who work with WooCommerce, including building stores for clients, designing sites, and developing plugins. Day 2 is geared towards developers and will focus on more technical topics.</p>\n<p><a href=\"https://twitter.com/toddwilkens\" rel=\"noopener noreferrer\" target=\"_blank\">Todd Wilkens</a>, Head of WooCommerce, will be giving the keynote along with Aviva Pinchas and Kelly Hoffman. The session is titled &#8220;The Past, Present, and Future of WooCommerce&#8221; and it will be followed up with a Q&amp;A time.</p>\n<p>In a recent <a href=\"https://panel.socialpilot.co/site/video/eNiqGdpe\" rel=\"noopener noreferrer\" target=\"_blank\">interview</a>, Wilkens told Patrick Rauland that they have been working to rethink the merchant experience of the platform, as it has traditionally offered more of a builder style experience. This is one topic they plan to discuss in the keynote, in addition to where they see WooCommerce going as a platform, some recent successes, and how WooCommerce fits into other trends with WordPress and e-commerce in general.</p>\n<p>Attendees can watch all sessions for free as long as they attend at least one presentation during the live event. Registration is open on the <a href=\"https://woosesh.com/\" rel=\"noopener noreferrer\" target=\"_blank\">WooSesh</a> website.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 05 Oct 2018 05:58:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"WPTavern: If Deadlines Are Not Arbitrary, Why Not Release WordPress 5.0 in the Beginning of January?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84466\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:109:\"https://wptavern.com/if-deadlines-are-not-arbitrary-why-not-release-wordpress-5-0-in-the-beginning-of-january\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3933:\"<p>The WordPress 5.0 release schedule <a href=\"https://wptavern.com/wordpress-5-0-slated-for-november-19-2018\">has been published</a> and not everyone is excited about the expected November 19th release. November 19th is three days before Thanksgiving, a major holiday in the U.S.</p>\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Just going to call bullshit on anyone claiming “every date is bad for someone” or “every month has holidays somewhere” when defending possible Nov-Dec WordPress 5.0 release. It is trying to be rammed in for WordCamp U.S. where those November and December holidays are major ones.</p>&mdash; Carl Hancock <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f680.png\" alt=\"🚀\" class=\"wp-smiley\" /> (@carlhancock) <a href=\"https://twitter.com/carlhancock/status/1047922585659461632?ref_src=twsrc%5Etfw\">October 4, 2018</a></blockquote>\n</div>\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">So <a href=\"https://twitter.com/hashtag/Gutenberg?src=hash&ref_src=twsrc%5Etfw\">#Gutenberg</a> is being rolled out the week of Thanksgiving? Do none of you have families or want to enjoy the holidays? What a terrible decision to push this during a holiday week&#8230;</p>&mdash; Jennifer Bourn (@jenniferbourn) <a href=\"https://twitter.com/jenniferbourn/status/1047845139912122368?ref_src=twsrc%5Etfw\">October 4, 2018</a></blockquote>\n</div>\n\n<p>Historically, WordPress has <a href=\"https://wordpress.org/news/category/releases/\">shipped major versions</a> in early to mid December rather than November. Holidays were considered because of the sharp drop-off in volunteer contribution activity. These versions were also part of a rigid and predictable four month schedule to get <a href=\"https://wordpress.org/about/roadmap/\">three major releases out per year</a>. </p>\n\n<p>However, WordPress 5.0 is no ordinary major release. It will contain Gutenberg and completely revamp the content creation and editing experience. Not to mention, we won&#8217;t know the full extent of plugin and theme compatibility until it&#8217;s installed on millions of sites. </p>\n\n<p>Looking at the proposed release date and <a href=\"https://2018.us.wordcamp.org/\">WordCamp US</a> taking place on December 7th, it&#8217;s not out of the question to theorize the release occurring before and because of WCUS. It should be noted though that the <a href=\"https://wptavern.com/matt-mullenweg-unveils-gutenberg-roadmap-at-wceu-wordpress-agencies-and-product-developers-sprint-to-prepare\">roadmap Matt Mullenweg outlined at WordCamp EU</a> earlier this year originally targeted a late August release.</p>\n\n<p>I think it would be a bummer if WordPress 5.0 was not released before WordCamp US. However, it would be irresponsible as a project leader to force a release for public relations reasons.</p>\n\n<p>As Mullenweg <a href=\"https://wptavern.com/matt-mullenweg-announces-5-0-release-plan-estimates-release-candidate-to-ship-in-november#comment-262936\">commented</a> in a recently published article, he won&#8217;t release WordPress 5.0 until it&#8217;s ready. I don&#8217;t think releasing it to have a big moment on stage would qualify as being ready.</p>\n\n<p>I think there should be consideration in pushing the release date to the beginning of next year. What better way to ring in the new year with a completely new editor in WordPress. It bypasses the holidays concern and allows people to apply all of their focus on making sure 5.0 is rolled out smoothly to sites they manage.</p>\n\n<p>Gutenberg has been in development for more than a year and a half. Since the WordPress release strategy was thrown out the window last year and <a href=\"https://wordpress.org/about/philosophy/\">deadlines are not arbitrary</a>, what&#8217;s a few more weeks of development and testing before pushing WordPress 5.0 to the public?<br /></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 05 Oct 2018 03:09:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"WPTavern: WordPress Theme and Plugin Shops are Pioneering the First Layout Blocks for Gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84351\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"https://wptavern.com/wordpress-theme-and-plugin-shops-are-pioneering-the-first-layout-blocks-for-gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5995:\"<a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2018/10/layout.jpg?ssl=1\"><img /></a>photo credit: <a href=\"https://stocksnap.io/photo/EWENELMHYR\">Jeffrey Betts</a>\n<p>Many WordPress theme shops started out with themes as their only products but over the years have moved into selling plugins that enhance their core products. This came about partially because theming standards evolved to encourage developers to <a href=\"https://wptavern.com/why-wordpress-theme-developers-are-moving-functionality-into-plugins\" rel=\"noopener noreferrer\" target=\"_blank\">put non-presentational functionality into plugins</a>. For many, the revenue from plugins quickly eclipsed that of their theme products. In the past, theme shops have often partnered with page builder plugins to enhance their users&#8217; capabilities in customizing the themes. This may soon change, as the advent of Gutenberg is bringing new product opportunities to theme and plugin shops shops.</p>\n<p>The first iteration of the new editor focuses on blocks and the post editing experience. After Gutenberg is in core, the project will move on to the second phase &#8211; full site customization. This will venture into page builder type functionality. Matt Mullenweg <a href=\"https://twitter.com/photomatt/status/1037843717070057472\" rel=\"noopener noreferrer\" target=\"_blank\">predicts this phase will happen much faster than phase 1</a>, since all of the infrastructure is already in place. The plugin already has a columns block in beta.</p>\n<p>Gutenberg is scheduled to debut in WordPress 5.0 in November, but site customization functionality won&#8217;t arrive until 2019 at the earliest. In the meantime, plugin developers have been experimenting with various implementations of &#8220;section&#8221; and &#8220;container&#8221; blocks while the Gutenberg team <a href=\"https://github.com/WordPress/gutenberg/issues/4900\" rel=\"noopener noreferrer\" target=\"_blank\">explores a core container block</a> for phase 2.</p>\n<p>Marie Comet&#8217;s <a href=\"https://github.com/MarieComet/WP-container-block/\" rel=\"noopener noreferrer\" target=\"_blank\">WP Container Block</a> is a fork of the core columns block that offers columns structure, spacing, and backgrounds (with both image and color controls). Felix Arntz recently published a tutorial on how he built a <a href=\"https://felix-arntz.me/blog/building-a-reusable-gutenberg-section-block/\" rel=\"noopener noreferrer\" target=\"_blank\">reusable Gutenberg section block</a>. Marc Lacroix created his own <a href=\"https://github.com/marcusig/gutenberg-section-block\" rel=\"noopener noreferrer\" target=\"_blank\">container block</a>, out of necessity, with capabilities for spacing and background customization.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2018/10/Screen-Shot-2018-10-03-at-10.26.43-PM.png?ssl=1\"><img /></a></p>\n<p>Section/container blocks are a precursor to using Gutenberg for building more complex layouts. Some of these explorations may inform the Gutenberg team&#8217;s implementation of a core container block in the future.</p>\n<p>A few more full-featured layout blocks are starting to pop up on WordPress.org. Kadence Themes, a theme and plugin shop based in Missoula, Montana, released its <a href=\"https://wordpress.org/plugins/kadence-blocks/\" rel=\"noopener noreferrer\" target=\"_blank\">Kadence Blocks &#8211; Gutenberg Page Builder Toolkit</a> at the end of August. The plugin brings the editor closer to delivering the features users expect from popular page builders, such as better control of columns for different screen sizes and a <a href=\"https://themes.kadencethemes.com/ascend-5/row-layout-block/\" rel=\"noopener noreferrer\" target=\"_blank\">row/layout block</a> with controls for padding, backgrounds, alignment, and overlays with gradients.</p>\n<p><a href=\"https://www.instagram.com/p/Bmtjc9lh6zA/\" title=\"View on Instagram\" target=\"_blank\"><img src=\"http://instagr.am/p/Bmtjc9lh6zA/media/?size=l\" alt=\"Instagram Photo\" /></a></p>\n<p>A live &#8220;Frontenberg&#8221; style <a href=\"http://demo.kadencethemes.com/kadence-blocks/\" rel=\"noopener noreferrer\" target=\"_blank\">demo of Kadence Blocks</a> is available where you can see the plugin&#8217;s options for manipulating page layout.</p>\n<p>Pootlepress, a WordPress plugin and theme shop, has added a new Layouts block to its free <a href=\"https://wordpress.org/plugins/caxton/\" rel=\"noopener noreferrer\" target=\"_blank\">Caxton plugin</a>. The company is one of the earlier Gutenberg adopters in the WooCommerce space with its recent release of the <a href=\"https://wptavern.com/pootlepress-previews-upcoming-storefront-blocks-plugin-for-woocommerce\" rel=\"noopener noreferrer\" target=\"_blank\">Storefront Blocks</a> plugin.</p>\n<p>Caxton bills itself as a &#8220;page layout plugin&#8221; for Gutenberg. Its layout block allows users to select from a number of preset layouts and then add blocks within those layouts. It supports nesting rows and row backgrounds. A Frontenberg <a href=\"http://demo.caxton.pro/\" rel=\"noopener noreferrer\" target=\"_blank\">demo site</a> gives users the chance to play around with the page builder functionality before installing the plugin.</p>\n<div class=\"embed-vimeo\"></div>\n<p>Until Gutenberg adds core support for more layout capabilities, WordPress may see an influx of these layout blocks that introduce basic page builder functionality. Some of these plugins may need to be refactored once there is more direction for these features in core, but they offer a glimpse of what Gutenberg will bring to site customization. Combined with <a href=\"https://wptavern.com/gutenberg-3-9-introduces-reusable-exportable-templates-for-multiple-blocks\" rel=\"noopener noreferrer\" target=\"_blank\">Gutenberg 3.9&#8217;s reusable, exportable templates for multiple blocks</a>, page layouts will become more portable than ever. In 2019, we may see new sites popping up that enable users and developers to share the layout designs they have created.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 04 Oct 2018 15:24:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:8:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Mon, 05 Nov 2018 19:57:58 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:13:\"last-modified\";s:29:\"Mon, 05 Nov 2018 19:45:29 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:9:\"HIT ord 2\";s:16:\"content-encoding\";s:4:\"gzip\";}}s:5:\"build\";s:14:\"20130911070210\";}", "no");
INSERT INTO `tb_options` VALUES("237", "_transient_timeout_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1541491078", "no");
INSERT INTO `tb_options` VALUES("238", "_transient_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1541447878", "no");
INSERT INTO `tb_options` VALUES("239", "_transient_timeout_dash_v2_b057e621f3d353b2bafc78d3ed3361bc", "1541491078", "no");
INSERT INTO `tb_options` VALUES("240", "_transient_dash_v2_b057e621f3d353b2bafc78d3ed3361bc", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2018/11/wordpress-5-0-beta-3/\'>WordPress 5.0 Beta 3</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wptavern.com/wordpress-5-0-beta-3-released-rc-1-expected-november-12\'>WPTavern: WordPress 5.0 Beta 3 Released, RC 1 Expected November 12</a></li><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2018/11/wordpress-5-0-beta-3/\'>Dev Blog: WordPress 5.0 Beta 3</a></li><li><a class=\'rsswidget\' href=\'https://wptavern.com/github-rolls-out-more-small-improvements-as-part-of-project-paper-cuts\'>WPTavern: GitHub Rolls Out More Small Improvements as Part of Project Paper Cuts</a></li></ul></div>", "no");
INSERT INTO `tb_options` VALUES("265", "_transient_timeout_pixova-lite_hash_update", "1541451238", "no");
INSERT INTO `tb_options` VALUES("266", "_transient_pixova-lite_hash_update", "", "no");
INSERT INTO `tb_options` VALUES("267", "_transient_is_multi_author", "0", "yes");
INSERT INTO `tb_options` VALUES("268", "Modula_db_version", "1.0", "yes");
INSERT INTO `tb_options` VALUES("269", "_transient_timeout_plugin_slugs", "1541537590", "no");
INSERT INTO `tb_options` VALUES("270", "_transient_plugin_slugs", "a:9:{i:0;s:19:\"akismet/akismet.php\";i:1;s:36:\"contact-form-7/wp-contact-form-7.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:35:\"fancybox-for-wordpress/fancybox.php\";i:4;s:9:\"hello.php\";i:5;s:39:\"kiwi-social-share/kiwi-social-share.php\";i:6;s:35:\"modula-best-grid-gallery/Modula.php\";i:7;s:53:\"simple-custom-post-order/simple-custom-post-order.php\";i:8;s:41:\"wordpress-importer/wordpress-importer.php\";}", "no");
INSERT INTO `tb_options` VALUES("271", "_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a", "1541461957", "no");
INSERT INTO `tb_options` VALUES("272", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "O:8:\"stdClass\":100:{s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";i:4517;}s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";i:3102;}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";i:2599;}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";i:2455;}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";i:1888;}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";i:1688;}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";i:1682;}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";i:1461;}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";i:1410;}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";i:1408;}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";i:1405;}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";i:1338;}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";i:1285;}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";i:1258;}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";i:1120;}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";i:1079;}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";i:1055;}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";i:1040;}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";i:946;}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";i:901;}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";i:836;}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";i:819;}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";i:813;}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";i:742;}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";i:713;}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";i:699;}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";i:695;}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";i:690;}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";i:687;}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";i:672;}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";i:669;}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";i:664;}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";i:651;}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";i:647;}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";i:626;}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";i:626;}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";i:619;}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"ajax\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";i:608;}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";i:603;}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";i:602;}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";i:575;}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";i:556;}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"css\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";i:549;}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";i:545;}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";i:535;}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";i:530;}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";i:526;}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";i:518;}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";i:517;}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";i:513;}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";i:510;}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";i:502;}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";i:494;}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";i:491;}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";i:485;}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";i:482;}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";i:465;}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";i:464;}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";i:457;}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";i:452;}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";i:446;}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";i:438;}s:7:\"payment\";a:3:{s:4:\"name\";s:7:\"payment\";s:4:\"slug\";s:7:\"payment\";s:5:\"count\";i:431;}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";i:426;}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";i:424;}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";i:419;}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";i:417;}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";i:417;}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";i:411;}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";i:394;}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";i:389;}s:15:\"payment-gateway\";a:3:{s:4:\"name\";s:15:\"payment gateway\";s:4:\"slug\";s:15:\"payment-gateway\";s:5:\"count\";i:385;}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";i:374;}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"news\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";i:372;}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";i:371;}s:5:\"popup\";a:3:{s:4:\"name\";s:5:\"popup\";s:4:\"slug\";s:5:\"popup\";s:5:\"count\";i:370;}s:4:\"chat\";a:3:{s:4:\"name\";s:4:\"chat\";s:4:\"slug\";s:4:\"chat\";s:5:\"count\";i:369;}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";i:364;}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";i:355;}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";i:354;}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";i:352;}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";i:350;}s:4:\"code\";a:3:{s:4:\"name\";s:4:\"code\";s:4:\"slug\";s:4:\"code\";s:5:\"count\";i:344;}s:4:\"meta\";a:3:{s:4:\"name\";s:4:\"meta\";s:4:\"slug\";s:4:\"meta\";s:5:\"count\";i:342;}s:3:\"url\";a:3:{s:4:\"name\";s:3:\"url\";s:4:\"slug\";s:3:\"url\";s:5:\"count\";i:340;}s:4:\"list\";a:3:{s:4:\"name\";s:4:\"list\";s:4:\"slug\";s:4:\"list\";s:5:\"count\";i:338;}s:5:\"forms\";a:3:{s:4:\"name\";s:5:\"forms\";s:4:\"slug\";s:5:\"forms\";s:5:\"count\";i:335;}s:8:\"redirect\";a:3:{s:4:\"name\";s:8:\"redirect\";s:4:\"slug\";s:8:\"redirect\";s:5:\"count\";i:332;}s:11:\"advertising\";a:3:{s:4:\"name\";s:11:\"advertising\";s:4:\"slug\";s:11:\"advertising\";s:5:\"count\";i:315;}s:11:\"performance\";a:3:{s:4:\"name\";s:11:\"performance\";s:4:\"slug\";s:11:\"performance\";s:5:\"count\";i:313;}s:6:\"simple\";a:3:{s:4:\"name\";s:6:\"simple\";s:4:\"slug\";s:6:\"simple\";s:5:\"count\";i:310;}s:16:\"custom-post-type\";a:3:{s:4:\"name\";s:16:\"custom post type\";s:4:\"slug\";s:16:\"custom-post-type\";s:5:\"count\";i:309;}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";i:308;}s:3:\"tag\";a:3:{s:4:\"name\";s:3:\"tag\";s:4:\"slug\";s:3:\"tag\";s:5:\"count\";i:305;}s:14:\"contact-form-7\";a:3:{s:4:\"name\";s:14:\"contact form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"count\";i:303;}s:7:\"adsense\";a:3:{s:4:\"name\";s:7:\"adsense\";s:4:\"slug\";s:7:\"adsense\";s:5:\"count\";i:303;}s:16:\"google-analytics\";a:3:{s:4:\"name\";s:16:\"google analytics\";s:4:\"slug\";s:16:\"google-analytics\";s:5:\"count\";i:303;}s:4:\"html\";a:3:{s:4:\"name\";s:4:\"html\";s:4:\"slug\";s:4:\"html\";s:5:\"count\";i:303;}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";i:302;}s:6:\"author\";a:3:{s:4:\"name\";s:6:\"author\";s:4:\"slug\";s:6:\"author\";s:5:\"count\";i:299;}}", "no");
INSERT INTO `tb_options` VALUES("274", "_site_transient_timeout_theme_roots", "1541452983", "no");
INSERT INTO `tb_options` VALUES("275", "_site_transient_theme_roots", "a:4:{s:11:\"pixova-lite\";s:7:\"/themes\";s:13:\"twentyfifteen\";s:7:\"/themes\";s:15:\"twentyseventeen\";s:7:\"/themes\";s:13:\"twentysixteen\";s:7:\"/themes\";}", "no");
INSERT INTO `tb_options` VALUES("276", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1541451189;s:7:\"checked\";a:9:{s:19:\"akismet/akismet.php\";s:5:\"4.0.8\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:5:\"5.0.5\";s:25:\"duplicator/duplicator.php\";s:6:\"1.2.52\";s:35:\"fancybox-for-wordpress/fancybox.php\";s:5:\"3.1.2\";s:9:\"hello.php\";s:3:\"1.7\";s:39:\"kiwi-social-share/kiwi-social-share.php\";s:5:\"2.0.9\";s:35:\"modula-best-grid-gallery/Modula.php\";s:5:\"1.3.2\";s:53:\"simple-custom-post-order/simple-custom-post-order.php\";s:5:\"2.3.4\";s:41:\"wordpress-importer/wordpress-importer.php\";s:5:\"0.6.4\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:9:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"4.0.8\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.4.0.8.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:59:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=969272\";s:2:\"1x\";s:59:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=969272\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:61:\"https://ps.w.org/akismet/assets/banner-772x250.jpg?rev=479904\";}s:11:\"banners_rtl\";a:0:{}}s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:28:\"w.org/plugins/contact-form-7\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:5:\"5.0.5\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.0.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/contact-form-7/assets/icon-256x256.png?rev=984007\";s:2:\"1x\";s:66:\"https://ps.w.org/contact-form-7/assets/icon-128x128.png?rev=984007\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/contact-form-7/assets/banner-1544x500.png?rev=860901\";s:2:\"1x\";s:68:\"https://ps.w.org/contact-form-7/assets/banner-772x250.png?rev=880427\";}s:11:\"banners_rtl\";a:0:{}}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"1.2.52\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.1.2.52.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=1298463\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=1298463\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=1645055\";}s:11:\"banners_rtl\";a:0:{}}s:35:\"fancybox-for-wordpress/fancybox.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:36:\"w.org/plugins/fancybox-for-wordpress\";s:4:\"slug\";s:22:\"fancybox-for-wordpress\";s:6:\"plugin\";s:35:\"fancybox-for-wordpress/fancybox.php\";s:11:\"new_version\";s:5:\"3.1.2\";s:3:\"url\";s:53:\"https://wordpress.org/plugins/fancybox-for-wordpress/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/fancybox-for-wordpress.3.1.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:75:\"https://ps.w.org/fancybox-for-wordpress/assets/icon-256x256.jpg?rev=1864321\";s:2:\"1x\";s:75:\"https://ps.w.org/fancybox-for-wordpress/assets/icon-256x256.jpg?rev=1864321\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:77:\"https://ps.w.org/fancybox-for-wordpress/assets/banner-772x250.jpg?rev=1864321\";}s:11:\"banners_rtl\";a:0:{}}s:9:\"hello.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:25:\"w.org/plugins/hello-dolly\";s:4:\"slug\";s:11:\"hello-dolly\";s:6:\"plugin\";s:9:\"hello.php\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/hello-dolly/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/hello-dolly.1.6.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/hello-dolly/assets/icon-256x256.jpg?rev=969907\";s:2:\"1x\";s:63:\"https://ps.w.org/hello-dolly/assets/icon-128x128.jpg?rev=969907\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:65:\"https://ps.w.org/hello-dolly/assets/banner-772x250.png?rev=478342\";}s:11:\"banners_rtl\";a:0:{}}s:39:\"kiwi-social-share/kiwi-social-share.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:31:\"w.org/plugins/kiwi-social-share\";s:4:\"slug\";s:17:\"kiwi-social-share\";s:6:\"plugin\";s:39:\"kiwi-social-share/kiwi-social-share.php\";s:11:\"new_version\";s:5:\"2.0.9\";s:3:\"url\";s:48:\"https://wordpress.org/plugins/kiwi-social-share/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/kiwi-social-share.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/kiwi-social-share/assets/icon-256x256.png?rev=1445882\";s:2:\"1x\";s:70:\"https://ps.w.org/kiwi-social-share/assets/icon-256x256.png?rev=1445882\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:72:\"https://ps.w.org/kiwi-social-share/assets/banner-772x250.png?rev=1445902\";}s:11:\"banners_rtl\";a:0:{}}s:35:\"modula-best-grid-gallery/Modula.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:38:\"w.org/plugins/modula-best-grid-gallery\";s:4:\"slug\";s:24:\"modula-best-grid-gallery\";s:6:\"plugin\";s:35:\"modula-best-grid-gallery/Modula.php\";s:11:\"new_version\";s:5:\"1.3.2\";s:3:\"url\";s:55:\"https://wordpress.org/plugins/modula-best-grid-gallery/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/modula-best-grid-gallery.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:77:\"https://ps.w.org/modula-best-grid-gallery/assets/icon-256x256.jpg?rev=1634322\";s:2:\"1x\";s:77:\"https://ps.w.org/modula-best-grid-gallery/assets/icon-256x256.jpg?rev=1634322\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:79:\"https://ps.w.org/modula-best-grid-gallery/assets/banner-772x250.jpg?rev=1634322\";}s:11:\"banners_rtl\";a:0:{}}s:53:\"simple-custom-post-order/simple-custom-post-order.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:38:\"w.org/plugins/simple-custom-post-order\";s:4:\"slug\";s:24:\"simple-custom-post-order\";s:6:\"plugin\";s:53:\"simple-custom-post-order/simple-custom-post-order.php\";s:11:\"new_version\";s:5:\"2.3.4\";s:3:\"url\";s:55:\"https://wordpress.org/plugins/simple-custom-post-order/\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/plugin/simple-custom-post-order.2.3.4.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:77:\"https://ps.w.org/simple-custom-post-order/assets/icon-256x256.jpg?rev=1859717\";s:2:\"1x\";s:77:\"https://ps.w.org/simple-custom-post-order/assets/icon-256x256.jpg?rev=1859717\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:79:\"https://ps.w.org/simple-custom-post-order/assets/banner-772x250.jpg?rev=1859717\";}s:11:\"banners_rtl\";a:0:{}}s:41:\"wordpress-importer/wordpress-importer.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:32:\"w.org/plugins/wordpress-importer\";s:4:\"slug\";s:18:\"wordpress-importer\";s:6:\"plugin\";s:41:\"wordpress-importer/wordpress-importer.php\";s:11:\"new_version\";s:5:\"0.6.4\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/wordpress-importer/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/wordpress-importer.0.6.4.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:71:\"https://ps.w.org/wordpress-importer/assets/icon-256x256.png?rev=1908375\";s:2:\"1x\";s:63:\"https://ps.w.org/wordpress-importer/assets/icon.svg?rev=1908375\";s:3:\"svg\";s:63:\"https://ps.w.org/wordpress-importer/assets/icon.svg?rev=1908375\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:72:\"https://ps.w.org/wordpress-importer/assets/banner-772x250.png?rev=547654\";}s:11:\"banners_rtl\";a:0:{}}}}", "no");
INSERT INTO `tb_options` VALUES("277", "duplicator_settings", "a:10:{s:7:\"version\";s:6:\"1.2.52\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:20:\"storage_htaccess_off\";b:0;}", "yes");
INSERT INTO `tb_options` VALUES("278", "duplicator_version_plugin", "1.2.52", "yes");
INSERT INTO `tb_options` VALUES("279", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-11-05 20:53:49\";s:7:\"Version\";s:6:\"1.2.52\";s:9:\"VersionWP\";s:5:\"4.9.8\";s:9:\"VersionDB\";s:6:\"5.6.37\";s:10:\"VersionPHP\";s:6:\"5.6.31\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";N;s:4:\"Name\";s:20:\"20181105_trustworthy\";s:4:\"Hash\";s:35:\"324541adb13515a27859_20181105205349\";s:8:\"NameHash\";s:56:\"20181105_trustworthy_324541adb13515a27859_20181105205349\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:65:\"/Applications/AMPPS/www/1mentha/midatech/otd/web/wp-snapshots/tmp\";s:8:\"StoreURL\";s:55:\"http://localhost/1mentha/midatech/otd/web/wp-snapshots/\";s:8:\"ScanFile\";s:66:\"20181105_trustworthy_324541adb13515a27859_20181105205349_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":19:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:48:\"/Applications/AMPPS/www/1mentha/midatech/otd/web\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-11-05 20:53:49\";s:7:\"Version\";s:6:\"1.2.52\";s:9:\"VersionWP\";s:5:\"4.9.8\";s:9:\"VersionDB\";s:6:\"5.6.37\";s:10:\"VersionPHP\";s:6:\"5.6.31\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";N;s:4:\"Name\";s:20:\"20181105_trustworthy\";s:4:\"Hash\";s:35:\"324541adb13515a27859_20181105205349\";s:8:\"NameHash\";s:56:\"20181105_trustworthy_324541adb13515a27859_20181105205349\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:65:\"/Applications/AMPPS/www/1mentha/midatech/otd/web/wp-snapshots/tmp\";s:8:\"StoreURL\";s:55:\"http://localhost/1mentha/midatech/otd/web/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";O:13:\"DUP_Installer\":9:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:10:\"\0*\0Package\";r:58;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:19:\"Source distribution\";s:10:\"\0*\0Package\";r:58;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:57:\"/Applications/AMPPS/www/1mentha/midatech/otd/web/wp-admin\";i:1;s:67:\"/Applications/AMPPS/www/1mentha/midatech/otd/web/wp-content/uploads\";i:2;s:69:\"/Applications/AMPPS/www/1mentha/midatech/otd/web/wp-content/languages\";i:3;s:67:\"/Applications/AMPPS/www/1mentha/midatech/otd/web/wp-content/plugins\";i:4;s:66:\"/Applications/AMPPS/www/1mentha/midatech/otd/web/wp-content/themes\";i:5;s:60:\"/Applications/AMPPS/www/1mentha/midatech/otd/web/wp-includes\";}}s:9:\"Installer\";r:80;s:8:\"Database\";r:90;}", "yes");

/* INSERT TABLE DATA: tb_postmeta */
INSERT INTO `tb_postmeta` VALUES("1", "2", "_wp_page_template", "default");
INSERT INTO `tb_postmeta` VALUES("2", "3", "_wp_page_template", "default");
INSERT INTO `tb_postmeta` VALUES("5", "8", "_form", "<label> Tu Nombre (requerido)\n    [text* your-name] </label>\n\n<label> Tu Correo (requerido)\n    [email* your-email] </label>\n\n<label> Asunto\n    [text your-subject] </label>\n\n<label> Tu Mensaje\n    [textarea your-message] </label>\n\n[submit \"Enviar\"]");
INSERT INTO `tb_postmeta` VALUES("6", "8", "_mail", "a:8:{s:7:\"subject\";s:32:\"Trans boomerang \"[your-subject]\"\";s:6:\"sender\";s:32:\"[your-name] <agomez@midatech.cl>\";s:4:\"body\";s:204:\"De: [your-name] <[your-email]>\nAsunto: [your-subject]\n\nCuerpo del Mensaje\n[your-message]\n\n-- \nEste correo fue enviado utilizando contact form en Trans boomerang (http://localhost/1mentha/midatech/otd/web)\";s:9:\"recipient\";s:18:\"agomez@midatech.cl\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";i:0;s:13:\"exclude_blank\";i:0;}");
INSERT INTO `tb_postmeta` VALUES("7", "8", "_mail_2", "a:9:{s:6:\"active\";b:0;s:7:\"subject\";s:32:\"Trans boomerang \"[your-subject]\"\";s:6:\"sender\";s:36:\"Trans boomerang <agomez@midatech.cl>\";s:4:\"body\";s:149:\"Cuerpo del Mensaje\n[your-message]\n\n-- \nEste correo fue enviado utilizando contact form en Trans boomerang (http://localhost/1mentha/midatech/otd/web)\";s:9:\"recipient\";s:12:\"[your-email]\";s:18:\"additional_headers\";s:28:\"Reply-To: agomez@midatech.cl\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";i:0;s:13:\"exclude_blank\";i:0;}");
INSERT INTO `tb_postmeta` VALUES("8", "8", "_messages", "a:8:{s:12:\"mail_sent_ok\";s:45:\"Thank you for your message. It has been sent.\";s:12:\"mail_sent_ng\";s:71:\"There was an error trying to send your message. Please try again later.\";s:16:\"validation_error\";s:61:\"One or more fields have an error. Please check and try again.\";s:4:\"spam\";s:71:\"There was an error trying to send your message. Please try again later.\";s:12:\"accept_terms\";s:69:\"You must accept the terms and conditions before sending your message.\";s:16:\"invalid_required\";s:22:\"The field is required.\";s:16:\"invalid_too_long\";s:22:\"The field is too long.\";s:17:\"invalid_too_short\";s:23:\"The field is too short.\";}");
INSERT INTO `tb_postmeta` VALUES("9", "8", "_additional_settings", NULL);
INSERT INTO `tb_postmeta` VALUES("10", "8", "_locale", "es_CL");
INSERT INTO `tb_postmeta` VALUES("11", "7", "pixova-settings", "a:132:{s:27:\"pixova_lite_intro_title_cta\";s:25:\"Bienvenidos a TrustWorthy\";s:21:\"pixova_lite_intro_cta\";s:14:\"Correo Privado\";s:25:\"pixova_lite_intro_sub_cta\";s:20:\"Hacemos sus entregas\";s:37:\"pixova_lite_intro_outline_button_text\";s:14:\"Sobre Nosotros\";s:36:\"pixova_lite_intro_outline_button_url\";s:6:\"#about\";s:29:\"pixova_lite_intro_button_text\";s:11:\"Contactenos\";s:28:\"pixova_lite_intro_button_url\";s:6:\"#about\";s:35:\"pixova_lite_intro_what_we_do_1_icon\";s:10:\"fa fa-bold\";s:36:\"pixova_lite_intro_what_we_do_1_title\";s:10:\"Web design\";s:42:\"pixova_lite_intro_what_we_do_1_description\";s:40:\"Lorem ipsum dolor sit amet. Lorem ipsum.\";s:35:\"pixova_lite_intro_what_we_do_2_icon\";s:10:\"fa fa-code\";s:36:\"pixova_lite_intro_what_we_do_2_title\";s:11:\"Development\";s:42:\"pixova_lite_intro_what_we_do_2_description\";s:40:\"Lorem ipsum dolor sit amet. Lorem ipsum.\";s:35:\"pixova_lite_intro_what_we_do_3_icon\";s:16:\"fa fa-envelope-o\";s:36:\"pixova_lite_intro_what_we_do_3_title\";s:12:\"Print design\";s:42:\"pixova_lite_intro_what_we_do_3_description\";s:40:\"Lorem ipsum dolor sit amet. Lorem ipsum.\";s:31:\"pixova_lite_about_section_title\";s:15:\"Nuestra Empresa\";s:35:\"pixova_lite_about_section_sub_title\";s:33:\"This is what we do in a nutshell.\";s:34:\"pixova_lite_about_section_textarea\";s:702:\"<em>Creada en Abril de 2005,  TRUSTWORTHY. es una Empresa que nace orientada en proporcionar como soluciones, alternativas de despacho, servicio de mensajería  y transporte de carga menor a los más variados requerimientos de nuestros Clientes y  que el mercado tanto local como regional nos impone. Para este efecto nos hemos consolidado basados en el profesionalismo y seriedad de nuestro staff humano, con más de  10 años de experiencia, hemos adquirido una profunda convicción en el trabajo permanente orientado a la consolidación de las  relaciones con nuestros Clientes, el desarrollo sostenible de nuestro negocio  y el respecto de los valores culturales de la sociedad Chilena. </em>\";s:36:\"pixova_lite_about_section_blockquote\";s:80:\"<em>Nuestra Premisa es Puntualidad, Honestidad, confianza y profesionalismo</em>\";s:41:\"pixova_lite_about_section_chart_1_heading\";s:12:\"Puntualidad \";s:41:\"pixova_lite_about_section_chart_2_heading\";s:10:\"Honestidad\";s:41:\"pixova_lite_about_section_chart_3_heading\";s:9:\"confianza\";s:44:\"pixova_lite_about_section_chart_3_percentage\";s:3:\"100\";s:44:\"pixova_lite_about_section_chart_4_percentage\";s:3:\"100\";s:41:\"pixova_lite_about_section_chart_4_heading\";s:15:\"Profesionalismo\";s:30:\"pixova_lite_work_section_title\";s:17:\"Nuestros Trabajos\";s:34:\"pixova_lite_work_section_sub_title\";s:24:\"It\'s show and tell time.\";s:44:\"pixova_lite_about_section_chart_1_percentage\";s:2:\"98\";s:44:\"pixova_lite_about_section_chart_2_percentage\";s:3:\"100\";s:31:\"pixova_lite_works_project_1_url\";s:0:\"\";s:31:\"pixova_lite_works_project_2_url\";s:0:\"\";s:31:\"pixova_lite_works_project_3_url\";s:0:\"\";s:31:\"pixova_lite_works_project_4_url\";s:0:\"\";s:37:\"pixova_lite_testimonial_section_title\";s:37:\"Algunas palabras de nuestros clientes\";s:41:\"pixova_lite_testimonial_section_sub_title\";s:43:\"We don\'t like to brag, others do it for us.\";s:37:\"pixova_lite_testimonial_1_person_name\";s:19:\"Katie Parry - Hooli\";s:44:\"pixova_lite_testimonial_1_person_description\";s:212:\"Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.\";s:37:\"pixova_lite_testimonial_2_person_name\";s:8:\"John Doe\";s:44:\"pixova_lite_testimonial_2_person_description\";s:212:\"Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.\";s:37:\"pixova_lite_testimonial_3_person_name\";s:19:\"Katie Parry - Hooli\";s:44:\"pixova_lite_testimonial_3_person_description\";s:212:\"Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.\";s:37:\"pixova_lite_testimonial_4_person_name\";s:19:\"Katie Parry - Hooli\";s:44:\"pixova_lite_testimonial_4_person_description\";s:212:\"Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.\";s:37:\"pixova_lite_testimonial_5_person_name\";s:19:\"Katie Parry - Hooli\";s:44:\"pixova_lite_testimonial_5_person_description\";s:211:\"Working with Pixva has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.\";s:30:\"pixova_lite_news_section_title\";s:16:\"Ultimas noticias\";s:34:\"pixova_lite_news_section_sub_title\";s:23:\"Straight from our blog.\";s:36:\"pixova_lite_news_section_button_text\";s:14:\"Visit our blog\";s:43:\"pixova_lite_news_section_no_posts_per_slide\";s:1:\"2\";s:30:\"pixova_lite_team_section_title\";s:14:\"Nuestro Equipo\";s:34:\"pixova_lite_team_section_sub_title\";s:36:\"Ellos son los que hacen posible todo\";s:30:\"pixova_lite_team_member_1_name\";s:12:\"Angelina Doe\";s:34:\"pixova_lite_team_member_1_facebook\";s:33:\"https://www.facebook.com/colorlib\";s:34:\"pixova_lite_team_member_1_dribbble\";s:32:\"http://www.dribbble.com/colorlib\";s:31:\"pixova_lite_team_member_1_email\";s:16:\"contact@site.com\";s:33:\"pixova_lite_team_member_1_twitter\";s:29:\"https://twitter.com/colorlib/\";s:34:\"pixova_lite_team_member_1_linkedin\";s:24:\"https://www.linkedin.com\";s:35:\"pixova_lite_team_member_1_pinterest\";s:21:\"https://pinterest.com\";s:35:\"pixova_lite_team_member_1_instagram\";s:25:\"https://www.instagram.com\";s:36:\"pixova_lite_team_member_1_googleplus\";s:23:\"https://plus.google.com\";s:30:\"pixova_lite_team_member_2_name\";s:8:\"John Doe\";s:34:\"pixova_lite_team_member_2_facebook\";s:33:\"https://www.facebook.com/colorlib\";s:34:\"pixova_lite_team_member_2_dribbble\";s:36:\"http://www.dribbble.com/madalin.duca\";s:31:\"pixova_lite_team_member_2_email\";s:16:\"contact@site.com\";s:33:\"pixova_lite_team_member_2_twitter\";s:29:\"https://twitter.com/colorlib/\";s:34:\"pixova_lite_team_member_2_linkedin\";s:24:\"https://www.linkedin.com\";s:35:\"pixova_lite_team_member_2_pinterest\";s:21:\"https://pinterest.com\";s:35:\"pixova_lite_team_member_2_instagram\";s:25:\"https://www.instagram.com\";s:36:\"pixova_lite_team_member_2_googleplus\";s:23:\"https://plus.google.com\";s:30:\"pixova_lite_team_member_3_name\";s:12:\"Angelina Doe\";s:34:\"pixova_lite_team_member_3_facebook\";s:33:\"https://www.facebook.com/colorlib\";s:34:\"pixova_lite_team_member_3_dribbble\";s:32:\"http://www.dribbble.com/colorlib\";s:31:\"pixova_lite_team_member_3_email\";s:16:\"contact@site.com\";s:33:\"pixova_lite_team_member_3_twitter\";s:29:\"https://twitter.com/colorlib/\";s:34:\"pixova_lite_team_member_3_linkedin\";s:24:\"https://www.linkedin.com\";s:35:\"pixova_lite_team_member_3_pinterest\";s:21:\"https://pinterest.com\";s:35:\"pixova_lite_team_member_3_instagram\";s:25:\"https://www.instagram.com\";s:36:\"pixova_lite_team_member_3_googleplus\";s:23:\"https://plus.google.com\";s:30:\"pixova_lite_team_member_4_name\";s:12:\"Angelina Doe\";s:34:\"pixova_lite_team_member_4_facebook\";s:34:\"https://www.facebook.com/colorlib/\";s:34:\"pixova_lite_team_member_4_dribbble\";s:33:\"http://www.dribbble.com/colorlib/\";s:31:\"pixova_lite_team_member_4_email\";s:16:\"contact@site.com\";s:33:\"pixova_lite_team_member_4_twitter\";s:28:\"https://twitter.com/colorlib\";s:34:\"pixova_lite_team_member_4_linkedin\";s:24:\"https://www.linkedin.com\";s:35:\"pixova_lite_team_member_4_pinterest\";s:21:\"https://pinterest.com\";s:35:\"pixova_lite_team_member_4_instagram\";s:25:\"https://www.instagram.com\";s:36:\"pixova_lite_team_member_4_googleplus\";s:23:\"https://plus.google.com\";s:30:\"pixova_lite_team_member_5_name\";s:8:\"John Doe\";s:34:\"pixova_lite_team_member_5_facebook\";s:33:\"https://www.facebook.com/colorlib\";s:34:\"pixova_lite_team_member_5_dribbble\";s:32:\"http://www.dribbble.com/colorlib\";s:31:\"pixova_lite_team_member_5_email\";s:16:\"contact@site.com\";s:33:\"pixova_lite_team_member_5_twitter\";s:29:\"https://twitter.com/colorlib/\";s:34:\"pixova_lite_team_member_5_linkedin\";s:24:\"https://www.linkedin.com\";s:35:\"pixova_lite_team_member_5_pinterest\";s:21:\"https://pinterest.com\";s:35:\"pixova_lite_team_member_5_instagram\";s:25:\"https://www.instagram.com\";s:36:\"pixova_lite_team_member_5_googleplus\";s:23:\"https://plus.google.com\";s:33:\"pixova_lite_contact_section_title\";s:11:\"Contactanos\";s:37:\"pixova_lite_contact_section_sub_title\";s:27:\"And we\'ll reply in no time.\";s:33:\"pixova_lite_contact_first_heading\";s:19:\"Estamos ubicados en\";s:34:\"pixova_lite_contact_second_heading\";s:20:\"Atención a clientes\";s:17:\"pixova_lite_email\";s:19:\"info@trustworthy.cl\";s:17:\"pixova_lite_phone\";s:13:\"0 332 548 955\";s:19:\"pixova_lite_address\";s:10:\"Dirección\";s:43:\"pixova_lite_about_section_chart_1_bar_color\";s:7:\"#f2c351\";s:45:\"pixova_lite_about_section_chart_1_track_color\";s:7:\"#eeeeee\";s:43:\"pixova_lite_about_section_chart_2_bar_color\";s:7:\"#f2c351\";s:45:\"pixova_lite_about_section_chart_2_track_color\";s:7:\"#eeeeee\";s:43:\"pixova_lite_about_section_chart_3_bar_color\";s:7:\"#f2c351\";s:45:\"pixova_lite_about_section_chart_3_track_color\";s:7:\"#eeeeee\";s:43:\"pixova_lite_about_section_chart_4_bar_color\";s:7:\"#f2c351\";s:45:\"pixova_lite_about_section_chart_4_track_color\";s:7:\"#eeeeee\";s:33:\"pixova_lite_works_project_1_image\";s:120:\"https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-1-270x426.jpg\";s:32:\"pixova_lite_works_project_1_logo\";s:86:\"http://localhost/1mentha/midatech/otd/web/wp-content/uploads/2018/11/logo_cliente1.png\";s:33:\"pixova_lite_works_project_2_image\";s:120:\"https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-2-270x426.jpg\";s:32:\"pixova_lite_works_project_2_logo\";s:86:\"http://localhost/1mentha/midatech/otd/web/wp-content/uploads/2018/11/logo_cliente3.png\";s:33:\"pixova_lite_works_project_3_image\";s:120:\"https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-3-270x426.jpg\";s:32:\"pixova_lite_works_project_3_logo\";s:86:\"http://localhost/1mentha/midatech/otd/web/wp-content/uploads/2018/11/logo_cliente2.png\";s:33:\"pixova_lite_works_project_4_image\";s:120:\"https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-4-270x426.jpg\";s:32:\"pixova_lite_works_project_4_logo\";s:86:\"http://localhost/1mentha/midatech/otd/web/wp-content/uploads/2018/11/logo_cliente4.png\";s:38:\"pixova_lite_testimonial_1_person_image\";s:121:\"https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg\";s:38:\"pixova_lite_testimonial_2_person_image\";s:121:\"https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg\";s:38:\"pixova_lite_testimonial_3_person_image\";s:121:\"https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg\";s:38:\"pixova_lite_testimonial_4_person_image\";s:121:\"https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg\";s:38:\"pixova_lite_testimonial_5_person_image\";s:121:\"https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg\";s:31:\"pixova_lite_team_member_1_image\";s:108:\"https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru-150x150.jpg\";s:31:\"pixova_lite_team_member_2_image\";s:109:\"https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru2-150x150.jpg\";s:31:\"pixova_lite_team_member_3_image\";s:109:\"https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru3-150x150.jpg\";s:31:\"pixova_lite_team_member_4_image\";s:109:\"https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru4-150x150.jpg\";s:31:\"pixova_lite_contact_section_cf7\";i:8;s:28:\"pixova_lite_copyright_enable\";i:0;s:39:\"pixova_lite_blog_breadcrumb_menu_prefix\";s:12:\"Ud esta aqui\";}");
INSERT INTO `tb_postmeta` VALUES("12", "12", "_wp_trash_meta_status", "publish");
INSERT INTO `tb_postmeta` VALUES("13", "12", "_wp_trash_meta_time", "1540442760");
INSERT INTO `tb_postmeta` VALUES("14", "14", "_edit_lock", "1540442823:1");
INSERT INTO `tb_postmeta` VALUES("15", "14", "_wp_trash_meta_status", "publish");
INSERT INTO `tb_postmeta` VALUES("16", "14", "_wp_trash_meta_time", "1540442830");
INSERT INTO `tb_postmeta` VALUES("17", "16", "_edit_lock", "1540442856:1");
INSERT INTO `tb_postmeta` VALUES("18", "16", "_wp_trash_meta_status", "publish");
INSERT INTO `tb_postmeta` VALUES("19", "16", "_wp_trash_meta_time", "1540442872");
INSERT INTO `tb_postmeta` VALUES("20", "18", "_edit_lock", "1540443036:1");
INSERT INTO `tb_postmeta` VALUES("21", "18", "_wp_trash_meta_status", "publish");
INSERT INTO `tb_postmeta` VALUES("22", "18", "_wp_trash_meta_time", "1540443045");
INSERT INTO `tb_postmeta` VALUES("23", "20", "_edit_lock", "1540472006:1");
INSERT INTO `tb_postmeta` VALUES("24", "20", "_wp_trash_meta_status", "publish");
INSERT INTO `tb_postmeta` VALUES("25", "20", "_wp_trash_meta_time", "1540472030");
INSERT INTO `tb_postmeta` VALUES("26", "22", "_edit_lock", "1540472095:1");
INSERT INTO `tb_postmeta` VALUES("27", "22", "_wp_trash_meta_status", "publish");
INSERT INTO `tb_postmeta` VALUES("28", "22", "_wp_trash_meta_time", "1540472109");
INSERT INTO `tb_postmeta` VALUES("29", "23", "_edit_lock", "1540472575:1");
INSERT INTO `tb_postmeta` VALUES("30", "24", "_wp_attached_file", "2018/10/trust-worthy_chico.png");
INSERT INTO `tb_postmeta` VALUES("31", "24", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:81;s:6:\"height\";i:81;s:4:\"file\";s:30:\"2018/10/trust-worthy_chico.png\";s:5:\"sizes\";a:2:{s:23:\"pixova-lite-custom-logo\";a:4:{s:4:\"file\";s:28:\"trust-worthy_chico-81x30.png\";s:5:\"width\";i:81;s:6:\"height\";i:30;s:9:\"mime-type\";s:9:\"image/png\";}s:37:\"pixova-lite-project-slider-logo-image\";a:4:{s:4:\"file\";s:28:\"trust-worthy_chico-81x35.png\";s:5:\"width\";i:81;s:6:\"height\";i:35;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `tb_postmeta` VALUES("32", "25", "_wp_attached_file", "2018/10/logo_blanco.png");
INSERT INTO `tb_postmeta` VALUES("33", "25", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1100;s:6:\"height\";i:360;s:4:\"file\";s:23:\"2018/10/logo_blanco.png\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"logo_blanco-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"logo_blanco-300x98.png\";s:5:\"width\";i:300;s:6:\"height\";i:98;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"logo_blanco-768x251.png\";s:5:\"width\";i:768;s:6:\"height\";i:251;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:24:\"logo_blanco-1024x335.png\";s:5:\"width\";i:1024;s:6:\"height\";i:335;s:9:\"mime-type\";s:9:\"image/png\";}s:23:\"pixova-lite-custom-logo\";a:4:{s:4:\"file\";s:22:\"logo_blanco-141x30.png\";s:5:\"width\";i:141;s:6:\"height\";i:30;s:9:\"mime-type\";s:9:\"image/png\";}s:37:\"pixova-lite-project-slider-logo-image\";a:4:{s:4:\"file\";s:22:\"logo_blanco-187x35.png\";s:5:\"width\";i:187;s:6:\"height\";i:35;s:9:\"mime-type\";s:9:\"image/png\";}s:31:\"pixova-lite-homepage-blog-posts\";a:4:{s:4:\"file\";s:23:\"logo_blanco-250x250.png\";s:5:\"width\";i:250;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";}s:31:\"pixova-lite-featured-blog-image\";a:4:{s:4:\"file\";s:23:\"logo_blanco-750x250.png\";s:5:\"width\";i:750;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";}s:25:\"pixova-lite-related-posts\";a:4:{s:4:\"file\";s:23:\"logo_blanco-600x360.png\";s:5:\"width\";i:600;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}s:30:\"pixova-lite-recent-works-image\";a:4:{s:4:\"file\";s:23:\"logo_blanco-285x360.png\";s:5:\"width\";i:285;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `tb_postmeta` VALUES("34", "25", "_edit_lock", "1540472316:1");
INSERT INTO `tb_postmeta` VALUES("35", "26", "_wp_attached_file", "2018/10/logo_blanco_chico.png");
INSERT INTO `tb_postmeta` VALUES("36", "26", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:227;s:6:\"height\";i:59;s:4:\"file\";s:29:\"2018/10/logo_blanco_chico.png\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"logo_blanco_chico-150x59.png\";s:5:\"width\";i:150;s:6:\"height\";i:59;s:9:\"mime-type\";s:9:\"image/png\";}s:23:\"pixova-lite-custom-logo\";a:4:{s:4:\"file\";s:28:\"logo_blanco_chico-141x30.png\";s:5:\"width\";i:141;s:6:\"height\";i:30;s:9:\"mime-type\";s:9:\"image/png\";}s:37:\"pixova-lite-project-slider-logo-image\";a:4:{s:4:\"file\";s:28:\"logo_blanco_chico-187x35.png\";s:5:\"width\";i:187;s:6:\"height\";i:35;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `tb_postmeta` VALUES("37", "23", "_wp_trash_meta_status", "publish");
INSERT INTO `tb_postmeta` VALUES("38", "23", "_wp_trash_meta_time", "1540472579");
INSERT INTO `tb_postmeta` VALUES("39", "9", "_edit_lock", "1541448566:1");
INSERT INTO `tb_postmeta` VALUES("40", "27", "_edit_lock", "1541448169:1");
INSERT INTO `tb_postmeta` VALUES("41", "27", "_wp_trash_meta_status", "publish");
INSERT INTO `tb_postmeta` VALUES("42", "27", "_wp_trash_meta_time", "1541448171");
INSERT INTO `tb_postmeta` VALUES("44", "29", "_edit_lock", "1541448837:1");
INSERT INTO `tb_postmeta` VALUES("45", "29", "_wp_trash_meta_status", "publish");
INSERT INTO `tb_postmeta` VALUES("46", "29", "_wp_trash_meta_time", "1541448876");
INSERT INTO `tb_postmeta` VALUES("47", "31", "_wp_trash_meta_status", "publish");
INSERT INTO `tb_postmeta` VALUES("48", "31", "_wp_trash_meta_time", "1541448967");
INSERT INTO `tb_postmeta` VALUES("49", "33", "_edit_lock", "1541450607:1");
INSERT INTO `tb_postmeta` VALUES("50", "33", "_wp_trash_meta_status", "publish");
INSERT INTO `tb_postmeta` VALUES("51", "33", "_wp_trash_meta_time", "1541450631");
INSERT INTO `tb_postmeta` VALUES("52", "35", "_wp_attached_file", "2018/11/logo_cliente1.png");
INSERT INTO `tb_postmeta` VALUES("53", "35", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:390;s:6:\"height\";i:73;s:4:\"file\";s:25:\"2018/11/logo_cliente1.png\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"logo_cliente1-150x73.png\";s:5:\"width\";i:150;s:6:\"height\";i:73;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"logo_cliente1-300x56.png\";s:5:\"width\";i:300;s:6:\"height\";i:56;s:9:\"mime-type\";s:9:\"image/png\";}s:23:\"pixova-lite-custom-logo\";a:4:{s:4:\"file\";s:24:\"logo_cliente1-141x30.png\";s:5:\"width\";i:141;s:6:\"height\";i:30;s:9:\"mime-type\";s:9:\"image/png\";}s:37:\"pixova-lite-project-slider-logo-image\";a:4:{s:4:\"file\";s:24:\"logo_cliente1-187x35.png\";s:5:\"width\";i:187;s:6:\"height\";i:35;s:9:\"mime-type\";s:9:\"image/png\";}s:31:\"pixova-lite-homepage-blog-posts\";a:4:{s:4:\"file\";s:24:\"logo_cliente1-250x73.png\";s:5:\"width\";i:250;s:6:\"height\";i:73;s:9:\"mime-type\";s:9:\"image/png\";}s:30:\"pixova-lite-recent-works-image\";a:4:{s:4:\"file\";s:24:\"logo_cliente1-285x73.png\";s:5:\"width\";i:285;s:6:\"height\";i:73;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `tb_postmeta` VALUES("54", "36", "_wp_attached_file", "2018/11/logo_cliente2.png");
INSERT INTO `tb_postmeta` VALUES("55", "36", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:390;s:6:\"height\";i:73;s:4:\"file\";s:25:\"2018/11/logo_cliente2.png\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"logo_cliente2-150x73.png\";s:5:\"width\";i:150;s:6:\"height\";i:73;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"logo_cliente2-300x56.png\";s:5:\"width\";i:300;s:6:\"height\";i:56;s:9:\"mime-type\";s:9:\"image/png\";}s:23:\"pixova-lite-custom-logo\";a:4:{s:4:\"file\";s:24:\"logo_cliente2-141x30.png\";s:5:\"width\";i:141;s:6:\"height\";i:30;s:9:\"mime-type\";s:9:\"image/png\";}s:37:\"pixova-lite-project-slider-logo-image\";a:4:{s:4:\"file\";s:24:\"logo_cliente2-187x35.png\";s:5:\"width\";i:187;s:6:\"height\";i:35;s:9:\"mime-type\";s:9:\"image/png\";}s:31:\"pixova-lite-homepage-blog-posts\";a:4:{s:4:\"file\";s:24:\"logo_cliente2-250x73.png\";s:5:\"width\";i:250;s:6:\"height\";i:73;s:9:\"mime-type\";s:9:\"image/png\";}s:30:\"pixova-lite-recent-works-image\";a:4:{s:4:\"file\";s:24:\"logo_cliente2-285x73.png\";s:5:\"width\";i:285;s:6:\"height\";i:73;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `tb_postmeta` VALUES("56", "37", "_wp_attached_file", "2018/11/logo_cliente3.png");
INSERT INTO `tb_postmeta` VALUES("57", "37", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:390;s:6:\"height\";i:73;s:4:\"file\";s:25:\"2018/11/logo_cliente3.png\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"logo_cliente3-150x73.png\";s:5:\"width\";i:150;s:6:\"height\";i:73;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"logo_cliente3-300x56.png\";s:5:\"width\";i:300;s:6:\"height\";i:56;s:9:\"mime-type\";s:9:\"image/png\";}s:23:\"pixova-lite-custom-logo\";a:4:{s:4:\"file\";s:24:\"logo_cliente3-141x30.png\";s:5:\"width\";i:141;s:6:\"height\";i:30;s:9:\"mime-type\";s:9:\"image/png\";}s:37:\"pixova-lite-project-slider-logo-image\";a:4:{s:4:\"file\";s:24:\"logo_cliente3-187x35.png\";s:5:\"width\";i:187;s:6:\"height\";i:35;s:9:\"mime-type\";s:9:\"image/png\";}s:31:\"pixova-lite-homepage-blog-posts\";a:4:{s:4:\"file\";s:24:\"logo_cliente3-250x73.png\";s:5:\"width\";i:250;s:6:\"height\";i:73;s:9:\"mime-type\";s:9:\"image/png\";}s:30:\"pixova-lite-recent-works-image\";a:4:{s:4:\"file\";s:24:\"logo_cliente3-285x73.png\";s:5:\"width\";i:285;s:6:\"height\";i:73;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `tb_postmeta` VALUES("58", "38", "_wp_attached_file", "2018/11/logo_cliente4.png");
INSERT INTO `tb_postmeta` VALUES("59", "38", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:390;s:6:\"height\";i:73;s:4:\"file\";s:25:\"2018/11/logo_cliente4.png\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"logo_cliente4-150x73.png\";s:5:\"width\";i:150;s:6:\"height\";i:73;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"logo_cliente4-300x56.png\";s:5:\"width\";i:300;s:6:\"height\";i:56;s:9:\"mime-type\";s:9:\"image/png\";}s:23:\"pixova-lite-custom-logo\";a:4:{s:4:\"file\";s:24:\"logo_cliente4-141x30.png\";s:5:\"width\";i:141;s:6:\"height\";i:30;s:9:\"mime-type\";s:9:\"image/png\";}s:37:\"pixova-lite-project-slider-logo-image\";a:4:{s:4:\"file\";s:24:\"logo_cliente4-187x35.png\";s:5:\"width\";i:187;s:6:\"height\";i:35;s:9:\"mime-type\";s:9:\"image/png\";}s:31:\"pixova-lite-homepage-blog-posts\";a:4:{s:4:\"file\";s:24:\"logo_cliente4-250x73.png\";s:5:\"width\";i:250;s:6:\"height\";i:73;s:9:\"mime-type\";s:9:\"image/png\";}s:30:\"pixova-lite-recent-works-image\";a:4:{s:4:\"file\";s:24:\"logo_cliente4-285x73.png\";s:5:\"width\";i:285;s:6:\"height\";i:73;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `tb_postmeta` VALUES("60", "39", "_edit_lock", "1541450766:1");
INSERT INTO `tb_postmeta` VALUES("61", "39", "_wp_trash_meta_status", "publish");
INSERT INTO `tb_postmeta` VALUES("62", "39", "_wp_trash_meta_time", "1541450786");
INSERT INTO `tb_postmeta` VALUES("63", "41", "_wp_trash_meta_status", "publish");
INSERT INTO `tb_postmeta` VALUES("64", "41", "_wp_trash_meta_time", "1541450913");
INSERT INTO `tb_postmeta` VALUES("65", "42", "_wp_trash_meta_status", "publish");
INSERT INTO `tb_postmeta` VALUES("66", "42", "_wp_trash_meta_time", "1541450922");
INSERT INTO `tb_postmeta` VALUES("67", "43", "_wp_trash_meta_status", "publish");
INSERT INTO `tb_postmeta` VALUES("68", "43", "_wp_trash_meta_time", "1541450938");
INSERT INTO `tb_postmeta` VALUES("69", "44", "_wp_trash_meta_status", "publish");
INSERT INTO `tb_postmeta` VALUES("70", "44", "_wp_trash_meta_time", "1541450953");

/* INSERT TABLE DATA: tb_posts */
INSERT INTO `tb_posts` VALUES("1", "1", "2018-10-25 01:29:01", "2018-10-25 04:29:01", "Bienvenido(a) a WordPress. Esta es tu primera entrada. Edítala o bórrala ¡y comienza a publicar!", "¡Hola mundo!", "", "publish", "open", "open", "", "hola-mundo", "", "", "2018-10-25 01:29:01", "2018-10-25 04:29:01", "", "0", "http://localhost/1mentha/midatech/otd/web/?p=1", "0", "post", "", "1");
INSERT INTO `tb_posts` VALUES("2", "1", "2018-10-25 01:29:01", "2018-10-25 04:29:01", "Esta es una página de ejemplo. Es diferente a un artículo del blog, ya que se quedará fijo y se mostrará en la navegación del sitio (en la mayoría de themes). La mayoría de la gente empieza con una página Acerca de que brinda información a los visitantes. Se podría decir algo como esto:\n\n<blockquote>¡Hola! Durante el día soy un mensajero sobre bicicleta, un aspirante a actor por la noche, y este es mi blog. Vivo en Los Ángeles, tengo un perro grande llamado Jack, y me gustan las piñas coladas. (Y quedar atrapado en la lluvia.)</blockquote>\n\n...o algo como esto:\n\n<blockquote>La compañía XYZ Artilugios, fue fundada en 1971, y ha estado desde entonces proporcionando al público de artilugios de calidad. Está situado en la ciudad de Gotham, XYZ emplea a más de 2.000 personas y hace todo tipo de cosas impresionantes para la comunidad de Gotham.</blockquote>\n\nComo nuevo usuario de WordPress, usted debe ir a <a href=\"http://localhost/1mentha/midatech/otd/web/wp-admin/\">su Escritorio</a> para eliminar esta página y crear nuevas para su contenido. ¡Que se divierta!", "Página de ejemplo", "", "publish", "closed", "open", "", "pagina-de-ejemplo", "", "", "2018-10-25 01:29:01", "2018-10-25 04:29:01", "", "0", "http://localhost/1mentha/midatech/otd/web/?page_id=2", "0", "page", "", "0");
INSERT INTO `tb_posts` VALUES("3", "1", "2018-10-25 01:29:01", "2018-10-25 04:29:01", "<h2>Quiénes somos</h2><p>Nuestra dirección de sitio web es: http://localhost/1mentha/midatech/otd/web.</p><h2>Qué datos personales recopilamos y por qué lo recogemos</h2><h3>Comentarios</h3><p>Cuando los visitantes dejan comentarios en el sitio recopilamos los datos mostrados en el formulario de comentarios, y también la dirección IP del visitante y la cadena del agente de usuario del navegador para ayudar a la detección de spam.</p><p>Se puede proporcionar una cadena anonimizada creada a partir de su dirección de correo electrónico (también denominada hash) al servicio gravatar para ver si la está utilizando. La política de privacidad del servicio gravar está disponible aquí: https://automattic.com/privacy/. Después de la aprobación de tu comentario, su imagen de perfil es visible para el público en el contexto de tu comentario.</p><h3>Multimedia</h3><p>Si subes imágenes al sitio web, debes evitar cargar imágenes con datos de ubicación incrustados (EXIF GPS). Los visitantes del sitio web pueden descargar y extraer los datos de la ubicación de las imágenes en el sitio Web.</p><h3>Formularios de Contacto</h3><h3>Cookies</h3><p>Si deja un Comentario en nuestro sitio puedes optar por guardar tu nombre, dirección de correo electrónico y sitio web en cookies. Éstos son para tu conveniencia de modo que no tengas que rellenar tus datos otra vez cuando dejes otro comentario. Estas cookies durarán un año.</p><p>Si tienes una cuenta e inicias sesión en este sitio, configuraremos una cookie temporal para determinar si tu navegador acepta cookies. Esta cookie no contiene datos personales y se descarta al cerrar el navegador.</p><p>Cuando inicies sesión, también configuraremos varias cookies para guardar tu información de inicio de sesión y sus opciones de visualización en pantalla. Las cookies de inicio de sesión duran dos días y las cookies de opciones de pantalla duran un año. Si selecciona &quot;Recordarme&quot; en tu inicio de sesión se mantendrá durante dos semanas. Si cierra la sesión de tu cuenta, se eliminarán las cookies de inicio de sesión.</p><p>Si editas o publicas un artículo, una cookie adicional se guardará en tu navegador. Esta cookie no incluye datos personales y simplemente indica el ID de correo del artículo que acabas de editar. Expira después de 1 día.</p><h3>Contenido incrustado de otros sitios web</h3><p>Los artículos en este sitio pueden incluir contenido incrustado (por ejemplo, videos, imágenes, artículos, etc.). El contenido incrustado de otros sitios web se comporta de la misma manera que si el visitante hubiera visitado el otro sitio web.</p><p>Estos sitios web pueden recopilar datos sobre ti, utilizar cookies, incrustar un seguimiento adicional de terceros y supervisar tu interacción con ese contenido incrustado, incluido el seguimiento de tu interacción con el contenido incrustado si tiene una cuenta y está conectado a dicho sitio web.</p><h3>Analíticas</h3><h2>Con quién compartimos tus datos</h2><h2>Cuánto tiempo conservamos tus datos</h2><p>Si dejas un comentario, el comentario y sus metadatos se conservan indefinidamente. Esto es para que podamos reconocer y aprobar automáticamente cualquier comentario de seguimiento en lugar de mantenerlos en una cola de moderación.</p><p>Para los usuarios que se registren en nuestro sitio web (si los hay), también almacenamos la información personal que proporcionan en su perfil de usuario. Todos los usuarios pueden ver, editar o borrar su información personal en cualquier momento (excepto que no pueden cambiar su nombre de usuario). Los administradores de sitios web también pueden ver y editar esa información.</p><h2>Qué derechos tienen sobre sus datos</h2><p>Si tienes una cuenta en este sitio, o ha dejado comentarios, puedes solicitar recibir un archivo exportado de los datos personales que tengamos sobre usted, incluyendo cualquier dato que nos haya proporcionado. También puede solicitar que borremos cualquier dato personal que mantengamos sobre usted. Esto no incluye los datos que estamos obligados a mantener para fines administrativos, legales o de seguridad.</p><h2>Dónde enviamos tus datos</h2><p>Los comentarios de los visitantes se pueden verificar a través de un servicio automático de detección de spam.</p><h2>Tu información de contacto</h2><h2>Información adicional</h2><h3>Cómo protegemos sus datos</h3><h3>Qué procedimientos de violación de datos tenemos en marcha</h3><h3>De qué terceros recibimos datos</h3><h3>Qué toma de decisiones y/o perfiles automatizados haremos con los datos del usuario</h3><h3>Requisitos de divulgación regulatoria de la industria</h3>", "Políticas de Privacidad", "", "draft", "closed", "open", "", "politica-de-privacidad", "", "", "2018-10-25 01:29:01", "2018-10-25 04:29:01", "", "0", "http://localhost/1mentha/midatech/otd/web/?page_id=3", "0", "page", "", "0");
INSERT INTO `tb_posts` VALUES("6", "0", "2018-11-05 17:49:13", "0000-00-00 00:00:00", "", "Pixova Lite Backup Settings", "", "draft", "closed", "closed", "", "", "", "", "2018-11-05 17:49:13", "2018-11-05 20:49:13", "", "0", "http://localhost/1mentha/midatech/otd/web/?page_id=6", "0", "page", "", "0");
INSERT INTO `tb_posts` VALUES("7", "0", "2018-11-05 17:49:13", "0000-00-00 00:00:00", "CTA Section<br><br>Main CTA title: Bienvenidos a TrustWorthy<br>Main CTA text: Correo Privado<br>Main CTA sub-title: Hacemos sus entregas<br>Outline Button Text: Sobre Nosotros<br>Outline Button URL: #about<br>Button Text: Contactenos<br>Button URL: #about<br><br>What We Do Section<br><br>What we do #1 title: Web design<br>What we do #1 description: Lorem ipsum dolor sit amet. Lorem ipsum.<br>What we do #2 title: Development<br>What we do #2 description: Lorem ipsum dolor sit amet. Lorem ipsum.<br>What we do #3 title: Print design<br>What we do #3 description: Lorem ipsum dolor sit amet. Lorem ipsum.<br><br>Pie Chart Section<br><br>Section title: Nuestra Empresa<br>Section sub-title: This is what we do in a nutshell.<br>Section content: <em>Creada en Abril de 2005,  TRUSTWORTHY. es una Empresa que nace orientada en proporcionar como soluciones, alternativas de despacho, servicio de mensajería  y transporte de carga menor a los más variados requerimientos de nuestros Clientes y  que el mercado tanto local como regional nos impone. Para este efecto nos hemos consolidado basados en el profesionalismo y seriedad de nuestro staff humano, con más de  10 años de experiencia, hemos adquirido una profunda convicción en el trabajo permanente orientado a la consolidación de las  relaciones con nuestros Clientes, el desarrollo sostenible de nuestro negocio  y el respecto de los valores culturales de la sociedad Chilena. </em><br>Section blockquote: <em>Nuestra Premisa es Puntualidad, Honestidad, confianza y profesionalismo</em><br>Pie Chart #1 Heading: Puntualidad <br>Pie Chart #1 Percentage: 98<br>Pie Chart #2 Heading: Honestidad<br>Pie Chart #2 Percentage: 100<br>Pie Chart #3 Heading: confianza<br>Pie Chart #3 Percentage: 100<br>Pie Chart #4 Heading: Profesionalismo<br>Pie Chart #4 Percentage: 100<br><br>Recent Works Section<br><br>Section title: Nuestros Trabajos<br>Section sub-title: It\'s show and tell time.<br>Project #1 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-1-270x426.jpg<br>Project #1 Logo: http://localhost/1mentha/midatech/otd/web/wp-content/uploads/2018/11/logo_cliente1.png<br>Project #1 URL: <br>Project #2 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-2-270x426.jpg<br>Project #2 Logo: http://localhost/1mentha/midatech/otd/web/wp-content/uploads/2018/11/logo_cliente3.png<br>Project #2 URL: <br>Project #3 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-3-270x426.jpg<br>Project #3 Logo: http://localhost/1mentha/midatech/otd/web/wp-content/uploads/2018/11/logo_cliente2.png<br>Project #3 URL: <br>Project #4 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-4-270x426.jpg<br>Project #4 Logo: http://localhost/1mentha/midatech/otd/web/wp-content/uploads/2018/11/logo_cliente4.png<br>Project #4 URL: <br><br>Testimonials Section<br><br>Section title: Algunas palabras de nuestros clientes<br>Section sub-title: We don\'t like to brag, others do it for us.<br>Testimonial #1 Person Name: Katie Parry - Hooli<br>Testimonial #1 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #1 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #2 Person Name: John Doe<br>Testimonial #2 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #2 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #3 Person Name: Katie Parry - Hooli<br>Testimonial #3 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #3 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #4 Person Name: Katie Parry - Hooli<br>Testimonial #4 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #4 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #5 Person Name: Katie Parry - Hooli<br>Testimonial #5 Content: Working with Pixva has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #5 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br><br>Latest News Section<br><br>Section title: Ultimas noticias<br>Section sub-title: Straight from our blog.<br>Button Text: Visit our blog<br>Number of post per slide: 2<br><br>Team Section<br><br>Section title: Nuestro Equipo<br>Section sub-title: Ellos son los que hacen posible todo<br>Team #1 Name: Angelina Doe<br>Team #1 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru-150x150.jpg<br>Team #1 Facebook: https://www.facebook.com/colorlib<br>Team #1 Dribbble: http://www.dribbble.com/colorlib<br>Team #1 Email: contact@site.com<br>Team #2 Name: John Doe<br>Team #2 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru2-150x150.jpg<br>Team #2 Facebook: https://www.facebook.com/colorlib<br>Team #2 Dribbble: http://www.dribbble.com/madalin.duca<br>Team #2 Email: contact@site.com<br>Team #3 Name: Angelina Doe<br>Team #3 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru3-150x150.jpg<br>Team #3 Facebook: https://www.facebook.com/colorlib<br>Team #3 Dribbble: http://www.dribbble.com/colorlib<br>Team #3 Email: contact@site.com<br>Team #4 Name: Angelina Doe<br>Team #4 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru4-150x150.jpg<br>Team #4 Facebook: https://www.facebook.com/colorlib/<br>Team #4 Dribbble: http://www.dribbble.com/colorlib/<br>Team #4 Email: contact@site.com<br>Team #5 Name: John Doe<br>Team #5 Facebook: https://www.facebook.com/colorlib<br>Team #5 Dribbble: http://www.dribbble.com/colorlib<br>Team #5 Email: contact@site.com<br><br>Contact Section<br><br>Section title: Contactanos<br>Section sub-title: And we\'ll reply in no time.<br>Left Heading 1: Estamos ubicados en<br>Left Heading 2: Atención a clientes<br>Email: info@trustworthy.cl<br>Phone number: 0 332 548 955<br>Address: Dirección<br>", "Pixova Settings", "", "draft", "closed", "closed", "", "", "", "", "2018-11-05 17:49:13", "2018-11-05 20:49:13", "", "0", "http://localhost/1mentha/midatech/otd/web/?page_id=7", "0", "page", "", "0");
INSERT INTO `tb_posts` VALUES("8", "1", "2018-10-25 01:40:04", "2018-10-25 04:40:04", "<label> Tu Nombre (requerido)\n    [text* your-name] </label>\n\n<label> Tu Correo (requerido)\n    [email* your-email] </label>\n\n<label> Asunto\n    [text your-subject] </label>\n\n<label> Tu Mensaje\n    [textarea your-message] </label>\n\n[submit \"Enviar\"]\nTrans boomerang \"[your-subject]\"\n[your-name] <agomez@midatech.cl>\nDe: [your-name] <[your-email]>\nAsunto: [your-subject]\n\nCuerpo del Mensaje\n[your-message]\n\n-- \nEste correo fue enviado utilizando contact form en Trans boomerang (http://localhost/1mentha/midatech/otd/web)\nagomez@midatech.cl\nReply-To: [your-email]\n\n0\n0\n\nTrans boomerang \"[your-subject]\"\nTrans boomerang <agomez@midatech.cl>\nCuerpo del Mensaje\n[your-message]\n\n-- \nEste correo fue enviado utilizando contact form en Trans boomerang (http://localhost/1mentha/midatech/otd/web)\n[your-email]\nReply-To: agomez@midatech.cl\n\n0\n0\nThank you for your message. It has been sent.\nThere was an error trying to send your message. Please try again later.\nOne or more fields have an error. Please check and try again.\nThere was an error trying to send your message. Please try again later.\nYou must accept the terms and conditions before sending your message.\nThe field is required.\nThe field is too long.\nThe field is too short.", "Formulario de contacto 1", "", "publish", "closed", "closed", "", "formulario-de-contacto-1", "", "", "2018-10-25 01:40:04", "2018-10-25 04:40:04", "", "0", "http://localhost/1mentha/midatech/otd/web/?post_type=wpcf7_contact_form&p=8", "0", "wpcf7_contact_form", "", "0");
INSERT INTO `tb_posts` VALUES("9", "1", "2018-10-25 01:40:16", "2018-10-25 04:40:16", "", "Homepage", "", "publish", "closed", "closed", "", "homepage", "", "", "2018-10-25 01:40:16", "2018-10-25 04:40:16", "", "0", "http://localhost/1mentha/midatech/otd/web/homepage/", "0", "page", "", "0");
INSERT INTO `tb_posts` VALUES("10", "1", "2018-10-25 01:40:16", "2018-10-25 04:40:16", "", "Blog", "", "publish", "closed", "closed", "", "blog", "", "", "2018-10-25 01:40:16", "2018-10-25 04:40:16", "", "0", "http://localhost/1mentha/midatech/otd/web/blog/", "0", "page", "", "0");
INSERT INTO `tb_posts` VALUES("11", "1", "2018-10-25 01:40:16", "2018-10-25 04:40:16", "CTA Section<br><br>Main CTA title: WELCOME TO PIXOVA LITE<br>Main CTA text: Free & Modern One-Page Parallax WordPress Theme<br>Main CTA sub-title: Your cool business headline here. You can even <u><strong>insert HTML here & images</strong></u>.\nLorem ipsum dolor sit amet lorem dolor sit amet.<br>Outline Button Text: LEARN MORE<br>Outline Button URL: #about<br>Button Text: CONTACT US<br>Button URL: #about<br><br>What We Do Section<br><br>What we do #1 title: Web design<br>What we do #1 description: Lorem ipsum dolor sit amet. Lorem ipsum.<br>What we do #2 title: Development<br>What we do #2 description: Lorem ipsum dolor sit amet. Lorem ipsum.<br>What we do #3 title: Print design<br>What we do #3 description: Lorem ipsum dolor sit amet. Lorem ipsum.<br><br>Pie Chart Section<br><br>Section title: We build solutions for your everyday problems.<br>Section sub-title: This is what we do in a nutshell.<br>Section content: Creative ut tincidunt nibh, varius cursus nunc. Curabitur molestie, metus vel luctus euismod, mi libero laoreet odio, eu dapibus leo tortor sit amet purus. It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.<br>Section blockquote: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Erlich Bachman, Aviato.<br>Pie Chart #1 Heading: Web design<br>Pie Chart #1 Percentage: 70<br>Pie Chart #2 Heading: Web development<br>Pie Chart #2 Percentage: 90<br>Pie Chart #3 Heading: Print design<br>Pie Chart #3 Percentage: 90<br>Pie Chart #4 Heading: Graphic identity<br>Pie Chart #4 Percentage: 50<br><br>Recent Works Section<br><br>Section title: Recent works<br>Section sub-title: It\'s show and tell time.<br>Project #1 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-1-270x426.jpg<br>Project #1 Logo: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/logo1.png<br>Project #1 URL: https://colorlib.com/pixova-lite/<br>Project #2 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-2-270x426.jpg<br>Project #2 Logo: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/logo2.png<br>Project #2 URL: https://colorlib.com/pixova-lite/<br>Project #3 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-3-270x426.jpg<br>Project #3 Logo: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/logo3.png<br>Project #3 URL: https://colorlib.com/pixova-lite/<br>Project #4 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-4-270x426.jpg<br>Project #4 Logo: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/logo4.png<br>Project #4 URL: https://colorlib.com/pixova-lite/<br><br>Testimonials Section<br><br>Section title: Some words from our clients<br>Section sub-title: We don\'t like to brag, others do it for us.<br>Testimonial #1 Person Name: Katie Parry - Hooli<br>Testimonial #1 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #1 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #2 Person Name: John Doe<br>Testimonial #2 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #2 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #3 Person Name: Katie Parry - Hooli<br>Testimonial #3 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #3 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #4 Person Name: Katie Parry - Hooli<br>Testimonial #4 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #4 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #5 Person Name: Katie Parry - Hooli<br>Testimonial #5 Content: Working with Pixva has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #5 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br><br>Latest News Section<br><br>Section title: Latest news<br>Section sub-title: Straight from our blog.<br>Button Text: Visit our blog<br>Number of post per slide: 2<br><br>Team Section<br><br>Section title: The team<br>Section sub-title: Meet the people that made it all happen.<br>Team #1 Name: Angelina Doe<br>Team #1 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru-150x150.jpg<br>Team #1 Facebook: https://www.facebook.com/colorlib<br>Team #1 Dribbble: http://www.dribbble.com/colorlib<br>Team #1 Email: contact@site.com<br>Team #2 Name: John Doe<br>Team #2 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru2-150x150.jpg<br>Team #2 Facebook: https://www.facebook.com/colorlib<br>Team #2 Dribbble: http://www.dribbble.com/madalin.duca<br>Team #2 Email: contact@site.com<br>Team #3 Name: Angelina Doe<br>Team #3 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru3-150x150.jpg<br>Team #3 Facebook: https://www.facebook.com/colorlib<br>Team #3 Dribbble: http://www.dribbble.com/colorlib<br>Team #3 Email: contact@site.com<br>Team #4 Name: Angelina Doe<br>Team #4 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru4-150x150.jpg<br>Team #4 Facebook: https://www.facebook.com/colorlib/<br>Team #4 Dribbble: http://www.dribbble.com/colorlib/<br>Team #4 Email: contact@site.com<br>Team #5 Name: John Doe<br>Team #5 Facebook: https://www.facebook.com/colorlib<br>Team #5 Dribbble: http://www.dribbble.com/colorlib<br>Team #5 Email: contact@site.com<br><br>Contact Section<br><br>Section title: Contact us<br>Section sub-title: And we\'ll reply in no time.<br>Left Heading 1: Address<br>Left Heading 2: Customer Support<br>Email: contact@site.org<br>Phone number: 0 332 548 955<br>Address: Street 221B Baker Street<br>", "Pixova Settings", "", "inherit", "closed", "closed", "", "7-revision-v1", "", "", "2018-10-25 01:40:16", "2018-10-25 04:40:16", "", "7", "http://localhost/1mentha/midatech/otd/web/2018/10/25/7-revision-v1/", "0", "revision", "", "0");
INSERT INTO `tb_posts` VALUES("12", "1", "2018-10-25 01:46:00", "2018-10-25 04:46:00", "{\n    \"widget_pixova_lite_widget_social_media[2]\": {\n        \"value\": {\n            \"encoded_serialized_instance\": \"YToxNDp7czo1OiJ0aXRsZSI7czowOiIiO3M6MTA6InNob3dfdGl0bGUiO3M6MDoiIjtzOjE2OiJwcm9maWxlX2ZhY2Vib29rIjtzOjE6IiMiO3M6MTU6InByb2ZpbGVfdHdpdHRlciI7czoxOiIjIjtzOjEyOiJwcm9maWxlX3BsdXMiO3M6MDoiIjtzOjE3OiJwcm9maWxlX3BpbnRlcmVzdCI7czowOiIiO3M6MTY6InByb2ZpbGVfbGlua2VkaW4iO3M6MDoiIjtzOjE1OiJwcm9maWxlX3lvdXR1YmUiO3M6MDoiIjtzOjE2OiJwcm9maWxlX2RyaWJiYmxlIjtzOjA6IiI7czoxNDoicHJvZmlsZV90dW1ibHIiO3M6MDoiIjtzOjE3OiJwcm9maWxlX2luc3RhZ3JhbSI7czoxOiIjIjtzOjE0OiJwcm9maWxlX2dpdGh1YiI7czowOiIiO3M6MTc6InByb2ZpbGVfYml0YnVja2V0IjtzOjA6IiI7czoxNToicHJvZmlsZV9jb2RlcGVuIjtzOjA6IiI7fQ==\",\n            \"title\": \"\",\n            \"is_widget_customizer_js_value\": true,\n            \"instance_hash_key\": \"c84aa77bf4986818c3c309945f7f6bfa\"\n        },\n        \"type\": \"option\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-10-25 04:46:00\"\n    }\n}", "", "", "trash", "closed", "closed", "", "9b57dd6e-b50b-4299-a693-dff8669852bd", "", "", "2018-10-25 01:46:00", "2018-10-25 04:46:00", "", "0", "http://localhost/1mentha/midatech/otd/web/2018/10/25/9b57dd6e-b50b-4299-a693-dff8669852bd/", "0", "customize_changeset", "", "0");
INSERT INTO `tb_posts` VALUES("13", "1", "2018-10-25 01:46:00", "2018-10-25 04:46:00", "", "Pixova Lite Backup Settings", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2018-10-25 01:46:00", "2018-10-25 04:46:00", "", "6", "http://localhost/1mentha/midatech/otd/web/2018/10/25/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `tb_posts` VALUES("14", "1", "2018-10-25 01:47:10", "2018-10-25 04:47:10", "{\n    \"pixova_lite_contact_section_title\": {\n        \"value\": \"Contactanos\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-10-25 04:46:36\"\n    },\n    \"pixova_lite_contact_first_heading\": {\n        \"value\": \"Estamos ubicados en\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-10-25 04:46:36\"\n    },\n    \"pixova_lite_email\": {\n        \"value\": \"mail@mail.cl\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-10-25 04:47:10\"\n    },\n    \"pixova_lite_contact_second_heading\": {\n        \"value\": \"Atenci\\u00f3n a clientes\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-10-25 04:47:10\"\n    }\n}", "", "", "trash", "closed", "closed", "", "f88e797c-2fd4-4145-a2e7-b8765be11a8a", "", "", "2018-10-25 01:47:10", "2018-10-25 04:47:10", "", "0", "http://localhost/1mentha/midatech/otd/web/?p=14", "0", "customize_changeset", "", "0");
INSERT INTO `tb_posts` VALUES("15", "1", "2018-10-25 01:47:10", "2018-10-25 04:47:10", "CTA Section<br><br>Main CTA title: WELCOME TO PIXOVA LITE<br>Main CTA text: Free & Modern One-Page Parallax WordPress Theme<br>Main CTA sub-title: Your cool business headline here. You can even <u><strong>insert HTML here & images</strong></u>.\nLorem ipsum dolor sit amet lorem dolor sit amet.<br>Outline Button Text: LEARN MORE<br>Outline Button URL: #about<br>Button Text: CONTACT US<br>Button URL: #about<br><br>What We Do Section<br><br>What we do #1 title: Web design<br>What we do #1 description: Lorem ipsum dolor sit amet. Lorem ipsum.<br>What we do #2 title: Development<br>What we do #2 description: Lorem ipsum dolor sit amet. Lorem ipsum.<br>What we do #3 title: Print design<br>What we do #3 description: Lorem ipsum dolor sit amet. Lorem ipsum.<br><br>Pie Chart Section<br><br>Section title: We build solutions for your everyday problems.<br>Section sub-title: This is what we do in a nutshell.<br>Section content: Creative ut tincidunt nibh, varius cursus nunc. Curabitur molestie, metus vel luctus euismod, mi libero laoreet odio, eu dapibus leo tortor sit amet purus. It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.<br>Section blockquote: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Erlich Bachman, Aviato.<br>Pie Chart #1 Heading: Web design<br>Pie Chart #1 Percentage: 70<br>Pie Chart #2 Heading: Web development<br>Pie Chart #2 Percentage: 90<br>Pie Chart #3 Heading: Print design<br>Pie Chart #3 Percentage: 90<br>Pie Chart #4 Heading: Graphic identity<br>Pie Chart #4 Percentage: 50<br><br>Recent Works Section<br><br>Section title: Recent works<br>Section sub-title: It\'s show and tell time.<br>Project #1 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-1-270x426.jpg<br>Project #1 Logo: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/logo1.png<br>Project #1 URL: https://colorlib.com/pixova-lite/<br>Project #2 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-2-270x426.jpg<br>Project #2 Logo: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/logo2.png<br>Project #2 URL: https://colorlib.com/pixova-lite/<br>Project #3 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-3-270x426.jpg<br>Project #3 Logo: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/logo3.png<br>Project #3 URL: https://colorlib.com/pixova-lite/<br>Project #4 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-4-270x426.jpg<br>Project #4 Logo: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/logo4.png<br>Project #4 URL: https://colorlib.com/pixova-lite/<br><br>Testimonials Section<br><br>Section title: Some words from our clients<br>Section sub-title: We don\'t like to brag, others do it for us.<br>Testimonial #1 Person Name: Katie Parry - Hooli<br>Testimonial #1 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #1 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #2 Person Name: John Doe<br>Testimonial #2 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #2 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #3 Person Name: Katie Parry - Hooli<br>Testimonial #3 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #3 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #4 Person Name: Katie Parry - Hooli<br>Testimonial #4 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #4 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #5 Person Name: Katie Parry - Hooli<br>Testimonial #5 Content: Working with Pixva has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #5 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br><br>Latest News Section<br><br>Section title: Latest news<br>Section sub-title: Straight from our blog.<br>Button Text: Visit our blog<br>Number of post per slide: 2<br><br>Team Section<br><br>Section title: The team<br>Section sub-title: Meet the people that made it all happen.<br>Team #1 Name: Angelina Doe<br>Team #1 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru-150x150.jpg<br>Team #1 Facebook: https://www.facebook.com/colorlib<br>Team #1 Dribbble: http://www.dribbble.com/colorlib<br>Team #1 Email: contact@site.com<br>Team #2 Name: John Doe<br>Team #2 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru2-150x150.jpg<br>Team #2 Facebook: https://www.facebook.com/colorlib<br>Team #2 Dribbble: http://www.dribbble.com/madalin.duca<br>Team #2 Email: contact@site.com<br>Team #3 Name: Angelina Doe<br>Team #3 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru3-150x150.jpg<br>Team #3 Facebook: https://www.facebook.com/colorlib<br>Team #3 Dribbble: http://www.dribbble.com/colorlib<br>Team #3 Email: contact@site.com<br>Team #4 Name: Angelina Doe<br>Team #4 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru4-150x150.jpg<br>Team #4 Facebook: https://www.facebook.com/colorlib/<br>Team #4 Dribbble: http://www.dribbble.com/colorlib/<br>Team #4 Email: contact@site.com<br>Team #5 Name: John Doe<br>Team #5 Facebook: https://www.facebook.com/colorlib<br>Team #5 Dribbble: http://www.dribbble.com/colorlib<br>Team #5 Email: contact@site.com<br><br>Contact Section<br><br>Section title: Contactanos<br>Section sub-title: And we\'ll reply in no time.<br>Left Heading 1: Estamos ubicados en<br>Left Heading 2: Atención a clientes<br>Email: mail@mail.cl<br>Phone number: 0 332 548 955<br>Address: Street 221B Baker Street<br>", "Pixova Settings", "", "inherit", "closed", "closed", "", "7-revision-v1", "", "", "2018-10-25 01:47:10", "2018-10-25 04:47:10", "", "7", "http://localhost/1mentha/midatech/otd/web/2018/10/25/7-revision-v1/", "0", "revision", "", "0");
INSERT INTO `tb_posts` VALUES("16", "1", "2018-10-25 01:47:52", "2018-10-25 04:47:52", "{\n    \"pixova_lite_news_section_title\": {\n        \"value\": \"Ultimas noticias\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-10-25 04:47:36\"\n    },\n    \"pixova_lite_team_section_title\": {\n        \"value\": \"Nuestro Equipo\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-10-25 04:47:36\"\n    },\n    \"pixova_lite_team_section_sub_title\": {\n        \"value\": \"Ellos son los que hacen posible todo\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-10-25 04:47:52\"\n    }\n}", "", "", "trash", "closed", "closed", "", "bc8b114a-6a90-4c61-98aa-ba5b1c4ee798", "", "", "2018-10-25 01:47:52", "2018-10-25 04:47:52", "", "0", "http://localhost/1mentha/midatech/otd/web/?p=16", "0", "customize_changeset", "", "0");
INSERT INTO `tb_posts` VALUES("17", "1", "2018-10-25 01:47:52", "2018-10-25 04:47:52", "CTA Section<br><br>Main CTA title: WELCOME TO PIXOVA LITE<br>Main CTA text: Free & Modern One-Page Parallax WordPress Theme<br>Main CTA sub-title: Your cool business headline here. You can even <u><strong>insert HTML here & images</strong></u>.\nLorem ipsum dolor sit amet lorem dolor sit amet.<br>Outline Button Text: LEARN MORE<br>Outline Button URL: #about<br>Button Text: CONTACT US<br>Button URL: #about<br><br>What We Do Section<br><br>What we do #1 title: Web design<br>What we do #1 description: Lorem ipsum dolor sit amet. Lorem ipsum.<br>What we do #2 title: Development<br>What we do #2 description: Lorem ipsum dolor sit amet. Lorem ipsum.<br>What we do #3 title: Print design<br>What we do #3 description: Lorem ipsum dolor sit amet. Lorem ipsum.<br><br>Pie Chart Section<br><br>Section title: We build solutions for your everyday problems.<br>Section sub-title: This is what we do in a nutshell.<br>Section content: Creative ut tincidunt nibh, varius cursus nunc. Curabitur molestie, metus vel luctus euismod, mi libero laoreet odio, eu dapibus leo tortor sit amet purus. It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.<br>Section blockquote: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Erlich Bachman, Aviato.<br>Pie Chart #1 Heading: Web design<br>Pie Chart #1 Percentage: 70<br>Pie Chart #2 Heading: Web development<br>Pie Chart #2 Percentage: 90<br>Pie Chart #3 Heading: Print design<br>Pie Chart #3 Percentage: 90<br>Pie Chart #4 Heading: Graphic identity<br>Pie Chart #4 Percentage: 50<br><br>Recent Works Section<br><br>Section title: Recent works<br>Section sub-title: It\'s show and tell time.<br>Project #1 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-1-270x426.jpg<br>Project #1 Logo: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/logo1.png<br>Project #1 URL: https://colorlib.com/pixova-lite/<br>Project #2 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-2-270x426.jpg<br>Project #2 Logo: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/logo2.png<br>Project #2 URL: https://colorlib.com/pixova-lite/<br>Project #3 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-3-270x426.jpg<br>Project #3 Logo: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/logo3.png<br>Project #3 URL: https://colorlib.com/pixova-lite/<br>Project #4 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-4-270x426.jpg<br>Project #4 Logo: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/logo4.png<br>Project #4 URL: https://colorlib.com/pixova-lite/<br><br>Testimonials Section<br><br>Section title: Some words from our clients<br>Section sub-title: We don\'t like to brag, others do it for us.<br>Testimonial #1 Person Name: Katie Parry - Hooli<br>Testimonial #1 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #1 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #2 Person Name: John Doe<br>Testimonial #2 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #2 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #3 Person Name: Katie Parry - Hooli<br>Testimonial #3 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #3 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #4 Person Name: Katie Parry - Hooli<br>Testimonial #4 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #4 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #5 Person Name: Katie Parry - Hooli<br>Testimonial #5 Content: Working with Pixva has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #5 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br><br>Latest News Section<br><br>Section title: Ultimas noticias<br>Section sub-title: Straight from our blog.<br>Button Text: Visit our blog<br>Number of post per slide: 2<br><br>Team Section<br><br>Section title: Nuestro Equipo<br>Section sub-title: Ellos son los que hacen posible todo<br>Team #1 Name: Angelina Doe<br>Team #1 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru-150x150.jpg<br>Team #1 Facebook: https://www.facebook.com/colorlib<br>Team #1 Dribbble: http://www.dribbble.com/colorlib<br>Team #1 Email: contact@site.com<br>Team #2 Name: John Doe<br>Team #2 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru2-150x150.jpg<br>Team #2 Facebook: https://www.facebook.com/colorlib<br>Team #2 Dribbble: http://www.dribbble.com/madalin.duca<br>Team #2 Email: contact@site.com<br>Team #3 Name: Angelina Doe<br>Team #3 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru3-150x150.jpg<br>Team #3 Facebook: https://www.facebook.com/colorlib<br>Team #3 Dribbble: http://www.dribbble.com/colorlib<br>Team #3 Email: contact@site.com<br>Team #4 Name: Angelina Doe<br>Team #4 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru4-150x150.jpg<br>Team #4 Facebook: https://www.facebook.com/colorlib/<br>Team #4 Dribbble: http://www.dribbble.com/colorlib/<br>Team #4 Email: contact@site.com<br>Team #5 Name: John Doe<br>Team #5 Facebook: https://www.facebook.com/colorlib<br>Team #5 Dribbble: http://www.dribbble.com/colorlib<br>Team #5 Email: contact@site.com<br><br>Contact Section<br><br>Section title: Contactanos<br>Section sub-title: And we\'ll reply in no time.<br>Left Heading 1: Estamos ubicados en<br>Left Heading 2: Atención a clientes<br>Email: mail@mail.cl<br>Phone number: 0 332 548 955<br>Address: Street 221B Baker Street<br>", "Pixova Settings", "", "inherit", "closed", "closed", "", "7-revision-v1", "", "", "2018-10-25 01:47:52", "2018-10-25 04:47:52", "", "7", "http://localhost/1mentha/midatech/otd/web/2018/10/25/7-revision-v1/", "0", "revision", "", "0");
INSERT INTO `tb_posts` VALUES("18", "1", "2018-10-25 01:50:45", "2018-10-25 04:50:45", "{\n    \"pixova_lite_work_section_title\": {\n        \"value\": \"Nuestros Trabajos\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-10-25 04:49:36\"\n    },\n    \"pixova_lite_testimonial_section_title\": {\n        \"value\": \"Algunas palabras de nuestros clientes\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-10-25 04:49:36\"\n    },\n    \"pixova_lite_intro_title_cta\": {\n        \"value\": \"Bienvenidos a\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-10-25 04:50:36\"\n    },\n    \"pixova_lite_intro_cta\": {\n        \"value\": \"Free\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-10-25 04:50:36\"\n    },\n    \"pixova_lite_intro_sub_cta\": {\n        \"value\": \"Your cool business headline here. You can even\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-10-25 04:50:36\"\n    },\n    \"pixova_lite_intro_outline_button_text\": {\n        \"value\": \"Sobre Nosotros\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-10-25 04:50:36\"\n    },\n    \"pixova_lite_intro_button_text\": {\n        \"value\": \"Contactenos\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-10-25 04:50:36\"\n    }\n}", "", "", "trash", "closed", "closed", "", "698975df-14e2-4311-84f6-8ae0294bddb7", "", "", "2018-10-25 01:50:45", "2018-10-25 04:50:45", "", "0", "http://localhost/1mentha/midatech/otd/web/?p=18", "0", "customize_changeset", "", "0");
INSERT INTO `tb_posts` VALUES("19", "1", "2018-10-25 01:50:45", "2018-10-25 04:50:45", "CTA Section<br><br>Main CTA title: Bienvenidos a<br>Main CTA text: Free<br>Main CTA sub-title: Your cool business headline here. You can even<br>Outline Button Text: Sobre Nosotros<br>Outline Button URL: #about<br>Button Text: Contactenos<br>Button URL: #about<br><br>What We Do Section<br><br>What we do #1 title: Web design<br>What we do #1 description: Lorem ipsum dolor sit amet. Lorem ipsum.<br>What we do #2 title: Development<br>What we do #2 description: Lorem ipsum dolor sit amet. Lorem ipsum.<br>What we do #3 title: Print design<br>What we do #3 description: Lorem ipsum dolor sit amet. Lorem ipsum.<br><br>Pie Chart Section<br><br>Section title: We build solutions for your everyday problems.<br>Section sub-title: This is what we do in a nutshell.<br>Section content: Creative ut tincidunt nibh, varius cursus nunc. Curabitur molestie, metus vel luctus euismod, mi libero laoreet odio, eu dapibus leo tortor sit amet purus. It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.<br>Section blockquote: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Erlich Bachman, Aviato.<br>Pie Chart #1 Heading: Web design<br>Pie Chart #1 Percentage: 70<br>Pie Chart #2 Heading: Web development<br>Pie Chart #2 Percentage: 90<br>Pie Chart #3 Heading: Print design<br>Pie Chart #3 Percentage: 90<br>Pie Chart #4 Heading: Graphic identity<br>Pie Chart #4 Percentage: 50<br><br>Recent Works Section<br><br>Section title: Nuestros Trabajos<br>Section sub-title: It\'s show and tell time.<br>Project #1 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-1-270x426.jpg<br>Project #1 Logo: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/logo1.png<br>Project #1 URL: https://colorlib.com/pixova-lite/<br>Project #2 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-2-270x426.jpg<br>Project #2 Logo: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/logo2.png<br>Project #2 URL: https://colorlib.com/pixova-lite/<br>Project #3 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-3-270x426.jpg<br>Project #3 Logo: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/logo3.png<br>Project #3 URL: https://colorlib.com/pixova-lite/<br>Project #4 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-4-270x426.jpg<br>Project #4 Logo: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/logo4.png<br>Project #4 URL: https://colorlib.com/pixova-lite/<br><br>Testimonials Section<br><br>Section title: Algunas palabras de nuestros clientes<br>Section sub-title: We don\'t like to brag, others do it for us.<br>Testimonial #1 Person Name: Katie Parry - Hooli<br>Testimonial #1 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #1 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #2 Person Name: John Doe<br>Testimonial #2 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #2 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #3 Person Name: Katie Parry - Hooli<br>Testimonial #3 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #3 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #4 Person Name: Katie Parry - Hooli<br>Testimonial #4 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #4 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #5 Person Name: Katie Parry - Hooli<br>Testimonial #5 Content: Working with Pixva has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #5 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br><br>Latest News Section<br><br>Section title: Ultimas noticias<br>Section sub-title: Straight from our blog.<br>Button Text: Visit our blog<br>Number of post per slide: 2<br><br>Team Section<br><br>Section title: Nuestro Equipo<br>Section sub-title: Ellos son los que hacen posible todo<br>Team #1 Name: Angelina Doe<br>Team #1 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru-150x150.jpg<br>Team #1 Facebook: https://www.facebook.com/colorlib<br>Team #1 Dribbble: http://www.dribbble.com/colorlib<br>Team #1 Email: contact@site.com<br>Team #2 Name: John Doe<br>Team #2 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru2-150x150.jpg<br>Team #2 Facebook: https://www.facebook.com/colorlib<br>Team #2 Dribbble: http://www.dribbble.com/madalin.duca<br>Team #2 Email: contact@site.com<br>Team #3 Name: Angelina Doe<br>Team #3 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru3-150x150.jpg<br>Team #3 Facebook: https://www.facebook.com/colorlib<br>Team #3 Dribbble: http://www.dribbble.com/colorlib<br>Team #3 Email: contact@site.com<br>Team #4 Name: Angelina Doe<br>Team #4 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru4-150x150.jpg<br>Team #4 Facebook: https://www.facebook.com/colorlib/<br>Team #4 Dribbble: http://www.dribbble.com/colorlib/<br>Team #4 Email: contact@site.com<br>Team #5 Name: John Doe<br>Team #5 Facebook: https://www.facebook.com/colorlib<br>Team #5 Dribbble: http://www.dribbble.com/colorlib<br>Team #5 Email: contact@site.com<br><br>Contact Section<br><br>Section title: Contactanos<br>Section sub-title: And we\'ll reply in no time.<br>Left Heading 1: Estamos ubicados en<br>Left Heading 2: Atención a clientes<br>Email: mail@mail.cl<br>Phone number: 0 332 548 955<br>Address: Street 221B Baker Street<br>", "Pixova Settings", "", "inherit", "closed", "closed", "", "7-revision-v1", "", "", "2018-10-25 01:50:45", "2018-10-25 04:50:45", "", "7", "http://localhost/1mentha/midatech/otd/web/2018/10/25/7-revision-v1/", "0", "revision", "", "0");
INSERT INTO `tb_posts` VALUES("20", "1", "2018-10-25 09:53:50", "2018-10-25 12:53:50", "{\n    \"pixova_lite_intro_title_cta\": {\n        \"value\": \"Bienvenidos a TrustWorthy\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-10-25 12:53:26\"\n    },\n    \"pixova_lite_intro_cta\": {\n        \"value\": \"Correo Privado\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-10-25 12:53:50\"\n    }\n}", "", "", "trash", "closed", "closed", "", "b7c840e0-e4e7-45c7-91d9-8ecedd26ba5b", "", "", "2018-10-25 09:53:50", "2018-10-25 12:53:50", "", "0", "http://localhost/1mentha/midatech/otd/web/?p=20", "0", "customize_changeset", "", "0");
INSERT INTO `tb_posts` VALUES("21", "1", "2018-10-25 09:53:50", "2018-10-25 12:53:50", "CTA Section<br><br>Main CTA title: Bienvenidos a TrustWorthy<br>Main CTA text: Correo Privado<br>Main CTA sub-title: Your cool business headline here. You can even<br>Outline Button Text: Sobre Nosotros<br>Outline Button URL: #about<br>Button Text: Contactenos<br>Button URL: #about<br><br>What We Do Section<br><br>What we do #1 title: Web design<br>What we do #1 description: Lorem ipsum dolor sit amet. Lorem ipsum.<br>What we do #2 title: Development<br>What we do #2 description: Lorem ipsum dolor sit amet. Lorem ipsum.<br>What we do #3 title: Print design<br>What we do #3 description: Lorem ipsum dolor sit amet. Lorem ipsum.<br><br>Pie Chart Section<br><br>Section title: We build solutions for your everyday problems.<br>Section sub-title: This is what we do in a nutshell.<br>Section content: Creative ut tincidunt nibh, varius cursus nunc. Curabitur molestie, metus vel luctus euismod, mi libero laoreet odio, eu dapibus leo tortor sit amet purus. It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.<br>Section blockquote: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Erlich Bachman, Aviato.<br>Pie Chart #1 Heading: Web design<br>Pie Chart #1 Percentage: 70<br>Pie Chart #2 Heading: Web development<br>Pie Chart #2 Percentage: 90<br>Pie Chart #3 Heading: Print design<br>Pie Chart #3 Percentage: 90<br>Pie Chart #4 Heading: Graphic identity<br>Pie Chart #4 Percentage: 50<br><br>Recent Works Section<br><br>Section title: Nuestros Trabajos<br>Section sub-title: It\'s show and tell time.<br>Project #1 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-1-270x426.jpg<br>Project #1 Logo: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/logo1.png<br>Project #1 URL: https://colorlib.com/pixova-lite/<br>Project #2 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-2-270x426.jpg<br>Project #2 Logo: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/logo2.png<br>Project #2 URL: https://colorlib.com/pixova-lite/<br>Project #3 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-3-270x426.jpg<br>Project #3 Logo: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/logo3.png<br>Project #3 URL: https://colorlib.com/pixova-lite/<br>Project #4 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-4-270x426.jpg<br>Project #4 Logo: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/logo4.png<br>Project #4 URL: https://colorlib.com/pixova-lite/<br><br>Testimonials Section<br><br>Section title: Algunas palabras de nuestros clientes<br>Section sub-title: We don\'t like to brag, others do it for us.<br>Testimonial #1 Person Name: Katie Parry - Hooli<br>Testimonial #1 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #1 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #2 Person Name: John Doe<br>Testimonial #2 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #2 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #3 Person Name: Katie Parry - Hooli<br>Testimonial #3 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #3 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #4 Person Name: Katie Parry - Hooli<br>Testimonial #4 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #4 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #5 Person Name: Katie Parry - Hooli<br>Testimonial #5 Content: Working with Pixva has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #5 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br><br>Latest News Section<br><br>Section title: Ultimas noticias<br>Section sub-title: Straight from our blog.<br>Button Text: Visit our blog<br>Number of post per slide: 2<br><br>Team Section<br><br>Section title: Nuestro Equipo<br>Section sub-title: Ellos son los que hacen posible todo<br>Team #1 Name: Angelina Doe<br>Team #1 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru-150x150.jpg<br>Team #1 Facebook: https://www.facebook.com/colorlib<br>Team #1 Dribbble: http://www.dribbble.com/colorlib<br>Team #1 Email: contact@site.com<br>Team #2 Name: John Doe<br>Team #2 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru2-150x150.jpg<br>Team #2 Facebook: https://www.facebook.com/colorlib<br>Team #2 Dribbble: http://www.dribbble.com/madalin.duca<br>Team #2 Email: contact@site.com<br>Team #3 Name: Angelina Doe<br>Team #3 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru3-150x150.jpg<br>Team #3 Facebook: https://www.facebook.com/colorlib<br>Team #3 Dribbble: http://www.dribbble.com/colorlib<br>Team #3 Email: contact@site.com<br>Team #4 Name: Angelina Doe<br>Team #4 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru4-150x150.jpg<br>Team #4 Facebook: https://www.facebook.com/colorlib/<br>Team #4 Dribbble: http://www.dribbble.com/colorlib/<br>Team #4 Email: contact@site.com<br>Team #5 Name: John Doe<br>Team #5 Facebook: https://www.facebook.com/colorlib<br>Team #5 Dribbble: http://www.dribbble.com/colorlib<br>Team #5 Email: contact@site.com<br><br>Contact Section<br><br>Section title: Contactanos<br>Section sub-title: And we\'ll reply in no time.<br>Left Heading 1: Estamos ubicados en<br>Left Heading 2: Atención a clientes<br>Email: mail@mail.cl<br>Phone number: 0 332 548 955<br>Address: Street 221B Baker Street<br>", "Pixova Settings", "", "inherit", "closed", "closed", "", "7-revision-v1", "", "", "2018-10-25 09:53:50", "2018-10-25 12:53:50", "", "7", "http://localhost/1mentha/midatech/otd/web/2018/10/25/7-revision-v1/", "0", "revision", "", "0");
INSERT INTO `tb_posts` VALUES("22", "1", "2018-10-25 09:55:09", "2018-10-25 12:55:09", "{\n    \"blogname\": {\n        \"value\": \"TrustWorthy\",\n        \"type\": \"option\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-10-25 12:54:26\"\n    },\n    \"pixova-lite::pixova_lite_copyright\": {\n        \"value\": \"\\u00a9 Copyright 2018.\\u00a0TrustWorthy\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-10-25 12:55:09\"\n    },\n    \"pixova_lite_copyright_enable\": {\n        \"value\": false,\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-10-25 12:55:09\"\n    }\n}", "", "", "trash", "closed", "closed", "", "56293107-c158-411a-9fae-f8f0a6610dc2", "", "", "2018-10-25 09:55:09", "2018-10-25 12:55:09", "", "0", "http://localhost/1mentha/midatech/otd/web/?p=22", "0", "customize_changeset", "", "0");
INSERT INTO `tb_posts` VALUES("23", "1", "2018-10-25 10:02:59", "2018-10-25 13:02:59", "{\n    \"blogdescription\": {\n        \"value\": \"TrustWorthy Correo Privado\",\n        \"type\": \"option\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-10-25 12:56:26\"\n    },\n    \"pixova-lite::custom_logo\": {\n        \"value\": 26,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-10-25 13:02:55\"\n    }\n}", "", "", "trash", "closed", "closed", "", "f526c8a8-8eba-4b29-8ece-1458a8c816a5", "", "", "2018-10-25 10:02:59", "2018-10-25 13:02:59", "", "0", "http://localhost/1mentha/midatech/otd/web/?p=23", "0", "customize_changeset", "", "0");
INSERT INTO `tb_posts` VALUES("24", "1", "2018-10-25 10:00:25", "2018-10-25 13:00:25", "", "trust-worthy_chico", "", "inherit", "open", "closed", "", "trust-worthy_chico", "", "", "2018-10-25 10:00:25", "2018-10-25 13:00:25", "", "0", "http://localhost/1mentha/midatech/otd/web/wp-content/uploads/2018/10/trust-worthy_chico.png", "0", "attachment", "image/png", "0");
INSERT INTO `tb_posts` VALUES("25", "1", "2018-10-25 10:00:50", "2018-10-25 13:00:50", "", "logo_blanco", "", "inherit", "open", "closed", "", "logo_blanco", "", "", "2018-10-25 10:00:50", "2018-10-25 13:00:50", "", "0", "http://localhost/1mentha/midatech/otd/web/wp-content/uploads/2018/10/logo_blanco.png", "0", "attachment", "image/png", "0");
INSERT INTO `tb_posts` VALUES("26", "1", "2018-10-25 10:02:32", "2018-10-25 13:02:32", "", "logo_blanco_chico", "", "inherit", "open", "closed", "", "logo_blanco_chico", "", "", "2018-10-25 10:02:32", "2018-10-25 13:02:32", "", "0", "http://localhost/1mentha/midatech/otd/web/wp-content/uploads/2018/10/logo_blanco_chico.png", "0", "attachment", "image/png", "0");
INSERT INTO `tb_posts` VALUES("27", "1", "2018-11-05 17:02:51", "2018-11-05 20:02:51", "{\n    \"pixova_lite_intro_sub_cta\": {\n        \"value\": \"Hacemos sus entregas\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:00:15\"\n    },\n    \"pixova_lite_about_section_title\": {\n        \"value\": \"Nuestra Empresa\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:00:15\"\n    },\n    \"pixova_lite_about_section_textarea\": {\n        \"value\": \"<em>Creada en Abril de 2005, \\u00a0TRUSTWORTHY. es una Empresa que nace orientada en proporcionar como soluciones, alternativas de despacho, servicio de mensajer\\u00eda \\u00a0y transporte de carga menor a los m\\u00e1s variados requerimientos de nuestros Clientes y \\u00a0que el mercado tanto local como regional nos impone. Para este efecto nos hemos consolidado basados en el profesionalismo y seriedad de nuestro staff humano, con m\\u00e1s de\\u00a0 10 a\\u00f1os de experiencia, hemos adquirido una profunda convicci\\u00f3n en el trabajo permanente orientado a la consolidaci\\u00f3n de las\\u00a0 relaciones con nuestros Clientes, el desarrollo sostenible de nuestro negocio \\u00a0y el respecto de los valores culturales de la sociedad Chilena. </em>\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:00:15\"\n    },\n    \"pixova_lite_about_section_blockquote\": {\n        \"value\": \"<em>Nuestra Premisa es Puntualidad, Honestidad, confianza y profesionalismo</em>\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:01:06\"\n    },\n    \"pixova_lite_about_section_chart_1_heading\": {\n        \"value\": \"Puntualidad \",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:01:37\"\n    },\n    \"pixova_lite_about_section_chart_1_percentage\": {\n        \"value\": \"98\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:02:51\"\n    },\n    \"pixova_lite_about_section_chart_2_heading\": {\n        \"value\": \"Honestidad\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:02:37\"\n    },\n    \"pixova_lite_about_section_chart_2_percentage\": {\n        \"value\": \"100\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:02:37\"\n    },\n    \"pixova_lite_about_section_chart_3_heading\": {\n        \"value\": \"confianza\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:02:37\"\n    },\n    \"pixova_lite_about_section_chart_3_percentage\": {\n        \"value\": \"100\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:02:37\"\n    },\n    \"pixova_lite_about_section_chart_4_heading\": {\n        \"value\": \"Profesionalismo\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:02:37\"\n    },\n    \"pixova_lite_about_section_chart_4_percentage\": {\n        \"value\": \"100\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:02:37\"\n    }\n}", "", "", "trash", "closed", "closed", "", "c6f1db09-069f-4d3f-857d-cf1b9c2648f2", "", "", "2018-11-05 17:02:51", "2018-11-05 20:02:51", "", "0", "http://localhost/1mentha/midatech/otd/web/?p=27", "0", "customize_changeset", "", "0");
INSERT INTO `tb_posts` VALUES("28", "1", "2018-11-05 17:02:51", "2018-11-05 20:02:51", "CTA Section<br><br>Main CTA title: Bienvenidos a TrustWorthy<br>Main CTA text: Correo Privado<br>Main CTA sub-title: Hacemos sus entregas<br>Outline Button Text: Sobre Nosotros<br>Outline Button URL: #about<br>Button Text: Contactenos<br>Button URL: #about<br><br>What We Do Section<br><br>What we do #1 title: Web design<br>What we do #1 description: Lorem ipsum dolor sit amet. Lorem ipsum.<br>What we do #2 title: Development<br>What we do #2 description: Lorem ipsum dolor sit amet. Lorem ipsum.<br>What we do #3 title: Print design<br>What we do #3 description: Lorem ipsum dolor sit amet. Lorem ipsum.<br><br>Pie Chart Section<br><br>Section title: Nuestra Empresa<br>Section sub-title: This is what we do in a nutshell.<br>Section content: <em>Creada en Abril de 2005,  TRUSTWORTHY. es una Empresa que nace orientada en proporcionar como soluciones, alternativas de despacho, servicio de mensajería  y transporte de carga menor a los más variados requerimientos de nuestros Clientes y  que el mercado tanto local como regional nos impone. Para este efecto nos hemos consolidado basados en el profesionalismo y seriedad de nuestro staff humano, con más de  10 años de experiencia, hemos adquirido una profunda convicción en el trabajo permanente orientado a la consolidación de las  relaciones con nuestros Clientes, el desarrollo sostenible de nuestro negocio  y el respecto de los valores culturales de la sociedad Chilena. </em><br>Section blockquote: <em>Nuestra Premisa es Puntualidad, Honestidad, confianza y profesionalismo</em><br>Pie Chart #1 Heading: Puntualidad <br>Pie Chart #1 Percentage: 98<br>Pie Chart #2 Heading: Honestidad<br>Pie Chart #2 Percentage: 100<br>Pie Chart #3 Heading: confianza<br>Pie Chart #3 Percentage: 100<br>Pie Chart #4 Heading: Profesionalismo<br>Pie Chart #4 Percentage: 100<br><br>Recent Works Section<br><br>Section title: Nuestros Trabajos<br>Section sub-title: It\'s show and tell time.<br>Project #1 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-1-270x426.jpg<br>Project #1 Logo: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/logo1.png<br>Project #1 URL: https://colorlib.com/pixova-lite/<br>Project #2 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-2-270x426.jpg<br>Project #2 Logo: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/logo2.png<br>Project #2 URL: https://colorlib.com/pixova-lite/<br>Project #3 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-3-270x426.jpg<br>Project #3 Logo: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/logo3.png<br>Project #3 URL: https://colorlib.com/pixova-lite/<br>Project #4 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-4-270x426.jpg<br>Project #4 Logo: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/logo4.png<br>Project #4 URL: https://colorlib.com/pixova-lite/<br><br>Testimonials Section<br><br>Section title: Algunas palabras de nuestros clientes<br>Section sub-title: We don\'t like to brag, others do it for us.<br>Testimonial #1 Person Name: Katie Parry - Hooli<br>Testimonial #1 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #1 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #2 Person Name: John Doe<br>Testimonial #2 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #2 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #3 Person Name: Katie Parry - Hooli<br>Testimonial #3 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #3 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #4 Person Name: Katie Parry - Hooli<br>Testimonial #4 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #4 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #5 Person Name: Katie Parry - Hooli<br>Testimonial #5 Content: Working with Pixva has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #5 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br><br>Latest News Section<br><br>Section title: Ultimas noticias<br>Section sub-title: Straight from our blog.<br>Button Text: Visit our blog<br>Number of post per slide: 2<br><br>Team Section<br><br>Section title: Nuestro Equipo<br>Section sub-title: Ellos son los que hacen posible todo<br>Team #1 Name: Angelina Doe<br>Team #1 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru-150x150.jpg<br>Team #1 Facebook: https://www.facebook.com/colorlib<br>Team #1 Dribbble: http://www.dribbble.com/colorlib<br>Team #1 Email: contact@site.com<br>Team #2 Name: John Doe<br>Team #2 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru2-150x150.jpg<br>Team #2 Facebook: https://www.facebook.com/colorlib<br>Team #2 Dribbble: http://www.dribbble.com/madalin.duca<br>Team #2 Email: contact@site.com<br>Team #3 Name: Angelina Doe<br>Team #3 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru3-150x150.jpg<br>Team #3 Facebook: https://www.facebook.com/colorlib<br>Team #3 Dribbble: http://www.dribbble.com/colorlib<br>Team #3 Email: contact@site.com<br>Team #4 Name: Angelina Doe<br>Team #4 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru4-150x150.jpg<br>Team #4 Facebook: https://www.facebook.com/colorlib/<br>Team #4 Dribbble: http://www.dribbble.com/colorlib/<br>Team #4 Email: contact@site.com<br>Team #5 Name: John Doe<br>Team #5 Facebook: https://www.facebook.com/colorlib<br>Team #5 Dribbble: http://www.dribbble.com/colorlib<br>Team #5 Email: contact@site.com<br><br>Contact Section<br><br>Section title: Contactanos<br>Section sub-title: And we\'ll reply in no time.<br>Left Heading 1: Estamos ubicados en<br>Left Heading 2: Atención a clientes<br>Email: mail@mail.cl<br>Phone number: 0 332 548 955<br>Address: Street 221B Baker Street<br>", "Pixova Settings", "", "inherit", "closed", "closed", "", "7-revision-v1", "", "", "2018-11-05 17:02:51", "2018-11-05 20:02:51", "", "7", "http://localhost/1mentha/midatech/otd/web/2018/11/05/7-revision-v1/", "0", "revision", "", "0");
INSERT INTO `tb_posts` VALUES("29", "1", "2018-11-05 17:14:36", "2018-11-05 20:14:36", "{\n    \"pixova_lite_work_section_title\": {\n        \"value\": \"Nuestros Trabajos\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:14:36\"\n    },\n    \"pixova_lite_work_section_sub_title\": {\n        \"value\": \"It\'s show and tell time.\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:14:36\"\n    },\n    \"pixova-lite::pixova_lite_news_visibility\": {\n        \"value\": false,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:14:36\"\n    }\n}", "", "", "trash", "closed", "closed", "", "07d87e8d-66f6-4421-8265-e368e3b1a4f2", "", "", "2018-11-05 17:14:36", "2018-11-05 20:14:36", "", "0", "http://localhost/1mentha/midatech/otd/web/?p=29", "0", "customize_changeset", "", "0");
INSERT INTO `tb_posts` VALUES("30", "1", "2018-11-05 17:09:27", "0000-00-00 00:00:00", "", "Borrador automático", "", "auto-draft", "open", "open", "", "", "", "", "2018-11-05 17:09:27", "0000-00-00 00:00:00", "", "0", "http://localhost/1mentha/midatech/otd/web/?p=30", "0", "post", "", "0");
INSERT INTO `tb_posts` VALUES("31", "1", "2018-11-05 17:16:06", "2018-11-05 20:16:06", "{\n    \"pixova_lite_email\": {\n        \"value\": \"info@trustworthy.cl\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:16:06\"\n    },\n    \"pixova_lite_address\": {\n        \"value\": \"Direcci\\u00f3n\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:16:06\"\n    }\n}", "", "", "trash", "closed", "closed", "", "56bd7ec6-be8c-4cae-8f4d-71600174e465", "", "", "2018-11-05 17:16:06", "2018-11-05 20:16:06", "", "0", "http://localhost/1mentha/midatech/otd/web/2018/11/05/56bd7ec6-be8c-4cae-8f4d-71600174e465/", "0", "customize_changeset", "", "0");
INSERT INTO `tb_posts` VALUES("32", "1", "2018-11-05 17:16:07", "2018-11-05 20:16:07", "CTA Section<br><br>Main CTA title: Bienvenidos a TrustWorthy<br>Main CTA text: Correo Privado<br>Main CTA sub-title: Hacemos sus entregas<br>Outline Button Text: Sobre Nosotros<br>Outline Button URL: #about<br>Button Text: Contactenos<br>Button URL: #about<br><br>What We Do Section<br><br>What we do #1 title: Web design<br>What we do #1 description: Lorem ipsum dolor sit amet. Lorem ipsum.<br>What we do #2 title: Development<br>What we do #2 description: Lorem ipsum dolor sit amet. Lorem ipsum.<br>What we do #3 title: Print design<br>What we do #3 description: Lorem ipsum dolor sit amet. Lorem ipsum.<br><br>Pie Chart Section<br><br>Section title: Nuestra Empresa<br>Section sub-title: This is what we do in a nutshell.<br>Section content: <em>Creada en Abril de 2005,  TRUSTWORTHY. es una Empresa que nace orientada en proporcionar como soluciones, alternativas de despacho, servicio de mensajería  y transporte de carga menor a los más variados requerimientos de nuestros Clientes y  que el mercado tanto local como regional nos impone. Para este efecto nos hemos consolidado basados en el profesionalismo y seriedad de nuestro staff humano, con más de  10 años de experiencia, hemos adquirido una profunda convicción en el trabajo permanente orientado a la consolidación de las  relaciones con nuestros Clientes, el desarrollo sostenible de nuestro negocio  y el respecto de los valores culturales de la sociedad Chilena. </em><br>Section blockquote: <em>Nuestra Premisa es Puntualidad, Honestidad, confianza y profesionalismo</em><br>Pie Chart #1 Heading: Puntualidad <br>Pie Chart #1 Percentage: 98<br>Pie Chart #2 Heading: Honestidad<br>Pie Chart #2 Percentage: 100<br>Pie Chart #3 Heading: confianza<br>Pie Chart #3 Percentage: 100<br>Pie Chart #4 Heading: Profesionalismo<br>Pie Chart #4 Percentage: 100<br><br>Recent Works Section<br><br>Section title: Nuestros Trabajos<br>Section sub-title: It\'s show and tell time.<br>Project #1 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-1-270x426.jpg<br>Project #1 Logo: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/logo1.png<br>Project #1 URL: https://colorlib.com/pixova-lite/<br>Project #2 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-2-270x426.jpg<br>Project #2 Logo: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/logo2.png<br>Project #2 URL: https://colorlib.com/pixova-lite/<br>Project #3 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-3-270x426.jpg<br>Project #3 Logo: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/logo3.png<br>Project #3 URL: https://colorlib.com/pixova-lite/<br>Project #4 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-4-270x426.jpg<br>Project #4 Logo: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/logo4.png<br>Project #4 URL: https://colorlib.com/pixova-lite/<br><br>Testimonials Section<br><br>Section title: Algunas palabras de nuestros clientes<br>Section sub-title: We don\'t like to brag, others do it for us.<br>Testimonial #1 Person Name: Katie Parry - Hooli<br>Testimonial #1 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #1 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #2 Person Name: John Doe<br>Testimonial #2 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #2 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #3 Person Name: Katie Parry - Hooli<br>Testimonial #3 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #3 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #4 Person Name: Katie Parry - Hooli<br>Testimonial #4 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #4 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #5 Person Name: Katie Parry - Hooli<br>Testimonial #5 Content: Working with Pixva has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #5 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br><br>Latest News Section<br><br>Section title: Ultimas noticias<br>Section sub-title: Straight from our blog.<br>Button Text: Visit our blog<br>Number of post per slide: 2<br><br>Team Section<br><br>Section title: Nuestro Equipo<br>Section sub-title: Ellos son los que hacen posible todo<br>Team #1 Name: Angelina Doe<br>Team #1 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru-150x150.jpg<br>Team #1 Facebook: https://www.facebook.com/colorlib<br>Team #1 Dribbble: http://www.dribbble.com/colorlib<br>Team #1 Email: contact@site.com<br>Team #2 Name: John Doe<br>Team #2 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru2-150x150.jpg<br>Team #2 Facebook: https://www.facebook.com/colorlib<br>Team #2 Dribbble: http://www.dribbble.com/madalin.duca<br>Team #2 Email: contact@site.com<br>Team #3 Name: Angelina Doe<br>Team #3 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru3-150x150.jpg<br>Team #3 Facebook: https://www.facebook.com/colorlib<br>Team #3 Dribbble: http://www.dribbble.com/colorlib<br>Team #3 Email: contact@site.com<br>Team #4 Name: Angelina Doe<br>Team #4 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru4-150x150.jpg<br>Team #4 Facebook: https://www.facebook.com/colorlib/<br>Team #4 Dribbble: http://www.dribbble.com/colorlib/<br>Team #4 Email: contact@site.com<br>Team #5 Name: John Doe<br>Team #5 Facebook: https://www.facebook.com/colorlib<br>Team #5 Dribbble: http://www.dribbble.com/colorlib<br>Team #5 Email: contact@site.com<br><br>Contact Section<br><br>Section title: Contactanos<br>Section sub-title: And we\'ll reply in no time.<br>Left Heading 1: Estamos ubicados en<br>Left Heading 2: Atención a clientes<br>Email: info@trustworthy.cl<br>Phone number: 0 332 548 955<br>Address: Dirección<br>", "Pixova Settings", "", "inherit", "closed", "closed", "", "7-revision-v1", "", "", "2018-11-05 17:16:07", "2018-11-05 20:16:07", "", "7", "http://localhost/1mentha/midatech/otd/web/2018/11/05/7-revision-v1/", "0", "revision", "", "0");
INSERT INTO `tb_posts` VALUES("33", "1", "2018-11-05 17:43:51", "2018-11-05 20:43:51", "{\n    \"pixova_lite_blog_breadcrumb_menu_prefix\": {\n        \"value\": \"Ud esta aqui\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:24:31\"\n    },\n    \"pixova_lite_works_project_1_url\": {\n        \"value\": \"\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:25:18\"\n    },\n    \"sidebars_widgets[footer-sidebar-3]\": {\n        \"value\": [],\n        \"type\": \"option\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:43:51\"\n    },\n    \"pixova_lite_copyright_enable\": {\n        \"value\": false,\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:43:51\"\n    }\n}", "", "", "trash", "closed", "closed", "", "dbd96bb2-80a1-4ad4-bac1-6bdfa15e0907", "", "", "2018-11-05 17:43:51", "2018-11-05 20:43:51", "", "0", "http://localhost/1mentha/midatech/otd/web/?p=33", "0", "customize_changeset", "", "0");
INSERT INTO `tb_posts` VALUES("34", "1", "2018-11-05 17:43:51", "2018-11-05 20:43:51", "CTA Section<br><br>Main CTA title: Bienvenidos a TrustWorthy<br>Main CTA text: Correo Privado<br>Main CTA sub-title: Hacemos sus entregas<br>Outline Button Text: Sobre Nosotros<br>Outline Button URL: #about<br>Button Text: Contactenos<br>Button URL: #about<br><br>What We Do Section<br><br>What we do #1 title: Web design<br>What we do #1 description: Lorem ipsum dolor sit amet. Lorem ipsum.<br>What we do #2 title: Development<br>What we do #2 description: Lorem ipsum dolor sit amet. Lorem ipsum.<br>What we do #3 title: Print design<br>What we do #3 description: Lorem ipsum dolor sit amet. Lorem ipsum.<br><br>Pie Chart Section<br><br>Section title: Nuestra Empresa<br>Section sub-title: This is what we do in a nutshell.<br>Section content: <em>Creada en Abril de 2005,  TRUSTWORTHY. es una Empresa que nace orientada en proporcionar como soluciones, alternativas de despacho, servicio de mensajería  y transporte de carga menor a los más variados requerimientos de nuestros Clientes y  que el mercado tanto local como regional nos impone. Para este efecto nos hemos consolidado basados en el profesionalismo y seriedad de nuestro staff humano, con más de  10 años de experiencia, hemos adquirido una profunda convicción en el trabajo permanente orientado a la consolidación de las  relaciones con nuestros Clientes, el desarrollo sostenible de nuestro negocio  y el respecto de los valores culturales de la sociedad Chilena. </em><br>Section blockquote: <em>Nuestra Premisa es Puntualidad, Honestidad, confianza y profesionalismo</em><br>Pie Chart #1 Heading: Puntualidad <br>Pie Chart #1 Percentage: 98<br>Pie Chart #2 Heading: Honestidad<br>Pie Chart #2 Percentage: 100<br>Pie Chart #3 Heading: confianza<br>Pie Chart #3 Percentage: 100<br>Pie Chart #4 Heading: Profesionalismo<br>Pie Chart #4 Percentage: 100<br><br>Recent Works Section<br><br>Section title: Nuestros Trabajos<br>Section sub-title: It\'s show and tell time.<br>Project #1 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-1-270x426.jpg<br>Project #1 Logo: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/logo1.png<br>Project #1 URL: <br>Project #2 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-2-270x426.jpg<br>Project #2 Logo: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/logo2.png<br>Project #2 URL: https://colorlib.com/pixova-lite/<br>Project #3 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-3-270x426.jpg<br>Project #3 Logo: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/logo3.png<br>Project #3 URL: https://colorlib.com/pixova-lite/<br>Project #4 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-4-270x426.jpg<br>Project #4 Logo: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/logo4.png<br>Project #4 URL: https://colorlib.com/pixova-lite/<br><br>Testimonials Section<br><br>Section title: Algunas palabras de nuestros clientes<br>Section sub-title: We don\'t like to brag, others do it for us.<br>Testimonial #1 Person Name: Katie Parry - Hooli<br>Testimonial #1 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #1 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #2 Person Name: John Doe<br>Testimonial #2 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #2 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #3 Person Name: Katie Parry - Hooli<br>Testimonial #3 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #3 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #4 Person Name: Katie Parry - Hooli<br>Testimonial #4 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #4 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #5 Person Name: Katie Parry - Hooli<br>Testimonial #5 Content: Working with Pixva has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #5 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br><br>Latest News Section<br><br>Section title: Ultimas noticias<br>Section sub-title: Straight from our blog.<br>Button Text: Visit our blog<br>Number of post per slide: 2<br><br>Team Section<br><br>Section title: Nuestro Equipo<br>Section sub-title: Ellos son los que hacen posible todo<br>Team #1 Name: Angelina Doe<br>Team #1 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru-150x150.jpg<br>Team #1 Facebook: https://www.facebook.com/colorlib<br>Team #1 Dribbble: http://www.dribbble.com/colorlib<br>Team #1 Email: contact@site.com<br>Team #2 Name: John Doe<br>Team #2 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru2-150x150.jpg<br>Team #2 Facebook: https://www.facebook.com/colorlib<br>Team #2 Dribbble: http://www.dribbble.com/madalin.duca<br>Team #2 Email: contact@site.com<br>Team #3 Name: Angelina Doe<br>Team #3 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru3-150x150.jpg<br>Team #3 Facebook: https://www.facebook.com/colorlib<br>Team #3 Dribbble: http://www.dribbble.com/colorlib<br>Team #3 Email: contact@site.com<br>Team #4 Name: Angelina Doe<br>Team #4 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru4-150x150.jpg<br>Team #4 Facebook: https://www.facebook.com/colorlib/<br>Team #4 Dribbble: http://www.dribbble.com/colorlib/<br>Team #4 Email: contact@site.com<br>Team #5 Name: John Doe<br>Team #5 Facebook: https://www.facebook.com/colorlib<br>Team #5 Dribbble: http://www.dribbble.com/colorlib<br>Team #5 Email: contact@site.com<br><br>Contact Section<br><br>Section title: Contactanos<br>Section sub-title: And we\'ll reply in no time.<br>Left Heading 1: Estamos ubicados en<br>Left Heading 2: Atención a clientes<br>Email: info@trustworthy.cl<br>Phone number: 0 332 548 955<br>Address: Dirección<br>", "Pixova Settings", "", "inherit", "closed", "closed", "", "7-revision-v1", "", "", "2018-11-05 17:43:51", "2018-11-05 20:43:51", "", "7", "http://localhost/1mentha/midatech/otd/web/2018/11/05/7-revision-v1/", "0", "revision", "", "0");
INSERT INTO `tb_posts` VALUES("35", "1", "2018-11-05 17:44:49", "2018-11-05 20:44:49", "", "logo_cliente1", "", "inherit", "open", "closed", "", "logo_cliente1", "", "", "2018-11-05 17:44:49", "2018-11-05 20:44:49", "", "0", "http://localhost/1mentha/midatech/otd/web/wp-content/uploads/2018/11/logo_cliente1.png", "0", "attachment", "image/png", "0");
INSERT INTO `tb_posts` VALUES("36", "1", "2018-11-05 17:44:50", "2018-11-05 20:44:50", "", "logo_cliente2", "", "inherit", "open", "closed", "", "logo_cliente2", "", "", "2018-11-05 17:44:50", "2018-11-05 20:44:50", "", "0", "http://localhost/1mentha/midatech/otd/web/wp-content/uploads/2018/11/logo_cliente2.png", "0", "attachment", "image/png", "0");
INSERT INTO `tb_posts` VALUES("37", "1", "2018-11-05 17:44:50", "2018-11-05 20:44:50", "", "logo_cliente3", "", "inherit", "open", "closed", "", "logo_cliente3", "", "", "2018-11-05 17:44:50", "2018-11-05 20:44:50", "", "0", "http://localhost/1mentha/midatech/otd/web/wp-content/uploads/2018/11/logo_cliente3.png", "0", "attachment", "image/png", "0");
INSERT INTO `tb_posts` VALUES("38", "1", "2018-11-05 17:44:51", "2018-11-05 20:44:51", "", "logo_cliente4", "", "inherit", "open", "closed", "", "logo_cliente4", "", "", "2018-11-05 17:44:51", "2018-11-05 20:44:51", "", "0", "http://localhost/1mentha/midatech/otd/web/wp-content/uploads/2018/11/logo_cliente4.png", "0", "attachment", "image/png", "0");
INSERT INTO `tb_posts` VALUES("39", "1", "2018-11-05 17:46:26", "2018-11-05 20:46:26", "{\n    \"pixova_lite_works_project_1_logo\": {\n        \"value\": \"http://localhost/1mentha/midatech/otd/web/wp-content/uploads/2018/11/logo_cliente1.png\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:45:06\"\n    },\n    \"pixova_lite_works_project_2_logo\": {\n        \"value\": \"http://localhost/1mentha/midatech/otd/web/wp-content/uploads/2018/11/logo_cliente3.png\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:46:06\"\n    },\n    \"pixova_lite_works_project_2_url\": {\n        \"value\": \"\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:46:06\"\n    },\n    \"pixova_lite_works_project_3_logo\": {\n        \"value\": \"http://localhost/1mentha/midatech/otd/web/wp-content/uploads/2018/11/logo_cliente2.png\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:46:06\"\n    },\n    \"pixova_lite_works_project_3_url\": {\n        \"value\": \"\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:46:06\"\n    },\n    \"pixova_lite_works_project_4_logo\": {\n        \"value\": \"http://localhost/1mentha/midatech/otd/web/wp-content/uploads/2018/11/logo_cliente4.png\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:46:26\"\n    },\n    \"pixova_lite_works_project_4_url\": {\n        \"value\": \"\",\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:46:26\"\n    }\n}", "", "", "trash", "closed", "closed", "", "81daec73-d532-474c-a760-31de83c0a837", "", "", "2018-11-05 17:46:26", "2018-11-05 20:46:26", "", "0", "http://localhost/1mentha/midatech/otd/web/?p=39", "0", "customize_changeset", "", "0");
INSERT INTO `tb_posts` VALUES("40", "1", "2018-11-05 17:46:26", "2018-11-05 20:46:26", "CTA Section<br><br>Main CTA title: Bienvenidos a TrustWorthy<br>Main CTA text: Correo Privado<br>Main CTA sub-title: Hacemos sus entregas<br>Outline Button Text: Sobre Nosotros<br>Outline Button URL: #about<br>Button Text: Contactenos<br>Button URL: #about<br><br>What We Do Section<br><br>What we do #1 title: Web design<br>What we do #1 description: Lorem ipsum dolor sit amet. Lorem ipsum.<br>What we do #2 title: Development<br>What we do #2 description: Lorem ipsum dolor sit amet. Lorem ipsum.<br>What we do #3 title: Print design<br>What we do #3 description: Lorem ipsum dolor sit amet. Lorem ipsum.<br><br>Pie Chart Section<br><br>Section title: Nuestra Empresa<br>Section sub-title: This is what we do in a nutshell.<br>Section content: <em>Creada en Abril de 2005,  TRUSTWORTHY. es una Empresa que nace orientada en proporcionar como soluciones, alternativas de despacho, servicio de mensajería  y transporte de carga menor a los más variados requerimientos de nuestros Clientes y  que el mercado tanto local como regional nos impone. Para este efecto nos hemos consolidado basados en el profesionalismo y seriedad de nuestro staff humano, con más de  10 años de experiencia, hemos adquirido una profunda convicción en el trabajo permanente orientado a la consolidación de las  relaciones con nuestros Clientes, el desarrollo sostenible de nuestro negocio  y el respecto de los valores culturales de la sociedad Chilena. </em><br>Section blockquote: <em>Nuestra Premisa es Puntualidad, Honestidad, confianza y profesionalismo</em><br>Pie Chart #1 Heading: Puntualidad <br>Pie Chart #1 Percentage: 98<br>Pie Chart #2 Heading: Honestidad<br>Pie Chart #2 Percentage: 100<br>Pie Chart #3 Heading: confianza<br>Pie Chart #3 Percentage: 100<br>Pie Chart #4 Heading: Profesionalismo<br>Pie Chart #4 Percentage: 100<br><br>Recent Works Section<br><br>Section title: Nuestros Trabajos<br>Section sub-title: It\'s show and tell time.<br>Project #1 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-1-270x426.jpg<br>Project #1 Logo: http://localhost/1mentha/midatech/otd/web/wp-content/uploads/2018/11/logo_cliente1.png<br>Project #1 URL: <br>Project #2 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-2-270x426.jpg<br>Project #2 Logo: http://localhost/1mentha/midatech/otd/web/wp-content/uploads/2018/11/logo_cliente3.png<br>Project #2 URL: <br>Project #3 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-3-270x426.jpg<br>Project #3 Logo: http://localhost/1mentha/midatech/otd/web/wp-content/uploads/2018/11/logo_cliente2.png<br>Project #3 URL: <br>Project #4 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/recent-works/recent-works-4-270x426.jpg<br>Project #4 Logo: http://localhost/1mentha/midatech/otd/web/wp-content/uploads/2018/11/logo_cliente4.png<br>Project #4 URL: <br><br>Testimonials Section<br><br>Section title: Algunas palabras de nuestros clientes<br>Section sub-title: We don\'t like to brag, others do it for us.<br>Testimonial #1 Person Name: Katie Parry - Hooli<br>Testimonial #1 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #1 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #2 Person Name: John Doe<br>Testimonial #2 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #2 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #3 Person Name: Katie Parry - Hooli<br>Testimonial #3 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #3 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #4 Person Name: Katie Parry - Hooli<br>Testimonial #4 Content: Working with Pixova has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #4 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br>Testimonial #5 Person Name: Katie Parry - Hooli<br>Testimonial #5 Content: Working with Pixva has been an experience for a lifetime. I strongly reccommend these guys for their awesome support. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer volutpat eleifend convallis.<br>Testimonial #5 Person Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/testimonials/teammembru_burned-92x92.jpg<br><br>Latest News Section<br><br>Section title: Ultimas noticias<br>Section sub-title: Straight from our blog.<br>Button Text: Visit our blog<br>Number of post per slide: 2<br><br>Team Section<br><br>Section title: Nuestro Equipo<br>Section sub-title: Ellos son los que hacen posible todo<br>Team #1 Name: Angelina Doe<br>Team #1 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru-150x150.jpg<br>Team #1 Facebook: https://www.facebook.com/colorlib<br>Team #1 Dribbble: http://www.dribbble.com/colorlib<br>Team #1 Email: contact@site.com<br>Team #2 Name: John Doe<br>Team #2 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru2-150x150.jpg<br>Team #2 Facebook: https://www.facebook.com/colorlib<br>Team #2 Dribbble: http://www.dribbble.com/madalin.duca<br>Team #2 Email: contact@site.com<br>Team #3 Name: Angelina Doe<br>Team #3 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru3-150x150.jpg<br>Team #3 Facebook: https://www.facebook.com/colorlib<br>Team #3 Dribbble: http://www.dribbble.com/colorlib<br>Team #3 Email: contact@site.com<br>Team #4 Name: Angelina Doe<br>Team #4 Image: https://cdn.colorlib.com/pixova-lite/wp-content/themes/pixova-lite/layout/images/team/teammembru4-150x150.jpg<br>Team #4 Facebook: https://www.facebook.com/colorlib/<br>Team #4 Dribbble: http://www.dribbble.com/colorlib/<br>Team #4 Email: contact@site.com<br>Team #5 Name: John Doe<br>Team #5 Facebook: https://www.facebook.com/colorlib<br>Team #5 Dribbble: http://www.dribbble.com/colorlib<br>Team #5 Email: contact@site.com<br><br>Contact Section<br><br>Section title: Contactanos<br>Section sub-title: And we\'ll reply in no time.<br>Left Heading 1: Estamos ubicados en<br>Left Heading 2: Atención a clientes<br>Email: info@trustworthy.cl<br>Phone number: 0 332 548 955<br>Address: Dirección<br>", "Pixova Settings", "", "inherit", "closed", "closed", "", "7-revision-v1", "", "", "2018-11-05 17:46:26", "2018-11-05 20:46:26", "", "7", "http://localhost/1mentha/midatech/otd/web/2018/11/05/7-revision-v1/", "0", "revision", "", "0");
INSERT INTO `tb_posts` VALUES("41", "1", "2018-11-05 17:48:33", "2018-11-05 20:48:33", "{\n    \"sidebars_widgets[wp_inactive_widgets]\": {\n        \"value\": [\n            \"text-2\"\n        ],\n        \"type\": \"option\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:48:33\"\n    },\n    \"sidebars_widgets[footer-sidebar-1]\": {\n        \"value\": [],\n        \"type\": \"option\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:48:33\"\n    }\n}", "", "", "trash", "closed", "closed", "", "bbcfe570-6201-4593-b9de-9d2245d887e7", "", "", "2018-11-05 17:48:33", "2018-11-05 20:48:33", "", "0", "http://localhost/1mentha/midatech/otd/web/2018/11/05/bbcfe570-6201-4593-b9de-9d2245d887e7/", "0", "customize_changeset", "", "0");
INSERT INTO `tb_posts` VALUES("42", "1", "2018-11-05 17:48:42", "2018-11-05 20:48:42", "{\n    \"sidebars_widgets[wp_inactive_widgets]\": {\n        \"value\": [\n            \"text-2\",\n            \"text-3\"\n        ],\n        \"type\": \"option\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:48:42\"\n    },\n    \"sidebars_widgets[footer-sidebar-2]\": {\n        \"value\": [],\n        \"type\": \"option\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:48:42\"\n    }\n}", "", "", "trash", "closed", "closed", "", "034db541-57cd-40c1-a749-338eecc32040", "", "", "2018-11-05 17:48:42", "2018-11-05 20:48:42", "", "0", "http://localhost/1mentha/midatech/otd/web/2018/11/05/034db541-57cd-40c1-a749-338eecc32040/", "0", "customize_changeset", "", "0");
INSERT INTO `tb_posts` VALUES("43", "1", "2018-11-05 17:48:58", "2018-11-05 20:48:58", "{\n    \"sidebars_widgets[wp_inactive_widgets]\": {\n        \"value\": [\n            \"text-2\",\n            \"text-3\",\n            \"pixova_lite_widget_social_media-2\"\n        ],\n        \"type\": \"option\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:48:58\"\n    },\n    \"sidebars_widgets[footer-sidebar-4]\": {\n        \"value\": [],\n        \"type\": \"option\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:48:58\"\n    }\n}", "", "", "trash", "closed", "closed", "", "f7be5ced-8018-42c9-83ed-9ade98a640f2", "", "", "2018-11-05 17:48:58", "2018-11-05 20:48:58", "", "0", "http://localhost/1mentha/midatech/otd/web/2018/11/05/f7be5ced-8018-42c9-83ed-9ade98a640f2/", "0", "customize_changeset", "", "0");
INSERT INTO `tb_posts` VALUES("44", "1", "2018-11-05 17:49:13", "2018-11-05 20:49:13", "{\n    \"pixova_lite_copyright_enable\": {\n        \"value\": false,\n        \"type\": \"epsilon_page\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-11-05 20:49:13\"\n    }\n}", "", "", "trash", "closed", "closed", "", "02bde422-9c29-4b51-803e-32a4f8c9bd28", "", "", "2018-11-05 17:49:13", "2018-11-05 20:49:13", "", "0", "http://localhost/1mentha/midatech/otd/web/2018/11/05/02bde422-9c29-4b51-803e-32a4f8c9bd28/", "0", "customize_changeset", "", "0");

/* INSERT TABLE DATA: tb_term_relationships */
INSERT INTO `tb_term_relationships` VALUES("1", "1", "0");

/* INSERT TABLE DATA: tb_term_taxonomy */
INSERT INTO `tb_term_taxonomy` VALUES("1", "1", "category", "", "0", "1");

/* INSERT TABLE DATA: tb_terms */
INSERT INTO `tb_terms` VALUES("1", "Sin categoría", "sin-categoria", "0", "0");

/* INSERT TABLE DATA: tb_usermeta */
INSERT INTO `tb_usermeta` VALUES("1", "1", "nickname", "admin");
INSERT INTO `tb_usermeta` VALUES("2", "1", "first_name", "");
INSERT INTO `tb_usermeta` VALUES("3", "1", "last_name", "");
INSERT INTO `tb_usermeta` VALUES("4", "1", "description", "");
INSERT INTO `tb_usermeta` VALUES("5", "1", "rich_editing", "true");
INSERT INTO `tb_usermeta` VALUES("6", "1", "syntax_highlighting", "true");
INSERT INTO `tb_usermeta` VALUES("7", "1", "comment_shortcuts", "false");
INSERT INTO `tb_usermeta` VALUES("8", "1", "admin_color", "fresh");
INSERT INTO `tb_usermeta` VALUES("9", "1", "use_ssl", "0");
INSERT INTO `tb_usermeta` VALUES("10", "1", "show_admin_bar_front", "true");
INSERT INTO `tb_usermeta` VALUES("11", "1", "locale", "");
INSERT INTO `tb_usermeta` VALUES("12", "1", "tb_capabilities", "a:1:{s:13:\"administrator\";b:1;}");
INSERT INTO `tb_usermeta` VALUES("13", "1", "tb_user_level", "10");
INSERT INTO `tb_usermeta` VALUES("14", "1", "dismissed_wp_pointers", "wp496_privacy");
INSERT INTO `tb_usermeta` VALUES("15", "1", "show_welcome_panel", "1");
INSERT INTO `tb_usermeta` VALUES("17", "1", "tb_dashboard_quick_press_last_post_id", "4");
INSERT INTO `tb_usermeta` VALUES("18", "1", "managenav-menuscolumnshidden", "a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}");
INSERT INTO `tb_usermeta` VALUES("19", "1", "metaboxhidden_nav-menus", "a:1:{i:0;s:12:\"add-post_tag\";}");
INSERT INTO `tb_usermeta` VALUES("20", "1", "tb_user-settings", "libraryContent=browse");
INSERT INTO `tb_usermeta` VALUES("21", "1", "tb_user-settings-time", "1540472450");
INSERT INTO `tb_usermeta` VALUES("22", "1", "pixova_welcome_notice", "true");
INSERT INTO `tb_usermeta` VALUES("23", "1", "session_tokens", "a:1:{s:64:\"7afb779e23ccaa383c0b9623dda91d6eadc4b6ae67a8cf338a77ad269d057ab9\";a:4:{s:10:\"expiration\";i:1541620673;s:2:\"ip\";s:3:\"::1\";s:2:\"ua\";s:120:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36\";s:5:\"login\";i:1541447873;}}");
INSERT INTO `tb_usermeta` VALUES("24", "1", "show_try_gutenberg_panel", "0");

/* INSERT TABLE DATA: tb_users */
INSERT INTO `tb_users` VALUES("1", "admin", "$P$BMQ7dwaRf7D3XVxhzB2xOGo99Ufn0R1", "admin", "agomez@midatech.cl", "", "2018-10-25 04:29:01", "", "0", "admin");

SET FOREIGN_KEY_CHECKS = 1; 

/* Duplicator WordPress Timestamp: 2018-11-05 20:53:54*/
/* DUPLICATOR_MYSQLDUMP_EOF */
